#open "graphics";;

open_graph"";;

let MX = 255;;

let nround x y = (2*x+y)/(2*y);;

let rgb_of_hsb(H, S, V) =
  let H = H*6 in
  let I = H/MX*MX in
  let F = H-I in
  let M = V*(MX-S)/MX and N = V*(MX-S*F/MX)/MX
  and K = V*(MX-S*(MX-F)/MX)/MX in
  (
    nround (MX*(
      match I/MX with
        0 | 6 -> V | 1 -> N | 2 -> M | 3 -> M | 4 -> K | 5 -> V
      | _ -> failwith "red_of_hsb"
    )) MX,
    nround (MX*(
      match I/MX with
        0 | 6 -> K | 1 -> V | 2 -> V | 3 -> N | 4 -> M | 5 -> M
      | _ -> failwith "green_of_hsb"
    )) MX,
    nround (MX*(
      match I/MX with
        0 | 6 -> M | 1 -> M | 2 -> K | 3 -> V | 4 -> V | 5 -> N
      | _ -> failwith "blue_of_hsb"
    )) MX
  )
;;

let set_col (r,g,b) =
  set_color (rgb r g b)
;;

let pi180 = 3.141592654 /. 180.0;;

let wheel s v r =
  for theta = 0 to 23 do
    set_col(rgb_of_hsb (theta * MX / 24, s, v));
    fill_arc (size_x()/2) (size_y()/2) r r (theta * 15) (theta * 15 + 15)
  done
;;

let wheels v =
  for r = 8 downto 1 do
    wheel (r * MX / 8) v (r * (size_y()/20))
  done
;;

let (msg_w, msg_h) = text_size "R=999 G=999 B=999";;

try
  wheels MX;
  while true do
    let e = wait_next_event [Button_down; Key_pressed] in
      if e.keypressed then begin
        match e.key with
	  `0` .. `9` ->
	    clear_graph();
	    wheels ((int_of_char e.key - 48) * MX / 9)
	| `q` | `Q` ->
	    raise Exit
        | _ ->
	    ()
      end else
      if e.button then begin
        let c = point_color e.mouse_x e.mouse_y in
        let r = c lsr 16 and g = (c lsr 8) land 255 and b = c land 255 in
	  set_color black;
	  fill_rect 0 0 msg_w msg_h;
	  set_color white;
	  moveto 0 0;
	  draw_string ("R=" ^ string_of_int r ^ " G=" ^ string_of_int g ^
	  	       " B=" ^ string_of_int b)
      end
  done
with Exit ->
  close_graph()
;;

