(* A few well-known sorting algorithms *)

#open "record";;

(* The open above changes the meaning of <., <=., and array assignment
   t.(i) <- v, so that they now record the operations performed. *)

let bubble_sort t =
  let ordered = ref false in
  while not !ordered do
    ordered := true;
    for i = 0 to vect_length t - 2 do
      if t.(i+1) <. t.(i) then begin
        exchange t i (i+1);
        ordered := false
      end
    done
  done
;;

let insertion_sort t =
  for i = 1 to vect_length t - 1 do
    let val_i = t.(i) in
    let j = ref i in
      while !j >= 1 & val_i <. t.(!j - 1) do
        t.(!j) <- t.(!j - 1);
        decr j
      done;
      t.(!j) <- val_i
  done
;;

let selection_sort t =
  for i = 0 to vect_length t - 2 do
    let min = ref i in
    for j = i + 1 to vect_length t - 1 do
      if t.(j) <. t.(!min) then
        min := j
    done;
    exchange t i !min
  done
;;

let quick_sort t =
  let rec quick lo hi =
    if lo < hi then begin
      let i = ref lo
      and j = ref hi
      and p = t.(hi) in
      while !i < !j do
        while !i < hi & t.(!i) <=. p do incr i done;
        while !j > lo & p <=. t.(!j) do decr j done;
        if !i < !j then exchange t !i !j
      done;
      exchange t hi !i;
      quick lo (!i - 1);
      quick (!i + 1) hi
    end in
  quick 0 (vect_length t - 1)
;;

let heap_sort t =

  let father n = (n-1) / 2
  and left_son n = n + n + 1
  and right_son n = n + n + 2 in

  let rec from_bottom i last =
    if i != 0 then begin
      let j = father i in
      let ls = left_son j
      and rs = right_son j in
      if rs > last then
        if t.(j) <. t.(ls) then
          exchange t j ls
        else
          ()
      else
        if t.(j) <. t.(ls) or t.(j) <. t.(rs) then
          if t.(rs) <=. t.(ls) then
            exchange t j ls
          else
            exchange t j rs;
      from_bottom j last
    end in

  let rec from_top i last =
    let ls = left_son i
    and rs = right_son i in
      if ls > last then
        ()
      else if rs > last then
        if t.(ls) <=. t.(i) then
          ()
        else
          (exchange t i ls; from_top ls last)
      else if t.(ls) <=. t.(i) & t.(rs) <=. t.(i) then
        ()
      else if t.(rs) <=. t.(ls) then
        (exchange t i ls; from_top ls last)
      else
        (exchange t i rs; from_top rs last) in

  for last = 1 to vect_length t - 1 do
    from_bottom last last
  done;
  for last = vect_length t - 2 downto 0 do
    exchange t 0 (last+1);
    from_top 0 last
  done
;;


let merge_sort t =
  let rec merge i = fun
    [] [] ->
      ()
  | [] (v2::r2) ->
      t.(i) <- v2; merge (i+1) [] r2
  | (v1::r1) [] ->
      t.(i) <- v1; merge (i+1) r1 []
  | (v1::r1 as l1) (v2::r2 as l2) ->
      if v1 <. v2 then
        (t.(i) <- v1; merge (i+1) r1 l2)
      else
        (t.(i) <- v2; merge (i+1) l1 r2) in
      
  let rec msort start l =
    if l >= 2 then begin
      let m = l / 2 in
      msort start m;
      msort (start + m) (l - m);
      merge start (list_of_vect (sub_vect t start m))
                  (list_of_vect (sub_vect t (start+m) (l-m)))
    end in

  msort 0 (vect_length t)
;;

let shell_sort t =
  let h = ref 4 in
  while !h < vect_length t do h := 3 * !h + 1 done;
  while !h > 1 do
    h := !h / 3;
    for i = !h to vect_length t - 1 do
      let v = t.(i) in
        let j = ref i in
          while !j >= !h & v <. t.(!j-!h) do
	    t.(!j) <- t.(!j-!h); j := !j - !h
          done;
          t.(!j) <- v
    done
  done
;;
