#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#if VAXC
#include <stat.h>
#else
#include <sys/stat.h>
#endif

int mode;

int compare_strings(const void *e1,const void *e2);
int die(char *cmd,int mode);

int die(char *cmd,int mode)
{
   switch(mode){
      case 1:
         fprintf(stderr,"Can't open %s for read; exit\n",cmd);
         exit(4);
      case 2:
         fprintf(stderr,"Can't open %s for read; exit\n",cmd);
         exit(4);
      case 3:
         fprintf(stderr,"%s\n",cmd);
         exit(4);
      default:
         return 0;
   }
}

int compare_strings(const void *e1,const void *e2)
{
   char *ptr1= *(char **)e1,*ptr2= *(char **)e2;

   for(;tolower(*ptr1)==tolower(*ptr2) && *ptr1;ptr1++,ptr2++);
   if(*ptr1=='{' && *ptr2>47 && *ptr2!='@') return -1;
   if(*ptr2=='{' && *ptr1>47 && *ptr1!='@')return 1;
   return tolower(*ptr1)-tolower(*ptr2);
}

main(int argc,char **argv)
{
   char *buffer,**line,**lineptr,*ptr,*ptr1,*ptr2,old,multiple;
   long size,cnt,i,j;
   struct stat sbuf;
   FILE *input,*output;

   if(argc<4){
      printf("no input/output file specified; exit\n");
      exit(2);
   }
   stat(argv[1],&sbuf);
   size=sbuf.st_size+128;   /* get file size */
   (output=fopen(argv[2],"w")) || die(argv[2],2);
   if(size==128){ /* file size was 0 */
      fclose(output);
#if VMS
      exit(1);
#else
     exit(0);
#endif
   }
   (input =fopen(argv[1],"r")) || die(argv[1],1);
   buffer=malloc(size);
   if(!strcmp(argv[3],"html"))
      mode=1;
   else if(!strcmp(argv[3],"html1")){
      mode=2;
      fprintf(output,"<HTML><BODY>\n<h3>Index</h3>\n");
   }
   else
      mode=0;
   for(cnt=0,ptr=buffer;fgets(ptr,256,input);){
      if(*ptr!='\n'){
         while(*ptr!='\n' && *ptr)ptr++;
         *ptr++=0;
         cnt++;
      }
   }
   lineptr=line=calloc(cnt+1,sizeof(char *));
   for(*lineptr=ptr=buffer,i=cnt;i>0;i--){
      while(*ptr++);   /* search the end of a string */
      lineptr++;       /* increment lineptr array */
      *lineptr=ptr;    /* put the string address into the array */
   }
   qsort(line,cnt,sizeof(char *),compare_strings);
   ptr=line[i];
   if(mode)while(*ptr++!='>');
   old=tolower(*line[i]);
   for(i=0;i<cnt;i++){
      ptr=line[i];
      if(!*ptr)continue;  /* skip empty lines */
      if(mode)while(*ptr++!='>');
      if(tolower(*line[i])!=old)
         if(mode)
            fprintf(output,"\n<p>");
         else
            fputc('\n',output);
      else
         if(mode)fprintf(output,"<br>");
      old=tolower(*line[i]);
      fprintf(output,"%s",line[i]);
      for(j=i+1;j<cnt;j++){
            /* find the ',' before the section entry */
         for(ptr2=line[i]+strlen(line[i]);ptr2>line[i] && *--ptr2!=',';);
         for(ptr=line[i],ptr1=line[j],multiple=1;ptr<ptr2 && *ptr1;){
            if(*ptr++!= *ptr1++){
               multiple=0;
               break;
            }
         }
         if(!*ptr1 || ptr>ptr2 || multiple && *ptr1!= *ptr2)multiple=0;
         if(multiple){
            for(i++,ptr2=line[i]+strlen(line[i]);ptr2>line[i] && *--ptr2!=',';);            
            fprintf(output,"%s",ptr2);
         }
      }
      fputc('\n',output);
   }
   if(mode==2)fprintf(output,"\n<p></body></html>\n");
#if VMS
   return 1;
#else
   return 0;
#endif
}
