#include <dos.h>
#include <string.h>
const fcarry=0x1;
const fparity=0x4;
const fauxiliary=0x10;
const fzero=0x40;
const fsign=0x80;
const foverflow=0x800;
enum boolean {false,true};
struct psp
{
 int int_0x21command;
 int availmemorypagargraphs;
 char reserved;
 char dosdispatcher[0x5];
 int comprogramavailmemory;
 long int_0x22address;
 long int_0x23address;
 long int_0x24address;
 char dosreserved[0x16];
 int environementsegment;
 char nextdosreserved[0x2E];
 char oneparamfcb[0x10];
 char twoparamfcb[0x14];
 char lengthofparameterarea;
 char parametersarea[0x7F];
};
struct standartfcb
{
 char drive;                           /* Drive number. 0=default, 1=A, etc. */
 char name[8];                                                 /* File name. */
 char extension[3];                                  /* File name extension. */
 int currentblock;    /* Current block number of 128 records/block, for r/w. */
 int recordsize;               /* Logical record size in bytes, default=128. */
 long filesize;                                       /* File size in bytes. */
 int filedate;                                         /* Date file created. */
 int filetime;                                        /* Time of last write. */
 char reserv[8];                                      /* Reserved by system. */
 char currentrecord;                             /* Current block number of. */
 long randomrecord;                       /* Current relative record number. */
};
struct extendedfcb
{char extendedfcbflag;                       /* 0xff indicates Extended FCB. */
 char extendedreserved[6];                            /* Reserved by system. */
 char attribute;                                               /* Attribute. */
 char drive;                           /* Drive number. 0=default, 1=A, etc. */
 char name[8];                                                 /* File name. */
 char extension[3];                                  /* File name extension. */
 int currentblock;    /* Current block number of 128 records/block, for r/w. */
 int recordsize;               /* Logical record size in bytes, default=128. */
 long filesize;                                       /* File size in bytes. */
 int filedate;                                         /* Date file created. */
 int filetime;                                        /* Time of last write. */
 char reserv[8];                                      /* Reserved by system. */
 char currentrecord;                             /* Current block number of. */
 long randomrecord;                       /* Current relative record number. */
};
struct renamefcb
{
 char rendrive;                                             /* Drive number. */
 char renoldname[8];                                       /* Old file name. */
 char renoldextension[3];                        /* Old file name extension. */
 char onereserved[5];                                 /* Reserved by system. */
 char rennewname[8];                                       /* New file name. */
 char rennewextension[3];                        /* New file name extension. */
 char tworeserved[9];                                 /* Reserved by system. */
};
struct finddata
{
 char filename[12];
 long filesize;
 int filetime;
 int filedate;
 struct standartfcb fcb;
};
enum daysofweek {sunday,monday,tuesday,wednesday,thursday,friday,saturday};
struct datetime
{
 int year;
 char month;
 char day;
 enum daysofweek weekday;
 char hour;
 char minute;
 char second;
};
struct filedescriptor
{
 char usedflag;
 char filename[8];
 char extension[3];
 long filesize;
 struct datetime datetimestamp;
 char attribute;
 char filedirectory[70];
 char filedrive;
 struct standartfcb fcb;
 char buffer[512];
};
char *fileerror;
char currentdirectory[70];
char currentdrive;
struct filedescriptor files[32];
char isleapyear(int year)
{
 if(((year/4)*4)==year)return 1;else return 0;
}
char monthday(int year,char month)
{
 switch(month)
 {
  case 1:
   return 31;
  case 2:
   return 28+isleapyear(year);
  case 3:
   return 31;
  case 4:
   return 30;
  case 5:
   return 31;
  case 6:
   return 30;
  case 7:
   return 31;
  case 8:
   return 31;
  case 9:
   return 30;
  case 10:
   return 31;
  case 11:
   return 30;
  case 12:
   return 31;
 }
}
int monthdays(int year,char month)
{
 switch(month)
 {
  case 1:
   return 0;
  case 2:
   return 31;
  case 3:
   return 59+isleapyear(year);
  case 4:
   return 90+isleapyear(year);
  case 5:
   return 120+isleapyear(year);
  case 6:
   return 151+isleapyear(year);
  case 7:
   return 181+isleapyear(year);
  case 8:
   return 212+isleapyear(year);
  case 9:
   return 243+isleapyear(year);
  case 10:
   return 273+isleapyear(year);
  case 11:
   return 304+isleapyear(year);
  case 12:
   return 334+isleapyear(year);
 }
}
long dayscount(int year,char month,char day)
{
 return (year*365)+(year/4)+(year/100)+monthdays(year,month)+day;
}
enum daysofweek dayofweek(int year,char month,char day)
{
 return dayscount(year,month,day)-((dayscount(year,month,day)/7)*7);
}
int packdate(int year,char month,char day)
{
 return (((year-1980)*512)+(month*32))+day;
}
void unpackdate(int packeddate,struct datetime *unpackeddate)
{
 unpackeddate->year=(packeddate/512)+1980;
 unpackeddate->month=(packeddate%512)/32;
 unpackeddate->day=packeddate%32;
 unpackeddate->weekday=
 dayofweek(unpackeddate->year,unpackeddate->month,unpackeddate->day);
}
int packtime(char hour,char minute,char second)
{
 return ((hour*2048)+(minute*32))+(second/2);
}
void unpacktime(int packedtime,struct datetime *unpackedtime)
{
 unpackedtime->hour=packedtime/2048;
 unpackedtime->minute=(packedtime%2048)/32;
 unpackedtime->second=packedtime%32;
}
void getsystemdate(int *year,char *month,char *day,char *dow)
{
 struct REGPACK registers;
 strcpy(fileerror,"");
 registers.r_ax=0x2a00;
 intr(0x21,&registers);
 *year=registers.r_cx;
 *month=registers.r_dx/0x100;
 *day=registers.r_dx%0x100;
 *dow=registers.r_ax%0x100;
}
void setsystemdate(int year,char month,char day)
{
 struct REGPACK registers;
 strcpy(fileerror,"");
 registers.r_ax=0x2b00;
 registers.r_cx=year;
 registers.r_dx=(month*0x100)+day;
 intr(0x21,&registers);
 if((registers.r_ax%0x100)==0xff)strcpy(fileerror,"Bad date.");
}
void getsystemtime(char *hour,char *minute,char *second)
{
 struct REGPACK registers;
 strcpy(fileerror,"");
 registers.r_ax=0x2c00;
 intr(0x21,&registers);
 hour=registers.r_cx/0x100;
 minute=registers.r_cx%0x100;
 second=registers.r_dx/0x100;
}
void setsystemtime(char hour,char minute,char second)
{
 struct REGPACK registers;
 strcpy(fileerror,"");
 registers.r_ax=0x2d00;
 registers.r_cx=(hour*0x100)+minute;
 registers.r_dx=second*0x100;
 intr(0x10,&registers);
 if((registers.r_ax%0x100)==0xff)strcpy(fileerror,"Bad time.");
}
char getverifystat()
{
 struct REGPACK registers;
 strcpy(fileerror,"");
 registers.r_ax=0x5400;
 intr(0x21,&registers);
 return registers.r_ax%0x100;
}
void setverifystat(char verify)
{
 struct REGPACK registers;
 strcpy(fileerror,"");
 registers.r_ax=(0x2e*0x100)+(verify==true);
 intr(0x21,&registers);
}
void clearfcb(struct standartfcb *fcb)
{
 char index;
 fcb->drive=0;
 for(index=0;index<8;index++)fcb->name[index]=0;
 for(index=0;index<3;index++)fcb->extension[index]=0;
 fcb->currentblock=0;
 fcb->recordsize=0;
 fcb->filesize=0;
 fcb->filedate=0;
 fcb->filetime=0;
 for(index=0;index<8;index++)fcb->reserv[index]=0;
 fcb->currentrecord=0;
 fcb->randomrecord=0;
}
void createfile(struct standartfcb *fcb)
{
 struct REGPACK registers;
 strcpy(fileerror,"");
 registers.r_ax=0x1600;
 registers.r_ds=FP_SEG(fcb);
 registers.r_dx=FP_OFF(fcb);
 intr(0x21,&registers);
 if((registers.ax%0x100)==0xff)strcpy(fileerror,"Cannot create file.");else
 fcb->recordsize=1;
}
void openfile(struct standartfcb *fcb)
{
 struct REGPACK registers;
 strcpy(fileerror,"");
 registers.r_ax=0x0f00;
 registers.r_ds=FP_SEG(fcb);
 registers.r_dx=FP_OFF(fcb);
 intr(0x21,&registers);
 if((registers.ax%0x100)==0xff)strcpy(fileerror,"File not found.");else
 fcb->recordsize=1;
}
char readfile(struct standartfcb *fcb)
{
 struct REGPACK registers;
 char buffer;
 strcpy(fileerror,"");
 registers.r_ax=0x1a00;
 registers.r_ds=FP_SEG(buffer);
 registers.r_dx=FP_OFF(buffer);
 intr(0x21,&registers);
 registers.r_ax=0x1400;
 registers.r_ds=FP_SEG(fcb);
 registers.r_dx=FP_OFF(fcb);
 intr(0x21,&registers);
 switch(registers.r_ax%0x100)
 {
  case 1:
   strcpy(fileerror,"End of file marker found.");
   break;
  case 2:
   strcpy(fileerror,"DTA would overrun a segment.");
   break;
  case 3:
   strcpy(fileerror,"End of file marker found and data is read.");
 }
 if(strcmp(fileerror,"")==0)return buffer;else return -1;
}
void writefile(struct standartfcb *fcb,char symbol)
{
 struct REGPACK registers;
 char buffer;
 buffer=symbol;
 strcpy(fileerror,"");
 registers.r_ax=0x1a00;
 registers.r_ds=FP_SEG(buffer);
 registers.r_dx=FP_OFF(buffer);
 intr(0x21,&registers);
 registers.r_ax=0x1500;
 registers.r_ds=FP_SEG(fcb);
 registers.r_dx=FP_OFF(fcb);
 intr(0x21,&registers);
 switch(registers.r_ax%0x100)
 {
  case 1:
   strcpy(fileerror,"Disk full.");
   break;
  case 2:
   strcpy(fileerror,"DTA would overrun a segment.");
 }
}
void closefile(struct standartfcb *fcb)
{
 struct REGPACK registers;
 strcpy(fileerror,"");
 registers.r_ax=0x1000;
 registers.r_ds=FP_SEG(fcb);
 registers.r_dx=FP_OFF(fcb);
 intr(0x21,&registers);
 if((registers.ax%0x100)==0xff)strcpy(fileerror,"File could not open.");
}
void deletefile(struct standartfcb *fcb)
{
 struct REGPACK registers;
 strcpy(fileerror,"");
 registers.r_ax=0x1300;
 registers.r_ds=FP_SEG(fcb);
 registers.r_dx=FP_OFF(fcb);
 intr(0x21,&registers);
 if((registers.ax%0x100)==0xff)strcpy(fileerror,"Access denied.");
}
char currentdisk()
{
 struct REGPACK registers;
 strcpy(fileerror,"");
 registers.r_ax=0x1900;
 intr(0x21,&registers);
 return (registers.r_ax%0x100)+'A';
}
long fileposition(struct standartfcb *fcb)
{
 strcpy(fileerror,"");
 return (fcb->currentblock*128)+fcb->currentrecord;
}
void seekfile(struct standartfcb *fcb,long newposition)
{
 strcpy(fileerror,"");
 fcb->currentblock=newposition/128;
 fcb->currentrecord=newposition%128;
}
void setcurrentdisk(char diskletter)
{
 struct REGPACK registers;
 strcpy(fileerror,"");
 registers.r_ax=0x0E00;
 if(((diskletter>('A'-1))&&(diskletter<('Z'+1))))diskletter=diskletter-'A';
 else
 if(((diskletter>('a'-1))&&(diskletter<('z'+1))))diskletter=diskletter-'a';
 else
 {
  strcpy(fileerror,"Bad disk letter.");
  return;
 }
 registers.r_dx=diskletter;
 intr(0x21,&registers);
}
void findfirstfile(struct standartfcb *fcb,struct finddata *findfile)
{
 struct REGPACK registers;
 struct standartfcb workfcb;
 struct standartfcb workdata;
 char index;
 strcpy(fileerror,"");
 clearfcb(&workfcb);
 clearfcb(&workdata);
 for(index=0;index<8;index++)workfcb.name[index]=fcb->name[index];
 for(index=0;index<3;index++)workfcb.extension[index]=fcb->extension[index];
 registers.r_ax=0x1a00;
 registers.r_ds=FP_SEG(&workdata);
 registers.r_dx=FP_OFF(&workdata);
 intr(0x21,&registers);
 registers.r_ax=0x1100;
 registers.r_ds=FP_SEG(&workfcb);
 registers.r_dx=FP_OFF(&workfcb);
 intr(0x21,&registers);
 if((registers.r_ax%0x100)==0xff)strcpy(fileerror,"Match not found.");else
 {
  findfile->filesize=workdata.filesize;
  for(index=0;index<12;index++)findfile->filename[index]=' ';
  for(index=0;index<8;index++)findfile->filename[index]=workdata.name[index];
  if(workdata.extension[0]!=' ')
  {
   char position;
   for(index=0;index<12;index++)if(findfile->filename[index]==' ')break;
   position=index;
   findfile->filename[index]='.';
   for(index=0;index<3;index++)
   findfile->filename[position+(index+1)]=workdata.extension[index];
   for(index=0;index<12;index++)if(findfile->filename[index]==' ')
   findfile->filename[index]=0;
   findfile->filedate=workdata.filedate;
   findfile->filetime=workdata.filetime;
   findfile->fcb.drive=workfcb.drive;
   for(index=0;index<8;index++)findfile->fcb.name[index]=workfcb.name[index];
   for(index=0;index<3;index++)
   findfile->fcb.extension[index]=workfcb.extension[index];
   findfile->fcb.currentblock=workfcb.currentblock;
   findfile->fcb.recordsize=workfcb.recordsize;
   findfile->fcb.filesize=workfcb.filesize;
   findfile->fcb.filedate=workfcb.filedate;
   findfile->fcb.filetime=workfcb.filetime;
   for(index=0;index<8;index++)
   findfile->fcb.reserv[index]=workfcb.reserv[index];
   findfile->fcb.currentrecord=workfcb.currentrecord;
   findfile->fcb.randomrecord=workfcb.randomrecord;
  }
 }
}
void findnextfile(struct finddata *findfile)
{
 struct REGPACK registers;
 struct standartfcb workfcb;
 struct standartfcb workdata;
 char index;
 strcpy(fileerror,"");
 clearfcb(&workfcb);
 clearfcb(&workdata);
 registers.r_ax=0x1a00;
 registers.r_ds=FP_SEG(&workdata);
 registers.r_dx=FP_OFF(&workdata);
 intr(0x21,&registers);
 workfcb.drive=findfile->fcb.drive;
 for(index=0;index<8;index++)workfcb.name[index]=findfile->fcb.name[index];
 for(index=0;index<3;index++)
 workfcb.extension[index]=findfile->fcb.extension[index];
 workfcb.currentblock=findfile->fcb.currentblock;
 workfcb.recordsize=findfile->fcb.recordsize;
 workfcb.filesize=findfile->fcb.filesize;
 workfcb.filedate=findfile->fcb.filedate;
 workfcb.filetime=findfile->fcb.filetime;
 for(index=0;index<8;index++)
 workfcb.reserv[index]=findfile->fcb.reserv[index];
 workfcb.currentrecord=findfile->fcb.currentrecord;
 workfcb.randomrecord=findfile->fcb.randomrecord;
 registers.r_ax=0x1200;
 registers.r_ds=FP_SEG(&workfcb);
 registers.r_dx=FP_OFF(&workfcb);
 intr(0x21,&registers);
 if((registers.r_ax%0x100)==0xff)strcpy(fileerror,"Match not found.");else
 {
  findfile->filesize=workdata.filesize;
  for(index=0;index<12;index++)findfile->filename[index]=' ';
  for(index=0;index<8;index++)findfile->filename[index]=workdata.name[index];
  if(workdata.extension[0]!=' ')
  {
   char position;
   for(index=0;index<12;index++)if(findfile->filename[index]==' ')break;
   position=index;
   findfile->filename[index]='.';
   for(index=0;index<3;index++)
   findfile->filename[position+(index+1)]=workdata.extension[index];
   for(index=0;index<12;index++)if(findfile->filename[index]==' ')
   findfile->filename[index]=0;
   findfile->filedate=workdata.filedate;
   findfile->filetime=workdata.filetime;
   findfile->fcb.drive=workfcb.drive;
   for(index=0;index<8;index++)findfile->fcb.name[index]=workfcb.name[index];
   for(index=0;index<3;index++)
   findfile->fcb.extension[index]=workfcb.extension[index];
   findfile->fcb.currentblock=workfcb.currentblock;
   findfile->fcb.recordsize=workfcb.recordsize;
   findfile->fcb.filesize=workfcb.filesize;
   findfile->fcb.filedate=workfcb.filedate;
   findfile->fcb.filetime=workfcb.filetime;
   for(index=0;index<8;index++)
   findfile->fcb.reserv[index]=workfcb.reserv[index];
   findfile->fcb.currentrecord=workfcb.currentrecord;
   findfile->fcb.randomrecord=workfcb.randomrecord;
  }
 }
}
void getcurrentdirectory(char drive,char *resultname)
{
 struct REGPACK registers;
 char directoryname[64];
 strcpy(fileerror,"");
 registers.r_ax=0x4700;
 registers.ds=FP_SEG(&directoryname);
 registers.si=FP_OFF(&directoryname);
 registers.dx=drive;
 intr(0x21,&registers);
 if(!(registers.r_flags&&fcarry))strcpy(fileerror,"Disk letter has invalid.");
 else
 {
  *resultname=currentdisk();
  resultname++;
  *resultname=0;
  strcat(resultname,":\\");
  strcat(resultname,directoryname);
 }
}
char assignfile(char *filename)
{
 int index;
 char usedfile;
 char *resultname;
 char filedisk;
 char filedirectory[70];
 char filetruename[8];
 char fileextension[3];
 char *namebuffer;
 char buffer[2];
 char pointflag=0;
 for(index=0;index<70;index++)filedirectory[index]=0;
 for(index=0;index<8;index++)filetruename[index]=0;
 for(index=0;index<3;index++)fileextension[index]=0;
 for(index=0;index<33;index++)
 {
  if(index==33)return -1;
  if(files[index].usedflag==0)break;
 }
 usedfile=index;
 strupr(filename);
 if(*filename==0)return -1;
 strcpy(namebuffer,"");
 for(index=0;index<2;index++)buffer[index]=0;
 if(*filename=='\\')
 {
  filedisk=currentdisk();
  filename++;
  strcpy(&filedirectory,"\\;");
 } else if(*(filename+1)==':')
 {
  filedisk=*filename;
  for(index=0;index<3;index++)filename++;
  strcpy(&filedirectory,"\\;");
 } else
 {
  getcurrentdirectory(0,namebuffer);
  filedisk=*namebuffer;
  for(index=0;index<2;index++)namebuffer++;
  strcpy(&filedirectory,"\\;");
  while(*namebuffer!=0)
  {
   switch(*namebuffer)
   {
    case '\\':
     strcat(&filedirectory,";");
     break;
    default:
     buffer[0]=*namebuffer;
     strcat(&filedirectory,&buffer);
   }
   namebuffer++;
  }
 }
 strcpy(namebuffer,"");
 while(strchr(filename,'\\')!=0)
 {
  switch(*filename)
  {
   case '\\':
    if((strlen(namebuffer)>8)||(strlen(namebuffer)<1))return -1;
    strcat(&filedirectory,namebuffer);
    strcat(&filedirectory,";");
    strcpy(namebuffer,"");
    pointflag=0;
    break;
   case '.':
    if(pointflag==1)return -1;
    if((strlen(namebuffer)>8)||(strlen(namebuffer)<1))return -1;
    if(filedirectory[strlen(&filedirectory)-1]!=';')return -1;
    strcat(&filedirectory,namebuffer);
    strcat(&filedirectory,".");
    strcpy(namebuffer,"");
    pointflag=1;
    break;
   default:
    if(pointflag==1)
    {
     if(strlen(namebuffer)==3)return -1;
    }
    {
     if(strlen(namebuffer)==8)return -1;
    }
    buffer[0]=*filename;
    strcat(namebuffer,&buffer);
  }
  filename++;
 }
 if(strlen(namebuffer)!=0)return -1;
 if(strchr(filename,'.')>0)
 {
  while(*filename!=0)
  {
   if(*filename=='.')break;
   if(strlen(namebuffer)==8)return -1;
   buffer[0]=*filename;
   strcat(namebuffer,&buffer);
   filename++;
  }
 } else strcpy(namebuffer,filename);
 if((strlen(namebuffer)>8)||(strlen(namebuffer)<1))return -1;
 strcpy(&filetruename,namebuffer);
 if(*filename=='.')
 {
  filename++;
  strcpy(namebuffer,filename);
  if((strlen(namebuffer)>3)||(strlen(namebuffer)<1))return -1;
  strcpy(&fileextension,namebuffer);
 }
 files[usedfile].usedflag=1;
 for(index=0;index<8;index++)files[usedfile].filename[index]=' ';
 for(index=0;index<8;index++)
 files[usedfile].filename[index]=filetruename[index];
 for(index=0;index<3;index++)files[usedfile].extension[index]=' ';
 for(index=0;index<3;index++)
 files[usedfile].extension[index]=fileextension[index];
 files[usedfile].filesize=0;
 files[usedfile].datetimestamp.year=0;
 files[usedfile].datetimestamp.month=0;
 files[usedfile].datetimestamp.day=0;
 files[usedfile].datetimestamp.weekday=sunday;
 files[usedfile].datetimestamp.hour=0;
 files[usedfile].datetimestamp.minute=0;
 files[usedfile].datetimestamp.second=0;
 files[usedfile].attribute=0;
 for(index=0;index<70;index++)
 files[usedfile].filedirectory[index]=filedirectory[index];
 files[usedfile].filedrive=filedisk;
 clearfcb(&files[usedfile].fcb);
 for(index=0;index<512;index++)files[usedfile].buffer[index]=0;
}
void main()
{
 char file;
 file=assignfile("C:\\SANDUL.YU\\H\\Text.txt");
}
