REM     The Standart GNU Personal ANSI Typewriter.
REM     Copyright (C) Sandul Yura Valentinovich.
REM     (R) Wednesday, 5 March 2003 year.
REM     This program is free software; you can redistribute it and/or modify
REM it under the terms of the GNU General Public License as published by the
REM Free Software Foundation; either version 2 of the License, or (at your
REM option) any later version.
REM     This program is distributed in the hope that it will be useful, but
REM WITHOUT ANY WARRANTY; without even the implied warranty of
REM MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
REM Public License for more details.
REM     You should have received a copy of the GNU General Public License
REM along with this program; if not, write to the Free Software Foundation,
REM Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
REM
REM $DYNAMIC
DECLARE SUB ClearANSI ()
DECLARE SUB ANSIOut (ANSISymbol$)
DECLARE FUNCTION DayOfWeekName$ (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION DayName$ (DayNumber%)
DECLARE FUNCTION DayOfWeek% (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION DaysCount& (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION IsLeapYear% (YearValue%)
DECLARE FUNCTION MonthDaysCount% (MonthValue%, YearValue%)
DECLARE FUNCTION MonthName$ (MonthNumber%)
DECLARE FUNCTION WeekNumber% (DayValue%, MonthValue%, YearValue%)
OPTION BASE 1
CONST False% = 0
CONST True% = NOT False%
CONST ANSIParametersCountValue% = 64
CONST ANSICursorsCountValue% = 64
DIM SHARED CursorRows%(ANSICursorsCountValue%)
DIM SHARED CursorColumns%(ANSICursorsCountValue%)
DIM SHARED CursorCount%
DIM SHARED Parameters%(ANSIParametersCountValue%)
DIM SHARED ParametersCount%
DIM SHARED ANSIMode%
DIM SHARED NumberLine$
DIM ANSIFile$
DIM ANSISymbol$
DIM WorkKey$
SCREEN 0, 1, 0, 0
COLOR 7, 0
CLS
LOCATE 1, 1, 1, 7, 8
PRINT "    The Standart GNU Personal ANSI Typewriter."
PRINT "    Copyright (C) Sandul Yura Valentinovich."
PRINT "    (R) Wednesday, 5 March 2003 year."
PRINT "    This program is free software; you can redistribute it and/or modify it"
PRINT "under the terms of the GNU General Public License as published by the Free"
PRINT "Software Foundation; either version 2 of the License, or (at your option) any"
PRINT "later version."
PRINT "    This program is distributed in the hope that it will be useful, but WITHOUT"
PRINT "ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS"
PRINT "FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details."
PRINT "    You should have received a copy of the GNU General Public License along with"
PRINT "this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,"
PRINT "Cambridge, MA 02139, USA."
PRINT
PRINT "Current date: " + DayOfWeekName$(VAL(MID$(DATE$, 4, 2)), VAL(MID$(DATE$, 1, 2)), VAL(MID$(DATE$, 7, 4))) + ", " + LTRIM$(STR$(VAL(MID$(DATE$, 4, 2)))) + " " + MonthName$(VAL(MID$(DATE$, 1, 2))) + " " + LTRIM$(STR$(VAL(MID$(DATE$, 7, 4))));
PRINT " year, time: " + TIME$ + ", week: " + LTRIM$(STR$(WeekNumber%(VAL(MID$(DATE$, 4, 2)), VAL(MID$(DATE$, 1, 2)), VAL(MID$(DATE$, 7, 4))))) + "."
PRINT "Free stack space: " + LTRIM$(STR$(FRE(-2))) + " bytes."
PRINT "Please enter name of ANSI text file for typewrite it (empty line to quit)."
LINE INPUT ANSIFile$
ANSIFile$ = LTRIM$(RTRIM$(UCASE$(ANSIFile$)))
IF ANSIFile$ = "" THEN END
ON ERROR GOTO CannotOpenANSIFile
OPEN ANSIFile$ FOR INPUT AS #1
ON ERROR GOTO 0
WHILE NOT EOF(1)
 ON ERROR GOTO CannotReadFromANSIFile
 ANSISymbol$ = INPUT$(1, #1)
 ON ERROR GOTO 0
 CALL ANSIOut(ANSISymbol$)
WEND
CLOSE #1
END
CannotOpenANSIFile:
 PRINT "Cannot open ANSI file. Retry opening (ENTER=Yes,ESC=No)?"
 DO
  WorkKey$ = INKEY$
 LOOP UNTIL (WorkKey$ = CHR$(13)) OR (WorkKey$ = CHR$(27))
 IF WorkKey$ = CHR$(13) THEN RESUME
 END
CannotReadFromANSIFile:
 PRINT "Cannot read from ANSI file. Retry reading (ENTER=Yes,ESC=No)?"
 DO
  WorkKey$ = INKEY$
 LOOP UNTIL (WorkKey$ = CHR$(13)) OR (WorkKey$ = CHR$(27))
 IF WorkKey$ = CHR$(13) THEN RESUME
 CLOSE #1
 END

SUB ANSIOut (ANSISymbol$)
 DIM CurrentColumn%
 DIM Index%
 SELECT CASE ANSIMode%
 CASE 0
   SELECT CASE ANSISymbol$
   CASE CHR$(10)
     PRINT
   CASE CHR$(27)
     ANSIMode% = 1
   CASE ELSE
     IF ANSISymbol$ <> "" THEN IF ASC(ANSISymbol$) > (ASC(SPACE$(1)) - 1) THEN PRINT ANSISymbol$;
   END SELECT
 CASE 1
   SELECT CASE ANSISymbol$
   CASE "["
     ANSIMode% = 2
   CASE ELSE
     CALL ClearANSI
     CALL ANSIOut(ANSISymbol$)
   END SELECT
 CASE 2
   SELECT CASE ANSISymbol$
   CASE "H"
     SELECT CASE ParametersCount%
     CASE 0
       LOCATE 1, 1, 1, 7, 8
     CASE 1
       IF Parameters%(1) < 1 THEN Parameters%(1) = 1
       IF Parameters%(1) > 25 THEN Parameters%(1) = 25
       LOCATE Parameters%(1), 1, 1, 7, 8
     CASE ELSE
       IF Parameters%(1) < 1 THEN Parameters%(1) = 1
       IF Parameters%(1) > 25 THEN Parameters%(1) = 25
       IF Parameters%(2) < 1 THEN Parameters%(2) = 1
       IF Parameters%(2) > 80 THEN Parameters%(2) = 80
       LOCATE Parameters%(1), Parameters%(2), 1, 7, 8
     END SELECT
     CALL ClearANSI
   CASE "f"
     SELECT CASE ParametersCount%
     CASE 0
       LOCATE 1, 1, 1, 7, 8
     CASE 1
       IF Parameters%(1) < 1 THEN Parameters%(1) = 1
       IF Parameters%(1) > 25 THEN Parameters%(1) = 25
       LOCATE Parameters%(1), 1, 1, 7, 8
     CASE ELSE
       IF Parameters%(1) < 1 THEN Parameters%(1) = 1
       IF Parameters%(1) > 25 THEN Parameters%(1) = 25
       IF Parameters%(2) < 1 THEN Parameters%(2) = 1
       IF Parameters%(2) > 80 THEN Parameters%(2) = 80
       LOCATE Parameters%(1), Parameters%(2), 1, 7, 8
     END SELECT
     CALL ClearANSI
   CASE "A"
     IF Parameters%(1) < 1 THEN Parameters%(1) = 1
     IF (CSRLIN - Parameters%(1)) > 0 THEN LOCATE CSRLIN - Parameters%(1), POS(0), 1, 7, 8
     CALL ClearANSI
   CASE "B"
     IF Parameters%(1) < 1 THEN Parameters%(1) = 1
     IF (CSRLIN + Parameters%(1)) < 26 THEN LOCATE CSRLIN + Parameters%(1), POS(0), 1, 7, 8
     CALL ClearANSI
   CASE "C"
     IF Parameters%(1) < 1 THEN Parameters%(1) = 1
     IF (POS(0) + Parameters%(1)) < 81 THEN LOCATE CSRLIN, POS(0) + Parameters%(1), 1, 7, 8
     CALL ClearANSI
   CASE "D"
     IF Parameters%(1) < 1 THEN Parameters%(1) = 1
     IF (POS(0) - Parameters%(1)) > 0 THEN LOCATE CSRLIN, POS(0) - Parameters%(1), 1, 7, 8
     CALL ClearANSI
   CASE "s"
     IF CursorCount% < ANSICursorsCountValue% THEN
      CursorCount% = CursorCount% + 1
      CursorRows%(CursorCount%) = CSRLIN
      CursorColumns%(CursorCount%) = POS(0)
     END IF
     CALL ClearANSI
   CASE "u"
     IF CursorCount% > 0 THEN
      LOCATE CursorRows%(CursorCount%), CursorColumns%(CursorCount%), 1, 7, 8
      CursorRows%(CursorCount%) = 0
      CursorColumns%(CursorCount%) = 0
      CursorCount% = CursorCount% - 1
     END IF
     CALL ClearANSI
   CASE "J"
     CLS
     CALL ClearANSI
     LOCATE 1, 1, 1, 7, 8
   CASE "K"
     CurrentColumn% = POS(0)
     PRINT SPACE$(80 - POS(0));
     LOCATE CSRLIN, CurrentColumn%, 1, 7, 8
     CurrentColumn% = 0
     CALL ClearANSI
   CASE "m"
     IF ParametersCount% > 0 THEN
      FOR Index% = 1 TO ParametersCount%
       SELECT CASE Parameters%(Index%)
       CASE 0
         COLOR 7, 0
       CASE 1
         COLOR 15
       CASE 4
         COLOR 1
       CASE 5
         COLOR 7
       CASE 7
         COLOR 0, 7
       CASE 8
         COLOR 0, 0
       CASE 30
         COLOR 0
       CASE 31
         COLOR 4
       CASE 32
         COLOR 2
       CASE 33
         COLOR 6
       CASE 34
         COLOR 1
       CASE 35
         COLOR 5
       CASE 36
         COLOR 3
       CASE 37
         COLOR 15
       CASE 40
         COLOR , 0
       CASE 41
         COLOR , 4
       CASE 42
         COLOR , 2
       CASE 43
         COLOR , 6
       CASE 44
         COLOR , 1
       CASE 45
         COLOR , 5
       CASE 46
         COLOR , 3
       CASE 47
         COLOR , 7
       END SELECT
      NEXT Index%
     ELSE
      COLOR 7, 0
     END IF
     CALL ClearANSI
   CASE "0" TO "9"
     ANSIMode% = 3
     CALL ANSIOut(ANSISymbol$)
   CASE ";"
     ParametersCount% = 1
   CASE ELSE
     CALL ClearANSI
     CALL ANSIOut(ANSISymbol$)
   END SELECT
 CASE 3
   SELECT CASE ANSISymbol$
   CASE "0" TO "9"
     IF LEN(NumberLine$) < 2 THEN NumberLine$ = NumberLine$ + ANSISymbol$
   CASE ";"
     IF ParametersCount% < ANSIParametersCountValue% THEN
      ParametersCount% = ParametersCount% + 1
      Parameters%(ParametersCount%) = VAL(NumberLine$)
     END IF
     NumberLine$ = ""
   CASE ELSE
     IF ParametersCount% < ANSIParametersCountValue% THEN
      ParametersCount% = ParametersCount% + 1
      Parameters%(ParametersCount%) = VAL(NumberLine$)
     END IF
     ANSIMode% = 2
     CALL ANSIOut(ANSISymbol$)
   END SELECT
 END SELECT
END SUB

SUB ClearANSI
 DIM Index%
 FOR Index% = 1 TO ANSIParametersCountValue%
  Parameters%(Index%) = 0
 NEXT Index%
 ParametersCount% = 0
 ANSIMode% = 0
 NumberLine$ = ""
END SUB

FUNCTION DayName$ (DayNumber%)
 SELECT CASE DayNumber%
 CASE 1
   DayName$ = "Monday"
 CASE 2
   DayName$ = "Tuesday"
 CASE 3
   DayName$ = "Wednesday"
 CASE 4
   DayName$ = "Thursday"
 CASE 5
   DayName$ = "Friday"
 CASE 6
   DayName$ = "Saturday"
 CASE 7
   DayName$ = "Sunday"
 END SELECT
END FUNCTION

FUNCTION DayOfWeek% (DayValue%, MonthValue%, YearValue%)
 SELECT CASE DaysCount&(DayValue%, MonthValue%, YearValue%) - (INT(DaysCount&(DayValue%, MonthValue%, YearValue%) / 7) * 7)
 CASE 0
   DayOfWeek% = 6
 CASE 1
   DayOfWeek% = 7
 CASE 2
   DayOfWeek% = 1
 CASE 3
   DayOfWeek% = 2
 CASE 4
   DayOfWeek% = 3
 CASE 5
   DayOfWeek% = 4
 CASE 6
   DayOfWeek% = 5
 CASE 7
   DayOfWeek% = 6
 END SELECT
END FUNCTION

FUNCTION DayOfWeekName$ (DayValue%, MonthValue%, YearValue%)
 DayOfWeekName$ = DayName$(DayOfWeek%(DayValue%, MonthValue%, YearValue%))
END FUNCTION

FUNCTION DaysCount& (DayValue%, MonthValue%, YearValue%)
 DaysCount& = (YearValue% * 365#) + INT(YearValue% / 100) + INT(YearValue% / 4) + MonthDaysCount%(MonthValue%, YearValue%) + DayValue%
END FUNCTION

FUNCTION IsLeapYear% (YearValue%)
 IsLeapYear% = ABS((INT(YearValue% / 4) * 4) = YearValue%)
END FUNCTION

FUNCTION MonthDaysCount% (MonthValue%, YearValue%)
 SELECT CASE MonthValue%
 CASE 1
   MonthDaysCount% = 0
 CASE 2
   MonthDaysCount% = 31
 CASE 3
   MonthDaysCount% = 59 + IsLeapYear%(YearValue%)
 CASE 4
   MonthDaysCount% = 90 + IsLeapYear%(YearValue%)
 CASE 5
   MonthDaysCount% = 120 + IsLeapYear%(YearValue%)
 CASE 6
   MonthDaysCount% = 151 + IsLeapYear%(YearValue%)
 CASE 7
   MonthDaysCount% = 181 + IsLeapYear%(YearValue%)
 CASE 8
   MonthDaysCount% = 212 + IsLeapYear%(YearValue%)
 CASE 9
   MonthDaysCount% = 243 + IsLeapYear%(YearValue%)
 CASE 10
   MonthDaysCount% = 273 + IsLeapYear%(YearValue%)
 CASE 11
   MonthDaysCount% = 304 + IsLeapYear%(YearValue%)
 CASE 12
   MonthDaysCount% = 334 + IsLeapYear%(YearValue%)
 END SELECT
END FUNCTION

FUNCTION MonthName$ (MonthNumber%)
 SELECT CASE MonthNumber%
 CASE 1
   MonthName$ = "January"
 CASE 2
   MonthName$ = "February"
 CASE 3
   MonthName$ = "March"
 CASE 4
   MonthName$ = "April"
 CASE 5
   MonthName$ = "May"
 CASE 6
   MonthName$ = "June"
 CASE 7
   MonthName$ = "July"
 CASE 8
   MonthName$ = "August"
 CASE 9
   MonthName$ = "September"
 CASE 10
   MonthName$ = "October"
 CASE 11
   MonthName$ = "November"
 CASE 12
   MonthName$ = "December"
 END SELECT
END FUNCTION

FUNCTION WeekNumber% (DayValue%, MonthValue%, YearValue%)
 WeekNumber% = INT((MonthDaysCount%(MonthValue%, YearValue%) + DayValue%) / 7) + 1
END FUNCTION

