REM     The Standart GNU Personal Picture Editor.
REM     Copyright (C) Sandul Yura Valentinovich.
REM     (R) Wednesday, 5 March 2003 year.
REM     This program is free software; you can redistribute it and/or modify
REM it under the terms of the GNU General Public License as published by the
REM Free Software Foundation; either version 2 of the License, or (at your
REM option) any later version.
REM     This program is distributed in the hope that it will be useful, but
REM WITHOUT ANY WARRANTY; without even the implied warranty of
REM MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
REM Public License for more details.
REM     You should have received a copy of the GNU General Public License
REM along with this program; if not, write to the Free Software Foundation,
REM Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
REM
REM $DYNAMIC
DECLARE SUB ScratchScreen ()
DECLARE SUB OutBox (Title$, Message$)
DECLARE SUB MakeBox (BoxColumn%, BoxRow%, BoxWidth%, BoxHeight%)
DECLARE SUB OutPicture ()
DECLARE FUNCTION CurrentDateTime$ ()
DECLARE FUNCTION DayName$ (DayNumber%)
DECLARE FUNCTION DayOfWeek% (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION DayOfWeekName$ (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION DaysCount& (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION InputBox% (Title$, Message$, InputTextLine$)
DECLARE FUNCTION IsLeapYear% (YearValue%)
DECLARE FUNCTION MenuBox% (ItemsCount%)
DECLARE FUNCTION MessageBox% (Title$, Message$)
DECLARE FUNCTION MonthDays% (MonthValue%, YearValue%)
DECLARE FUNCTION MonthDaysCount% (MonthValue%, YearValue%)
DECLARE FUNCTION MonthName$ (MonthNumber%)
DECLARE FUNCTION ColorName$ (ColorNumber%)
OPTION BASE 1
CONST False% = 0
CONST True% = NOT False%
DIM SHARED MenuItems$(17)
DIM SHARED Picture$(20)
DIM SHARED PictureRow%
DIM SHARED PictureColumn%
DIM SHARED StatusText$
DIM SHARED PictureName$
DIM SHARED CurrentColor%
DIM Index%
DIM WorkKey$
DIM OldSecond%
DIM WorkLine$
DIM WorkIndex%
DIM Work$
PictureRow% = 1
PictureColumn% = 1
PictureName$ = "Picture.pic"
CurrentColor% = 15
FOR Index% = 1 TO 20
 Picture$(Index%) = SPACE$(77)
NEXT Index%
StatusText$ = CurrentDateTime$
OldSecond% = NOT VAL(MID$(TIME$, 7, 2))
SCREEN 0, 1, 0, 0
CALL ScratchScreen
CALL OutPicture
DO
 IF OldSecond% <> VAL(MID$(TIME$, 7, 2)) THEN
  OldSecond% = VAL(MID$(TIME$, 7, 2))
  StatusText$ = CurrentDateTime$
  CALL OutPicture
 END IF
 WorkKey$ = INKEY$
 SELECT CASE LEN(WorkKey$)
 CASE 1
   IF WorkKey$ = CHR$(27) THEN
    StatusText$ = "Main menu."
    CALL ScratchScreen
    CALL OutPicture
    MenuItems$(1) = "Change current color."
    MenuItems$(2) = "Save picture."
    MenuItems$(3) = "Save picture with other name."
    MenuItems$(4) = "Load picture."
    MenuItems$(5) = "Quit."
    SELECT CASE MenuBox%(5)
    CASE 1
      StatusText$ = "Color selection."
      CALL ScratchScreen
      CALL OutPicture
      FOR Index% = 1 TO 16
       MenuItems$(Index%) = ColorName$(Index% - 1)
      NEXT Index%
      MenuItems$(17) = "Cancel."
      Index% = MenuBox%(17)
      IF (Index% > 0) AND (Index% < 17) THEN CurrentColor% = Index% - 1
    CASE 2
      StatusText$ = "Save picture. Please waith..."
      CALL ScratchScreen
      CALL OutPicture
      ON ERROR GOTO CannotOpenFileForSave
      OPEN PictureName$ FOR OUTPUT AS #1
      ON ERROR GOTO 0
      FOR Index% = 1 TO 20
       ON ERROR GOTO CannotWriteToFileForSave
       PRINT #1, Picture$(Index%)
       ON ERROR GOTO 0
      NEXT Index%
      CLOSE #1
    CASE 3
      StatusText$ = "Save picture with other name."
      CALL ScratchScreen
      CALL OutPicture
      WorkLine$ = ""
      IF InputBox%("Picture editor.", "Please enter file name for save picture with other name.", WorkLine$) THEN
       CALL ScratchScreen
       CALL OutPicture
       WorkLine$ = UCASE$(LEFT$(LTRIM$(RTRIM$(WorkLine$)), 1)) + LCASE$(MID$(LTRIM$(RTRIM$(WorkLine$)), 2))
       IF (WorkLine$ = "") OR (LEN(WorkLine$) > 12) OR (INSTR(WorkLine$, ":") > 0) OR (INSTR(WorkLine$, "/") > 0) OR (INSTR(WorkLine$, "\") > 0) OR (INSTR(WorkLine$, "?") > 0) OR (INSTR(WorkLine$, "*") > 0) THEN
        CALL OutBox("Picture editor.", "You input the invalid file name.")
       ELSE
        ON ERROR GOTO CannotOpenFileForSave
        OPEN WorkLine$ FOR OUTPUT AS #1
        ON ERROR GOTO 0
        FOR Index% = 1 TO 20
         ON ERROR GOTO CannotWriteToFileForSave
         PRINT #1, Picture$(Index%)
         ON ERROR GOTO 0
        NEXT Index%
        CLOSE #1
        PictureName$ = WorkLine$
       END IF
      END IF
    CASE 4
      StatusText$ = "Load picture."
      CALL ScratchScreen
      CALL OutPicture
      WorkLine$ = ""
      IF InputBox%("Picture editor.", "Please enter file name for load picture with other name.", WorkLine$) THEN
       CALL ScratchScreen
       CALL OutPicture
       WorkLine$ = UCASE$(LEFT$(LTRIM$(RTRIM$(WorkLine$)), 1)) + LCASE$(MID$(LTRIM$(RTRIM$(WorkLine$)), 2))
       IF (WorkLine$ = "") OR (LEN(WorkLine$) > 12) OR (INSTR(WorkLine$, ":") > 0) OR (INSTR(WorkLine$, "/") > 0) OR (INSTR(WorkLine$, "\") > 0) OR (INSTR(WorkLine$, "?") > 0) OR (INSTR(WorkLine$, "*") > 0) THEN
        CALL OutBox("Picture editor.", "You input the invalid file name.")
       ELSE
        IF MessageBox%("Picture editor.", "Save picture before load?") THEN
         StatusText$ = "Save picture. Please waith..."
         CALL ScratchScreen
         CALL OutPicture
         ON ERROR GOTO CannotOpenFileForSave
         OPEN PictureName$ FOR OUTPUT AS #1
         ON ERROR GOTO 0
         FOR Index% = 1 TO 20
          ON ERROR GOTO CannotWriteToFileForSave
          PRINT #1, Picture$(Index%)
          ON ERROR GOTO 0
         NEXT Index%
         CLOSE #1
        END IF
        StatusText$ = "Load picture."
        CALL ScratchScreen
        CALL OutPicture
        ON ERROR GOTO CannotOpenFileForLoad
        OPEN WorkLine$ FOR INPUT AS #1
        ON ERROR GOTO 0
        FOR Index% = 1 TO 20
         Picture$(Index%) = SPACE$(77)
        NEXT Index%
        CurrentColor% = 0
        PictureRow% = 1
        PictureColumn% = 1
        Index% = 1
        DO WHILE NOT EOF(1)
         ON ERROR GOTO CannotReadFromFileForLoad
         LINE INPUT #1, Work$
         ON ERROR GOTO 0
         Work$ = LEFT$(Work$, 77)
         Work$ = Work$ + SPACE$(77 - LEN(Work$))
         FOR WorkIndex% = 1 TO 77
          IF ASC(MID$(Work$, WorkIndex%)) < ASC(SPACE$(1)) THEN Work$ = MID$(Work$, 1, WorkIndex% - 1) + CHR$(ASC(MID$(Work$, WorkIndex%)) + ASC(SPACE$(1))) + MID$(Work$, WorkIndex% + 1)
          IF ASC(MID$(Work$, WorkIndex%)) > (ASC(SPACE$(1)) + 15) THEN Work$ = MID$(Work$, 1, WorkIndex% - 1) + CHR$(INT(ASC(MID$(Work$, WorkIndex%)) / &H10) + ASC(SPACE$(1))) + MID$(Work$, WorkIndex% + 1)
         NEXT WorkIndex%
         Picture$(Index%) = Work$
         Index% = Index% + 1
         IF Index% = 21 THEN EXIT DO
        LOOP
        CLOSE #1
        PictureName$ = WorkLine$
       END IF
      END IF
    CASE 5
      StatusText$ = "Quit."
      CALL ScratchScreen
      CALL OutPicture
      IF MessageBox%("Picture editor.", "Save picture before quit?") THEN
       StatusText$ = "Save picture. Please waith..."
       CALL ScratchScreen
       CALL OutPicture
       ON ERROR GOTO CannotOpenFileForSave
       OPEN PictureName$ FOR OUTPUT AS #1
       ON ERROR GOTO 0
       FOR Index% = 1 TO 20
        ON ERROR GOTO CannotWriteToFileForSave
        PRINT #1, Picture$(Index%)
        ON ERROR GOTO 0
       NEXT Index%
       CLOSE #1
      END IF
      EXIT DO
    END SELECT
    StatusText$ = CurrentDateTime$
    CALL ScratchScreen
    CALL OutPicture
   END IF
 CASE 2
   WorkKey$ = MID$(WorkKey$, 2)
   SELECT CASE WorkKey$
   CASE CHR$(72)
     IF PictureRow% > 1 THEN
      PictureRow% = PictureRow% - 1
      CALL OutPicture
     END IF
   CASE CHR$(80)
     IF PictureRow% < 20 THEN
      PictureRow% = PictureRow% + 1
      CALL OutPicture
     END IF
   CASE CHR$(73)
     IF PictureRow% <> 1 THEN
      PictureRow% = 1
      CALL OutPicture
     END IF
   CASE CHR$(81)
     IF PictureRow% <> 20 THEN
      PictureRow% = 20
      CALL OutPicture
     END IF
   CASE CHR$(75)
     IF PictureColumn% > 1 THEN
      PictureColumn% = PictureColumn% - 1
      CALL OutPicture
     END IF
   CASE CHR$(77)
     IF PictureColumn% < 77 THEN
      PictureColumn% = PictureColumn% + 1
      CALL OutPicture
     END IF
   CASE CHR$(71)
     IF PictureColumn% <> 1 THEN
      PictureColumn% = 1
      CALL OutPicture
     END IF
   CASE CHR$(79)
     IF PictureColumn% <> 77 THEN
      PictureColumn% = 77
      CALL OutPicture
     END IF
   CASE CHR$(82)
     Picture$(PictureRow%) = MID$(Picture$(PictureRow%), 1, PictureColumn% - 1) + CHR$(CurrentColor% + ASC(SPACE$(1))) + MID$(Picture$(PictureRow%), PictureColumn% + 1)
     CALL OutPicture
   CASE CHR$(83)
     Picture$(PictureRow%) = MID$(Picture$(PictureRow%), 1, PictureColumn% - 1) + SPACE$(1) + MID$(Picture$(PictureRow%), PictureColumn% + 1)
     CALL OutPicture
   END SELECT
 END SELECT
PictureWork:
LOOP
COLOR 7, 0
CLS
LOCATE 1, 1, 1, 7, 8
END
CannotOpenFileForSave:
 IF MessageBox%("Picture editor.", "Cannot open file for save. Retry opening?") THEN
  CALL ScratchScreen
  CALL OutPicture
  RESUME
 ELSE
  StatusText$ = CurrentDateTime$
  CALL ScratchScreen
  CALL OutPicture
  RESUME PictureWork
 END IF
CannotWriteToFileForSave:
 IF MessageBox%("Picture editor.", "Cannot write to file. Retry writing?") THEN
  CALL ScratchScreen
  CALL OutPicture
  RESUME
 ELSE
  CLOSE #1
  StatusText$ = CurrentDateTime$
  CALL ScratchScreen
  CALL OutPicture
  RESUME PictureWork
 END IF
CannotOpenFileForLoad:
 IF MessageBox%("Picture editor.", "Cannot open file for load. Retry opening?") THEN
  CALL ScratchScreen
  CALL OutPicture
  RESUME
 ELSE
  StatusText$ = CurrentDateTime$
  CALL ScratchScreen
  CALL OutPicture
  RESUME PictureWork
 END IF
CannotReadFromFileForLoad:
 IF MessageBox%("Picture editor.", "Cannot read from file. Retry reading?") THEN
  CALL ScratchScreen
  CALL OutPicture
  RESUME
 ELSE
  CLOSE #1
  StatusText$ = CurrentDateTime$
  CALL ScratchScreen
  CALL OutPicture
  RESUME PictureWork
 END IF

FUNCTION ColorName$ (ColorNumber%)
 SELECT CASE ColorNumber%
 CASE 0
   ColorName$ = "Black"
 CASE 1
   ColorName$ = "Blue"
 CASE 2
   ColorName$ = "Green"
 CASE 3
   ColorName$ = "Cyan"
 CASE 4
   ColorName$ = "Red"
 CASE 5
   ColorName$ = "Magenta"
 CASE 6
   ColorName$ = "Brown"
 CASE 7
   ColorName$ = "White"
 CASE 8
   ColorName$ = "Gray"
 CASE 9
   ColorName$ = "LightBlue"
 CASE 10
   ColorName$ = "LightGreen"
 CASE 11
   ColorName$ = "LightCyan"
 CASE 12
   ColorName$ = "LightRed"
 CASE 13
   ColorName$ = "LightMagenta"
 CASE 14
   ColorName$ = "Yellow"
 CASE 15
   ColorName$ = "BrightWhite"
 END SELECT
END FUNCTION

FUNCTION CurrentDateTime$
 CurrentDateTime$ = "Date: " + DayOfWeekName$(VAL(MID$(DATE$, 4, 2)), VAL(MID$(DATE$, 1, 2)), VAL(MID$(DATE$, 7, 4))) + ", " + LTRIM$(STR$(VAL(MID$(DATE$, 4, 2)))) + " " + MonthName$(VAL(MID$(DATE$, 1, 2))) + " " + LTRIM$(STR$(VAL(MID$(DATE$, 7, 4)))) + " year. Time: " + TIME$ + "."
END FUNCTION

FUNCTION DayName$ (DayNumber%)
 SELECT CASE DayNumber%
 CASE 1
   DayName$ = "Monday"
 CASE 2
   DayName$ = "Tuesday"
 CASE 3
   DayName$ = "Wednesday"
 CASE 4
   DayName$ = "Thursday"
 CASE 5
   DayName$ = "Friday"
 CASE 6
   DayName$ = "Saturday"
 CASE 7
   DayName$ = "Sunday"
 END SELECT
END FUNCTION

FUNCTION DayOfWeek% (DayValue%, MonthValue%, YearValue%)
 SELECT CASE DaysCount&(DayValue%, MonthValue%, YearValue%) - (INT(DaysCount&(DayValue%, MonthValue%, YearValue%) / 7) * 7)
 CASE 0
   DayOfWeek% = 6
 CASE 1
   DayOfWeek% = 7
 CASE 2
   DayOfWeek% = 1
 CASE 3
   DayOfWeek% = 2
 CASE 4
   DayOfWeek% = 3
 CASE 5
   DayOfWeek% = 4
 CASE 6
   DayOfWeek% = 5
 CASE 7
   DayOfWeek% = 6
 END SELECT
END FUNCTION

FUNCTION DayOfWeekName$ (DayValue%, MonthValue%, YearValue%)
 DayOfWeekName$ = DayName$(DayOfWeek%(DayValue%, MonthValue%, YearValue%))
END FUNCTION

FUNCTION DaysCount& (DayValue%, MonthValue%, YearValue%)
 DaysCount& = (YearValue% * 365#) + INT(YearValue% / 100) + INT(YearValue% / 4) + MonthDaysCount%(MonthValue%, YearValue%) + DayValue%
END FUNCTION

FUNCTION InputBox% (Title$, Message$, InputTextLine$)
 DIM OutMessage$
 DIM OutIndex%
 DIM WorkKey$
 DIM InputTextCursorColumn%
 DIM InputTextCursorPosition%
 DIM InputText$
 IF LEN(Message$) < 256 THEN OutMessage$ = Message$ + SPACE$(256 - LEN(Message$)) ELSE OutMessage$ = LEFT$(Message$, 256)
 CALL MakeBox(7, 8, 64, 7)
 PRINT LEFT$(Title$, 64) + SPACE$(64 - LEN(LEFT$(Title$, 64)));
 COLOR 1, 7
 FOR OutIndex% = 1 TO 4
  LOCATE 9 + OutIndex%, 8, 0
  PRINT LEFT$(OutMessage$, 64);
  OutMessage$ = MID$(OutMessage$, 65)
 NEXT OutIndex%
 COLOR 14, 7
 LOCATE 15, 8, 0
 PRINT "Please press key is equalient to your answer: ENTER=Yes, ESC=No.";
 InputTextCursorColumn% = 1
 InputTextCursorPosition% = 1
 InputText$ = InputTextLine$
 GOSUB OutInputLine
 DO
  WorkKey$ = INKEY$
  SELECT CASE LEN(WorkKey$)
  CASE 1
    SELECT CASE WorkKey$
    CASE CHR$(8)
      IF InputTextCursorColumn% > 1 THEN
       InputTextCursorColumn% = InputTextCursorColumn% - 1
       InputTextCursorPosition% = InputTextCursorPosition% - 1
       IF InputTextCursorColumn% < 1 THEN InputTextCursorColumn% = 1
       IF InputTextCursorPosition% < 1 THEN InputTextCursorPosition% = 1
       InputText$ = MID$(InputText$, 1, InputTextCursorColumn% - 1) + MID$(InputText$, InputTextCursorColumn% + 1)
       GOSUB OutInputLine
      END IF
    CASE CHR$(13)
      InputTextLine$ = InputText$
      EXIT DO
    CASE CHR$(27)
      EXIT DO
    CASE ELSE
      IF (LEN(InputText$) < 256) AND (ASC(WorkKey$) > (ASC(SPACE$(1)) - 1)) THEN
       InputText$ = MID$(InputText$, 1, InputTextCursorColumn% - 1) + WorkKey$ + MID$(InputText$, InputTextCursorColumn%)
       InputTextCursorColumn% = InputTextCursorColumn% + 1
       InputTextCursorPosition% = InputTextCursorPosition% + 1
       IF InputTextCursorColumn% > LEN(InputText$) + 1 THEN InputTextCursorColumn% = LEN(InputText$) + 1
       IF LEN(InputText$) > 63 THEN IF InputTextCursorPosition% > 64 THEN InputTextCursorPosition% = 64
       IF LEN(InputText$) < 65 THEN IF InputTextCursorPosition% > LEN(InputText$) + 1 THEN InputTextCursorPosition% = LEN(InputText$) + 1
       GOSUB OutInputLine
      END IF
    END SELECT
  CASE 2
    WorkKey$ = MID$(WorkKey$, 2)
    SELECT CASE WorkKey$
    CASE CHR$(75)
      IF InputTextCursorColumn% > 1 THEN
       InputTextCursorColumn% = InputTextCursorColumn% - 1
       InputTextCursorPosition% = InputTextCursorPosition% - 1
       IF InputTextCursorColumn% < 1 THEN InputTextCursorColumn% = 1
       IF InputTextCursorPosition% < 1 THEN InputTextCursorPosition% = 1
       GOSUB OutInputLine
      END IF
    CASE CHR$(77)
      IF InputTextCursorColumn% < LEN(InputText$) + 1 THEN
       InputTextCursorColumn% = InputTextCursorColumn% + 1
       InputTextCursorPosition% = InputTextCursorPosition% + 1
       IF InputTextCursorColumn% > LEN(InputText$) + 1 THEN InputTextCursorColumn% = LEN(InputText$) + 1
       IF LEN(InputText$) > 63 THEN IF InputTextCursorPosition% > 64 THEN InputTextCursorPosition% = 64
       IF LEN(InputText$) < 65 THEN IF InputTextCursorPosition% > LEN(InputText$) + 1 THEN InputTextCursorPosition% = LEN(InputText$) + 1
       GOSUB OutInputLine
      END IF
    CASE CHR$(71)
      IF InputTextCursorColumn% <> 1 THEN
       InputTextCursorColumn% = 1
       InputTextCursorPosition% = 1
       GOSUB OutInputLine
      END IF
    CASE CHR$(79)
      IF InputTextCursorColumn% <> LEN(InputText$) + 1 THEN
       InputTextCursorColumn% = LEN(InputText$) + 1
       InputTextCursorPosition% = LEN(InputText$) + 1
       IF LEN(InputText$) > 63 THEN IF InputTextCursorPosition% > 64 THEN InputTextCursorPosition% = 64
       IF LEN(InputText$) < 65 THEN IF InputTextCursorPosition% > LEN(InputText$) + 1 THEN InputTextCursorPosition% = LEN(InputText$) + 1
       GOSUB OutInputLine
      END IF
    CASE CHR$(83)
      IF InputText$ <> "" THEN
       InputText$ = MID$(InputText$, 1, InputTextCursorColumn% - 1) + MID$(InputText$, InputTextCursorColumn% + 1)
       GOSUB OutInputLine
      END IF
    END SELECT
  END SELECT
 LOOP
 LOCATE , , 0
 InputBox% = WorkKey$ = CHR$(13)
 EXIT FUNCTION
OutInputLine:
 COLOR 4, 7
 LOCATE 14, 8, 0
 PRINT MID$(InputText$, (InputTextCursorColumn% - InputTextCursorPosition%) + 1, 64) + SPACE$(64 - LEN(MID$(InputText$, (InputTextCursorColumn% - InputTextCursorPosition%) + 1, 64)));
 LOCATE 14, 7 + InputTextCursorPosition%, 1, 7, 8
 RETURN
END FUNCTION

FUNCTION IsLeapYear% (YearValue%)
 IsLeapYear% = ABS((INT(YearValue% / 4) * 4) = YearValue%)
END FUNCTION

SUB MakeBox (BoxColumn%, BoxRow%, BoxWidth%, BoxHeight%)
 DIM BoxWorkIndex%
 IF (BoxColumn% < 1) OR (BoxRow% < 1) OR (BoxWidth% < 1) OR (BoxHeight% < 1) OR (BoxWidth% > 77) OR (BoxHeight% > 22) OR (((BoxColumn% - 1) + BoxWidth%) > 77) OR (((BoxRow% - 1) + BoxHeight%) > 22) THEN EXIT SUB
 COLOR 0, 7
 LOCATE BoxRow%, BoxColumn%, 0
 PRINT CHR$(201) + STRING$(BoxWidth%, CHR$(205)) + CHR$(187);
 FOR BoxWorkIndex% = 1 TO BoxHeight% + 1
  LOCATE BoxRow% + BoxWorkIndex%, BoxColumn%, 0
  PRINT CHR$(186) + SPACE$(BoxWidth%) + CHR$(186);
  COLOR 0, 0
  PRINT SPACE$(1);
  COLOR 0, 7
 NEXT BoxWorkIndex%
 LOCATE BoxRow% + BoxHeight% + 1, BoxColumn%, 0
 PRINT CHR$(200) + STRING$(BoxWidth%, CHR$(205)) + CHR$(188);
 COLOR 0, 0
 LOCATE BoxRow% + BoxHeight% + 2, BoxColumn% + 1, 0
 PRINT SPACE$(BoxWidth% + 2);
 COLOR 15, 2
 LOCATE BoxRow% + 1, BoxColumn% + 1, 0
END SUB

FUNCTION MenuBox% (ItemsCount%)
 DIM MenuIndex%
 DIM MenuLineLength%
 DIM CurrentItem%
 DIM WorkKey$
 IF (ItemsCount% < 1) OR (ItemsCount% > UBOUND(MenuItems$)) OR (UBOUND(MenuItems$) > 20) THEN
  MenuBox% = 0
  EXIT FUNCTION
 END IF
 MenuLineLength% = 0
 FOR MenuIndex% = 1 TO ItemsCount%
  IF LEN(MenuItems$(MenuIndex%)) > MenuLineLength% THEN MenuLineLength% = LEN(MenuItems$(MenuIndex%))
 NEXT MenuIndex%
 IF MenuLineLength% < 56 THEN MenuLineLength% = 56
 IF MenuLineLength% > 75 THEN MenuLineLength% = 75
 CurrentItem% = 1
 GOSUB OutMenu
 DO
  WorkKey$ = UCASE$(INKEY$)
  SELECT CASE LEN(WorkKey$)
  CASE 1
    SELECT CASE WorkKey$
    CASE CHR$(13)
      MenuBox% = CurrentItem%
      EXIT DO
    CASE CHR$(27)
      MenuBox% = 0
      EXIT DO
    CASE ELSE
      IF (ASC(WorkKey$) > (ASC("A") - 1)) AND (ASC(WorkKey$) < (ASC("A") + ItemsCount%)) THEN
       CurrentItem% = (ASC(WorkKey$) - ASC("A")) + 1
       GOSUB OutMenu
      END IF
    END SELECT
  CASE 2
    WorkKey$ = MID$(WorkKey$, 2)
    SELECT CASE WorkKey$
    CASE CHR$(72)
      IF CurrentItem% > 1 THEN
       CurrentItem% = CurrentItem% - 1
       GOSUB OutMenu
      END IF
    CASE CHR$(80)
      IF CurrentItem% < ItemsCount% THEN
       CurrentItem% = CurrentItem% + 1
       GOSUB OutMenu
      END IF
    CASE CHR$(73)
      IF CurrentItem% <> 1 THEN
       CurrentItem% = 1
       GOSUB OutMenu
      END IF
    CASE CHR$(81)
      IF CurrentItem% <> ItemsCount% THEN
       CurrentItem% = ItemsCount%
       GOSUB OutMenu
      END IF
    CASE CHR$(71)
      IF CurrentItem% <> 1 THEN
       CurrentItem% = 1
       GOSUB OutMenu
      END IF
    CASE CHR$(79)
      IF CurrentItem% <> ItemsCount% THEN
       CurrentItem% = ItemsCount%
       GOSUB OutMenu
      END IF
    END SELECT
  END SELECT
 LOOP
 EXIT FUNCTION
OutMenu:
 CALL MakeBox(INT((80 - (MenuLineLength% + 5)) / 2) + 1, INT((25 - (ItemsCount% + 5)) / 2) + 1, MenuLineLength% + 2, ItemsCount% + 2)
 FOR MenuIndex% = 1 TO ItemsCount%
  COLOR 14, 7
  LOCATE INT((25 - (ItemsCount% + 5)) / 2) + (MenuIndex% + 1), INT((80 - (MenuLineLength% + 5)) / 2) + 2, 0
  PRINT CHR$(ASC("A") + (MenuIndex% - 1));
  COLOR 12, 7
  PRINT "=";
  IF MenuIndex% = CurrentItem% THEN COLOR 15, 6 ELSE COLOR 8, 7
  PRINT LEFT$(MenuItems$(MenuIndex%), MenuLineLength%) + SPACE$(MenuLineLength% - LEN(LEFT$(MenuItems$(MenuIndex%), MenuLineLength%)));
 NEXT MenuIndex%
 COLOR 0, 7
 LOCATE INT((25 - (ItemsCount% + 5)) / 2) + 2 + ItemsCount%, INT((80 - (MenuLineLength% + 5)) / 2) + 1, 0
 PRINT CHR$(204) + STRING$(MenuLineLength% + 2, CHR$(205)) + CHR$(185);
 COLOR 14, 7
 LOCATE INT((25 - (ItemsCount% + 5)) / 2) + 3 + ItemsCount%, INT((80 - (MenuLineLength% + 5)) / 2) + 2, 0
 PRINT SPACE$(INT((MenuLineLength% - 56) / 2) + 1) + "Please press ENTER to select menu item or ESC to cancel."
 RETURN
END FUNCTION

FUNCTION MessageBox% (Title$, Message$)
 DIM OutMessage$
 DIM OutIndex%
 DIM WorkKey$
 IF LEN(Message$) < 256 THEN OutMessage$ = Message$ + SPACE$(256 - LEN(Message$)) ELSE OutMessage$ = LEFT$(Message$, 256)
 CALL MakeBox(7, 9, 64, 6)
 PRINT LEFT$(Title$, 64) + SPACE$(64 - LEN(LEFT$(Title$, 64)));
 COLOR 1, 7
 FOR OutIndex% = 1 TO 4
  LOCATE 10 + OutIndex%, 8, 0
  PRINT LEFT$(OutMessage$, 64);
  OutMessage$ = MID$(OutMessage$, 65)
 NEXT OutIndex%
 COLOR 14, 7
 LOCATE 15, 8, 0
 PRINT "Please press key is equalient to your answer: ENTER=Yes, ESC=No.";
 WorkKey$ = ""
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
  WorkKey$ = INKEY$
 WEND
 MessageBox% = WorkKey$ = CHR$(13)
END FUNCTION

FUNCTION MonthDays% (MonthValue%, YearValue%)
 SELECT CASE MonthValue%
 CASE 1
   MonthDays% = 31
 CASE 2
   MonthDays% = 28 + IsLeapYear%(YearValue%)
 CASE 3
   MonthDays% = 31
 CASE 4
   MonthDays% = 30
 CASE 5
   MonthDays% = 31
 CASE 6
   MonthDays% = 30
 CASE 7
   MonthDays% = 31
 CASE 8
   MonthDays% = 31
 CASE 9
   MonthDays% = 30
 CASE 10
   MonthDays% = 31
 CASE 11
   MonthDays% = 30
 CASE 12
   MonthDays% = 31
 END SELECT
END FUNCTION

FUNCTION MonthDaysCount% (MonthValue%, YearValue%)
 SELECT CASE MonthValue%
 CASE 1
   MonthDaysCount% = 0
 CASE 2
   MonthDaysCount% = 31
 CASE 3
   MonthDaysCount% = 59 + IsLeapYear%(YearValue%)
 CASE 4
   MonthDaysCount% = 90 + IsLeapYear%(YearValue%)
 CASE 5
   MonthDaysCount% = 120 + IsLeapYear%(YearValue%)
 CASE 6
   MonthDaysCount% = 151 + IsLeapYear%(YearValue%)
 CASE 7
   MonthDaysCount% = 181 + IsLeapYear%(YearValue%)
 CASE 8
   MonthDaysCount% = 212 + IsLeapYear%(YearValue%)
 CASE 9
   MonthDaysCount% = 243 + IsLeapYear%(YearValue%)
 CASE 10
   MonthDaysCount% = 273 + IsLeapYear%(YearValue%)
 CASE 11
   MonthDaysCount% = 304 + IsLeapYear%(YearValue%)
 CASE 12
   MonthDaysCount% = 334 + IsLeapYear%(YearValue%)
 END SELECT
END FUNCTION

FUNCTION MonthName$ (MonthNumber%)
 SELECT CASE MonthNumber%
 CASE 1
   MonthName$ = "January"
 CASE 2
   MonthName$ = "February"
 CASE 3
   MonthName$ = "March"
 CASE 4
   MonthName$ = "April"
 CASE 5
   MonthName$ = "May"
 CASE 6
   MonthName$ = "June"
 CASE 7
   MonthName$ = "July"
 CASE 8
   MonthName$ = "August"
 CASE 9
   MonthName$ = "September"
 CASE 10
   MonthName$ = "October"
 CASE 11
   MonthName$ = "November"
 CASE 12
   MonthName$ = "December"
 END SELECT
END FUNCTION

SUB OutBox (Title$, Message$)
 DIM OutMessage$
 DIM OutIndex%
 IF LEN(Message$) < 256 THEN OutMessage$ = Message$ + SPACE$(256 - LEN(Message$)) ELSE OutMessage$ = LEFT$(Message$, 256)
 CALL MakeBox(7, 9, 64, 6)
 PRINT LEFT$(Title$, 64) + SPACE$(64 - LEN(LEFT$(Title$, 64)));
 COLOR 1, 7
 FOR OutIndex% = 1 TO 4
  LOCATE 10 + OutIndex%, 8, 0
  PRINT LEFT$(OutMessage$, 64);
  OutMessage$ = MID$(OutMessage$, 65)
 NEXT OutIndex%
 COLOR 14, 7
 LOCATE 15, 8, 0
 PRINT "       Please press the ENTER key to quit from this box.";
 WHILE INKEY$ <> CHR$(13)
 WEND
END SUB

SUB OutPicture
 DIM Index%
 DIM OutLine$
 CALL MakeBox(1, 1, 77, 22)
 COLOR 0, 7
 FOR Index% = 1 TO 20
  LOCATE Index% + 1, 2, 0
  PRINT STRING$(77, CHR$(219));
  LOCATE Index% + 1, 2, 0
  OutLine$ = Picture$(Index%)
  WHILE OutLine$ <> ""
   COLOR ASC(OutLine$) - ASC(SPACE$(1))
   PRINT CHR$(219);
   OutLine$ = MID$(OutLine$, 2)
  WEND
 NEXT Index%
 COLOR 4, 7
 LOCATE 22, 2, 0
 PRINT "ESC=Menu. Column=" + LTRIM$(STR$(PictureColumn%)) + ". Row=" + LTRIM$(STR$(PictureRow%)) + ". File name=" + PictureName$ + ". Current color=" + ColorName$(CurrentColor%) + ".";
 COLOR 1, 7
 LOCATE 23, 2, 0
 PRINT StatusText$;
 LOCATE PictureRow% + 1, PictureColumn% + 1, 1, 7, 8
END SUB

SUB ScratchScreen
 COLOR 0, 2
 CLS
 PRINT "********************************************************************************"
 PRINT "                    The Standart GNU Personal Picture Editor."
 PRINT "                     Copyright (C) Sandul Yura Valentinovich."
 PRINT "                        (R) Wednesday, 5 March 2003 year."
 PRINT
 PRINT "    This program is free software; you can redistribute it and/or modify it"
 PRINT "under the terms of the GNU General Public License as published by the Free"
 PRINT "Software Foundation; either version 2 of the License, or (at your option) any"
 PRINT "later version."
 PRINT "    This program is distributed in the hope that it will be useful, but WITHOUT"
 PRINT "ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS"
 PRINT "FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details."
 PRINT "    You should have received a copy of the GNU General Public License along with"
 PRINT "this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,"
 PRINT "Cambridge, MA 02139, USA."
END SUB

