REM     The Standart GNU Personal Multifunctional Utility.
REM     Copyright (C) Sandul Yura Valentinovich.
REM     (R) Wednesday, 5 March 2003 year.
REM     This program is free software; you can redistribute it and/or modify
REM it under the terms of the GNU General Public License as published by the
REM Free Software Foundation; either version 2 of the License, or (at your
REM option) any later version.
REM     This program is distributed in the hope that it will be useful, but
REM WITHOUT ANY WARRANTY; without even the implied warranty of
REM MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
REM Public License for more details.
REM     You should have received a copy of the GNU General Public License
REM along with this program; if not, write to the Free Software Foundation,
REM Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
REM
REM $DYNAMIC
DECLARE SUB ScratchScreen ()
DECLARE SUB CalculatorOut ()
DECLARE SUB CalendarOut ()
DECLARE SUB OutBox (Title$, Message$)
DECLARE SUB MakeBox (BoxColumn%, BoxRow%, BoxWidth%, BoxHeight%)
DECLARE SUB OutHelpText ()
DECLARE FUNCTION CalendarBox% (Title$, Message$, DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION CurrentDateTime$ ()
DECLARE FUNCTION DayName$ (DayNumber%)
DECLARE FUNCTION DayOfWeek% (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION DayOfWeekName$ (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION DaysCount& (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION InputBox% (Title$, Message$, InputTextLine$)
DECLARE FUNCTION IsLeapYear% (YearValue%)
DECLARE FUNCTION MenuBox% (ItemsCount%)
DECLARE FUNCTION MessageBox% (Title$, Message$)
DECLARE FUNCTION MonthDays% (MonthValue%, YearValue%)
DECLARE FUNCTION MonthDaysCount% (MonthValue%, YearValue%)
DECLARE FUNCTION MonthName$ (MonthNumber%)
OPTION BASE 1
CONST False% = 0
CONST True% = NOT False%
CONST Pi# = 3.141592653589793#
CONST HelpTextLinesCount% = 256
CONST HelpSubjectsCount% = 8
DIM SHARED MenuItems$(10)
DIM SHARED HelpText$(HelpTextLinesCount%)
DIM SHARED HelpTextPosition%
DIM SHARED HelpPosition%
DIM SHARED HelpLinePosition%
DIM SHARED HelpWorkSubjectsCount%
DIM WorkMode%
DIM Frequency#
DIM Delay#
DIM Column%
DIM Row%
DIM OutColor%
DIM Hang%(32)
DIM Code%
DIM Index%
DIM WorkLine$
DIM WorkHour%
DIM WorkMinute%
DIM WorkSecond%
DIM WorkYear%
DIM WorkMonth%
DIM WorkDay%
DIM HelpSubjects$(HelpSubjectsCount%)
DIM HelpTextPositions%(HelpSubjectsCount%)
DIM HelpPositions%(HelpSubjectsCount%)
DIM HelpLinePositions%(HelpSubjectsCount%)
DIM HelpFileName$
DIM HelpSubject$
DIM HelpLinesCount%
DIM WorkKey$
DIM OldSecond%
SCREEN 0, 1, 0, 0
HelpFileName$ = "Workhelp.hlp"
HelpWorkSubjectsCount% = 0
DO
 CALL ScratchScreen
 MenuItems$(1) = "Calculator."
 MenuItems$(2) = "Calendar."
 MenuItems$(3) = "Change system date."
 MenuItems$(4) = "Change system time."
 MenuItems$(5) = "Random number player."
 MenuItems$(6) = "Screen blank saver."
 MenuItems$(7) = "Reboot computer."
 MenuItems$(8) = "Hang computer."
 MenuItems$(9) = "Work help."
 MenuItems$(10) = "Quit."
 SELECT CASE MenuBox%(10)
 CASE 0
   EXIT DO
 CASE 1
   CALL ScratchScreen
   CALL CalculatorOut
 CASE 2
   CALL ScratchScreen
   CALL CalendarOut
 CASE 3
   CALL ScratchScreen
   WorkYear% = VAL(MID$(DATE$, 7, 4))
   WorkMonth% = VAL(MID$(DATE$, 1, 2))
   WorkDay% = VAL(MID$(DATE$, 4, 2))
   IF CalendarBox%("GNU Personal Multifunctional Utility.", "Please select new date.", WorkDay%, WorkMonth%, WorkYear%) THEN
    CALL ScratchScreen
    DATE$ = STRING$(2 - LEN(LTRIM$(STR$(WorkMonth%))), "0") + LTRIM$(STR$(WorkMonth%)) + "-" + STRING$(2 - LEN(LTRIM$(STR$(WorkDay%))), "0") + LTRIM$(STR$(WorkDay%)) + "-" + STRING$(4 - LEN(LTRIM$(STR$(WorkYear%))), "0") + LTRIM$(STR$(WorkYear%))
    CALL OutBox("GNU Personal Multifunctional Utility.", "System date is succefully changed.")
   END IF
 CASE 4
   CALL ScratchScreen
   WorkLine$ = TIME$
   IF InputBox%("GNU Personal Multifunctional Utility.", "Please enter the new time in format: HH:MM:SS (HH - hour, MM - minute, SS - second.).", WorkLine$) THEN
    CALL ScratchScreen
    WorkLine$ = LTRIM$(RTRIM$(WorkLine$))
    IF (LEN(WorkLine$) < 8) OR (INSTR(WorkLine$, ":") = 0) THEN
     CALL OutBox("GNU Personal Multifunctional Utility.", "You entered invalid line.")
    ELSE
     IF (VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1)) < 0) OR (VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1)) > 23) THEN
      CALL OutBox("GNU Personal Multifunctional Utility.", "Hour must be from 0 to 23.")
     ELSE
      WorkHour% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1))
      WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, ":") + 1)
      IF INSTR(WorkLine$, ":") = 0 THEN
       CALL OutBox("GNU Personal Multifunctional Utility.", "You entered invalid line.")
      ELSE
       IF (VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1)) < 0) OR (VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1)) > 59) THEN
        CALL OutBox("GNU Personal Multifunctional Utility.", "Minute must be from 0 to 59.")
       ELSE
        WorkMinute% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1))
        WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, ":") + 1)
        IF (VAL(WorkLine$) < 0) OR (VAL(WorkLine$) > 59) THEN
         CALL OutBox("GNU Personal Multifunctional Utility.", "Minute must be from 0 to 59.")
        ELSE
         WorkSecond% = VAL(WorkLine$)
         TIME$ = STRING$(2 - LEN(LTRIM$(STR$(WorkHour%))), "0") + LTRIM$(STR$(WorkHour%)) + ":" + STRING$(2 - LEN(LTRIM$(STR$(WorkMinute%))), "0") + LTRIM$(STR$(WorkMinute%)) + ":" + STRING$(2 - LEN(LTRIM$(STR$(WorkSecond%))), "0") + LTRIM$(STR$(WorkSecond%))
         CALL OutBox("GNU Personal Multifunctional Utility.", "System time is succefully changed.")
        END IF
       END IF
      END IF
     END IF
    END IF
   END IF
 CASE 5
   COLOR 7, 0
   CLS
   LOCATE 1, 1, 0
   WHILE INKEY$ <> ""
   WEND
   WHILE INKEY$ = ""
    RANDOMIZE TIMER
    Frequency# = (Pi# / 2) * (RND * (Pi# * 1000))
    Delay# = RND * (Pi# / 2)
    IF Frequency# < 37 THEN Frequency# = 37
    SOUND Frequency#, Delay#
    Row% = Pi# * (RND * (Pi# * 50))
    Column% = RND * (Pi# * 50)
    IF (NOT (Row% < 1)) AND (NOT (Row% > 25)) THEN
     IF (NOT (Column% < 1) AND (NOT (Column% > 80))) THEN
      OutColor% = RND * (Pi# * 5)
      IF OutColor% < 0 THEN OutColor% = 0
      IF OutColor% > 15 THEN OutColor% = 15
      COLOR OutColor%
      LOCATE Row%, Column%, 0
      PRINT CHR$(219);
     END IF
    END IF
   WEND
 CASE 6
   COLOR 7, 0
   CLS
   LOCATE 1, 1, 0
   WHILE INKEY$ <> ""
   WEND
   WHILE INKEY$ = ""
   WEND
 CASE 7
   CALL ScratchScreen
   IF MessageBox%("GNU Personal Multifunctional Utility.", "Are you sure to reboot compter?") THEN
    COLOR 7, 0
    CLS
    LOCATE 1, 1, 1, 7, 8
    DEF SEG = &HF000
    CALL ABSOLUTE(&HFFF0)
   END IF
 CASE 8
   CALL ScratchScreen
   IF MessageBox%("GNU Personal Multifunctional Utility.", "Are you sure to hang compter?") THEN
    COLOR 7, 0
    CLS
    LOCATE 1, 1, 1, 7, 8
    DEF SEG = VARSEG(Hang%(1))
    RESTORE HangCode
    FOR Index% = 0 TO 61
     READ Code%
    POKE VARPTR(Hang%(1)) + Index%, Code%
    NEXT Index%
    CALL ABSOLUTE(VARPTR(Hang%(1)))
   END IF
 CASE 9
   DO
    CALL ScratchScreen
    MenuItems$(1) = "Change help file name (" + HelpFileName$ + ".)."
    MenuItems$(2) = "Show help text."
    MenuItems$(3) = "Quit."
    SELECT CASE MenuBox%(3)
    CASE 0
      EXIT DO
    CASE 1
      CALL ScratchScreen
      WorkLine$ = ""
      IF InputBox%("DOS Help.", "Please enter name of exist help file.", WorkLine$) THEN
       CALL ScratchScreen
       WorkLine$ = UCASE$(LEFT$(LTRIM$(RTRIM$(WorkLine$)), 1)) + LCASE$(MID$(LTRIM$(RTRIM$(WorkLine$)), 2))
       IF (WorkLine$ = "") OR (LEN(WorkLine$) > 12) OR (INSTR(WorkLine$, ":") > 0) OR (INSTR(WorkLine$, "/") > 0) OR (INSTR(WorkLine$, "\") > 0) OR (INSTR(WorkLine$, "?") > 0) OR (INSTR(WorkLine$, "*") > 0) THEN CALL OutBox("DOS Help.", "You input the invalid file name.") ELSE HelpFileName$ = WorkLine$
      END IF
    CASE 2
      HelpSubject$ = "Main"
      GOSUB WorkHelp
    CASE 3
      EXIT DO
    END SELECT
WorkHelpRepeat:
   LOOP
 CASE 10
   EXIT DO
 END SELECT
LOOP
COLOR 7, 0
CLS
LOCATE 1, 1, 1, 7, 8
END
HangCode:
 DATA &HBA,&H00,&H00,&H52,&H9D,&HBF,&H40
 DATA &H00,&H8E,&HC7,&HBF,&H00,&H00,&H26
 DATA &HC6,&H05,&H00,&H83,&HC7,&H01,&H81
 DATA &HFF,&H01,&H04,&H75,&HF3,&HB8,&H00
 DATA &H00,&H50,&H9D,&HBB,&H00,&H00,&HB9
 DATA &H00,&H00,&HBA,&H00,&H00,&HBD,&H00
 DATA &H00,&HBC,&H00,&H00,&HBE,&H00,&H00
 DATA &HBF,&H00,&H00,&H8E,&HDA,&H8E,&HC7
 DATA &H8E,&HD4,&HF0,&HF4,&HCD,&H20,&HCB
WorkHelp:
 OldSecond% = NOT VAL(MID$(TIME$, 7, 2))
 CALL ScratchScreen
 ON ERROR GOTO CannotOpenHelpFile
 OPEN HelpFileName$ FOR INPUT AS #1
 ON ERROR GOTO 0
 DO WHILE NOT EOF(1)
  ON ERROR GOTO CannotReadFromHelpFile
  LINE INPUT #1, WorkLine$
  ON ERROR GOTO 0
  IF LTRIM$(RTRIM$(WorkLine$)) <> "" THEN
   WorkLine$ = LTRIM$(RTRIM$(UCASE$(WorkLine$)))
   IF (LEFT$(WorkLine$, 1) = "{") AND (RIGHT$(WorkLine$, 1) = "}") THEN
    WorkLine$ = LTRIM$(RTRIM$(MID$(WorkLine$, 2, LEN(WorkLine$) - 2)))
    IF RIGHT$(WorkLine$, 1) = ":" THEN
     IF LTRIM$(LEFT$(WorkLine$, LEN(WorkLine$) - 1)) = LTRIM$(RTRIM$(UCASE$(HelpSubject$))) THEN
      HelpSubject$ = LTRIM$(LEFT$(WorkLine$, LEN(WorkLine$) - 1))
      EXIT DO
     END IF
    END IF
   END IF
  END IF
 LOOP
 IF EOF(1) THEN
  CLOSE #1
  RETURN
 END IF
 FOR Index% = 1 TO HelpTextLinesCount%
  HelpText$(Index%) = ""
 NEXT Index%
 HelpLinesCount% = 0
 DO WHILE NOT EOF(1)
  ON ERROR GOTO CannotReadFromHelpFile
  LINE INPUT #1, WorkLine$
  ON ERROR GOTO 0
  IF LTRIM$(RTRIM$(WorkLine$)) = STRING$(80, "_") THEN EXIT DO
  IF HelpLinesCount% = 256 THEN EXIT DO
  HelpLinesCount% = HelpLinesCount% + 1
  HelpText$(HelpLinesCount%) = LEFT$(MID$(WorkLine$, 2), 77)
 LOOP
 CLOSE #1
 HelpTextPosition% = 1
 HelpPosition% = 1
 HelpLinePosition% = 1
 CALL MakeBox(1, 1, 77, 22)
 CALL OutHelpText
 DO
  IF OldSecond% <> VAL(MID$(TIME$, 7, 2)) THEN
   OldSecond% = VAL(MID$(TIME$, 7, 2))
   CALL OutHelpText
  END IF
  WorkKey$ = INKEY$
  SELECT CASE LEN(WorkKey$)
  CASE 1
    SELECT CASE WorkKey$
    CASE CHR$(13)
      WorkLine$ = MID$(HelpText$(HelpTextPosition%), HelpLinePosition%)
      IF (LEFT$(WorkLine$, 1) = "{") AND (INSTR(WorkLine$, "}") > 0) AND (HelpWorkSubjectsCount% < HelpSubjectsCount%) THEN
       WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
       HelpWorkSubjectsCount% = HelpWorkSubjectsCount% + 1
       HelpSubjects$(HelpWorkSubjectsCount%) = HelpSubject$
       HelpTextPositions%(HelpWorkSubjectsCount%) = HelpTextPosition%
       HelpPositions%(HelpWorkSubjectsCount%) = HelpPosition%
       HelpLinePositions%(HelpWorkSubjectsCount%) = HelpLinePosition%
       HelpSubject$ = RTRIM$(UCASE$(MID$(WorkLine$, 1, INSTR(WorkLine$, "}") - 1)))
       GOSUB WorkHelp
       HelpSubject$ = HelpSubjects$(HelpWorkSubjectsCount%)
       HelpTextPosition% = HelpTextPositions%(HelpWorkSubjectsCount%)
       HelpPosition% = HelpPositions%(HelpWorkSubjectsCount%)
       HelpLinePosition% = HelpLinePositions%(HelpWorkSubjectsCount%)
       HelpSubjects$(HelpWorkSubjectsCount%) = ""
       HelpTextPositions%(HelpWorkSubjectsCount%) = 0
       HelpPositions%(HelpWorkSubjectsCount%) = 0
       HelpLinePositions%(HelpWorkSubjectsCount%) = 0
       HelpWorkSubjectsCount% = HelpWorkSubjectsCount% - 1
       ON ERROR GOTO CannotOpenHelpFile
       OPEN HelpFileName$ FOR INPUT AS #1
       ON ERROR GOTO 0
       DO WHILE NOT EOF(1)
        ON ERROR GOTO CannotReadFromHelpFile
        LINE INPUT #1, WorkLine$
        ON ERROR GOTO 0
        IF LTRIM$(RTRIM$(WorkLine$)) <> "" THEN
         WorkLine$ = LTRIM$(RTRIM$(UCASE$(WorkLine$)))
         IF (LEFT$(WorkLine$, 1) = "{") AND (RIGHT$(WorkLine$, 1) = "}") THEN
          WorkLine$ = LTRIM$(RTRIM$(MID$(WorkLine$, 2, LEN(WorkLine$) - 2)))
          IF RIGHT$(WorkLine$, 1) = ":" THEN
           IF LTRIM$(LEFT$(WorkLine$, LEN(WorkLine$) - 1)) = LTRIM$(RTRIM$(UCASE$(HelpSubject$))) THEN
            HelpSubject$ = LTRIM$(LEFT$(WorkLine$, LEN(WorkLine$) - 1))
            EXIT DO
           END IF
          END IF
         END IF
        END IF
       LOOP
       IF EOF(1) THEN
        CLOSE #1
        RETURN
       END IF
       FOR Index% = 1 TO HelpTextLinesCount%
        HelpText$(Index%) = ""
       NEXT Index%
       HelpLinesCount% = 0
       DO WHILE NOT EOF(1)
        ON ERROR GOTO CannotReadFromHelpFile
        LINE INPUT #1, WorkLine$
        ON ERROR GOTO 0
        IF LTRIM$(RTRIM$(WorkLine$)) = STRING$(80, "_") THEN EXIT DO
        IF HelpLinesCount% = 256 THEN EXIT DO
        HelpLinesCount% = HelpLinesCount% + 1
        HelpText$(HelpLinesCount%) = LEFT$(MID$(WorkLine$, 2), 77)
       LOOP
       CLOSE #1
       CALL ScratchScreen
       CALL MakeBox(1, 1, 77, 22)
       CALL OutHelpText
      END IF
    CASE CHR$(27)
      CALL ScratchScreen
      EXIT DO
    END SELECT
  CASE 2
    WorkKey$ = MID$(WorkKey$, 2)
    SELECT CASE WorkKey$
    CASE CHR$(72)
      IF HelpTextPosition% > 1 THEN
       HelpTextPosition% = HelpTextPosition% - 1
       HelpPosition% = HelpPosition% - 1
       IF HelpTextPosition% < 1 THEN HelpTextPosition% = 1
       IF HelpPosition% < 1 THEN HelpPosition% = 1
       CALL OutHelpText
      END IF
    CASE CHR$(80)
      IF HelpTextPosition% < HelpLinesCount% THEN
       HelpTextPosition% = HelpTextPosition% + 1
       HelpPosition% = HelpPosition% + 1
       IF HelpTextPosition% > HelpLinesCount% THEN HelpTextPosition% = HelpLinesCount%
       IF HelpLinesCount% < 21 THEN
        IF HelpPosition% > HelpLinesCount% THEN HelpPosition% = HelpLinesCount%
       ELSE
        IF HelpPosition% > 20 THEN HelpPosition% = 20
       END IF
       CALL OutHelpText
      END IF
    CASE CHR$(73)
      IF HelpTextPosition% > 1 THEN
       HelpTextPosition% = HelpTextPosition% - 20
       HelpPosition% = HelpPosition% - 20
       IF HelpTextPosition% < 1 THEN HelpTextPosition% = 1
       IF HelpPosition% < 1 THEN HelpPosition% = 1
       CALL OutHelpText
      END IF
    CASE CHR$(81)
      IF HelpTextPosition% < HelpLinesCount% THEN
       HelpTextPosition% = HelpTextPosition% + 20
       HelpPosition% = HelpPosition% + 20
       IF HelpTextPosition% > HelpLinesCount% THEN HelpTextPosition% = HelpLinesCount%
       IF HelpLinesCount% < 21 THEN
        IF HelpPosition% > HelpLinesCount% THEN HelpPosition% = HelpLinesCount%
       ELSE
        IF HelpPosition% > 20 THEN HelpPosition% = 20
       END IF
       CALL OutHelpText
      END IF
    CASE CHR$(75)
      IF HelpLinePosition% > 1 THEN
       HelpLinePosition% = HelpLinePosition% - 1
       IF HelpLinePosition% < 1 THEN HelpLinePosition% = 1
       CALL OutHelpText
      END IF
    CASE CHR$(77)
      IF HelpLinePosition% < 77 THEN
       HelpLinePosition% = HelpLinePosition% + 1
       IF HelpLinePosition% > 77 THEN HelpLinePosition% = 77
       CALL OutHelpText
      END IF
    CASE CHR$(71)
      IF HelpLinePosition% <> 1 THEN
       HelpLinePosition% = 1
       CALL OutHelpText
      END IF
    CASE CHR$(79)
      IF HelpLinePosition% <> 77 THEN
       HelpLinePosition% = 77
       CALL OutHelpText
      END IF
    END SELECT
  END SELECT
 LOOP
 RETURN
CannotOpenHelpFile:
 IF MessageBox%("DOS Help.", "Cannot open help file. Retry opening?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  RESUME WorkHelpRepeat
 END IF
CannotReadFromHelpFile:
 IF MessageBox%("DOS Help.", "Cannot read from help file. Retry reading?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  CLOSE #1
  RESUME WorkHelpRepeat
 END IF

SUB CalculatorOut
 DIM WorkKey$
 DIM Memory$
 DIM Number$
 DIM Number#
 DIM Value#
 DIM IsClear%
 DIM IsInNumber%
 DIM PointPresent%
 DIM Action$
 DIM Result$
 CALL MakeBox(28, 1, 25, 22)
 COLOR 0, 7
 LOCATE 3, 28, 0
 PRINT CHR$(204) + STRING$(25, CHR$(205)) + CHR$(185);
 COLOR 2, 7
 LOCATE 4, 29, 0
 PRINT "Note for";
 LOCATE 5, 29, 0
 PRINT "calculations:";
 COLOR 1, 7
 LOCATE 5, 29, 0
 PRINT "Insert=Memory value.";
 LOCATE 6, 29, 0
 PRINT "Tab=Give value.";
 LOCATE 7, 29, 0
 PRINT "Delete=Clear memory.";
 LOCATE 8, 29, 0
 PRINT "+ - add, - - substract,";
 LOCATE 9, 29, 0
 PRINT "/ - divide, * - multiply.";
 LOCATE 10, 29, 0
 PRINT "Spacebar=Square root.";
 LOCATE 11, 29, 0
 PRINT "BackSpace=Clear value.";
 LOCATE 11, 29, 0
 PRINT "Pi=3.1415926535897932385.";
 COLOR 2, 7
 LOCATE 21, 29, 0
 PRINT "Memory value:";
 COLOR 14, 7
 LOCATE 23, 29, 0
 PRINT "ESC=Quit.";
 Memory$ = ""
 Number$ = "0"
 Number# = 0#
 Value# = 0#
 IsClear% = True%
 IsInNumber% = False%
 PointPresent% = False%
 Action$ = ""
 GOSUB OutCalc
 DO
  WorkKey$ = ""
  WHILE WorkKey$ = ""
   WorkKey$ = INKEY$
  WEND
  IF LEN(WorkKey$) = 1 THEN
   SELECT CASE WorkKey$
   CASE CHR$(8)
     Number$ = "0"
     Number# = 0#
     Value# = 0#
     IsClear% = True%
     IsInNumber% = False%
     PointPresent% = False%
     Action$ = ""
     GOSUB OutCalc
   CASE CHR$(27)
     EXIT DO
   CASE "0" TO "9"
     IF IsClear% THEN
      IsClear% = False%
      IsInNumber% = False%
      PointPresent% = False%
      Number$ = WorkKey$
      GOSUB OutCalc
     ELSE
      IF LEN(Number$) < 25 THEN
       Number$ = Number$ + WorkKey$
       GOSUB OutCalc
      END IF
     END IF
   CASE "."
     IF NOT PointPresent% THEN
      IF IsClear% THEN
       IsClear% = False%
       IsInNumber% = False%
       Number$ = "0."
      ELSE
       IF LEN(Number$) < 25 THEN
        PointPresent% = True%
        Number$ = Number$ + "."
        GOSUB OutCalc
       END IF
      END IF
     END IF
   CASE "+"
     GOSUB Calculate
     Action$ = "+"
     IsClear% = True%
     Number# = VAL(Number$)
   CASE "-"
     GOSUB Calculate
     Action$ = "-"
     IsClear% = True%
     Number# = VAL(Number$)
   CASE "/"
     GOSUB Calculate
     Action$ = "/"
     IsClear% = True%
     Number# = VAL(Number$)
   CASE "*"
     GOSUB Calculate
     Action$ = "*"
     IsClear% = True%
     Number# = VAL(Number$)
   CASE CHR$(32)
     Number$ = LEFT$(LTRIM$(STR$(SQR(VAL(Number$)))), 25)
     GOSUB OutCalc
   CASE CHR$(9)
     IF Memory$ <> "" THEN
      Result$ = Memory$
      GOSUB OutCalc
     END IF
   CASE "=", CHR$(13)
     GOSUB Calculate
   END SELECT
  ELSE
   WorkKey$ = MID$(WorkKey$, 2)
   SELECT CASE WorkKey$
   CASE CHR$(82)
     Memory$ = Result$
     GOSUB OutCalc
   CASE CHR$(83)
     Memory$ = ""
     GOSUB OutCalc
   END SELECT
  END IF
 LOOP
 EXIT SUB
Calculate:
 IF Action$ <> "" THEN
  SELECT CASE Action$
  CASE "+"
    IF NOT IsInNumber% THEN
     IsInNumber% = True%
     Value# = VAL(Number$)
    END IF
    Number# = Number# + Value#
    Number$ = LEFT$(LTRIM$(STR$(Number#)), 25)
    IsClear% = True%
    GOSUB OutCalc
  CASE "-"
    IF NOT IsInNumber% THEN
     IsInNumber% = True%
     Value# = VAL(Number$)
    END IF
    Number# = Number# - Value#
    Number$ = LEFT$(LTRIM$(STR$(Number#)), 25)
    IsClear% = True%
    GOSUB OutCalc
  CASE "/"
    IF NOT IsInNumber% THEN
     IsInNumber% = True%
     Value# = VAL(Number$)
    END IF
    IF Value# = 0# THEN
     Number$ = "Divide by zero"
    ELSE
     Number# = Number# / Value#
     Number$ = LEFT$(LTRIM$(STR$(Number#)), 25)
    END IF
    IsClear% = True%
    GOSUB OutCalc
  CASE "*"
    IF NOT IsInNumber% THEN
     IsInNumber% = True%
     Value# = VAL(Number$)
    END IF
    Number# = Number# * Value#
    Number$ = LEFT$(LTRIM$(STR$(Number#)), 25)
    IsClear% = True%
    GOSUB OutCalc
  END SELECT
 END IF
 RETURN
OutCalc:
 IF LEFT$(Number$, 1) = "." THEN Number$ = "0" + Number$
 COLOR 15, 1
 LOCATE 2, 29, 0
 PRINT SPACE$(25 - LEN(Number$)) + Number$;
 COLOR 4, 7
 LOCATE 22, 29, 0
 PRINT Memory$ + SPACE$(25 - LEN(Memory$));
 RETURN
END SUB

FUNCTION CalendarBox% (Title$, Message$, DayValue%, MonthValue%, YearValue%)
 DIM OutMessage$
 DIM OutIndex%
 DIM Value%
 DIM Days%(37)
 DIM CalendarLine$
 DIM WorkDay%
 DIM WorkMonth%
 DIM WorkYear%
 DIM WorkKey$
 IF LEN(Message$) < 256 THEN OutMessage$ = Message$ + SPACE$(256 - LEN(Message$)) ELSE OutMessage$ = LEFT$(Message$, 256)
 CALL MakeBox(7, 5, 64, 14)
 PRINT LEFT$(Title$, 64) + SPACE$(64 - LEN(LEFT$(Title$, 64)));
 COLOR 1, 7
 FOR OutIndex% = 1 TO 4
  LOCATE 6 + OutIndex%, 8, 0
  PRINT LEFT$(OutMessage$, 64);
  OutMessage$ = MID$(OutMessage$, 65)
 NEXT OutIndex%
 COLOR 14, 7
 LOCATE 19, 8, 0
 PRINT "Please press key is equalient to your answer: ENTER=Yes, ESC=No.";
 WorkDay% = DayValue%
 WorkMonth% = MonthValue%
 WorkYear% = YearValue%
 COLOR 15, 7
 LOCATE 11, 31, 0
 PRINT "Mo Tu We Th Fr Sa Su";
 GOSUB OutCalendar
 DO
  WorkKey$ = INKEY$
  SELECT CASE LEN(WorkKey$)
  CASE 1
    SELECT CASE WorkKey$
    CASE CHR$(13)
      DayValue% = WorkDay%
      MonthValue% = WorkMonth%
      YearValue% = WorkYear%
      EXIT DO
    CASE CHR$(27)
      EXIT DO
    END SELECT
  CASE 2
    WorkKey$ = MID$(WorkKey$, 2)
    SELECT CASE WorkKey$
    CASE CHR$(72)
      WorkDay% = WorkDay% - 1
      IF WorkDay% < 1 THEN
       WorkMonth% = WorkMonth% - 1
       IF WorkMonth% < 1 THEN
        IF WorkYear% = 1980 THEN
         WorkMonth% = 1
         WorkDay% = 1
        ELSE
         WorkYear% = WorkYear% - 1
         WorkMonth% = 12
         WorkDay% = 31
        END IF
       ELSE
        WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
       END IF
      END IF
      GOSUB OutCalendar
    CASE CHR$(80)
      WorkDay% = WorkDay% + 1
      IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN
       WorkMonth% = WorkMonth% + 1
       IF WorkMonth% > 12 THEN
        IF WorkYear% = 2010 THEN
         WorkMonth% = 12
         WorkDay% = 31
        ELSE
         WorkYear% = WorkYear% + 1
         WorkMonth% = 1
         WorkDay% = 1
        END IF
       ELSE
        WorkDay% = 1
       END IF
      END IF
      GOSUB OutCalendar
    CASE CHR$(75)
      WorkDay% = WorkDay% - 1
      IF WorkDay% < 1 THEN
       WorkMonth% = WorkMonth% - 1
       IF WorkMonth% < 1 THEN
        IF WorkYear% = 1980 THEN
         WorkMonth% = 1
         WorkDay% = 1
        ELSE
         WorkYear% = WorkYear% - 1
         WorkMonth% = 12
         WorkDay% = 31
        END IF
       ELSE
        WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
       END IF
      END IF
      GOSUB OutCalendar
    CASE CHR$(77)
      WorkDay% = WorkDay% + 1
      IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN
       WorkMonth% = WorkMonth% + 1
       IF WorkMonth% > 12 THEN
        IF WorkYear% = 2010 THEN
         WorkMonth% = 12
         WorkDay% = 31
        ELSE
         WorkYear% = WorkYear% + 1
         WorkMonth% = 1
         WorkDay% = 1
        END IF
       ELSE
        WorkDay% = 1
       END IF
      END IF
      GOSUB OutCalendar
    CASE CHR$(73)
      WorkMonth% = WorkMonth% - 1
      IF WorkMonth% < 1 THEN
       IF WorkYear% = 1980 THEN
        WorkMonth% = 1
       ELSE
        WorkYear% = WorkYear% - 1
        WorkMonth% = 12
       END IF
      END IF
      IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
      GOSUB OutCalendar
    CASE CHR$(81)
      WorkMonth% = WorkMonth% + 1
      IF WorkMonth% > 12 THEN
       IF WorkYear% = 2010 THEN
        WorkMonth% = 12
       ELSE
        WorkYear% = WorkYear% + 1
        WorkMonth% = 1
       END IF
      END IF
      IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
      GOSUB OutCalendar
    CASE CHR$(71)
      IF WorkYear% > 1980 THEN
       WorkYear% = WorkYear% - 1
       IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
       GOSUB OutCalendar
      END IF
    CASE CHR$(79)
      IF WorkYear% < 2010 THEN
       WorkYear% = WorkYear% + 1
       IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
       GOSUB OutCalendar
      END IF
    END SELECT
  END SELECT
 LOOP
 CalendarBox% = WorkKey$ = CHR$(13)
 EXIT FUNCTION
OutCalendar:
 COLOR 8, 7
 LOCATE 12, 31, 0
 PRINT MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + " year." + SPACE$(21 - LEN(MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + " year."));
 FOR OutIndex% = 1 TO 37
  Days%(OutIndex%) = 0
 NEXT OutIndex%
 Value% = 1
 FOR OutIndex% = DayOfWeek%(1, WorkMonth%, WorkYear%) TO 37
  Days%(OutIndex%) = Value%
  Value% = Value% + 1
  IF Value% = MonthDays%(WorkMonth%, WorkYear%) + 1 THEN EXIT FOR
 NEXT OutIndex%
 CalendarLine$ = ""
 Value% = 1
 FOR OutIndex% = 1 TO 37
  IF Days%(OutIndex%) > 0 THEN
   IF Days%(OutIndex%) = WorkDay% THEN
    CalendarLine$ = CalendarLine$ + "*" + SPACE$(2 - LEN(LTRIM$(STR$(Days%(OutIndex%))))) + LTRIM$(STR$(Days%(OutIndex%)))
   ELSE
    CalendarLine$ = CalendarLine$ + SPACE$(3 - LEN(LTRIM$(STR$(Days%(OutIndex%))))) + LTRIM$(STR$(Days%(OutIndex%)))
   END IF
  ELSE
   CalendarLine$ = CalendarLine$ + SPACE$(3)
  END IF
  IF LEN(CalendarLine$) = 21 THEN
   COLOR 6, 7
   LOCATE 12 + Value%, 30, 0
   WHILE CalendarLine$ <> ""
    SELECT CASE LEFT$(CalendarLine$, 1)
    CASE "*"
      COLOR 14, 6
      CalendarLine$ = MID$(CalendarLine$, 2)
      PRINT SPACE$(1) + LEFT$(CalendarLine$, 3);
      CalendarLine$ = MID$(CalendarLine$, 4)
      COLOR 6, 7
    CASE ELSE
      PRINT LEFT$(CalendarLine$, 1);
      CalendarLine$ = MID$(CalendarLine$, 2)
    END SELECT
   WEND
   Value% = Value% + 1
  END IF
 NEXT OutIndex%
 IF CalendarLine$ <> "" THEN
  COLOR 6, 7
  LOCATE 12 + Value%, 30, 0
  WHILE CalendarLine$ <> ""
   SELECT CASE LEFT$(CalendarLine$, 1)
   CASE "*"
     COLOR 14, 6
     CalendarLine$ = MID$(CalendarLine$, 2)
     PRINT SPACE$(1) + LEFT$(CalendarLine$, 3);
     CalendarLine$ = MID$(CalendarLine$, 4)
     COLOR 6, 7
   CASE ELSE
     PRINT LEFT$(CalendarLine$, 1);
     CalendarLine$ = MID$(CalendarLine$, 2)
   END SELECT
  WEND
 END IF
 RETURN
END FUNCTION

SUB CalendarOut
 DIM OutIndex%
 DIM Value%
 DIM Days%(37)
 DIM CalendarLine$
 DIM WorkDay%
 DIM WorkMonth%
 DIM WorkYear%
 DIM WorkKey$
 DIM OldSecond%
 CALL MakeBox(11, 6, 56, 12)
 PRINT "The Calendar." + SPACE$(43);
 COLOR 2, 7
 LOCATE 16, 19, 0
 PRINT "Please press ESC key to exit from calendar.";
 COLOR 0, 7
 LOCATE 17, 11, 0
 PRINT CHR$(204) + STRING$(56, CHR$(205)) + CHR$(185);
 WorkDay% = VAL(MID$(DATE$, 4, 2))
 WorkMonth% = VAL(MID$(DATE$, 1, 2))
 WorkYear% = VAL(MID$(DATE$, 7, 4))
 COLOR 4, 7
 LOCATE 9, 31, 0
 PRINT "Mo Tu We Th Fr Sa Su";
 OldSecond% = NOT VAL(MID$(TIME$, 7, 2))
 GOSUB CalendarOutCalendar
 DO
  IF OldSecond% <> VAL(MID$(TIME$, 7, 2)) THEN
   OldSecond% = VAL(MID$(TIME$, 7, 2))
   GOSUB CalendarOutCalendar
  END IF
  WorkKey$ = INKEY$
  SELECT CASE LEN(WorkKey$)
  CASE 1
    IF WorkKey$ = CHR$(27) THEN EXIT DO
  CASE 2
    WorkKey$ = MID$(WorkKey$, 2)
    SELECT CASE WorkKey$
    CASE CHR$(72)
      WorkDay% = WorkDay% - 1
      IF WorkDay% < 1 THEN
       WorkMonth% = WorkMonth% - 1
       IF WorkMonth% < 1 THEN
        IF WorkYear% = 1980 THEN
         WorkMonth% = 1
         WorkDay% = 1
        ELSE
         WorkYear% = WorkYear% - 1
         WorkMonth% = 12
         WorkDay% = 31
        END IF
       ELSE
        WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
       END IF
      END IF
      GOSUB CalendarOutCalendar
    CASE CHR$(80)
      WorkDay% = WorkDay% + 1
      IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN
       WorkMonth% = WorkMonth% + 1
       IF WorkMonth% > 12 THEN
        IF WorkYear% = 2010 THEN
         WorkMonth% = 12
         WorkDay% = 31
        ELSE
         WorkYear% = WorkYear% + 1
         WorkMonth% = 1
         WorkDay% = 1
        END IF
       ELSE
        WorkDay% = 1
       END IF
      END IF
      GOSUB CalendarOutCalendar
    CASE CHR$(75)
      WorkDay% = WorkDay% - 1
      IF WorkDay% < 1 THEN
       WorkMonth% = WorkMonth% - 1
       IF WorkMonth% < 1 THEN
        IF WorkYear% = 1980 THEN
         WorkMonth% = 1
         WorkDay% = 1
        ELSE
         WorkYear% = WorkYear% - 1
         WorkMonth% = 12
         WorkDay% = 31
        END IF
       ELSE
        WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
       END IF
      END IF
      GOSUB CalendarOutCalendar
    CASE CHR$(77)
      WorkDay% = WorkDay% + 1
      IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN
       WorkMonth% = WorkMonth% + 1
       IF WorkMonth% > 12 THEN
        IF WorkYear% = 2010 THEN
         WorkMonth% = 12
         WorkDay% = 31
        ELSE
         WorkYear% = WorkYear% + 1
         WorkMonth% = 1
         WorkDay% = 1
        END IF
       ELSE
        WorkDay% = 1
       END IF
      END IF
      GOSUB CalendarOutCalendar
    CASE CHR$(73)
      WorkMonth% = WorkMonth% - 1
      IF WorkMonth% < 1 THEN
       IF WorkYear% = 1980 THEN
        WorkMonth% = 1
       ELSE
        WorkYear% = WorkYear% - 1
        WorkMonth% = 12
       END IF
      END IF
      IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
      GOSUB CalendarOutCalendar
    CASE CHR$(81)
      WorkMonth% = WorkMonth% + 1
      IF WorkMonth% > 12 THEN
       IF WorkYear% = 2010 THEN
        WorkMonth% = 12
       ELSE
        WorkYear% = WorkYear% + 1
        WorkMonth% = 1
       END IF
      END IF
      IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
      GOSUB CalendarOutCalendar
    CASE CHR$(71)
      IF WorkYear% > 1980 THEN
       WorkYear% = WorkYear% - 1
       IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
       GOSUB CalendarOutCalendar
      END IF
    CASE CHR$(79)
      IF WorkYear% < 2010 THEN
       WorkYear% = WorkYear% + 1
       IF WorkDay% > MonthDays%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDays%(WorkMonth%, WorkYear%)
       GOSUB CalendarOutCalendar
      END IF
    END SELECT
  END SELECT
 LOOP
 EXIT SUB
CalendarOutCalendar:
 COLOR 2, 7
 LOCATE 8, 31, 0
 PRINT MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + " year." + SPACE$(21 - LEN(MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + " year."));
 FOR OutIndex% = 1 TO 37
  Days%(OutIndex%) = 0
 NEXT OutIndex%
 Value% = 1
 FOR OutIndex% = DayOfWeek%(1, WorkMonth%, WorkYear%) TO 37
  Days%(OutIndex%) = Value%
  Value% = Value% + 1
  IF Value% = MonthDays%(WorkMonth%, WorkYear%) + 1 THEN EXIT FOR
 NEXT OutIndex%
 CalendarLine$ = ""
 Value% = 1
 FOR OutIndex% = 1 TO 37
  IF Days%(OutIndex%) > 0 THEN
   IF Days%(OutIndex%) = WorkDay% THEN
    CalendarLine$ = CalendarLine$ + "*" + SPACE$(2 - LEN(LTRIM$(STR$(Days%(OutIndex%))))) + LTRIM$(STR$(Days%(OutIndex%)))
   ELSE
    CalendarLine$ = CalendarLine$ + SPACE$(3 - LEN(LTRIM$(STR$(Days%(OutIndex%))))) + LTRIM$(STR$(Days%(OutIndex%)))
   END IF
  ELSE
   CalendarLine$ = CalendarLine$ + SPACE$(3)
  END IF
  IF LEN(CalendarLine$) = 21 THEN
   COLOR 6, 7
   LOCATE 9 + Value%, 30, 0
   WHILE CalendarLine$ <> ""
    SELECT CASE LEFT$(CalendarLine$, 1)
    CASE "*"
      COLOR 14, 6
      CalendarLine$ = MID$(CalendarLine$, 2)
      PRINT SPACE$(1) + LEFT$(CalendarLine$, 3);
      CalendarLine$ = MID$(CalendarLine$, 4)
      COLOR 6, 7
    CASE ELSE
      PRINT LEFT$(CalendarLine$, 1);
      CalendarLine$ = MID$(CalendarLine$, 2)
    END SELECT
   WEND
   Value% = Value% + 1
  END IF
 NEXT OutIndex%
 IF CalendarLine$ <> "" THEN
  COLOR 6, 7
  LOCATE 9 + Value%, 30, 0
  WHILE CalendarLine$ <> ""
   SELECT CASE LEFT$(CalendarLine$, 1)
   CASE "*"
     COLOR 14, 6
     CalendarLine$ = MID$(CalendarLine$, 2)
     PRINT SPACE$(1) + LEFT$(CalendarLine$, 3);
     CalendarLine$ = MID$(CalendarLine$, 4)
     COLOR 6, 7
   CASE ELSE
     PRINT LEFT$(CalendarLine$, 1);
     CalendarLine$ = MID$(CalendarLine$, 2)
   END SELECT
  WEND
 END IF
 COLOR 15, 7
 LOCATE 18, 12, 0
 PRINT CurrentDateTime$;
 RETURN
END SUB

FUNCTION CurrentDateTime$
 CurrentDateTime$ = "Date: " + DayOfWeekName$(VAL(MID$(DATE$, 4, 2)), VAL(MID$(DATE$, 1, 2)), VAL(MID$(DATE$, 7, 4))) + ", " + LTRIM$(STR$(VAL(MID$(DATE$, 4, 2)))) + " " + MonthName$(VAL(MID$(DATE$, 1, 2))) + " " + LTRIM$(STR$(VAL(MID$(DATE$, 7, 4)))) + " year. Time: " + TIME$ + "."
END FUNCTION

FUNCTION DayName$ (DayNumber%)
 SELECT CASE DayNumber%
 CASE 1
   DayName$ = "Monday"
 CASE 2
   DayName$ = "Tuesday"
 CASE 3
   DayName$ = "Wednesday"
 CASE 4
   DayName$ = "Thursday"
 CASE 5
   DayName$ = "Friday"
 CASE 6
   DayName$ = "Saturday"
 CASE 7
   DayName$ = "Sunday"
 END SELECT
END FUNCTION

FUNCTION DayOfWeek% (DayValue%, MonthValue%, YearValue%)
 SELECT CASE DaysCount&(DayValue%, MonthValue%, YearValue%) - (INT(DaysCount&(DayValue%, MonthValue%, YearValue%) / 7) * 7)
 CASE 0
   DayOfWeek% = 6
 CASE 1
   DayOfWeek% = 7
 CASE 2
   DayOfWeek% = 1
 CASE 3
   DayOfWeek% = 2
 CASE 4
   DayOfWeek% = 3
 CASE 5
   DayOfWeek% = 4
 CASE 6
   DayOfWeek% = 5
 CASE 7
   DayOfWeek% = 6
 END SELECT
END FUNCTION

FUNCTION DayOfWeekName$ (DayValue%, MonthValue%, YearValue%)
 DayOfWeekName$ = DayName$(DayOfWeek%(DayValue%, MonthValue%, YearValue%))
END FUNCTION

FUNCTION DaysCount& (DayValue%, MonthValue%, YearValue%)
 DaysCount& = (YearValue% * 365#) + INT(YearValue% / 100) + INT(YearValue% / 4) + MonthDaysCount%(MonthValue%, YearValue%) + DayValue%
END FUNCTION

FUNCTION InputBox% (Title$, Message$, InputTextLine$)
 DIM OutMessage$
 DIM OutIndex%
 DIM WorkKey$
 DIM InputTextCursorColumn%
 DIM InputTextCursorPosition%
 DIM InputText$
 IF LEN(Message$) < 256 THEN OutMessage$ = Message$ + SPACE$(256 - LEN(Message$)) ELSE OutMessage$ = LEFT$(Message$, 256)
 CALL MakeBox(7, 8, 64, 7)
 PRINT LEFT$(Title$, 64) + SPACE$(64 - LEN(LEFT$(Title$, 64)));
 COLOR 1, 7
 FOR OutIndex% = 1 TO 4
  LOCATE 9 + OutIndex%, 8, 0
  PRINT LEFT$(OutMessage$, 64);
  OutMessage$ = MID$(OutMessage$, 65)
 NEXT OutIndex%
 COLOR 14, 7
 LOCATE 15, 8, 0
 PRINT "Please press key is equalient to your answer: ENTER=Yes, ESC=No.";
 InputTextCursorColumn% = 1
 InputTextCursorPosition% = 1
 InputText$ = InputTextLine$
 GOSUB OutInputLine
 DO
  WorkKey$ = INKEY$
  SELECT CASE LEN(WorkKey$)
  CASE 1
    SELECT CASE WorkKey$
    CASE CHR$(8)
      IF InputTextCursorColumn% > 1 THEN
       InputTextCursorColumn% = InputTextCursorColumn% - 1
       InputTextCursorPosition% = InputTextCursorPosition% - 1
       IF InputTextCursorColumn% < 1 THEN InputTextCursorColumn% = 1
       IF InputTextCursorPosition% < 1 THEN InputTextCursorPosition% = 1
       InputText$ = MID$(InputText$, 1, InputTextCursorColumn% - 1) + MID$(InputText$, InputTextCursorColumn% + 1)
       GOSUB OutInputLine
      END IF
    CASE CHR$(13)
      InputTextLine$ = InputText$
      EXIT DO
    CASE CHR$(27)
      EXIT DO
    CASE ELSE
      IF (LEN(InputText$) < 256) AND (ASC(WorkKey$) > (ASC(SPACE$(1)) - 1)) THEN
       InputText$ = MID$(InputText$, 1, InputTextCursorColumn% - 1) + WorkKey$ + MID$(InputText$, InputTextCursorColumn%)
       InputTextCursorColumn% = InputTextCursorColumn% + 1
       InputTextCursorPosition% = InputTextCursorPosition% + 1
       IF InputTextCursorColumn% > LEN(InputText$) + 1 THEN InputTextCursorColumn% = LEN(InputText$) + 1
       IF LEN(InputText$) > 63 THEN IF InputTextCursorPosition% > 64 THEN InputTextCursorPosition% = 64
       IF LEN(InputText$) < 65 THEN IF InputTextCursorPosition% > LEN(InputText$) + 1 THEN InputTextCursorPosition% = LEN(InputText$) + 1
       GOSUB OutInputLine
      END IF
    END SELECT
  CASE 2
    WorkKey$ = MID$(WorkKey$, 2)
    SELECT CASE WorkKey$
    CASE CHR$(75)
      IF InputTextCursorColumn% > 1 THEN
       InputTextCursorColumn% = InputTextCursorColumn% - 1
       InputTextCursorPosition% = InputTextCursorPosition% - 1
       IF InputTextCursorColumn% < 1 THEN InputTextCursorColumn% = 1
       IF InputTextCursorPosition% < 1 THEN InputTextCursorPosition% = 1
       GOSUB OutInputLine
      END IF
    CASE CHR$(77)
      IF InputTextCursorColumn% < LEN(InputText$) + 1 THEN
       InputTextCursorColumn% = InputTextCursorColumn% + 1
       InputTextCursorPosition% = InputTextCursorPosition% + 1
       IF InputTextCursorColumn% > LEN(InputText$) + 1 THEN InputTextCursorColumn% = LEN(InputText$) + 1
       IF LEN(InputText$) > 63 THEN IF InputTextCursorPosition% > 64 THEN InputTextCursorPosition% = 64
       IF LEN(InputText$) < 65 THEN IF InputTextCursorPosition% > LEN(InputText$) + 1 THEN InputTextCursorPosition% = LEN(InputText$) + 1
       GOSUB OutInputLine
      END IF
    CASE CHR$(71)
      IF InputTextCursorColumn% <> 1 THEN
       InputTextCursorColumn% = 1
       InputTextCursorPosition% = 1
       GOSUB OutInputLine
      END IF
    CASE CHR$(79)
      IF InputTextCursorColumn% <> LEN(InputText$) + 1 THEN
       InputTextCursorColumn% = LEN(InputText$) + 1
       InputTextCursorPosition% = LEN(InputText$) + 1
       IF LEN(InputText$) > 63 THEN IF InputTextCursorPosition% > 64 THEN InputTextCursorPosition% = 64
       IF LEN(InputText$) < 65 THEN IF InputTextCursorPosition% > LEN(InputText$) + 1 THEN InputTextCursorPosition% = LEN(InputText$) + 1
       GOSUB OutInputLine
      END IF
    CASE CHR$(83)
      IF InputText$ <> "" THEN
       InputText$ = MID$(InputText$, 1, InputTextCursorColumn% - 1) + MID$(InputText$, InputTextCursorColumn% + 1)
       GOSUB OutInputLine
      END IF
    END SELECT
  END SELECT
 LOOP
 LOCATE , , 0
 InputBox% = WorkKey$ = CHR$(13)
 EXIT FUNCTION
OutInputLine:
 COLOR 4, 7
 LOCATE 14, 8, 0
 PRINT MID$(InputText$, (InputTextCursorColumn% - InputTextCursorPosition%) + 1, 64) + SPACE$(64 - LEN(MID$(InputText$, (InputTextCursorColumn% - InputTextCursorPosition%) + 1, 64)));
 LOCATE 14, 7 + InputTextCursorPosition%, 1, 7, 8
 RETURN
END FUNCTION

FUNCTION IsLeapYear% (YearValue%)
 IsLeapYear% = ABS((INT(YearValue% / 4) * 4) = YearValue%)
END FUNCTION

SUB MakeBox (BoxColumn%, BoxRow%, BoxWidth%, BoxHeight%)
 DIM BoxWorkIndex%
 IF (BoxColumn% < 1) OR (BoxRow% < 1) OR (BoxWidth% < 1) OR (BoxHeight% < 1) OR (BoxWidth% > 77) OR (BoxHeight% > 22) OR (((BoxColumn% - 1) + BoxWidth%) > 77) OR (((BoxRow% - 1) + BoxHeight%) > 22) THEN EXIT SUB
 COLOR 0, 7
 LOCATE BoxRow%, BoxColumn%, 0
 PRINT CHR$(201) + STRING$(BoxWidth%, CHR$(205)) + CHR$(187);
 FOR BoxWorkIndex% = 1 TO BoxHeight% + 1
  LOCATE BoxRow% + BoxWorkIndex%, BoxColumn%, 0
  PRINT CHR$(186) + SPACE$(BoxWidth%) + CHR$(186);
  COLOR 0, 0
  PRINT SPACE$(1);
  COLOR 0, 7
 NEXT BoxWorkIndex%
 LOCATE BoxRow% + BoxHeight% + 1, BoxColumn%, 0
 PRINT CHR$(200) + STRING$(BoxWidth%, CHR$(205)) + CHR$(188);
 COLOR 0, 0
 LOCATE BoxRow% + BoxHeight% + 2, BoxColumn% + 1, 0
 PRINT SPACE$(BoxWidth% + 2);
 COLOR 15, 2
 LOCATE BoxRow% + 1, BoxColumn% + 1, 0
END SUB

FUNCTION MenuBox% (ItemsCount%)
 DIM MenuIndex%
 DIM MenuLineLength%
 DIM CurrentItem%
 DIM WorkKey$
 IF (ItemsCount% < 1) OR (ItemsCount% > UBOUND(MenuItems$)) OR (UBOUND(MenuItems$) > 20) THEN
  MenuBox% = 0
  EXIT FUNCTION
 END IF
 MenuLineLength% = 0
 FOR MenuIndex% = 1 TO ItemsCount%
  IF LEN(MenuItems$(MenuIndex%)) > MenuLineLength% THEN MenuLineLength% = LEN(MenuItems$(MenuIndex%))
 NEXT MenuIndex%
 IF MenuLineLength% < 56 THEN MenuLineLength% = 56
 IF MenuLineLength% > 75 THEN MenuLineLength% = 75
 CurrentItem% = 1
 GOSUB OutMenu
 DO
  WorkKey$ = UCASE$(INKEY$)
  SELECT CASE LEN(WorkKey$)
  CASE 1
    SELECT CASE WorkKey$
    CASE CHR$(13)
      MenuBox% = CurrentItem%
      EXIT DO
    CASE CHR$(27)
      MenuBox% = 0
      EXIT DO
    CASE ELSE
      IF (ASC(WorkKey$) > (ASC("A") - 1)) AND (ASC(WorkKey$) < (ASC("A") + ItemsCount%)) THEN
       CurrentItem% = (ASC(WorkKey$) - ASC("A")) + 1
       GOSUB OutMenu
      END IF
    END SELECT
  CASE 2
    WorkKey$ = MID$(WorkKey$, 2)
    SELECT CASE WorkKey$
    CASE CHR$(72)
      IF CurrentItem% > 1 THEN
       CurrentItem% = CurrentItem% - 1
       GOSUB OutMenu
      END IF
    CASE CHR$(80)
      IF CurrentItem% < ItemsCount% THEN
       CurrentItem% = CurrentItem% + 1
       GOSUB OutMenu
      END IF
    CASE CHR$(73)
      IF CurrentItem% <> 1 THEN
       CurrentItem% = 1
       GOSUB OutMenu
      END IF
    CASE CHR$(81)
      IF CurrentItem% <> ItemsCount% THEN
       CurrentItem% = ItemsCount%
       GOSUB OutMenu
      END IF
    CASE CHR$(71)
      IF CurrentItem% <> 1 THEN
       CurrentItem% = 1
       GOSUB OutMenu
      END IF
    CASE CHR$(79)
      IF CurrentItem% <> ItemsCount% THEN
       CurrentItem% = ItemsCount%
       GOSUB OutMenu
      END IF
    END SELECT
  END SELECT
 LOOP
 EXIT FUNCTION
OutMenu:
 CALL MakeBox(INT((80 - (MenuLineLength% + 5)) / 2) + 1, INT((25 - (ItemsCount% + 5)) / 2) + 1, MenuLineLength% + 2, ItemsCount% + 2)
 FOR MenuIndex% = 1 TO ItemsCount%
  COLOR 14, 7
  LOCATE INT((25 - (ItemsCount% + 5)) / 2) + (MenuIndex% + 1), INT((80 - (MenuLineLength% + 5)) / 2) + 2, 0
  PRINT CHR$(ASC("A") + (MenuIndex% - 1));
  COLOR 12, 7
  PRINT "=";
  IF MenuIndex% = CurrentItem% THEN COLOR 15, 6 ELSE COLOR 8, 7
  PRINT LEFT$(MenuItems$(MenuIndex%), MenuLineLength%) + SPACE$(MenuLineLength% - LEN(LEFT$(MenuItems$(MenuIndex%), MenuLineLength%)));
 NEXT MenuIndex%
 COLOR 0, 7
 LOCATE INT((25 - (ItemsCount% + 5)) / 2) + 2 + ItemsCount%, INT((80 - (MenuLineLength% + 5)) / 2) + 1, 0
 PRINT CHR$(204) + STRING$(MenuLineLength% + 2, CHR$(205)) + CHR$(185);
 COLOR 14, 7
 LOCATE INT((25 - (ItemsCount% + 5)) / 2) + 3 + ItemsCount%, INT((80 - (MenuLineLength% + 5)) / 2) + 2, 0
 PRINT SPACE$(INT((MenuLineLength% - 56) / 2) + 1) + "Please press ENTER to select menu item or ESC to cancel."
 RETURN
END FUNCTION

FUNCTION MessageBox% (Title$, Message$)
 DIM OutMessage$
 DIM OutIndex%
 DIM WorkKey$
 IF LEN(Message$) < 256 THEN OutMessage$ = Message$ + SPACE$(256 - LEN(Message$)) ELSE OutMessage$ = LEFT$(Message$, 256)
 CALL MakeBox(7, 9, 64, 6)
 PRINT LEFT$(Title$, 64) + SPACE$(64 - LEN(LEFT$(Title$, 64)));
 COLOR 1, 7
 FOR OutIndex% = 1 TO 4
  LOCATE 10 + OutIndex%, 8, 0
  PRINT LEFT$(OutMessage$, 64);
  OutMessage$ = MID$(OutMessage$, 65)
 NEXT OutIndex%
 COLOR 14, 7
 LOCATE 15, 8, 0
 PRINT "Please press key is equalient to your answer: ENTER=Yes, ESC=No.";
 WorkKey$ = ""
 WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
  WorkKey$ = INKEY$
 WEND
 MessageBox% = WorkKey$ = CHR$(13)
END FUNCTION

FUNCTION MonthDays% (MonthValue%, YearValue%)
 SELECT CASE MonthValue%
 CASE 1
   MonthDays% = 31
 CASE 2
   MonthDays% = 28 + IsLeapYear%(YearValue%)
 CASE 3
   MonthDays% = 31
 CASE 4
   MonthDays% = 30
 CASE 5
   MonthDays% = 31
 CASE 6
   MonthDays% = 30
 CASE 7
   MonthDays% = 31
 CASE 8
   MonthDays% = 31
 CASE 9
   MonthDays% = 30
 CASE 10
   MonthDays% = 31
 CASE 11
   MonthDays% = 30
 CASE 12
   MonthDays% = 31
 END SELECT
END FUNCTION

FUNCTION MonthDaysCount% (MonthValue%, YearValue%)
 SELECT CASE MonthValue%
 CASE 1
   MonthDaysCount% = 0
 CASE 2
   MonthDaysCount% = 31
 CASE 3
   MonthDaysCount% = 59 + IsLeapYear%(YearValue%)
 CASE 4
   MonthDaysCount% = 90 + IsLeapYear%(YearValue%)
 CASE 5
   MonthDaysCount% = 120 + IsLeapYear%(YearValue%)
 CASE 6
   MonthDaysCount% = 151 + IsLeapYear%(YearValue%)
 CASE 7
   MonthDaysCount% = 181 + IsLeapYear%(YearValue%)
 CASE 8
   MonthDaysCount% = 212 + IsLeapYear%(YearValue%)
 CASE 9
   MonthDaysCount% = 243 + IsLeapYear%(YearValue%)
 CASE 10
   MonthDaysCount% = 273 + IsLeapYear%(YearValue%)
 CASE 11
   MonthDaysCount% = 304 + IsLeapYear%(YearValue%)
 CASE 12
   MonthDaysCount% = 334 + IsLeapYear%(YearValue%)
 END SELECT
END FUNCTION

FUNCTION MonthName$ (MonthNumber%)
 SELECT CASE MonthNumber%
 CASE 1
   MonthName$ = "January"
 CASE 2
   MonthName$ = "February"
 CASE 3
   MonthName$ = "March"
 CASE 4
   MonthName$ = "April"
 CASE 5
   MonthName$ = "May"
 CASE 6
   MonthName$ = "June"
 CASE 7
   MonthName$ = "July"
 CASE 8
   MonthName$ = "August"
 CASE 9
   MonthName$ = "September"
 CASE 10
   MonthName$ = "October"
 CASE 11
   MonthName$ = "November"
 CASE 12
   MonthName$ = "December"
 END SELECT
END FUNCTION

SUB OutBox (Title$, Message$)
 DIM OutMessage$
 DIM OutIndex%
 IF LEN(Message$) < 256 THEN OutMessage$ = Message$ + SPACE$(256 - LEN(Message$)) ELSE OutMessage$ = LEFT$(Message$, 256)
 CALL MakeBox(7, 9, 64, 6)
 PRINT LEFT$(Title$, 64) + SPACE$(64 - LEN(LEFT$(Title$, 64)));
 COLOR 1, 7
 FOR OutIndex% = 1 TO 4
  LOCATE 10 + OutIndex%, 8, 0
  PRINT LEFT$(OutMessage$, 64);
  OutMessage$ = MID$(OutMessage$, 65)
 NEXT OutIndex%
 COLOR 14, 7
 LOCATE 15, 8, 0
 PRINT "       Please press the ENTER key to quit from this box.";
 WHILE INKEY$ <> CHR$(13)
 WEND
END SUB

SUB OutHelpText
 DIM OutLine$
 DIM OutIndex%
 DIM Index%
 COLOR 4, 7
 LOCATE 22, 2, 0
 PRINT SPACE$(77);
 LOCATE 22, 2, 0
 PRINT "Row=" + LTRIM$(STR$(HelpTextPosition%)) + ". Column=" + LTRIM$(STR$(HelpLinePosition%)) + ". Free space of subject count=" + LTRIM$(STR$(HelpSubjectsCount% - HelpWorkSubjectsCount%)) + ".";
 LOCATE 23, 2, 0
 PRINT SPACE$(77);
 LOCATE 23, 2, 0
 PRINT CurrentDateTime$;
 FOR Index% = 1 TO 20
  OutLine$ = HelpText$((HelpTextPosition% - HelpPosition%) + Index%)
  COLOR 1, 7
  LOCATE Index% + 1, 2, 0
  PRINT SPACE$(77);
  LOCATE Index% + 1, 2, 0
  WHILE OutLine$ <> ""
   SELECT CASE LEFT$(OutLine$, 1)
   CASE "{"
     IF INSTR(OutLine$, "}") > 0 THEN
      OutLine$ = LTRIM$(MID$(OutLine$, 2))
      COLOR 15, 7
      PRINT "#";
      COLOR 2, 7
      PRINT RTRIM$(MID$(OutLine$, 1, INSTR(OutLine$, "}") - 1));
      COLOR 14, 7
      PRINT "@";
      COLOR 1, 7
      OutLine$ = MID$(OutLine$, INSTR(OutLine$, "}") + 1)
     ELSE
      PRINT LEFT$(OutLine$, 1);
      OutLine$ = MID$(OutLine$, 2)
     END IF
   CASE ELSE
     PRINT LEFT$(OutLine$, 1);
     OutLine$ = MID$(OutLine$, 2)
   END SELECT
  WEND
 NEXT Index%
 LOCATE HelpPosition% + 1, HelpLinePosition% + 1, 1, 7, 8
END SUB

SUB ScratchScreen
 COLOR 0, 2
 CLS
 PRINT "********************************************************************************"
 PRINT "                The Standart GNU Personal Multifunctional Utility."
 PRINT "                     Copyright (C) Sandul Yura Valentinovich."
 PRINT "                        (R) Wednesday, 5 March 2003 year."
 PRINT
 PRINT "    This program is free software; you can redistribute it and/or modify it"
 PRINT "under the terms of the GNU General Public License as published by the Free"
 PRINT "Software Foundation; either version 2 of the License, or (at your option) any"
 PRINT "later version."
 PRINT "    This program is distributed in the hope that it will be useful, but WITHOUT"
 PRINT "ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS"
 PRINT "FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details."
 PRINT "    You should have received a copy of the GNU General Public License along with"
 PRINT "this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,"
 PRINT "Cambridge, MA 02139, USA."
END SUB

