// ***************************************
// WATCOM LINKER TO LOG TRANSLATOR
//
//
//              Written by Emil Dotchevski
// ***************************************

// This program reads Watcom Linker output from stdin, translates it
// to log format, and writes translated text to stdout.
//
// POWER VIEW IDE LOG FORMAT DESCRIPTION
//
// All lines written to stdout must be in the format
//
// <file>,<line>,<column>,<message>\n
//
// where <file> is full file specification of the source file, <line>
// and <column> are location of the message (error) in the source file,
// and <message> is the text to be displayed by the IDE.
//
// If any of <file>, <line> or <column> are unknown, leave responding
// field empty, for example ",,,something" describes none of <file>,
// <line> and <column> are given, and the message is "something".
//
// It is a good idea, if compiler output is not recognized to copy all
// stdin lines to stdout in the form ",,,<message>", wich guarantees
// all the messages will be displayed in the log.


#include <stdio.h>
#include <string.h>

#define MAX_LINE_SIZE     255


static char buffer[MAX_LINE_SIZE+1]; //buffer for read lines


static char *read( void )
//read a line from stdin in the buffer
{
  return fgets( buffer, MAX_LINE_SIZE, stdin );
}


static int write( char *l )
//write string to stdout
{
  return fputs( l, stdout );
}


void main( void )
{
  char msg[256], *b, *z;

  if( ( read() == NULL ) ||
      ( strstr( buffer, "WATCOM Linker" ) != buffer ) )
  {

// Watcom Linker not recognized -- copy input to output

    do
    {
      write( ",,," );
      write( buffer );
    }
    while( read() != NULL );
    return;
  }

// Watcom Linker recognized -- translate to log format

  read();
  read(); //skip copyright messages

  while( read() != NULL )
  {
    if( ( *buffer == 0 ) || ( *buffer == '\n' ) ) continue;
    if( strstr( buffer, "file " ) == buffer )
    {
      b = strchr( buffer, '(' ) + 1; if( b == NULL ) goto not_recognized;
      z = strchr( b, ')' );          if( z == NULL ) goto not_recognized;
      *z = 0;
      if( ( *++z != ':' ) || ( *++z != ' ' ) ) goto not_recognized;
      strcpy( msg, b );
      strcat( msg, ", 0, 0, " );
      strcat( msg, "Linker:" );
      strcat( msg, z );
      write( msg );
    }
    else
    {
    not_recognized:
      write( ",,," );
      write( buffer ); //message not recognized -- write as is
    }
  }
}
