//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVFC.CPP                             |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Power View Font Compiler             |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_stdlib
#define uses_dos
#define uses_fcntl
#define uses_stdio
#define uses_basics
#define uses_comlin
#define uses_system

#include "PVuses.h"

char font1[256*16], font2[256*16];
Tset graph_chars;
word graph_count;
word char_size = 16;

void error( int flag, char *s, char *m )
{
  if( flag )
  {
    printf( "Error: %s %s", s, m );
    exit( -1 );
  }
}

boolean read_font( char *filename, char *font )
{
  int handle;
  unsigned num_read;

  if( _dos_open( filename, O_RDONLY, &handle) ) return 0;
  if( _dos_read( handle, font, 256*16, &num_read ) || ( num_read != 256*16 ) )
  {
    _dos_close( handle );
    return 0;
  }
  _dos_close( handle );
  return 1;
}

boolean cmp_chars( word chr )
{
  word i;

  for( i = 0; i < char_size; i++ )
    if( font1[16*chr+i] != font2[16*chr+i] ) return 0;
  return 1;
}

void cmp_fonts( void )
{
  word i;

  graph_count = 0;
  for( i = 0; i < 256; i++ )
    if( !cmp_chars( i ) )
    {
      graph_chars<<i;
      graph_count++;
    }
}

boolean write_cpp( char *filename, char *font )
{
  FILE *f;
  unsigned num_read;
  word i, c, cnt;

  if( !( f = fopen( filename, "w+" ) ) ) return 0;
  if( fprintf(f,"\n#define GRAPH_COUNT%d %d\n", char_size, graph_count ) == EOF ) return 0;
  if( fprintf( f, "char graph_set%d[32] = {", char_size ) == EOF ) return 0;
  for( i = 0; i < 32; i++ )
  {
    if( !( i % 8 ) && ( fprintf( f, "\n  " ) == EOF ) ) return 0;
    if( fprintf( f, "0x%02X", graph_chars.members[i] ) == EOF ) return 0;
    if( ( i < 31 ) && ( fprintf( f, "," ) == EOF ) ) return 0;
  }
  if( fprintf( f,"\n};\nchar graph_chars%d[GRAPH_COUNT%d][%d] = {\n", char_size, char_size, char_size ) == EOF ) return 0;
  cnt = 0;
  for( i = 0; i < 256; i++ )
    if( i&graph_chars )
    {
      if( fprintf( f, "  { " ) == EOF ) return 0;
      for( c = 0; c < char_size - 1; c++ )
        if( fprintf( f, "0x%02X,", font[16*i+c] ) == EOF ) return 0;
      if( fprintf( f, "0x%02X }", font[16*i+char_size-1] ) == EOF ) return 0;
      if( ++cnt < graph_count )
      {
        if( fprintf( f,",\n" ) == EOF ) return 0;
      }
      else
        if( fprintf( f, "\n" ) == EOF ) return 0;
    }
  if( fprintf(f,"};\n") == EOF ) return 0;
  fclose( f );
  return 1;
}

char fn1[_MAX_PATH], fn2[_MAX_PATH], fn3[_MAX_PATH];

void proceed_command_line( void )
{
  printf("Power View Font Compiler. Written by Emil Dochevsky.\n\n");
  if( !param_filename( fn1, ".FNT" ) ||
      !param_filename( fn2, ".CPP" ) ||
      param_opt( "/?" ) )
  {
    printf( "\
Syntax:\n\
  fnt2c <font_file>[.FNT] <C_file>[.CPP] [<standard_font>[.FNT]] [/<x>]\n\n\
Description:\n\
  If <standard_font> is omitted, complete font definition is exported.\n\
  Otherwise <standard_font> is compared to <font_file> and only different\n\
  chars definitions are exported.\n\
  <x> is bytes per char to compare/export (default=16)\n"
    );
    exit( 1 );
  }
  *fn3 = 0; param_filename( fn3, ".FNT" );
  if( param_opt( "/8" ) ) char_size = 8;
  if( param_opt( "/14" ) ) char_size = 14;
  if( param_opt( "/16" ) ) char_size = 16;
}

word i;

void main( int argc, char* argv[] )
{
  __init_comlin( argc, argv );
  proceed_command_line();
  __tini_comlin();
  printf( "Reading first font file...\n" );
  error( !read_font( fn1, font1 ), "Error reading first font file", fexpand( fn1 ) );
  if( *fn3 == 0 )
    for( i = 0; i < 256*16; i++ )
      font2[i] = ~font1[i];
  else
  {
    printf( "Reading second font file...\n" );
    error( !read_font( fn3, font2 ), "Error reading second font file", fexpand( fn3 ) );
    printf( "Comparing chars definitions...\n" );
  }
  cmp_fonts();
  printf( "Writing output file...\n" );
  error( !write_cpp( fn2, font1 ), "Error writing C file", fexpand( fn2 ) );
  printf( "Done.\n\nOutput file: %s\n%d chars definitions exported.\n", fexpand( fn2 ), graph_count );
}
