//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVBUTTON.CPP                         |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Buttons implementation               |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_string
#define uses_button
#define uses_colors
#define uses_dc
#define uses_dialog
#define uses_icons
#define uses_system

#include "PVuses.h"

//Tbutton publics:

Tbutton::Tbutton( char *t, uint cmd ):
  Titem( smart_len( t ) + 2, 1 )
{
  title = STRDUP( t );
  shortcut = 0;
  command = cmd;
  pressed = 0;
#ifndef NOMOUSE
  if( flags( bfREPEAT ) ) set_events_mask( evMOUSE_REP, 1 );
#endif
  if( flags( bfDEFAULT ) )
  {
    set_state( bsDEFAULT, 1 );
    shortcut = kENTER;
  }
  if( command ) set_state( isDISABLED, cdisabled( command ) );
}

Tbutton::~Tbutton( void )
{
  FREE( title );
}

void Tbutton::set_flags( uint _flags_word, boolean enable )
{
  Titem::set_flags( _flags_word, enable );
  if( flags_word & bfDEFAULT )
  {
    shortcut = kENTER;
    grab_default();
  }
  if( !( _flags_word & bfREPEAT ) ) return;
#ifndef NOMOUSE
  set_events_mask( evMOUSE_REP, flags( bfREPEAT ) );
#endif
}

void Tbutton::set_state( uint _state_word, boolean enable )
{
  uint st;

  st = state_word;
  Titem::set_state( _state_word, enable );
  if( ( st & bsDEFAULT ) != ( state_word & bsDEFAULT ) ) redraw();
}

void Tbutton::set_title( char *t )
{
  FREE( title );
  title = STRDUP( t );
  resize( smart_len( t ), 1 );
  redraw();
}

void Tbutton::set_cmd( uint cmd )
{
  command = cmd;
}

//Tbutton protected:

void Tbutton::set_palette( void )
{
  Titem::set_palette();
  attr[0] = pal_buttons.normal;
  attr[1] = pal_buttons.selected;
  attr[3] = pal_buttons._default;
  attr[4] = pal_buttons.pressed;
  attr[2] = pal_buttons.disabled;
  attr[9] = (char) ( text_attr & 0xF0 );
  attr[5] = (char) ( attr[9] | ( ( attr[0] >> 4 ) & 0x0F ) );
  attr[6] = (char) ( attr[9] | ( ( attr[1] >> 4 ) & 0x0F ) );
  attr[7] = (char) ( attr[9] | ( ( attr[2] >> 4 ) & 0x0F ) );
  attr[8] = (char) ( attr[9] | ( ( attr[3] >> 4 ) & 0x0F ) );
  attr[9] = (char) ( attr[9] | ( ( attr[4] >> 4 ) & 0x0F ) );
  if( state( isDISABLED ) ) shortcut_attr = 0;
  bold_attr = (char) ( ( pal_buttons.normal & 0xF0 ) | shortcut_attr );
}

void Tbutton::draw( void )
{
  static char *t = "|0%s|0%s|r%c |0%s";
  char s, b, l, xx;

  if( pressed )
    { s = '4'; b = '9'; }
  else
    if( state( isDISABLED ) )
      { s = '2'; b = '7'; }
    else
      if( state( isSELECTED ) )
        { s = '1'; b = '6'; }
      else
        if( state( bsDEFAULT ) )
          { s = '3'; b = '8'; }
        else
          { s = '0'; b = '5'; }
  t[1] = b; t[5] = s; t[14] = b;
  xx = (char) ( xl - 2 ); l = (char) smart_len( title );
  if( l < xx ) xx -= l; else xx = 0;
  txtf( t, i_buttonl, title, xx, i_buttonr );
}

void Tbutton::get_focused( void )
{
  grab_default();
}

boolean Tbutton::release_focus( void )
{
  if( Titem::release_focus() )
  {
    if( !flags( bfDEFAULT ) ) release_default();
    return 1;
  }
  return 0;
}

void Tbutton::event_handler( Tevent &ev )
{
  uint xx;
  boolean fl;

  if( ev.code == evCOMMAND )
  {
    switch( ev.CMD_CODE )
    {
      case cmAPP_COMMANDS_CHANGED:
        if( state( isACCESSABLE ) )
      case cmDLG_RESET:
        if( command )
        {
          fl = cdisabled( command );
          if( state( isDISABLED ) != fl ) set_state( isDISABLED, fl );
        }
    }
    if( ev.CMD_INFO != this )
      switch( ev.CMD_CODE )
      {
        case cmBTN_GRAB_DEFAULT:
          if( state( bsDEFAULT ) && ( owner == ((Titem *) ev.CMD_INFO)->owner ) )
          {
            pressed = 0;
            set_state( bsDEFAULT, 0 );
            handled( ev );
          }
          break;
        case cmBTN_RELEASE_DEFAULT:
          if( flags( bfDEFAULT ) && ( owner == ((Titem *) ev.CMD_INFO)->owner ) )
          {
            set_state( bsDEFAULT, 1 );
            handled( ev );
          }
      }
  }
  switch( ev.code )
  {
    case evKEY_PRESS:
      if( ( state( isFOCUSED ) && ( ev.ASCII==kSPACE || ev.ASCII==kENTER ) ) ||
          ( ev.ASCII==get_shortcut( title ) ) ||
          ( upcased( ev.ASCII )==shortcut && ( shortcut!=kENTER || !flags( ifSELECTABLE ) || state( bsDEFAULT ) ) ) )
      {
        if( flags( bfGRAB_FOCUS ) ) focus();
        xx = ev.SCAN_CODE;
        pressed = 1; redraw();
        do
        {
          if( flags( bfREPEAT ) && ( ev.code == evKEY_PRESS ) &&
             ( ( ev.ASCII == shortcut ) || ( ev.ASCII == get_shortcut( title ) ) ) ) press();
          get_key( ev, evKEY_PRESS|evKEY_UP );
        }
        while( !state( isHIDDEN ) && ( ( ev.code != evKEY_UP ) || ( xx != ev.SCAN_CODE ) ) );
        if( !flags( bfREPEAT ) ) press();
        pressed = 0; redraw();
        handled( ev );
      }
      break;
#ifndef NOMOUSE
    case evMOUSE_DOWN:
      if( ev.INSIDE )
      {
        if( flags( bfGRAB_FOCUS ) ) focus(); else owner->focus();
        ev.code = evMOUSE_REP;
        do
        {
          if( ev.INSIDE != pressed )
          {
            pressed = ev.INSIDE;
            redraw();
          }
          if( pressed && ( ev.code==evMOUSE_REP ) && flags( bfREPEAT ) ) press();
        }
        while( !state( isHIDDEN ) && get_mouse( ev, evMOUSE_DRAG|evMOUSE_REP ) );
        if( pressed )
        {
          if( !flags( bfREPEAT ) ) press();
          pressed = 0;
          redraw();
        }
        handled( ev );
      }
      break;
#endif
  }
  Titem::event_handler( ev );
}

void Tbutton::press( void )
{
  if( flags( bfSTOP_MODAL ) )
    stop( command );
  else
  {
    _command_info( this, 0 );
    if( flags( bfBROADCAST ) )
      put_command( NULL, command );
    else
      if( command == cmDONE )
        put_command( owner, command );
      else
        message( owner, command );
  }
}

void Tbutton::grab_default( void )
{
  _command_info( this, 0 ); broadcast( cmBTN_GRAB_DEFAULT );
  set_state( bsDEFAULT, 1 );
}

void Tbutton::release_default( void )
{
  _command_info( this, 0 ); broadcast( cmBTN_RELEASE_DEFAULT );
  set_state( bsDEFAULT, 0 );
}

//Ticon publics:

Ticon::Ticon( char *t, uint cmd, uint _shortcut ):
  Tbutton( t, cmd )
{
  set_flags( ifSELECTABLE, 0 ); set_flags( ifPRE_PROCESS, 1 );
  resize( smart_len( t ), 1 ); shortcut = _shortcut;
  set_state( isON_TOP, 1 );
}

//Ticon protected:

void Ticon::calc_bounds( int delta_xl, int delta_yl )
{
  int xx;

  xx = smart_len( title );
  if( xl != xx ) resize( xx, 1 );
  Tbutton::calc_bounds( delta_xl, delta_yl );
}

void Ticon::set_palette( void )
{
  Titem::set_palette();
}

void Ticon::draw( void )
{
  char s;

  if( window_state( isACTIVE ) )
    if( pressed )
      s = '4';
    else
      s = '3';
  else
    s = '2';
  txtf( "|%c%s", s, title );
}

void Ticon::event_handler( Tevent &ev )
{
  if( !( ev.code & evKEYBOARD ) || window_state( isFOCUSED|isMODAL ) )
    Tbutton::event_handler( ev );
}

//Tkey publics:

Tkey::Tkey( uint k, uint cmd ):
  Titem( 0, 0 )
{
  set_flags( ifVISIBLE+ifSELECTABLE, 0 ); set_flags( bfBROADCAST, 1 );
  set_events_mask( (uint)-1,0 );
  set_events_mask( evCOMMAND+evKEY_PRESS, 1 );
  shortcut = k; command = cmd;
}

//Tkey protected:

void Tkey::event_handler( Tevent &ev )
{
  boolean fl;

  Titem::event_handler( ev );
  switch( ev.code )
  {
    case evKEY_PRESS:
      if( ev.ASCII == shortcut )
      {
        if( flags( bfSTOP_MODAL ) )
          stop( command );
        else
        {
          _command_info( this ,0 );
          if( flags( bfBROADCAST ) )
            put_command( NULL, command );
          else
            if( command == cmDONE )
              put_command( owner, command );
            else
              message( owner,command );
        }
        handled( ev );
      }
      break;
    case evCOMMAND:
      if( ev.CMD_CODE == cmAPP_COMMANDS_CHANGED )
        if( state( isACCESSABLE ) )
        {
          fl = cdisabled( command );
          if( state( isDISABLED ) != fl ) set_state( isDISABLED, fl );
        }
  }
}

//CONSTRUCTORS FOR USE WITH DIALOG BOXES

/*
  Description:
    Construct a button and insert it in the dialog box.
  Entry:
    t - title of the button, shortcut prefix '|~';
    cmd - command to be generated by the button.
  Exit:
    Return pointer to the button.
*/
Tbutton *button( char *t, uint cmd )
{
  Tbutton *b;

  b = NEW( Tbutton( t, cmd ) ); b->set_flags( bfSTOP_MODAL, 1 );
  put_item( b, b->xl, 1 );
  if( !fill() ) vspace();
  return b;
}

/*
  Description:
    Construct a default accept button and insert it in the dialog box.
  Entry:
    t - title of the button, shortcut prefix '|~';
    cmd - command to be generated by the button.
  Exit:
    Return pointer to the button.
*/
Tbutton *dbutton( char *t, uint cmd )
{
  Tbutton *b;

  b = button( t, cmd );
  b->set_flags( bfDEFAULT, 1 );
  return b;
}

/*
  Description:
    Construct a default cancel button and insert it in the dialog box.
  Entry:
    t - title of the button, shortcut prefix '|~';
    cmd - command to be generated by the button.
  Exit:
    Return pointer to the button.
*/
Tbutton *dcbutton( char *t, uint cmd )
{
  Tbutton *b;

  b = button( t, cmd ); b->shortcut = kESC;
  return b;
}

/*
  Description:
    Construct 'OK' button and insert it in the dialog box.
  Entry:
    t - title of the button, shortcut prefix '|~'.
  Exit:
    Return pointer to the button.
*/
Tbutton *kbutton( char *t )
{
  return dbutton( t, cmOK );
}

/*
  Description:
    Construct 'Cancel' button and insert it in the dialog box.
  Entry:
    t - title of the button, shortcut prefix '|~'.
  Exit:
    Return pointer to the button.
*/
Tbutton *cbutton( char *t )
{
  return dcbutton( t,cmCANCEL );
}

/*
  Description:
    Construct 'Help' button and insert it in the dialog box.
  Entry:
    t - title of the button, shortcut prefix '|~'.
  Exit:
    Return pointer to the button.
*/
#pragma off( unreferenced )
Tbutton *hbutton( char *t )
{
#ifdef NOHELP
  return NULL;
#else
  Tbutton *b;

  b = button( t,cmHELP );
  b->set_flags( bfSTOP_MODAL, 0 );
  return b;
#endif
}
#pragma on( unreferenced )

/*
  Description:
    Construct key ( accelerator ) item and insert it in the dialog box.
  Entry:
    k   - key code;
    cmd - command to be generated.
  Exit:
    Return pointer to the key item.
*/
Tkey *key( uint k, uint cmd )
{
  Tkey *ki;

  ki = NEW( Tkey( k, cmd ) ); ki->set_flags( bfSTOP_MODAL, 1 );
  put_item( ki, 0, 0 );
  return ki;
}
