//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVDESK.CPP                           |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Desktop support implementation       |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_app
#define uses_colors
#define uses_config
#define uses_ini
#define uses_desk
#define uses_dialog
#define uses_help
#define uses_icons
#define uses_lbox
#define uses_cmdgen

#define DECLARE_PVDESK
#include "PVuses.h"
#undef DECLARE_PVDESK

void insert_window( Titem *item, int x, int y )
{
  if( is_valid( item ) ) desktop->put_in( item, x, y );
}

Tdesktop::Tdesktop( void ):
  Titem( 1, 1 )
{
  backgrnd_attr = pal_desktop.normal;
  max_tileable = 64;
  tile_columns = 1;
  iconize_x = 2;
  iconize_y = yl - 2;
  tile_rect_x = 0;
  tile_rect_y = 0;
  tile_rect_xl = xl;
  tile_rect_yl = yl;
}

void Tdesktop::resize( int _xl, int _yl )
{
  iconize_x = 2;
  iconize_y = _yl - 2;
  tile_rect_x = 0;
  tile_rect_y = 0;
  tile_rect_xl = _xl;
  tile_rect_yl = _yl;
  Titem::resize( _xl, _yl );
}

void Tdesktop::put_in( Titem *v, int _x, int _y )
{
  Titem::put_in( v, _x, _y ) ;
  update_commands();
}

boolean Tdesktop::remove( Titem *v )
{
  if( !Titem::remove( v ) ) return 0;
  update_commands();
  return 1;
}

void Tdesktop::update_commands( void )
{
  Titem *p;
  uint f, c, s, t, i;

  c = s = t = i = 0;
  p = first();
  while( p != NULL )
  {
    f = p->flags_word;
    if( p->state( isALIVE ) )
    {
      if( f & ifCLOSEABLE  ) c++;
      if( f & ifSELECTABLE ) s++;
      if( f & ifTILEABLE ) t++;
      if( p->state( isICONIZED ) ) i++;
    }
    p = p->nextl();
  }
  if( !s ) set_context( -1 );
  cstate( cmWINDOW_TILE, t != 0 );
  cstate( cmWINDOW_CASCADE, t != 0 );
  cstate( cmWINDOW_ARRANGE_ICONS, i != 0 );
  cstate( cmWINDOW_CLOSE_ALL, c && s != 0);
  cstate( cmWINDOW_NEXT, s > 1 );
  cstate( cmWINDOW_PREVIOUS, s > 1 );
}

void Tdesktop::tab_next( int direction )
{
  Titem *p, *l, *ll;

  if( current == NULL ) return;
  if( direction > 0 )
  {
    p = ll = current;
    l = last;
    do
    {
      ll = ll->next;
      if( ll->flags( ifSELECTABLE ) && ll->state( isALIVE ) )
      {
        l = p;
        p = ll;
      }
    }
    while( ll != last );
  }
  else
  {
    p = current;
    do
    {
      l = p;
      p = p->next;
    }
    while( ( !p->flags( ifSELECTABLE ) || !p->state( isALIVE ) ) &&
           ( p != current ) );
  }
  if( p != current )
  {
    last = l;
    items_changed = 1;
    pop_top_items();
    p->focus();
  }
}

void Tdesktop::close_all( void )
{
  Titem *p;
  int n, i, cancel;

  p = first();
  n = 1;
  while( p != NULL )
  {
    if( p->flags( ifCLOSEABLE ) &&
        p->state( isALIVE ) &&
        p->flags( ifSELECTABLE ) ) n++;
    p = p->nextl();
  }
  cancel = 1;
  while( --n )
  {
    p = first();
    i = cancel;
    while( !p->flags( ifCLOSEABLE ) ||
           !p->state( isALIVE ) ||
           !p->flags( ifSELECTABLE ) ||
           --i ) p = p->nextl();
    if( ( message( p, cmDONE ) != p ) && p->state( isALIVE ) ) cancel++;
  }
}

static uint square_root( uint x )
{
  uint i, j;
  for( i = 1, j = 0; j <= x; i += 2 )
    j += i;
  return ( i - 1 ) / 2 - 1;
}

/*
  Description:
    Try to tile subitems. If tile fails, undo tile and call tile_error().
*/
#define dv( n, a )  (( a ) - ( n )+( ( n ) / ( a ) ) * ( a ))
static int r, cl, dx, dy, xx, yy, al, bl, mx, my;

void Tdesktop::tile( void )
{
  Titem *p;
  int n, c;

  if( last == NULL ) return;
  iconize_x = 2;
  iconize_y = yl - 2;
  tile_rect_x = 0;
  tile_rect_y = 0;
  tile_rect_xl = xl;
  tile_rect_yl = yl;
  message( this, cmARRANGING );
  n = 0;
  p = first();
  while( p != NULL )
  {
    if( !p->state( isICONIZED ) )
      if( p->flags( ifTILEABLE ) && p->state( isALIVE ) )
        n++;
      else
        message( p, cmARRANGING );
    p = p->nextl();
  }
  if( !n ) return;
  if( n > max_tileable )
  {
    if( tile_error != NULL ) tile_error();
  }
  else
  {
    c = square_root( n );
    r = n / c;
    cl = c - n + c * r;
    if( tile_columns )
    {
      mx = tile_rect_yl;
      my = tile_rect_xl;
    }
    else
    {
      mx = tile_rect_xl;
      my = tile_rect_yl;
    }
    al = mx / c; bl = my / r;
    p = last;
    dx = dv( mx, c ); dy = dv( my, r );
    xx = 0; yy = 0;
    do_tile( last );
    redraw();
  }
}

/*
  Description:
    Try to cascade subitems. If cascade fails, undo cascade and call
    tile_error().
*/
static char undo;

void Tdesktop::cascade( void )
{
  Titem *p;

  if( last == NULL ) return;
  iconize_x = 2;
  iconize_y = yl - 2;
  tile_rect_x = 0;
  tile_rect_y = 0;
  tile_rect_xl = xl;
  tile_rect_yl = yl;
  message( this, cmARRANGING );
  p = first();
  while( p != NULL )
  {
    if( !p->state( isICONIZED ) && !p->flags( ifTILEABLE ) ) message( p, cmARRANGING );
    p = p->nextl();
  }
  undo = 0; xx = tile_rect_x; yy = tile_rect_y;
  do_cascade( last, 1, 1 );
  if( ( undo ) && ( tile_error ) ) tile_error();
  redraw();
}

/*
  Description:
    Arranges all iconized subitems.
  Exit:
    1 if at least one icon has been arranged,
    0 otherwise.
*/
boolean Tdesktop::arrange_icons( void )
{
  Titem *p;
  char result;

  iconize_y = yl - 2;
  iconize_x = 2;
  result = 0;
  p = first();
  while( p != NULL )
  {
    if( p->state( isICONIZED ) )
    {
      arrange_one_icon( p );
      result = 1;
    }
    p = p->nextl();
  }
  return result;
}

/*
  Description:
    Arrange one iconized subitem. Usually called when item is iconized for
    the first time.
*/
void Tdesktop::arrange_one_icon( Titem *p )
{
  if( p->state( isICONIZED ) )
  {
    if( iconize_x <= xl - p->xl )
      p->drag( iconize_x, iconize_y );
    else
    {
      if( iconize_y>1 ) iconize_y--; else iconize_y = yl - 2;
      iconize_x = 2;
      p->drag( iconize_x, iconize_y );
    }
    iconize_x += p->xl + 1;
  }
}

//Tdesktop protected:

#pragma off( unreferenced )
void Tdesktop::calc_bounds( int delta_xl, int delta_yl )
{
  drag( desktop_x, desktop_y );
  resize( desktop_xl, desktop_yl );
}
#pragma on( unreferenced )

void Tdesktop::event_handler( Tevent &ev )
{
  backgrnd_char = i_desktop;
  Titem::event_handler( ev );
  switch( ev.code )
  {
    case evCOMMAND:
      switch( ev.CMD_CODE )
      {
        case cmARRANGING:
          tile_rect_x = 0;  tile_rect_y = 0;
          tile_rect_xl = xl; tile_rect_yl = yl;
          if( arrange_icons() )
          {
            tile_rect_yl = yl-5;
            if( tile_rect_yl < iconize_y ) tile_rect_yl = iconize_y-1;
          }
          break;
        case cmWINDOW_NEXT:
          tab_next(  1 ); break;
        case cmWINDOW_PREVIOUS:
          tab_next( -1 ); break;
        case cmWINDOW_TILE:
          tile(); break;
        case cmWINDOW_CASCADE:
          cascade(); break;
        case cmWINDOW_ARRANGE_ICONS:
          arrange_icons(); break;
        case cmWINDOW_CLOSE_ALL:
          close_all(); break;
        case cmWINDOW_LIST:
          list_all(); break;
#ifndef NOHELP
        case cmHELP_CONTENTS:
          online_help( htHELP_CONTENTS ); break;
        case cmHELP_USING:
          online_help( htHELP_ON_HELP ); break;
#endif
        default: goto hot;
      }
      handled( ev );
    hot:
      break;
#ifndef NOMOUSE
    case evMOUSE_DOWN:
      if( ev.INSIDE && ev.CLICKS )
      {
        list_all();
        handled( ev );
      }
#endif
  }
}

//Tdesktop private:

void Tdesktop::do_tile( Titem *p )
{
  p = p->next; if( p != last ) do_tile( p );
  if( p->flags( ifTILEABLE ) && p->state( isALIVE ) && !p->state( isICONIZED ) )
  {
    if( tile_columns )
    {
      p->drag( tile_rect_x + yy, tile_rect_y + xx );
      p->resize( bl, al );
    }
    else
    {
      p->drag( tile_rect_x + xx, tile_rect_y + yy );
      p->resize( al, bl );
    }
    yy += bl;
    bl += ( !--dy );
    if( yy >= my )
    {
      yy = 0; xx += al;
      r += ( !--cl );
      bl = my / r; dy = dv( my, r );
      al += ( !--dx );
    }
  }
}

void Tdesktop::do_cascade( Titem *p, int _x, int _y )
{
  int xls, yls;

  p = p->next;
  if( p->flags( ifTILEABLE ) && p->state( isALIVE ) && !p->state( isICONIZED ) )
  {
    if( ( _x > tile_rect_xl ) || ( _y > tile_rect_yl ) )
      undo = 1;
    else
    {
      xls = p->xl; yls = p->yl;
      p->resize( _x, _y );
      if( p != last ) do_cascade( p, p->xl + 1, p->yl + 1 );
      if( undo )
        p->resize( xls, yls );
      else
      {
        p->drag( xx, yy );
        p->resize( tile_rect_xl + tile_rect_x - xx,
                   tile_rect_yl + tile_rect_y - yy );
        xx++; yy++;
      }
    }
  }
  else
    if( p != last ) do_cascade( p, _x, _y );
}

#undef dv

Tlist_box *__l;

boolean list_all_validator( uint x )
{
  Twindow *p;

  if( x == cmDELETE )
  {
    if( __l->vcount )
    {
      __l->getdata( __l->vcurrent, &p );
      if( ( message( p, cmDONE ) == p ) || !p->state( isALIVE ) )
        __l->del( __l->vcurrent );
      __l->cstate( cmDELETE, __l->vcount > 0 );
      set_cmd( &( (Twindow *) modal_item)->commands );
    }
    return 0;
  }
  return 1;
}

void Tdesktop::list_all( void )
{
  uint i;
  uint r;
  Titem *p;

#ifndef NOHELP
  _help( htD_WINDOWS_LIST );
#endif
#ifdef CYR
  dialog( "  " );
#else
  dialog( "Windows list" );
#endif
  validator( list_all_validator );
  _lsize( sizeof( Titem * ) );
  _stay();
#ifdef CYR
  __l = list_box( "|~", i, 35, 11 );
#else
  __l = list_box( "|~Windows", i, 35, 11 );
#endif
  p = first();
  i = 1;
  while( p != NULL )
  {
    if( p->flags( ifSELECTABLE ) && p->state( isALIVE ) )
    {
      _ldata( &p );
      __l->add( ((Twindow *)p)->title );
      if( p->state( isON_TOP ) ) i++;
    }
    p = p->nextl();
  }
  __l->at( i );
  nc();
#ifdef CYR
  kbutton( " " );
  cbutton( "  " );
  button(  " |~", cmDELETE )->shortcut = kDEL;
  hbutton( "  " );
#else
  kbutton( "Select" );
  cbutton( " Done " );
  button( "|~Delete", cmDELETE )->shortcut = kDEL;
  hbutton( " Help " );
#endif
  p = NULL;
  __l->cstate( cmDELETE, __l->vcount > 0 );
  r = run();
  if( !__l->vcount )
    set_cmd( NULL );
  else
    if( r == cmOK )
    {
      __l->getdata( i, &p );
      if( p != NULL )
      {
        p->set_state( isICONIZED, 0 );
        p->focus();
      }
    }
  DELETE( __l );
}

#ifndef NOCONFIG
static void read_params( void )
{
  seek_section( 0, SECTION_DESKTOP );
  ini( VAR_TILE_MODE, desktop->tile_columns, desktop->tile_columns );
}
#endif

void __init_desktop( void )
{
  desktop = NEW( Tdesktop );
  application->put_in( desktop, 0, 0 );
#ifndef NOCONFIG
  read_params();
#endif
}
