//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVDIALOG.CPP                         |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Dialog boxes support implementation  |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_app
#define uses_desk
#define uses_dialog
#define uses_icons
#define uses_lbox

#include "PVuses.h"

#define _ALIGN_LEFT     1
#define _ALIGN_RIGHT    2
#define _ALIGN_CENTER   3

struct Tfill
{
  int x;
  int y;
  int max_xl;
  int max_yl;
  boolean fill;
};

struct Tmark
{
  int x;
  int y;
};

static Tmark mrk = { 0, 0 };
static Tmark mrk0 = { 0, 0 };
static Tmark mrk1 = { 0, 0 };
static Tmark mrk2 = { 0, 0 };
static Tmark mrk3 = { 0, 0 };
static Tmark mrk4 = { 0, 0 };
static Tmark mrk5 = { 0, 0 };
static Tmark mrk6 = { 0, 0 };
static Tmark mrk7 = { 0, 0 };
static Tmark mrk8 = { 0, 0 };
static Tmark mrk9 = { 0, 0 };

static int hspc, vspc;
static Tfill local;
static Tfill stack[0x10];
static uint sp = 0;
static Tset rights;
static Tset centers;
static Tdialog *dlg;

//Tdialog publics:

Tdialog::Tdialog( char *t, int _xl, int _yl ):
  Twindow( t, _xl, _yl )
{
  set_flags( ifSELECTABLE+ifICONIZEABLE+ifRESIZEABLE+ifTILEABLE, 0 );
  set_flags( ifSTAY, __stay() );
  set_state( isON_TOP, 1 );
  dlg_handler = NULL;
  dlg_validator = NULL;
  xl_min = 1; yl_min = 1;
  !commands;
  commands>>cmWIN_RESTORE;
  dlg_saved = dlg;
}

boolean Tdialog::valid( uint stop_st )
{
  boolean v;

  v = 1;
  if( stop_st==cmDONE ) stop_st=cmCANCEL;
  if( stop_st!=cmCANCEL && stop_st!=cmVALID )
    handle_command( NULL, cmDLG_RECORD_HISTORY );
  v = Twindow::valid( stop_st );
  if( dlg_validator!=NULL && v ) v = dlg_validator( stop_st );
  if( stop_st == cmVALID ) return v;
  if( v )
    if( stop_st != cmCANCEL )
      ok_item();
    else
      cancel_item();
  else
    modal_broadcast( cmDLG_RESET );
  if( !v ) redraw();
  item_acted = NULL;
  return v;
}

uint Tdialog::exec( void )
{
  uint ex;

  if( last == NULL ) return cmCANCEL;
  tab_next( -1 );
  handle_command( NULL, cmDLG_RESET );
  if( first_focused != NULL ) put_command( first_focused, cmFOCUS );
  item_acted = NULL;
  ex = Twindow::exec();
  if( ex==cmDONE ) ex = cmCANCEL;
  return ex;
}

//Tdialog protected:

boolean Tdialog::isit_4u( Tevent &ev )
{
  Twindow::isit_4u( ev );
  return 1;
}

void Tdialog::event_handler( Tevent &ev )
{
  if( ev.code==evCOMMAND && ev.destination==this && ev.CMD_CODE==cmDONE &&
      valid(cmDONE) && (!state(isSELECTED) || release_focus()) && state(isMODAL) )
  {
    stop(cmDONE);
    handled(ev);
    return;
  }
  if( Twindow::isit_4u(ev) ) Twindow::event_handler( ev );
  if( ev.code==evCOMMAND && ev.CMD_CODE==cmDLG_RECORD_HISTORY ) handled( ev );
  if( ev.code<evCOMMAND && item_acted!=NULL && dlg_handler!=NULL )
  {
    dlg_handler( item_acted );
    item_acted = NULL;
  }
}

//DIALOG ITEMS ARRANGING

/*
  Description:
    Construct a new dialog box with given title.
  Entry:
    t - title of the dialog box.
  Exit:
    Return pointer to the dialog box.
*/
Tdialog *dialog( char *t )
{
  dlg = NEW( Tdialog( t, 5, 3 ) );
  extern_dialog( dlg );
  return dlg;
}

/*
  Description:
    Initialize externaly constructed dialog box for items setup.
  Entry:
    p - pointer to the dialog box.
*/
void extern_dialog( Tdialog *p )
{
  dlg = p;
  local.x = 2;
  local.y = 2;
  local.max_xl = 0;
  local.max_yl = 0;
  local.fill = 0;
  hspc = 0; vspc = 0;
  sp = 0;
  push();
  dlg->first_focused = NULL;
  _focused();
  ~centers; ~rights;
}

/*
  Description:
    Update internal parameters after inserting an item in the dialog box.
  Entry:
    item_xl, item_yl: item's bounds
*/
static void item_in( int item_xl, int item_yl )
{
  int xx, yy, rx, ry;
  char align;

  xx = local.x+item_xl; if( xx > dlg->xl ) rx = xx; else rx = dlg->xl;
  yy = local.y+item_yl; if( yy > dlg->yl ) ry = yy; else ry = dlg->yl;
  if( local.max_xl < xx ) local.max_xl = xx;
  if( local.max_yl < yy ) local.max_yl = yy;
  dlg->resize( rx, ry );
  _aleft(); align = __align();
  if( align == _ALIGN_CENTER ) centers << local.y;
  if( align == _ALIGN_RIGHT ) rights << local.y;
  if( local.fill ) local.x = xx + hspc; else local.y = yy + vspc;
}

/*
  Description:
    Insert an item in the dialog box. Item must be constructed.
  Entry:
    item             - pointer to the item to insert;
    item_xl, item_yl - requested item's bounds.
*/
void put_item( Titem *item, int item_xl, int item_yl )
{
  int x, y;

  x = local.x; y = local.y;
  item_in( item_xl, item_yl );
  dlg->put_in( item, x, y );
  item->set_flags( ifSTAY, __stay() );
  if( __focused() && item->flags( ifSELECTABLE ) ) dlg->first_focused = item;
}

/*
  Description:
    Specify how many horizontal text positions to leave between two items.
  Entry:
    s - requested text positions.
*/
void hspacing( int s )
{
  hspc = s;
}

/*
  Description:
    Specify how many vertical text positions to leave between two items.
  Entry:
    s - requested text positions.
*/
void vspacing( int s )
{
  vspc = s;
}

/*
  Description:
    Specify horizontal items arrange.
*/
void hor( void )
{
  local.fill = 1;
}

/*
  Description:
    Specify vertical items arrange.
*/
void ver( void )
{
  local.fill = 0;
}

/*
  Description:
    Return TRUE if hor, FALSE if ver.
*/
boolean fill( void )
{
  return local.fill;
}

/*
  Description:
    Move internal cursor to a new line.
*/
void nl( void )
{
  local.x = stack[sp - 1].x;
  local.y = local.max_yl + vspc;
}

/*
  Description:
    Move internal cursor to a new column.
*/
void nc( void )
{
  local.x = local.max_xl + hspc;
  local.y = stack[sp - 1].y;
}

/*
  Description:
    Place in the internal stack current dialog context. After that a call to
    nl, nc, etc. will work in a new local region.
*/
void push( void )
{
  stack[sp++] = local;
  local.max_xl = 0;
  local.max_yl = 0;
}

/*
  Description:
    Insert all the items arranged since the push like one big item in the
    previously saved dialog context.
*/
void pop( void )
{
  int mx, my;

  mx = local.max_xl;
  my = local.max_yl;
  local = stack[--sp];
  item_in( mx - local.x, my - local.y );
}

static Titem *dlg_frame;

/*
  Description:
    Start of frame w/ title. All items that are arranged until endfr will
    be framed out.
*/
Titem *frame( char *t )
{
  dlg_frame = dlg->frame( t );
  push();
  local.x++;
  local.y++;
  push();
  return dlg_frame;
}

/*
  Description:
    Start of frame w/o title. All items that are arranged until endfr will
    be framed out.
*/
Titem *frame( void )
{
  return frame( "" );
}

/*
  Description:
    End of frame. All items that are arranged since frame will
    be framed out.
*/
void endfr( void )
{
  pop();
  dlg->endfr();
  local = stack[--sp];
  item_in( dlg_frame->xl + 1, dlg_frame->yl );
}

/*
  Description:
    Move internal cursor one text position to the right.
*/
void hspace( void )
{
  local.x++;
}

/*
  Description:
    Move internal cursor one text position to the bottom.
*/
void vspace( void )
{
  local.y++;
}

/*
  Description:
    Move internal cursor one text position to the right or one text position
    to the bottom depending on the current arrange style.
*/
void space( void )
{
  if( local.fill )
    local.x++;
  else
    local.y++;
}

/*
  Description:
    Move internal cursor multiply text position to the right.
  Entry:
    tb - number of text positions.
*/
void hspaces( int tb )
{
  local.x += tb;
}

/*
  Description:
    Move internal cursor multiply text position to the bottom.
  Entry:
    tb - number of text positions.
*/
void vspaces( int tb )
{
  local.y += tb;
}

/*
  Description:
    Move internal cursor multiply text positions to the right or multiply
    text positions to the bottom depending on the current arrange style.
  Entry:
    tb - number of text positions.
*/
void spaces( int tb )
{
  if( local.fill )
    local.x += tb;
  else
    local.y += tb;
}

/*
  Description:
    Remember internal cursor current position.
*/
void mark( void )
{
  mrk.x = local.x;
  mrk.y = local.y;
}

void mark0( void )
{
  mrk0.x = local.x;
  mrk0.y = local.y;
}

void mark1( void )
{
  mrk1.x = local.x;
  mrk1.y = local.y;
}

void mark2( void )
{
  mrk2.x = local.x;
  mrk2.y = local.y;
}

void mark3( void )
{
  mrk3.x = local.x;
  mrk3.y = local.y;
}

void mark4( void )
{
  mrk4.x = local.x;
  mrk4.y = local.y;
}

void mark5( void )
{
  mrk5.x = local.x;
  mrk5.y = local.y;
}

void mark6( void )
{
  mrk6.x = local.x;
  mrk6.y = local.y;
}

void mark7( void )
{
  mrk7.x = local.x;
  mrk7.y = local.y;
}

void mark8( void )
{
  mrk8.x = local.x;
  mrk8.y = local.y;
}

void mark9( void )
{
  mrk9.x = local.x;
  mrk9.y = local.y;
}

/*
  Description:
    Retrieve saved internal cursor position.
*/
void gmrk( void )
{
  local.x = mrk.x;
  local.y = mrk.y;
}

void gmrk0( void )
{
  local.x = mrk0.x;
  local.y = mrk0.y;
}

void gmrk1( void )
{
  local.x = mrk1.x;
  local.y = mrk1.y;
}

void gmrk2( void )
{
  local.x = mrk2.x;
  local.y = mrk2.y;
}

void gmrk3( void )
{
  local.x = mrk3.x;
  local.y = mrk3.y;
}

void gmrk4( void )
{
  local.x = mrk4.x;
  local.y = mrk4.y;
}

void gmrk5( void )
{
  local.x = mrk5.x;
  local.y = mrk5.y;
}

void gmrk6( void )
{
  local.x = mrk6.x;
  local.y = mrk6.y;
}

void gmrk7( void )
{
  local.x = mrk7.x;
  local.y = mrk7.y;
}

void gmrk8( void )
{
  local.x = mrk8.x;
  local.y = mrk8.y;
}

void gmrk9( void )
{
  local.x = mrk9.x;
  local.y = mrk9.y;
}

/*
  Description:
    Retrieve column of saved internal cursor position.
*/
void gmrc( void )
{
  local.x = mrk.x;
}

void gmrc0( void )
{
  local.x = mrk0.x;
}

void gmrc1( void )
{
  local.x = mrk1.x;
}

void gmrc2( void )
{
  local.x = mrk2.x;
}

void gmrc3( void )
{
  local.x = mrk3.x;
}

void gmrc4( void )
{
  local.x = mrk4.x;
}

void gmrc5( void )
{
  local.x = mrk5.x;
}

void gmrc6( void )
{
  local.x = mrk6.x;
}

void gmrc7( void )
{
  local.x = mrk7.x;
}

void gmrc8( void )
{
  local.x = mrk8.x;
}

void gmrc9( void )
{
  local.x = mrk9.x;
}

/*
  Description:
    Retrieve line of saved internal cursor position.
*/
void gmrl( void )
{
  local.y = mrk.y;
}

void gmrl0( void )
{
  local.y = mrk0.y;
}

void gmrl1( void )
{
  local.y = mrk1.y;
}

void gmrl2( void )
{
  local.y = mrk2.y;
}

void gmrl3( void )
{
  local.y = mrk3.y;
}

void gmrl4( void )
{
  local.y = mrk4.y;
}

void gmrl5( void )
{
  local.y = mrk5.y;
}

void gmrl6( void )
{
  local.y = mrk6.y;
}

void gmrl7( void )
{
  local.y = mrk7.y;
}

void gmrl8( void )
{
  local.y = mrk8.y;
}

void gmrl9( void )
{
  local.y = mrk9.y;
}

//DIALOG EXECUTING

/*
  Description:
    Resize arranged dialog to hold all the controls.
*/
void end_of_dialog( void )
{
  int xx, xmin, xmax, n;
  int i;
  Titem *p;

  dlg->resize( dlg->xl + 1, dlg->yl + 1 );
  for( i = 0; i < 256; i++ )
    if( ( i & centers ) || ( i & rights ) )
    {
      xmin = 1000; xmax = -1000;
      p = dlg->first();
      while( p != NULL )
      {
        if( ( p->y == i ) && p->flags( ifVISIBLE ) )
        {
          if( ( n = p->x + p->bound_x ) < xmin ) xmin = n;
          xx = n + p->bound_xl;
          if( xx > xmax ) xmax = xx;
        }
        p = p->nextl();
      }
      xx = ( dlg->xl - xmax + xmin );
      if( i & centers ) xx >>= 1; else xx -= 2;
      xx -= xmin;
      p = dlg->first();
      while( p != NULL )
      {
        if( ( p->y == i ) && p->flags( ifVISIBLE ) )
          p->drag( p->x + xx, p->y );
        p = p->nextl();
      }
    }
}

void done_dialog( void )
{
  Tdialog *_dlg = dlg;
  dlg = dlg->dlg_saved;
  if( !_dlg->flags( ifSTAY ) ) DELETE( _dlg );
}

/*
  Description:
    Execute just arranged dialog box.
  Exit:
    Return dialog exit code - usualy this is the command of the button that
    has been pressed.
*/
uint run( void )
{
  end_of_dialog();
  uint result = exec_dialog( dlg );
  done_dialog();
  return result;
}

/*
  Description:
    Insert an 'OK' button at the bottom of the dialog box and call run.
*/
void bok( void )
{
  hor(); nl(); vspace(); _acenter();
#ifdef CYR
  kbutton( " ' " );
#else
  kbutton( "  OK  " );
#endif
  run();
}

/*
  Description:
    Insert 'OK' and 'Cancel' buttons at the bottom of the dialog box
    and call run.
  Exit:
    Return boolean: TRUE - ok, FALSE - cancel.
*/
boolean bkc( void )
{
  hor(); nl(); vspace(); hspc = 1; _acenter();
#ifdef CYR
  kbutton( " ' " );
  cbutton( "  " );
#else
  kbutton( "  OK  " );
  cbutton( "Cancel" );
#endif
  return run() == cmOK;
}

/*
  Description:
    Insert 'OK', 'Cancel' and 'Help' buttons at the bottom of the dialog box
    and call run.
  Exit:
    Return boolean: TRUE - ok, FALSE - cancel.
*/
boolean bkch( void )
{
  hor(); vspc = 0; hspc = 1; nl(); vspace(); _acenter();
#ifdef CYR
  kbutton( " ' " );
  cbutton( "  " );
  hbutton( "  " );
#else
  kbutton( "  OK  " );
  cbutton( "Cancel" );
  hbutton( " Help " );
#endif
  return run() == cmOK;
}

/*
  Description:
    Insert 'Yes' and 'No' buttons at the bottom of the dialog box
    and call run.
  Exit:
    Return boolean: TRUE - yes, FALSE - no.
*/
boolean byn( void )
{
  hor(); nl(); vspace(); hspc = 1; _acenter();
#ifdef CYR
  button( "  |~  ", cmYES );
  dcbutton( "  |~  ", cmNO );
#else
  button( " |~Yes  ", cmYES );
  dcbutton( "  |~No  ", cmNO );
#endif
  return run() == cmYES;
}

/*
  Description:
    Insert 'Yes', 'No' and 'Help' buttons at the bottom of the dialog box
    and call run.
  Exit:
    Return boolean: TRUE - yes, FALSE - no.
*/
boolean bynh( void )
{
  hor(); nl(); vspace(); hspc = 1; _acenter();
#ifdef CYR
  button( "  |~  ", cmYES );
  dcbutton( "  |~  ", cmNO );
  hbutton(  "  " );
#else
  button( " |~Yes  ", cmYES );
  dcbutton( "  |~No  ", cmNO );
  hbutton( " Help " );
#endif
  return run() == cmYES;
}

/*
  Description:
    Insert 'Yes', 'No' and 'Cancel' buttons at the bottom of the dialog box
    and call run.
  Exit:
    Return dialog exit code - command of the button that has been pressed.
*/
uint bync( void )
{
  hor(); nl(); vspace(); hspc = 1; _acenter();
#ifdef CYR
  button( "  |~  ", cmYES );
  dcbutton( "  |~  ", cmNO );
  cbutton( "  " );
#else
  button( " |~Yes  ", cmYES );
  dcbutton( "  |~No  ", cmNO );
  cbutton( "Cancel" );
#endif
  return run();
}

/*
  Description:
    Insert 'Yes', 'No', 'Cancel' and 'Help' buttons at the bottom of the
    dialog box and call run.
  Exit:
    Return dialog exit code - command of the button that has been pressed.
*/
uint bynch( void )
{
  hor(); nl(); vspace(); hspc = 1; _acenter();
#ifdef CYR
  button( "  |~  ", cmYES );
  dcbutton( "  |~  ", cmNO );
  cbutton( "  " );
  hbutton( "  " );
#else
  button( " |~Yes  ", cmYES );
  dcbutton( "  |~No  ", cmNO );
  cbutton( "Cancel" );
  hbutton( " Help " );
#endif
  return run();
}

/*
  Description:
    Insert 'Retry' and 'Abort' buttons at the bottom of the dialog box
    and call run.
  Exit:
    Return boolean: TRUE - retry, FALSE - abort.
*/
boolean bra( void )
{
  hor(); nl(); vspace(); hspc = 1; _acenter();
#ifdef CYR
  kbutton( "|~ " );
  cbutton( " |~ " );
#else
  kbutton( "|~Retry" );
  cbutton( "|~Abort" );
#endif
  return run() == cmOK;
}

/*
  Description:
    Insert 'Retry', 'Abort' and 'Help' buttons at the bottom of the dialog
    box and call run.
  Exit:
    Return boolean: TRUE - retry, FALSE - abort.
*/
boolean brah( void )
{
  hor(); nl(); vspace(); hspc = 1; _acenter();
#ifdef CYR
  kbutton( "|~ " );
  cbutton( " |~ " );
  hbutton( "  " );
#else
  kbutton( "|~Retry" );
  cbutton( "|~Abort" );
  hbutton( " Help " );
#endif
  return run() == cmOK;
}

//DIALOG HANDLING

/*
  Description:
    Specify dialog handler proc. It must be a void function expecting a
    pointer as parameter. This handler will be called whenever an item in
    the dialog box has been changed, allowing the handler to control some
    of the items.
  Entry:
    p - address of the handler proc for current dialog box.
*/
void handler( Tdlg_handler p )
{
  dlg->dlg_handler = p;
}

/*
  Description:
    Specify dialog validation proc. It must be a function expecting a
    uint as a parameter (validation code, usually this is command of the
    button that has been pressed) and returning boolean - allow or not
    dialog box to be terminated.
  Entry:
    p - address of the validation proc for current dialog box.
*/
void validator( Tdlg_validator p )
{
  dlg->dlg_validator = p;
}

/*
  Description:
    Called from a dialog handler proc or from dialog validator proc. This
    instructs the dialog box to focus specified item.
  Entry:
    p - address of the item to be focused.
*/
void focus( Titem *p )
{
  p->focus();
}

/*
  Description:
    Called from a dialog handler proc or from dialog validator proc. This
    instructs the dialog box to enable or to disable specified item.
  Entry:
    p - address of the item to be enabled/disabled.
    f - TRUE: enable, FALSE: disable item.
*/
void set_enable( Titem *p, boolean f )
{
  p->set_state( isDISABLED, !f );
}

/*
  Description:
    Return a pointer to the currently selected item.
*/
Titem *current( void )
{
  return dlg->current;
}

//PREFIXES

char align_ = 0;
boolean focused_ = 0;
boolean stay_ = 0;

/*
  Description:
    Specify left alignement for dialog items. Call just before constructing
    such items.
*/
void _aleft( void )
{
  if( !align_ ) align_ = _ALIGN_LEFT;
}

/*
  Description:
    Specify right alignement for dialog items. Call just before constructing
    such items.
*/
void _aright( void )
{
  if( !align_ ) align_ = _ALIGN_RIGHT;
}

/*
  Description:
    Specify center alignement for dialog items. Call just before constructing
    such items.
*/
void _acenter( void )
{
  if( !align_ ) align_ = _ALIGN_CENTER;
}

char __align( void )
{
  char result = _ALIGN_LEFT;

  if( align_ ) result = align_;
  align_ = 0;
  return result;
}

/*
  Description:
    Specify the following item that constructs to be focused when dialog box
    executes.
*/
void _focused( void )
{
  focused_ = 1;
}

boolean __focused( void )
{
  boolean result;

  result = focused_;
  focused_ = 0;
  return result;
}

/*
  Description:
    Specify the following item that constructs not to be disposed when
    dialog box terminates. You must dispose it later by calling its
    destructor, as follows:
    dispose( item,done )
*/
void _stay( void )
{
  stay_ = 1;
}

boolean __stay( void )
{
  boolean result;

  result = stay_;
  stay_ = 0;
  return result;
}
