//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVHELP.CPP                           |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Help manager implementation          |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#ifndef NOHELP

#define uses_ctype
#define uses_dos
#define uses_fcntl
#define uses_io
#define uses_string
#define uses_dc
#define uses_dialog
#define uses_ht
#define uses_icons
#define uses_list
#define uses_stddlg
#define uses_system

#include "PVuses.h"

#define MAX_BACK_TOPICS  0x20
#define HLP_SIGNATURE    "\r\nPower View help file.\r\n\032"
#define DONT_WRAP        '`'
#define CR               '\r'
#define VSCROLL_AHEAD    2
#define HSCROLL_AHEAD    5

#define cmHLP_ON_HELP    cmUSER00
#define cmHLP_INDEX      cmUSER01
#define cmHLP_CONTENTS   cmUSER02
#define cmHLP_CROSS_REF  cmUSER03
#define cmHLP_BACK       cmUSER04

class Thelp: public Titem
{
  public:
    Thscroll_bar *hbar;
    Tvscroll_bar *vbar;
    char *vbegprint_org;
    uint vbeg_print;
    uint hbeg_print;
    uint rows_num;
    uint cols_num;
    uint cursor_x;
    uint cursor_y;
    char *cursor_org;
    char *hilight;
    char *help;
    uint help_size;
    uint help_len;
    uint topics_num;
    word *topics;
    uint current_topic;
    char *line_org;
    uint line_org_num;
    boolean wrapped;
    char search[256];
    Thelp( int _xl, int _yl );
    virtual ~Thelp( void );
    virtual void resize( int newxl, int newyl );
    virtual void draw( void );
    virtual void event_handler( Tevent &ev );
    void go_forward( void );
    void cross_reference( void );
    void go_back( void );
    void cursor_up( void );
    void cursor_down( void );
    void cursor_page_up( void );
    void cursor_page_down( void );
    void cursor_left( void );
    void cursor_right( void );
    void cursor_top( void );
    void cursor_bottom( void );
    void cursor_home( void );
    void cursor_end( void );
    void tab_topic( int direction );
    void speed_search( char c );
    char *get_line_org( uint i );
    char *next_line_org( void );
    void update( void );
    void update_hilight( void );
    void update_cursor_org( void );
    void update_cursor_xy( void );
    inline void read_help( unsigned long o, uint s );
    void read_topic( uint ht );

    inline void set_cursor_org( char *p )
    {
      cursor_org = p;
      while( *cursor_org == DONT_WRAP ) cursor_org++;
    }

    inline void set_vbegprint_org( char *p )
    {
      vbegprint_org = p;
      while( *vbegprint_org == DONT_WRAP ) vbegprint_org++;
    }
};

struct Tback_info
{
  uint topic_num;
  uint hbeg_prn;
  uint curs_org;
  uint vbegprn_org;
};

static Tback_info back_info[MAX_BACK_TOPICS];
static uint back_info_ptr = 0;
static char help_filename[_MAX_PATH];


void set_help_filename( char *filename )
{
  strcpy( help_filename, filename );
}

static Thelp *help_item;

boolean help_validator( uint stop_code )
{
  switch( stop_code )
  {
    case cmHLP_ON_HELP:
      help_item->go_forward();
      help_item->read_topic( htHELP_ON_HELP );
      break;
    case cmHLP_INDEX:
      help_item->go_forward();
      help_item->read_topic( htHELP_INDEX );
      break;
    case cmHLP_CONTENTS:
      help_item->go_forward();
      help_item->read_topic( htHELP_CONTENTS );
      break;
    case cmHLP_CROSS_REF:
      help_item->cross_reference();
      break;
    case cmHLP_BACK:
      help_item->go_back();
      break;
    default:
      return 1;
  }
  help_item->resize( help_item->xl, help_item->yl );
  return 0;
}

static Tbutton *btn( char *t, uint cmd, uint sc )
{
  Tbutton *b;

  b = button( t, cmd );
  b->shortcut = sc;
  b->set_flags( ifSELECTABLE, 0 );
  return b;
}

void online_help( uint help_context )
{
  static int recurse=0;
  uint t;
  Tdialog *d;

  if( recurse ) return;
  recurse++;
  if( help_context )
    t = help_context;
  else
    t = htHELP_CONTENTS;
  help_item = NEW( Thelp( 50, 16 ) );
  help_item->read_topic( t );
  if( help_item->help == NULL )
  {
    DELETE( help_item );
    _terror();
#ifdef CYR
    ok( "   .\n\n     \"%s\".", help_filename );
#else
    ok( "Can not read help topic.\n\nPlease verify the file \"%s\" exist.", help_filename );
#endif
    recurse--;
    return;
  }
#ifdef CYR
  _phelp(); d = dialog( "" );
#else
  _phelp(); d = dialog( "Help" );
#endif
  d->set_flags( ifRESIZEABLE, 1 );
  d->xl_min = 38;
  d->yl_min = 14;
  validator( help_validator );
  hspaces( -1 );
#ifdef CYR
  btn( "|~ ", cmHLP_CROSS_REF, kENTER )->set_flags( bfDEFAULT, 1 );
  btn( "  |~   ", cmHLP_BACK,      kALT_F1 );
  btn( "|~", cmHLP_CONTENTS,  kCTRL_F1 );
  btn( " |~ ", cmHLP_INDEX,     kSHIFT_F1 );
  btn( "     ", cmHLP_ON_HELP,   0 );
  btn( "   ",   cmCANCEL,        kESC );
#else
  btn( "Cross |~ref", cmHLP_CROSS_REF, kENTER )->set_flags( bfDEFAULT, 1 );
  btn( " Go |~back ", cmHLP_BACK,      kALT_F1 );
  btn( "|~Contents ", cmHLP_CONTENTS,  kCTRL_F1 );
  btn( "  |~Index  ", cmHLP_INDEX,     kSHIFT_F1 );
  btn( "  Help   ", cmHLP_ON_HELP,   0 );
  btn( " Cancel  ",   cmCANCEL,        kESC );
#endif
  nc(); vspaces( -1 ); hspace();
  _stay(); put_item( help_item, help_item->xl + 1 + i_sb_up_len, help_item->yl + 1 );
  run();
  help_item->go_forward();
  DELETE( help_item );
  recurse--;
}

// HELP ITEM

Thelp::Thelp( int _xl, int _yl ):
  Titem( _xl, _yl )
{
#ifndef NOMOUSE
  set_events_mask( evMOUSE_REP, 1 );
#endif
  vbar = NEW( Tvscroll_bar( yl, rows_num, vbeg_print ) );
    vbar->set_flags( sfHANDLE_KEYBOARD+sfHIDEABLE, 0 );
  hbar = NEW( Thscroll_bar( xl+1, cols_num, hbeg_print ) );
    hbar->set_flags( sfHANDLE_KEYBOARD+sfHIDEABLE, 0 );
  put_in( hbar, 0, yl );
  put_in( vbar, xl + 1, 0 );
  rows_num = 0;
  cols_num = 0;
  hilight = help = line_org = NULL;
  line_org_num = 0;
  wrapped = 0;
  grow_mode = gmGROW_BOTH;
  curs_type = 1;
}

Thelp::~Thelp( void )
{
  if( help != NULL ) FREE( help );
  help = NULL;
}

void Thelp::resize( int newxl, int newyl )
{
  uint hlen, h_count, line_chars, l;
  uint v_count;
  char *i, *line_start, *wrap, *p, *n;
  boolean wrap_fl, topic_fl;

  Titem::resize( newxl, newyl );
  if( help == NULL ) return;
  if( wrapped )
  {
    i = help;
    for( hlen = 0; hlen < help_len; hlen++ )
    {
      if( *i == 0 )
        switch( *( i + 1 ) )
        {
          case CR:
            *i = CR; break;
          case DONT_WRAP:
            *i = DONT_WRAP; break;
          default:
            *i = ' ';
        }
      i++;
    }
  }
  wrap = help;
  v_count = h_count = 0;
  topic_fl = 0;
  while( ( wrap - help ) <= help_len )
  {
    i = line_start = wrap;
    wrap_fl = 1;
    if( *i == DONT_WRAP )
      wrap_fl = 0,
      i += 2,
      wrap += 2,
      line_start += 2;
    line_chars = 0;
    while( ( ( i - help ) < help_len ) && ( *i != CR ) &&
           ( !wrap_fl || topic_fl || ( wrap == line_start ) || ( line_chars <= xl ) ) )
    {
      if( *i == '|' ) topic_fl = !topic_fl, line_chars -= 2;
      if( ( *i == ' ' ) && !topic_fl ) wrap = i;
      i++;
      line_chars++;
    }
    if( ( *i == CR ) && ( !wrap_fl || ( line_chars <= xl ) ) ) wrap = i;
    if( *wrap == '|' ) wrap = i;
    *(wrap++) = 0;
    if( *wrap == CR ) wrap++;
    l = smart_len( line_start );
    if( l > h_count ) h_count = l;
    v_count++;
  }
  cols_num = h_count; rows_num = v_count;
  update_cursor_xy();
  p = get_line_org( vbeg_print );
  while( p < vbegprint_org )
  {
    n = p;
    p = next_line_org();
    if( p == NULL )
    {
      p = n;
      break;
    }
    vbeg_print++;
  }
  while( p > vbegprint_org )
  {
    vbeg_print--;
    p = get_line_org( vbeg_print );
  }
  update_cursor_org();
  wrapped = 1;
}

void Thelp::draw( void )
{
  uint i;
  char *p;

  if( help == NULL ) return;
  p = get_line_org( vbeg_print );
  set_vbegprint_org( p );
  goto_xy( 0, 0 ); txtf( "|r%c |l%c", xl, yl );
  i = 0;
  while( ( i < yl ) && ( p != NULL ) )
  {
    goto_xy( -hbeg_print, i );
    txt( p );
    p = next_line_org();
    i++;
  }
  curs_x = cursor_x - hbeg_print;
  curs_y = cursor_y - vbeg_print;
}

void Thelp::event_handler( Tevent &ev )
{
  char n;

  if( state( isACTIVE ) && ( help != NULL ) )
  {
    switch( ev.code )
    {
#ifndef NOMOUSE
      boolean dirty, inside_x, inside_y;
      uint i, ii;
      uint j, jj;
      case evMOUSE_DOWN:
        if( ev.INSIDE )
        {
          ii = (uint)-1; jj = (uint)-1;
          do
          {
            dirty = 0;
            inside_x = ( ev.LOCAL_X >= 0 ) && ( ev.LOCAL_X < xl );
            inside_y = ( ev.LOCAL_Y >= 0 ) && ( ev.LOCAL_Y < yl );
            if( inside_x || ( ev.code == evMOUSE_REP ) )
            {
              if( ev.LOCAL_X >= 0 ) j = ev.LOCAL_X; else j = 0;
              j = hbeg_print + j;
              if( !inside_x )
              {
                if( j > cursor_x ) cursor_right(); else cursor_left();
                j = cursor_x;
              }
              if( j >= cols_num ) j = cols_num - 1;
            }
            if( inside_y || ( ev.code == evMOUSE_REP ) )
            {
              if( ev.LOCAL_Y >= 0 ) i = ev.LOCAL_Y; else i = 0;
              i = vbeg_print + i;
              if( !inside_y )
              {
                if( i > cursor_y ) cursor_down(); else cursor_up();
                i = cursor_y;
              }
              if( i >= rows_num ) i = rows_num - 1;
            }
            if( j != jj )
            {
              cursor_x = j;
              dirty = 1;
            }
            if( i != ii )
            {
              cursor_y = i;
              dirty = 1;
            }
            if( dirty )
            {
              update_cursor_org();
              update();
              if( ev.CLICKS )
              {
                cross_reference();
                break;
              }
            }
            ii = i; jj = j;
          }
          while( get_mouse( ev, evMOUSE_REP | evMOUSE_DRAG ) );
          item_acted = this;
          handled( ev );
        }
      break;
#endif
      case evKEY_PRESS:
        if( state( isFOCUSED ) )
        {
          n = *search; *search = 0;
          switch( ev.ASCII )
          {
            case kUP:
              cursor_up(); break;
            case kDOWN:
              cursor_down(); break;
            case kPG_UP:
              cursor_page_up(); break;
            case kPG_DN:
              cursor_page_down(); break;
            case kCTRL_HOME:
              cursor_top(); break;
            case kCTRL_END:
              cursor_bottom(); break;
            case kLEFT:
              cursor_left(); break;
            case kRIGHT:
              cursor_right(); break;
            case kHOME:
              cursor_home(); break;
            case kEND:
              cursor_end(); break;
            case kTAB:
              tab_topic( 1 ); break;
            case kSHIFT_TAB:
              tab_topic( -1 ); break;
            case kF1:
              help_item->go_forward();
              help_item->read_topic( htHELP_ON_HELP );
              break;
            default:
              if( ( ( ev.ASCII < 0x0020 ) && ( ev.ASCII != kBS ) ) || ( ev.ASCII > 0x00BF ) )
                goto hot;
              else
              {
                *search = n;
                speed_search( (char) ev.ASCII );
              }
          }
          handled( ev );
        }
    }
  hot:
    if( wrapped )
    {
      update_cursor_org();
      update();
    }
    else
      resize( xl, yl );
    cstate( cmHLP_BACK, back_info_ptr != 0 );
    cstate( cmHLP_ON_HELP, current_topic != htHELP_ON_HELP );
    cstate( cmHLP_INDEX, current_topic != htHELP_INDEX );
    cstate( cmHLP_CONTENTS, current_topic != htHELP_CONTENTS );
    cstate( cmHLP_CROSS_REF, hilight != NULL );
  }
  Titem::event_handler( ev );
}

void Thelp::cursor_up( void )
{
  cursor_up_left( cursor_y, vbeg_print, yl, VSCROLL_AHEAD );
}

void Thelp::cursor_down( void )
{
  cursor_down_right( cursor_y, vbeg_print, yl, rows_num, VSCROLL_AHEAD );
}

void Thelp::cursor_page_up( void )
{
  if( vbeg_print < yl )
    cursor_top();
  else
  {
    vbeg_print -= ( yl - 1 );
    cursor_y -= ( yl - 1 );
  }
}

void Thelp::cursor_page_down( void )
{
  if( ( vbeg_print + yl) >= rows_num )
    cursor_bottom();
  else
  {
    vbeg_print += ( yl - 1 );
    cursor_y += ( yl - 1 );
  }
}

void Thelp::cursor_left( void )
{
  cursor_up_left( cursor_x, hbeg_print, xl, HSCROLL_AHEAD );
}

void Thelp::cursor_right( void )
{
  cursor_down_right( cursor_x, hbeg_print, xl, cols_num, HSCROLL_AHEAD );
}

void Thelp::cursor_top( void )
{
  cursor_top_home( cursor_y, vbeg_print );
}

void Thelp::cursor_bottom( void )
{
  cursor_bottom_end( cursor_y, vbeg_print, yl, rows_num );
}

void Thelp::cursor_home( void )
{
  cursor_top_home( cursor_x, hbeg_print );
}

void Thelp::cursor_end( void )
{
  char *p;

  p = get_line_org( cursor_y );
  cursor_bottom_end( cursor_x, hbeg_print, xl, smart_len( p ) );
}

void Thelp::tab_topic( int direction )
{
  char *p, *help_end;

  p = cursor_org;
  if( direction > 0 )
  {
    help_end = help + help_len - 1;
    while( ( *( (word *) p ) != 0x627C ) && ( p < help_end ) )
      p++;
  }
  else
    while( ( *( (word *) p ) != 0x627C ) && ( p > help ) )
      p--;
  if( *( (word *) p ) == 0x627C )
  {
    *hilight = 'b';
    hilight = ++p;
    *hilight = 's';
    set_cursor_org( ++p );
    update_cursor_xy();
    while( vbeg_print + yl <= cursor_y )
      vbeg_print++;
    while( vbeg_print > cursor_y )
      vbeg_print--;
  }
}

void Thelp::speed_search( char c )
{
  char s[256], *i, *j, *p;
  char n;
  uint hbp, vbp, cx, cy, xx, yy;
  word saved;

  if( !topics_num ) return;
  cx = cursor_x; cy = cursor_y;
  hbp = hbeg_print; vbp = vbeg_print;
  c = toupper( c );
#ifdef CYR
  c = cyr_toupper( c );
#endif
  p = strchr( search, 0 ) - 1;
  saved = (word) *p;
  if( c != (char) kBS )
    *( (word *) ( p + 1 ) ) = c;
  else
    if( *search ) *p = 0;
  set_cursor_org( help );
  vbeg_print = hbeg_print = cursor_y = cursor_x = 0;
  update_cursor_xy();
  if( *search == 0 ) return;
  do
  {
    n = 1;
    xx = cursor_x; yy = cursor_y;
    tab_topic( 1 );
    if( ( cursor_y == yy ) && ( cursor_x == xx ) )
    {
      cursor_x = cx; cursor_y = cy;
      hbeg_print = hbp; vbeg_print = vbp;
      *( (word *) p ) = saved;
      return;
    }
    i = hilight + 1;
    while( *i == ' ' )
      i++, n++;
    j = s;
    while( *i != '|' )
      *(j++) = *(i++);
    *( s + strlen( search ) ) = 0;
#ifdef CYR
    cyr_strupr( s );
#endif
    strupr( s );
  }
  while( strcmp( s, search ) );
  n += strlen( search );
  while( --n )
    cursor_right();
  update_cursor_org();
  if( hilight == NULL ) cursor_left();
}

void Thelp::cross_reference( void )
{
  char *s, *i, *j;
  uint n;

  if( ( help == NULL ) || ( hilight == NULL ) ) return;
  n = 0;
  s = get_line_org( 0 );
  i = strstr( s, "|b" );
  j = strstr( s, "|s" );
  while( j == NULL )
  {
    while( i != NULL )
    {
      n++;
      *i = ' ';
      i = strstr( s, "|b" );
    }
    s = next_line_org();
    i = strstr( s, "|b" );
    j = strstr( s, "|s" );
  }
  n++;
  i = strstr( s, "|t" );
  while( i < j )
  {
    *i = ' ';
    i = strstr( s, "|t" );
    n++;
  }
  go_forward();
  read_topic( topics[topics_num - n] );
}

char *Thelp::get_line_org( uint i )
{
  if( i >= rows_num ) return NULL;
  line_org = help;
  line_org_num = 0;
  while( line_org_num < i )
  {
    line_org = strchr( line_org, 0 ) + 1;
    line_org_num++;
  }
  while( ( *line_org == DONT_WRAP ) || ( *line_org == CR ) )
    line_org++;
  return line_org;
}

char *Thelp::next_line_org( void )
{
  if( line_org_num >= ( rows_num - 1 ) ) return NULL;
  line_org = strchr( line_org, 0 ) + 1;
  while( ( *line_org == DONT_WRAP ) || ( *line_org == CR ) )
    line_org++;
  line_org_num++;
  return line_org;
}

void Thelp::go_forward()
{
  if( ( back_info_ptr ) && ( back_info[back_info_ptr - 1].topic_num == current_topic ) ) return;
  back_info[back_info_ptr].topic_num = current_topic;
  back_info[back_info_ptr].hbeg_prn = hbeg_print;
  back_info[back_info_ptr].curs_org = cursor_org - help;
  back_info[back_info_ptr].vbegprn_org = vbegprint_org - help;
  if( ++back_info_ptr == MAX_BACK_TOPICS )
  {
    back_info_ptr--;
    memmove( &back_info[0], &back_info[1], sizeof( back_info ) - sizeof( Tback_info ) );
  }
}

void Thelp::go_back( void )
{
  if( !back_info_ptr ) return;
  read_topic( back_info[--back_info_ptr].topic_num );
  hbeg_print = back_info[back_info_ptr].hbeg_prn;
  cursor_org = help + back_info[back_info_ptr].curs_org;
  vbegprint_org = help + back_info[back_info_ptr].vbegprn_org;
}

void Thelp::update( void )
{
  static char *old_vbegprint_org = NULL;
  static char *old_hilight = NULL;
  static uint old_hbeg_print = (uint)-1;
  static uint old_vbeg_print = (uint)-1;

  if( ( old_hbeg_print != hbeg_print ) ||
      ( old_vbeg_print != vbeg_print ) ||
      ( old_hilight != hilight ) ||
      ( old_vbegprint_org != vbegprint_org ) )
  {
    old_hbeg_print = hbeg_print;
    old_vbeg_print = vbeg_print;
    old_hilight = hilight;
    old_vbegprint_org = vbegprint_org;
    redraw();
  }
  curs_x = cursor_x - hbeg_print;
  curs_y = cursor_y - vbeg_print;
}

void Thelp::update_hilight( void )
{
  char *t, *b;

  if( hilight != NULL ) *hilight = 'b';
  hilight = NULL;
  t = get_line_org( cursor_y );
  while( t != NULL )
  {
    b = strstr( t, "|b" );
    t = strstr( t, "|t" );
    if( ( cursor_org < t ) && ( cursor_org >= b ) )
    {
      *(++b) = 's';
      hilight = b;
      break;
    }
    if( t != NULL ) t++;
  }
}

void Thelp::update_cursor_org( void )
{
  char *p;
  uint l;

  if( help == NULL ) return;
  p = get_line_org( cursor_y );
  l = smart_len( p );
  if( cursor_x <= l )
    set_cursor_org( p + smart_index( p, cursor_x ) );
  else
  {
    p = next_line_org();
    if( p != NULL )
      set_cursor_org( p );
    else
    {
      p = get_line_org( rows_num );
      set_cursor_org( p + smart_index( p, smart_len( p ) - 1 ) );
    }
  }
  update_hilight();
}

void Thelp::update_cursor_xy( void )
{
  char *p, *n;
  uint l;

  if( cursor_y >= rows_num ) cursor_y = rows_num - 1;
  p = get_line_org( cursor_y );
  while( p < cursor_org )
  {
    n = p;
    p = next_line_org();
    if( p == NULL )
    {
      p = n;
      break;
    }
    cursor_y++;
  }
  while( p > cursor_org )
    p = get_line_org( --cursor_y );
  cursor_x = ( cursor_org - p );
  if( cursor_x )
  {
    l = smart_len( p ); if( cursor_x > l ) cursor_x = l;
    while( ( p + smart_index( p, cursor_x ) ) > cursor_org )
      cursor_x--;
  }
  update_hilight();
}

inline void Thelp::read_help( unsigned long o, uint s )
{
  int handle;
  unsigned num_read;
  uint i, n;
  word k;
  char *h;

  if( help != NULL ) FREE( help );
  help = NULL;
  if( !o || !s || _dos_open( help_filename, O_RDONLY, &handle) ) return;
  help_size = s + 2;
  help = (char *) MALLOC( help_size );
  help[help_size-1] = 0;
  help[help_size-2] = 0;
  lseek( handle, o, 0 );
  if( _dos_read( handle, help, s, &num_read ) || ( num_read != s ) )
  {
    FREE( help );
    help = NULL;
  }
  _dos_close( handle );
  if( help == NULL ) return;
  help_len = s;
  h = help;
  i = 0;
  n = 0;
  do
  {
    if( ( *h == '|' ) && ( *( h + 1 ) == 't' ) )
    {
      h += 2; i += 2;
      help_len -= 2;
      k = *( (word *) h );
      n += 2;
      memmove( h, h + 2, help_size - i - n );
      *( (word *) ( help + help_size - n ) ) = k;
    }
#ifndef HGR
    if( graph_flag )
#endif
    {
#ifdef CYR
      if( *h == '' ) *h = frame_standard[2]; else
      if( *h == '' ) *h = frame_standard[3]; else
#endif
      if( *h == '' ) *h = frame_standard[8];
    }
    i++; h++;
  }
  while( i < help_len );
  topics_num = n >> 1;
  topics = (word *) ( help + help_size - n );
  wrapped = 0;
  cursor_x = 0;
  cursor_y = 0;
  set_cursor_org( help );
  set_vbegprint_org( help );
  hbeg_print = 0;
  vbeg_print = 0;
  hilight = NULL;
  *search = 0;
}

void Thelp::read_topic( uint ht )
{
  static char signature[] = HLP_SIGNATURE;
  char buf[256];
  int handle;
  unsigned num_read;
  boolean signature_ok, opened;
  unsigned long o;
  word s;

  if( !ht ) return;
  o = 0; s = 0;
  signature_ok = 0; opened = 0;
  if( !_dos_open( help_filename, O_RDONLY, &handle ) )
  {
    opened = 1;
    if( !_dos_read( handle, buf, sizeof( signature ) - 1, &num_read ) )
    {
      buf[sizeof( signature ) - 1] = 0;
      signature_ok = ( strcmp( buf, signature ) == 0 );
    }
  }
  if( !signature_ok ) goto xit;
  lseek( handle, (ht - 1) * 6, 1 );
  if( _dos_read( handle, &o, sizeof(o), &num_read ) || ( num_read < sizeof(o) ) ) goto xit;
  if( _dos_read( handle, &s, sizeof(s), &num_read ) || ( num_read < sizeof(s) ) ) goto xit;
xit:
  current_topic = ht;
  if( opened ) _dos_close( handle );
  read_help( o, s );
}

#endif //NOHELP
