//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVLIST.CPP                           |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Dynamic lists implementation         |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_basics
#define uses_list

#define DECLARE_PVLIST
#include "PVuses.h"
#undef DECLARE_PVLIST

//LIST

Tlist::Tlist( void ):
  vcount( _vcount ),
  vcurrent( _vcurrent ),
  vbeg_print( _vbeg_print ),
  vmax_print( _vmax_print )
{
  vcount = 0;
  vcurrent = 0;
  vbeg_print = 0;
  scroll_ahead = 2;
  options = 0;
}

Tlist::Tlist( Tlist *_list ):
  vcount( _list->vcount ),
  vcurrent( _vcurrent ),
  vbeg_print( _vbeg_print ),
  vmax_print( _vmax_print )
{
  scroll_ahead = _list->scroll_ahead;
  options = loASSOCIATED;
}

Tlist::Tlist( uint &v_count, uint &v_current, uint &v_beg_print, int &v_max_print ):
  vcount( v_count ),
  vcurrent( v_current ),
  vbeg_print( v_beg_print ),
  vmax_print( v_max_print )
{
  vcount = 0;
  vcurrent = 0;
  vbeg_print = 0;
  scroll_ahead = 2;
  options = 0;
}

Tlist::~Tlist( void )
{
  if( !( options & loASSOCIATED ) ) clear();
}

void Tlist::clear( void )
{
  vcount = 0;
  vcurrent = 0;
  vbeg_print = 0;
}

void Tlist::up( void )
{
  cursor_up_left( vcurrent, vbeg_print, vmax_print, scroll_ahead );
}

void Tlist::down( void )
{
  cursor_down_right( vcurrent, vbeg_print, vmax_print, vcount, scroll_ahead );
}

void Tlist::pgup( void )
{
  for( uint i = 1; i < vmax_print; i++ ) up();
}

void Tlist::pgdn( void )
{
  for( uint i = 1; i < vmax_print; i++ ) down();
}

void Tlist::top( void )
{
  cursor_top_home( vcurrent, vbeg_print );
}

void Tlist::bottom( void )
{
  cursor_bottom_end( vcurrent, vbeg_print, vmax_print, vcount );
}

void Tlist::at( uint i )
{
  cursor_at( i, vcurrent, vbeg_print, vmax_print, vcount );
}

uint Tlist::findf( Tlfilter p )
{
  cur_filter = p;
  find_index = 0;
  return findn();
}

uint Tlist::findn( void )
{
  while( ( find_index < vcount ) && !cur_filter( this, find_index ) )
    find_index++;
  if( find_index >= vcount ) return (uint) -1;
  return find_index;
}

void Tlist::inc_count( void )
{
  vcount++;
}

void Tlist::dec_count( void )
{
  vcount--;
}


void cursor_up_left( uint &current, uint &beg_print, uint max_print, uint scroll_ahead )
{
  if( current < beg_print ) beg_print = current;
  if( current >= ( beg_print + max_print ) )
    if( current > max_print )
      beg_print = current - max_print;
    else
      beg_print = 0;
  if( current )
  {
    current--;
    if( ( ( beg_print + scroll_ahead ) > current ) && beg_print ) beg_print--;
  }
}

void cursor_down_right( uint &current, uint &beg_print, uint max_print, uint count, uint scroll_ahead )
{
  if( !count )
  {
    current = 0;
    return;
  }
  if( current < beg_print ) beg_print = current;
  if( current >= beg_print + max_print )
    if( current > max_print )
      beg_print = current - max_print;
    else
      beg_print = 0;
  if( current < ( count - 1 ) )
  {
    current++;
    if( ( ( ( current + scroll_ahead ) - beg_print ) >= max_print ) &&
       ( ( beg_print + max_print ) < count ) ) beg_print++;
  }
}

void cursor_top_home( uint &current, uint &beg_print )
{
  beg_print = 0;
  current = 0;
}

void cursor_bottom_end( uint &current, uint &beg_print, uint max_print, uint count )
{
  if( !count )
  {
    current = 0;
    beg_print = 0;
    return;
  }
  current = count - 1;
  if( current >= max_print )
    beg_print = current - max_print + 1;
  else
    beg_print = 0;
}

void cursor_at( uint i, uint &current, uint &beg_print, uint max_print, uint count )
{
  if( !count || ( i >= count ) ) return;
  current = i;
  beg_print = min( max( 0, count - max_print ), max( 0, current - ( max_print >> 1 ) ) );
}
