//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVSTDDLG.CPP                         |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Standard dialog boxes implementation |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#define uses_fcntl
#define uses_stdarg
#define uses_stdio
#define uses_string
#define uses_app
#define uses_desk
#define uses_dialog
#define uses_help
#define uses_icons
#define uses_input
#define uses_stddlg
#define uses_system
#define uses_txt

#define DECLARE_PVSTDDLG
#include "PVuses.h"
#undef DECLARE_PVSTDDLG

#define _ICON_NOTHING   1
#define _ICON_WARNING   2
#define _ICON_QUESTION  3
#define _ICON_INFO      4

uint test_file_exist( char *path )
{
  int handle;
  if( !_dos_open( path, O_RDONLY, &handle ) )
  {
    char s[_MAX_PATH];
    _dos_close( handle );
    strcpy( s, path );
    fexpand( s ); min_path( s ); short_path( s, 29 );
    _iwarning();
#ifdef CYR
    return ync( "   %s.\n\n   ?", s );
#else
    return ync( "File %s already exists.\n\nReplace existing file?", s );
#endif
  }
  return 0;
}

//OPEN FILE DIALOG

static char dir[_MAX_DIR+_MAX_DRIVE];
static char filter[_MAX_FNAME];
static Tlist_box *files=NULL;
static Tlist_box *dirs;
static Tcombo_box *filters;
static Tcombo_box *drives;
static Tinput *item_name;
static Tdtext *show_dir;
static Tdtext *show_info;
static boolean new_file_fl;
static boolean overflow;

struct Tfile_rec
{
  char attr;
  uint time;
  uint date;
  long size;
};

static void get_info_str( Tfile_rec &d, char *result )
{
  char m[14];
  uint year;
  char month, day, hours, minutes, seconds;
#ifndef CYR
  char *am;
#endif

  if( d.attr & _A_SUBDIR )
#ifdef CYR
    strcpy( result, "    " );
#else
    strcpy( result, "Directory" );
#endif
  else
    sprintf( result, "%-9lu", d.size );
  unpack_time( d.time, hours, minutes, seconds );
  unpack_date( d.date, year, month, day );
  if( month ) month--;
  memcpy( m, months[month], 3 ); m[3] = 0;
#ifdef CYR
  sprintf( result + 9, " %2d %s, %4d %2d:%02d", day, m, year, hours, minutes );
#else
  if( hours < 12 )
    am = "am";
  else
  {
    am = "pm";
    hours -= 12;
  }
  if( !hours ) hours = 12;
  sprintf( result + 9, " %s %2d, %4d %2d:%02d%s", m, day, year, hours, minutes, am );
#endif
}

static void file_change( void )
{
  char s[_MAX_PATH], *p;
  int i;
  Tfile_rec d;

  if( !files->vcount ) return;
  files->gettxt( files->vcurrent, s );
  item_name->set_txt( s );
  files->getdata( files->vcurrent, &d );
  p  = strchr( s, 0 );
  for( i = 0; i < ( _MAX_FNAME + _MAX_EXT ); i++ )
    *(p++) = ' ';
  get_info_str( d, s + _MAX_FNAME + _MAX_EXT );
  show_info->set_txt( s );
}

static void dir_change( void )
{
  char s[_MAX_PATH], r[_MAX_PATH], *p;
  int i;
  Tfile_rec d;

  if( !dirs->vcount ) return;
  dirs->gettxt( dirs->vcurrent, s );
  sprintf( r, "%s\\%s", s, filter );
  item_name->set_txt( r );
  dirs->getdata( dirs->vcurrent, &d );
  p  = strchr( s, 0 );
  for( i = 0; i < ( _MAX_FNAME + _MAX_EXT ); i++ )
    *(p++) = ' ';
  get_info_str( d, s + _MAX_FNAME + _MAX_EXT );
  show_info->set_txt( s );
}

static void reread( void )
{
  struct find_t dir_info;
  char tmp_drive[_MAX_DRIVE];
  char tmp_path[_MAX_PATH];
  char tmp_name[_MAX_FNAME];
  char tmp_ext[_MAX_EXT];
  char path[_MAX_PATH];
  char *p;
  int done;
  uint index;
  Tfile_rec fd;

  item_name->get_txt( path );
  while( ( p = strchr( path, ' ' ) ) != NULL )
    strcpy( p, p+1 );
  if( ( *path == 0 ) || ( ( path[0] != '\\' ) && ( path[1] != ':' ) ) )
  {
    strcpy( tmp_path, path );
    strcpy( path, dir );
    strcat( path, tmp_path );
  }
  fexpand( path );
  _splitpath( path, tmp_drive, dir, tmp_name, tmp_ext );
  if( ( *tmp_name != 0 ) || ( *tmp_ext != 0 ) )
  {
    strcpy( filter, tmp_name );
    strcat( filter, tmp_ext );
  }
  strcpy( path, tmp_drive );
  strcat( path, dir );
  strcat( path, filter );
  short_path( path, 48 );
  show_dir->set_txt( path );
  strcpy( path, dir );
  strcpy( dir, tmp_drive );
  strcat( dir, path );
  strcpy( path, filter );
  item_name->set_txt( path );
  show_info->set_txt( "" );
  for( ;; )
  {
    strcpy( tmp_path, dir );
    strcat( tmp_path, filter );
    files->clear();
    critical_error();
    for( done=_dos_findfirst(tmp_path,_A_NORMAL,&dir_info);
         !done;
         done=_dos_findnext(&dir_info) )
    {
      fd.attr = dir_info.attrib;
      fd.time = dir_info.wr_time;
      fd.date = dir_info.wr_date;
      fd.size = dir_info.size;
      _ldata( &fd ); files->add( dir_info.name );
    }
    files->sort();
    files->top();
    if( files->overflow ) overflow = 1;

    strcpy( tmp_path, dir );
    strcat( tmp_path, "*.*" );
    dirs->clear();
    for( done=_dos_findfirst(tmp_path,_A_SUBDIR,&dir_info);
         !done;
         done=_dos_findnext(&dir_info) )
      if( ( strcmp( dir_info.name, "." ) && ( dir_info.attrib & _A_SUBDIR ) ) )
      {
        fd.attr = dir_info.attrib;
        fd.time = dir_info.wr_time;
        fd.date = dir_info.wr_date;
        fd.size = dir_info.size;
        _ldata( &fd ); dirs->add( dir_info.name );
      }
    dirs->sort();
    dirs->top();
    if( dirs->overflow ) overflow = 1;

    sprintf( tmp_path, "[-%c-]", tmp_drive[0] );
    if( ( index = drives->findft( tmp_path ) ) != (uint) -1 )
      drives->set_data( index );
    if( done!=18 )
      if( critical_error() )
      {
        files->clear();
        dirs->clear();
        if( drive_error( tmp_drive[0] ) ) continue;
      }
      else
      {
        _terror();
        ok( "Cant read disk directory.\n\n(Does such directory exist?)" );
      }
    break;
  }
  if( current() == dirs )
    dir_change();
  else
    if( current() == files )
      file_change();
    else
      focus( files );
  modal_broadcast( cmDLG_RESET );
}

static void open_file_handler( Titem *p )
{
  char s[_MAX_PATH], *n;

  if( p == files )
    file_change();
  else
    if( p == dirs )
      dir_change();
    else
      if( p == drives )
      {
        drives->get_data( s );
        *dir = s[2];
        strcpy( dir+1, ":\\" );
        item_name->set_txt( "" );
        reread();
      }
      else
        if( p == filters )
        {
          filters->get_data( s );
          n = strchr( s, '(' ) + 1;
          *strchr( n, ')' ) = 0;
          item_name->set_txt( n );
          reread();
        }
}

static boolean open_file_validator( uint x )
{
  char path[_MAX_PATH];
  char tmp_drive[_MAX_DRIVE];
  char tmp_dir[_MAX_DIR];
  char tmp_name[_MAX_FNAME];
  char tmp_ext[_MAX_EXT];
  char *l;
  uint xx;

  switch( x )
  {
    case cmVALID:
      return !overflow;
    case cmOK:
      item_name->get_txt( path );
      l = strchr( path, 0 );
      if( *(l - 1) == ':' )
      {
        *(l++) = '\\';
        *l = 0;
      }
      if( ( strchr( path, '*') == NULL ) && ( strchr( path, '?' ) == NULL ) && ( *( strchr( path, 0 ) - 1 ) != '\\' ) )
      {
        _splitpath( path, tmp_drive, tmp_dir, tmp_name, tmp_ext );
        if( !*tmp_dir && !*tmp_drive )
        {
          strcpy( tmp_dir, dir+2 );
          *tmp_drive = *dir;
        }
        if( !*tmp_ext ) strcpy( tmp_ext, strchr( filter, '.' ) );
        if( ( strchr( tmp_ext, '*' ) != NULL ) || ( strchr( tmp_ext, '?' ) != NULL ) ) strcpy( tmp_ext, "." );
        _makepath( path, tmp_drive, tmp_dir, tmp_name, tmp_ext );
        fexpand( path );
        if( new_file_fl && (xx=test_file_exist(path)) )
        {
          if( xx == cmCANCEL ) *path = 0;
          item_name->set_txt( path );
          if( xx != cmNO ) return 1;
          focus( item_name );
          return 0;
        }
        item_name->set_txt( path );
      }
      else
      {
        item_name->set_txt( path );
        reread();
        return 0;
      }
  }
  return 1;
}

uint get_file( char *title, char *result )
{
  unsigned drive_svd, maxdrives;
  uint i;
  char s[_MAX_PATH], *p, *f;
  char path[_MAX_PATH];
  uint i_files, i_dirs, i_filters, i_drives;
  char *dir_svd;
  uint *filter_svd;

  if( files!=NULL )
  {
  qqq:
    while( files->vcount && !files->checked(0) ) files->del(0);
    if( !files->vcount )
    {
      DELETE(files); files=NULL;
      return 0;
    }
    else
    {
      strcpy( result, dir );
      files->gettxt( 0, strchr(result,0) );
      files->del(0);
      return 1;
    }
  }
  __get_file_svd( &dir_svd, &filter_svd );
  i_filters = 0; i_drives = 0; i_dirs = 0; i_files = 0;
  overflow = 0;
  new_file_fl = __new_file();
#ifndef NOHELP
  _help( htD_SELECT_FILE );
#endif
  dialog( title );
  hspacing( 1 );
  handler( open_file_handler ); validator( open_file_validator );
  *path = 0;
  _focused();
#ifndef NOHIST
  _history( ( dir_svd == NULL )? get_file : (void *) dir_svd );
#endif
#ifdef CYR
  item_name = input( "|~:", path, 79, 26 );
  filters = combo_box( "|~:", i_filters, 27 );
#else
  item_name = input( "|~Name: ", path, 79, 24 );
  filters = combo_box( "|~Types:", i_filters, 25 );
#endif
  push();
  i = desktop->yl/3+1;
  _lsize( sizeof( Tfile_rec ) );
#ifdef CYR
  _lsize( sizeof( Tfile_rec ) );
  files = list_box( "|~", i_files, 12, i );
  nc();
  _lsize( sizeof( Tfile_rec ) );
  dirs = list_box( "|~", i_dirs, 12, i - 2 );
  drives = combo_box( "  |~:", i_drives, 5 );
#else
  _lsize( sizeof( Tfile_rec ) );
  files = list_box( "|~Files", i_files, 12, i );
  nc();
  _lsize( sizeof( Tfile_rec ) );
  dirs = list_box( "|~Directories", i_dirs, 12, i - 2 );
  drives = combo_box( "Dri|~ves:", i_drives, 5 );
#endif
  files->set_flags( ifSTAY, 1 );
  files->set_flags( lfMULTIPLY_SELECTION, __multi_files() );
  _dos_getdrive( &drive_svd );
  _dos_setdrive( 3, &maxdrives);
  for( unsigned n = 0; n < 26; n++ )
  {
    unsigned drv;

    _dos_setdrive( n, &maxdrives );
    _dos_getdrive( &drv );
    if( drv == n )
    {
      sprintf( s, "[-%c-]", drv + ( 'A' - 1 ) );
      drives->add( s );
    }
  }
  _dos_setdrive( drive_svd, &maxdrives );
  drives->top();
  drives->combo->open_yl = drives->vcount;
  pop();
  nc();
#ifdef CYR
  kbutton( " ' " );
  cbutton( "  " );
  hbutton( "  " );
#else
  kbutton( "  OK  " );
  cbutton( "Cancel" );
  hbutton( " Help " );
#endif
  nl();
  _tselected(); show_dir  = dtext( 46,1 );
  _tselected(); show_info = dtext( 46,1 );
  f = __filters();
  if( f != NULL )
  {
    f--;
    do
    {
      f++;
      p = s;
      while( *f && ( *f != '|' ) ) *(p++) = *(f++);
      *p = 0;
      filters->add( s );
    }
    while( *f );
  }
#ifdef CYR
  filters->add( "  (*.*)" );
#else
  filters->add( "Any file (*.*)" );
#endif
  filters->set_data( 0 );
  filters->gettxt( 0, s );
  if( filter_svd != NULL )
  {
    filters->set_data( *filter_svd );
    filters->gettxt( *filter_svd, s );
  }
  p = strchr( s, '(' ) + 1; *strchr( p, ')' ) = 0;
  item_name->set_txt( p );

  *dir = 0;
  if( dir_svd != NULL ) strcpy( dir, dir_svd );
  reread();
  if( run()==cmOK && *path )
  {
    if( dir_svd != NULL ) min_path( strcpy( dir_svd, dir ) );
    if( filter_svd != NULL ) *filter_svd = filters->cursor();
    for( int q=0; q<files->vcount; q++ )
      if( files->checked(q) ) goto qqq;
    strcpy( result, fexpand(path) );
    DELETE(files); files=NULL;
    return cmOK;
  }
  DELETE(files); files=NULL;
  return 0;
}

static Tdialog *msg( char *txt, va_list argptr )
{
  char i;
  Tstext *t;
  Tdialog *result;

  result = dialog( __title() );
  i = __icon();
  if( i && ( i != _ICON_NOTHING ) )
  {
    switch( i )
    {
      case _ICON_WARNING:
        t = NEW( Tstext( i_warning, 7 ) ); break;
      case _ICON_QUESTION:
        t = NEW( Tstext( i_question, 7 ) ); break;
      case _ICON_INFO:
        t = NEW( Tstext( i_info, 7 ) );
    }
    t->align = _TALIGN_LEFT;
    t->color = _TATTR_SELECTED;
    put_item( t, 8, t->yl );
    nc();
  }
  vstext( txt, 36, argptr );
  return result;
}

static Tdialog *current_action = NULL;

Tdialog *action( char *txt, ... )
{
  va_list argptr;
  int dx, dy;

  done_action();
  _inothing();
#ifdef CYR
  _title( " " );
#else
  _title( "Please stand by" );
#endif
  va_start( argptr, txt );
  _tacenter();
  current_action = msg( txt, argptr );
  va_end( argptr );
  end_of_dialog();
  current_action->set_state( isON_TOP, 1 );
  current_action->set_flags( ifCLOSEABLE, 0 );
  __dialog_xy( dx, dy );
  insert_window( current_action, dx, dy );
  hide_cursor();
  application->refresh_screen();
  return current_action;
}

void done_action( void )
{
  if( current_action != NULL )
  {
    done_dialog();
    current_action = NULL;
    show_cursor();
    application->update_cursor();
  }
}

void ok( char *txt, ... )
{
  va_list argptr;
  char buffer[256];

  va_start( argptr, txt );
  if( con_messages )
  {
    vsprintf( buffer, txt, argptr );
    printf( "%s: %s\n", __title(), buffer );
  }
  else
  {
    _iinfo();
    msg(txt,argptr);
    key( kESC, cmOK );
    bok();
  }
  va_end( argptr );
}

boolean kc( char *txt, ... )
{
  va_list argptr;

  _iwarning(); _tconfirm();
  va_start( argptr, txt );
  msg( txt, argptr );
  va_end( argptr );
  _focused(); return bkc();
}

boolean kch( char *txt, ... )
{
  va_list argptr;

  _iwarning(); _tconfirm();
  va_start( argptr, txt );
  msg( txt, argptr );
  va_end( argptr );
  _focused(); return bkch();
}

boolean yn( char *txt, ... )
{
  va_list argptr;

  _tconfirm();
  va_start( argptr, txt );
  msg( txt, argptr );
  va_end( argptr );
  _focused(); return byn();
}

boolean ynh( char *txt, ... )
{
  va_list argptr;

  _tconfirm();
  va_start( argptr, txt );
  msg( txt, argptr );
  va_end( argptr );
  _focused(); return bynh();
}

uint ync( char *txt, ... )
{
  va_list argptr;

  _tconfirm();
  va_start( argptr, txt );
  msg( txt, argptr );
  va_end( argptr );
  _focused(); return bync();
}

uint ynch( char *txt, ... )
{
  va_list argptr;

  _tconfirm();
  va_start( argptr, txt );
  msg( txt, argptr );
  va_end( argptr );
  _focused(); return bynch();
}

boolean ra( char *txt, ... )
{
  va_list argptr;

  _terror();
  va_start( argptr, txt );
  msg( txt, argptr );
  va_end( argptr );
  _focused(); return bra();
}

boolean rah( char *txt, ... )
{
  va_list argptr;

  _terror();
  va_start( argptr, txt );
  msg( txt, argptr );
  va_end( argptr );
  _focused(); return brah();
}

boolean drive_error( int drv )
{
#ifdef CYR
  return ra( "     %c:\n\n               .", drv );
#else
  return ra( "Cannot access drive %c:\n\nPlease verify the drive door is closed and that the disk is formatted and free of errors.", drv );
#endif
}

//PREFIXES

static boolean new_file_ = 0;
static boolean multi_files_ = 0;
static char *filters_ = NULL;
static char *title_ = NULL;
static char icon_ = 0;
static char *get_file_dir_ = NULL;
static uint *get_file_filter_ = 0;

/*
  Description:
    Specify select file dialog box to ask for overwriting if the user
    selected an existing file. Call just before a call to get_file.
*/
void _new_file( void )
{
  new_file_ = 1;
}

boolean __new_file( void )
{
  boolean result;

  result = new_file_;
  new_file_ = 0;
  return result;
}

/*
  Description:
    Specify select file dialog box can select multiply files. Call just
    before a call to get_file. After get_file call get_file_list to obtain
    pointer to the files list box. Don't forget to delete the list box.
*/
void _multi_files( void )
{
  multi_files_ = 1;
}

boolean __multi_files( void )
{
  boolean result;

  result = multi_files_;
  multi_files_ = 0;
  return result;
}

/*
  Description:
    Specify filters for the select file dialog box. Call just before a call
    to get_file. if you do not specify filters, *.* is assumed.
  Entry:
    f - string with the following structure:
        "description1 ( wildcard1 )|description2 ( wildcard2 )|....".
*/
void _filters( char *f )
{
  filters_ = f;
}

char *__filters( void )
{
  char *result;

  result = filters_;
  filters_ = NULL;
  return result;
}

/*
  Description:
    Specify directory & filter hold areas for get_file.
  Entry:
    get_file_dir    - area for directory (char *)
    get_file_filter - area for filter    (uint *)
*/
void _get_file_svd( char *get_file_dir, uint &get_file_filter )
{
  if( get_file_dir_    == NULL ) get_file_dir_    = get_file_dir;
  if( get_file_filter_ == NULL ) get_file_filter_ = &get_file_filter;
}

void __get_file_svd( char **get_file_dir, uint **get_file_filter )
{
  *get_file_dir    = get_file_dir_;
  *get_file_filter = get_file_filter_;
  get_file_dir_    = NULL;
  get_file_filter_ = NULL;
}

/*
  Description:
    Specify title for a message dialog. Call just before a call to
    'ok','kc','ra', etc.
*/
void _title( char *t )
{
  if( title_ == NULL ) title_ = t;
}

/*
  Description:
    Specify 'Message' title for a message dialog. Call just before a call to
    'ok','kc','ra', etc.
*/
void _tmessage( void )
{
#ifdef CYR
  if( title_ == NULL ) title_ = "";
#else
  if( title_ == NULL ) title_ = "Message";
#endif
}

/*
  Description:
    Specify 'Error' title, alert palette, and warning icon for a message
    dialog. Call just before a call to 'ok','kc','ra', etc.
*/
void _terror( void )
{
#ifdef CYR
  if( title_ == NULL ) title_ = "";
#else
  if( title_ == NULL ) title_ = "Error";
#endif
  _iwarning();
}

/*
  Description:
    Specify 'Confirm' title and warning icon for a message dialog. Call just
    before a call to 'ok','kc','ra', etc.
*/
void _tconfirm( void )
{
#ifdef CYR
  if( title_ == NULL ) title_ = "";
#else
  if( title_ == NULL ) title_ = "Confirm";
#endif
  _iquestion();
}

char *__title( void )
{
#ifdef CYR
  char *result = "";
#else
  char *result = "Message";
#endif

  if( title_ != NULL ) result = title_;
  title_ = NULL;
  return result;
}

/*
  Description:
    Specify warning icon for a message dialog. Call just before a call
    to 'ok','kc','ra', etc.
*/
void _iwarning( void )
{
  _palert();
  if( !icon_ ) icon_ = _ICON_WARNING;
}

/*
  Description:
    Specify question icon for a message dialog. Call just before a call
    to 'ok','kc','ra', etc.
*/
void _iquestion( void )
{
  if( !icon_ ) icon_ = _ICON_QUESTION;
}

/*
  Description:
    Specify info icon for a message dialog. Call just before a call
    to 'ok','kc','ra', etc.
*/
void _iinfo( void )
{
  if( !icon_ ) icon_ = _ICON_INFO;
}

/*
  Description:
    Specify no icon for a message dialog. Call just before a call
    to 'ok','kc','ra', etc.
*/
void _inothing( void )
{
  if( !icon_ ) icon_ = _ICON_NOTHING;
}

char __icon( void )
{
  char result = _ICON_NOTHING;

  if( icon_ ) result = icon_;
  icon_ = 0;
  return result;
}
