//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVAPP.H                              |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Power View Application interface     |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

void __init_application( void );
void __resize_application();

#ifndef _PVAPP_H
#define _PVAPP_H
class Tapplication : public Titem
{
  public:
    Tapplication( void );
    virtual void resize( int newxl, int newyl );
    void update_events_mask( void );
    void or_events_mask( Titem *p );
    void refresh_screen( void );
    void update_cursor( void );

  protected:
    virtual void event_handler( Tevent &ev );
    virtual void get_event( Tevent &ev );
};

class Tmaster_modal : public Titem
{
  private:
    Tmaster_modal( void );

  friend class Tapplication;
};

typedef void ( * Tidle ) ( unsigned long time_passed );
typedef void ( * Tcmd_handler ) ( uint cmd_code, void *cmd_info );
#endif //_PVAPP_H

#ifdef DECLARE_PVAPP
Tapplication *application = NULL;
Tmaster_modal *master_modal = NULL;
#ifdef MEMMON
unsigned long mem_avail;
#endif
int desktop_x, desktop_y, desktop_xl, desktop_yl;
Tidle idle;
#else
extern Tapplication *application;
extern Tmaster_modal *master_modal;
#ifdef MEMMON
extern unsigned long mem_avail;
#endif
extern int desktop_x, desktop_y, desktop_xl, desktop_yl;
extern Tidle idle;
#endif

void hide_cursor( void );
void show_cursor( void );
void req_update( Titem *p );
void cancel_update( Titem *p );
void commands_changed( void );
void _dialog_xy( int x, int y );    //prefix
void __dialog_xy( int &x, int &y );
uint exec_dialog( Titem *p );
Tidle hook_idle( Tidle p );
void cmd_handler( Tcmd_handler p );
