//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVCMD.H                              |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Commands manager interface           |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

//LOCAL COMMANDS

/*
  Description:
    The local commands can be used only inside a window item. Every window
    has its own enable flags set. When you enable or disable a command
    it is enabled/disabled in current window's local set only, and another
    windows will keep their own flags unchanged. It is OK to use commands
    with one and the same code in two or more different windows.

  Notes:
    - Local command 0 is special and if disabled, it disables all the local
      commands above or equal to cmUSER00
    - Command codes above 0xD0 are reserved for Power View internal use only.
      It is OK to use some pre-defined commands such as cmOK, cmCANCEL,
      cmYES, etc. but it is not recommended to define new codes above 0xD0.
    - Command codes above 0x7F are 'public' and such codes must be unique
      for entire application.
    - Command codes below 0x80 are 'private' and such codes may not be unique.
    - Use pre-defined cmUSER00..cmUSER99 commands for your private commands.
*/

#ifndef _PVCMD_H
#define _PVCMD_H

#define cmWIN_RESTORE   0x01
#define cmWIN_CLOSE     0x02
#define cmWIN_MOVE      0x03
#define cmWIN_SIZE      0x04
#define cmWIN_MINIMIZE  0x05
#define cmWIN_MAXIMIZE  0x06
#define cmWIN_ON_TOP    0x07

#define cmOK            0xD0
#define cmCANCEL        0xD1
#define cmYES           0xD2
#define cmNO            0xD3
#define cmABORT         0xD4
#define cmRETRY         0xD5
#define cmOPEN          0xD6
#define cmCLOSE         0xD7
#define cmDELETE        0xD8
#define cmUNDO          0xD9
#define cmSAVE          0xDA
#define cmSAVE_AS       0xDB
#define cmSTAMP_CHECK   0xDC
#define cmPRINT         0xDD
#define cmCUT           0xDE
#define cmCOPY          0xDF
#define cmPASTE         0xE0
#define cmCLEAR         0xE1
#define cmUP_ARROW      0xE2
#define cmDOWN_ARROW    0xE3
#define cmLEFT_ARROW    0xE4
#define cmRIGHT_ARROW   0xE5
#define cmSCROLL_BAR    0xE6
#define cmLABEL_FOCUSED 0xE7

//USER AVAILABLE LOCAL COMMANDS

#define cmUSER99        0x7F
#define cmUSER98  ( cmUSER99- 1 )
#define cmUSER97  ( cmUSER99- 2 )
#define cmUSER96  ( cmUSER99- 3 )
#define cmUSER95  ( cmUSER99- 4 )
#define cmUSER94  ( cmUSER99- 5 )
#define cmUSER93  ( cmUSER99- 6 )
#define cmUSER92  ( cmUSER99- 7 )
#define cmUSER91  ( cmUSER99- 8 )
#define cmUSER90  ( cmUSER99- 9 )
#define cmUSER89  ( cmUSER99-10 )
#define cmUSER88  ( cmUSER99-11 )
#define cmUSER87  ( cmUSER99-12 )
#define cmUSER86  ( cmUSER99-13 )
#define cmUSER85  ( cmUSER99-14 )
#define cmUSER84  ( cmUSER99-15 )
#define cmUSER83  ( cmUSER99-16 )
#define cmUSER82  ( cmUSER99-17 )
#define cmUSER81  ( cmUSER99-18 )
#define cmUSER80  ( cmUSER99-19 )
#define cmUSER79  ( cmUSER99-20 )
#define cmUSER78  ( cmUSER99-21 )
#define cmUSER77  ( cmUSER99-22 )
#define cmUSER76  ( cmUSER99-23 )
#define cmUSER75  ( cmUSER99-24 )
#define cmUSER74  ( cmUSER99-25 )
#define cmUSER73  ( cmUSER99-26 )
#define cmUSER72  ( cmUSER99-27 )
#define cmUSER71  ( cmUSER99-28 )
#define cmUSER70  ( cmUSER99-29 )
#define cmUSER69  ( cmUSER99-30 )
#define cmUSER68  ( cmUSER99-31 )
#define cmUSER67  ( cmUSER99-32 )
#define cmUSER66  ( cmUSER99-33 )
#define cmUSER65  ( cmUSER99-34 )
#define cmUSER64  ( cmUSER99-35 )
#define cmUSER63  ( cmUSER99-36 )
#define cmUSER62  ( cmUSER99-37 )
#define cmUSER61  ( cmUSER99-38 )
#define cmUSER60  ( cmUSER99-39 )
#define cmUSER59  ( cmUSER99-40 )
#define cmUSER58  ( cmUSER99-41 )
#define cmUSER57  ( cmUSER99-42 )
#define cmUSER56  ( cmUSER99-43 )
#define cmUSER55  ( cmUSER99-44 )
#define cmUSER54  ( cmUSER99-45 )
#define cmUSER53  ( cmUSER99-46 )
#define cmUSER52  ( cmUSER99-47 )
#define cmUSER51  ( cmUSER99-48 )
#define cmUSER50  ( cmUSER99-49 )
#define cmUSER49  ( cmUSER99-50 )
#define cmUSER48  ( cmUSER99-51 )
#define cmUSER47  ( cmUSER99-52 )
#define cmUSER46  ( cmUSER99-53 )
#define cmUSER45  ( cmUSER99-54 )
#define cmUSER44  ( cmUSER99-55 )
#define cmUSER43  ( cmUSER99-56 )
#define cmUSER42  ( cmUSER99-57 )
#define cmUSER41  ( cmUSER99-58 )
#define cmUSER40  ( cmUSER99-59 )
#define cmUSER39  ( cmUSER99-60 )
#define cmUSER38  ( cmUSER99-61 )
#define cmUSER37  ( cmUSER99-62 )
#define cmUSER36  ( cmUSER99-63 )
#define cmUSER35  ( cmUSER99-64 )
#define cmUSER34  ( cmUSER99-65 )
#define cmUSER33  ( cmUSER99-66 )
#define cmUSER32  ( cmUSER99-67 )
#define cmUSER31  ( cmUSER99-68 )
#define cmUSER30  ( cmUSER99-69 )
#define cmUSER29  ( cmUSER99-70 )
#define cmUSER28  ( cmUSER99-71 )
#define cmUSER27  ( cmUSER99-72 )
#define cmUSER26  ( cmUSER99-73 )
#define cmUSER25  ( cmUSER99-74 )
#define cmUSER24  ( cmUSER99-75 )
#define cmUSER23  ( cmUSER99-76 )
#define cmUSER22  ( cmUSER99-77 )
#define cmUSER21  ( cmUSER99-78 )
#define cmUSER20  ( cmUSER99-79 )
#define cmUSER19  ( cmUSER99-80 )
#define cmUSER18  ( cmUSER99-81 )
#define cmUSER17  ( cmUSER99-82 )
#define cmUSER16  ( cmUSER99-83 )
#define cmUSER15  ( cmUSER99-84 )
#define cmUSER14  ( cmUSER99-85 )
#define cmUSER13  ( cmUSER99-86 )
#define cmUSER12  ( cmUSER99-87 )
#define cmUSER11  ( cmUSER99-88 )
#define cmUSER10  ( cmUSER99-89 )
#define cmUSER09  ( cmUSER99-90 )
#define cmUSER08  ( cmUSER99-91 )
#define cmUSER07  ( cmUSER99-92 )
#define cmUSER06  ( cmUSER99-93 )
#define cmUSER05  ( cmUSER99-94 )
#define cmUSER04  ( cmUSER99-95 )
#define cmUSER03  ( cmUSER99-96 )
#define cmUSER02  ( cmUSER99-97 )
#define cmUSER01  ( cmUSER99-98 )
#define cmUSER00  ( cmUSER99-99 )

//GLOBAL COMMANDS

/*
  Description:
    A global command differs from a local in the code: local command codes
    are from 0x00 to 0xFF, and the global codes are above or equal to 0x100.
    Only low char is used for identification. Only 256 local and 256 global
    commands are available.

  Notes:
    - Global command 0 is special and if disabled, it disables all other
      global commands.
    - Beside the local commands flags, global commands flags are static and
      are valid for all the items, no matter what window is currently active.
    - Global codes above 0xCF (low char!) are reserved for Power View internal
      use only. It is not recommended to disable or use such the commands.
    - You can use pre-defined basic menu commands, such as cmFILE_NEW,
      cmFILE_OPEN, etc. in your application.
*/

//STANDARD ITEM COMMANDS

#define cmVALID                0x10D0 //check window validity
#define cmHELP                 0x10D1 //show help for the item
#define cmSELECT               0x10D2 //select item
#define cmFOCUS                0x10D3 //focus item
#define cmENABLE               0x10D4 //enable item
#define cmDISABLE              0x10D5 //disable item
#define cmHIDE                 0x10D6 //hide item
#define cmSHOW                 0x10D7 //show (unhide) item
#define cmDONE                 0x10D8 //dispose item
#define cmARRANGING            0x10D9 //item is about to be tile/casc
#define cmCAN_DROP             0x10DA //can item handle a drop on it
#define cmDROP                 0x10DB //drop an object on the item

//SPECIFIC ITEMS COMMANDS

#define cmBTN_GRAB_DEFAULT     0x10DC //button has been selected
#define cmBTN_RELEASE_DEFAULT  0x10DD //non-default btn deselected
#define cmRADIO_DEPRESS        0x10DE //radio btns release command
#define cmDLG_RESET            0x10DF //dialog is about to (re)exec
#define cmDLG_RECORD_HISTORY   0x10E0 //sent to the items if dlg ok

//MENU COMMANDS

#define cmMENU_SELECTION       0x10E1 //menu entry selected
#define cmMENU_OPEN_SUBMENU    0x10E2 //open hilighted submenu
#define cmMENU_CLOSE_SUBMENU   0x10E3 //close any open submenu
#define cmMENU_SELECTION_MADE  0x10E4 //selection made, close menu
#define cmMENU_CANCELLED       0x10E5 //cancelled, close the menu

//APPLICATION COMMANDS

#define cmAPP_SCREEN_SAVER     0x10E6 //activate screen saver
#define cmAPP_COMMANDS_CHANGED 0x10E7 //command set has been changed
#define cmAPP_REDRAW           0x10E8 //refresh screen
#define cmAPP_QUIT             0x10E9 //quit the application

//STANDARD FILE MENU COMMANDS

#define cmFILE_NEW             0x10B0     //open a new file
#define cmFILE_OPEN            0x10B1     //select a file to open
#define cmFILE_SAVE            cmSAVE     //save current file (Local)
#define cmFILE_SAVE_AS         cmSAVE_AS  //save file as... (Local)
#define cmFILE_SAVE_ALL        0x10B2     //save all files
#define cmSAVE_ALL             0x10B2
#define cmFILE_PRINT           cmPRINT    //print current file (Local)
#define cmFILE_PRINTER_SETUP   0x10B3     //printer setup dialog
#define cmFILE_DOS_SHELL       0x10B4     //enter DOS shell
#define cmFILE_EXIT            cmAPP_QUIT //exit the application

//STANDARD OPTIONS MENU COMMANDS

#define cmOPTIONS_OPEN         0x10B5 //read options from a file
#define cmOPTIONS_SAVE         0x10B6 //save current options
#define cmOPTIONS_SAVE_AS      0x10B7 //save current options as...

//STANDARD WINDOW MENU COMMANDS

#define cmWINDOW_TILE          0x10B8        //tile windows in desktop
#define cmWINDOW_CASCADE       0x10B9        //cascade windows in desktop
#define cmWINDOW_ARRANGE_ICONS 0x10BA        //arrange iconized windows
#define cmWINDOW_CLOSE_ALL     0x10BB        //close all wins in desktop
#define cmWINDOW_REFRESH       cmAPP_REDRAW  //refresh application screen
#define cmWINDOW_NEXT          0x10BC        //select next win in desktop
#define cmWINDOW_PREVIOUS      0x10BD        //select prev win in desktop
#define cmWINDOW_CLOSE         cmWIN_CLOSE   //close current win (Local)
#define cmWINDOW_LIST          0x10BE        //invoke Windows List dialog
#define cmWINDOW_TITLE         0x10BF        //toggle application title
#define cmWINDOW_TOOLBAR       0x10C0        //toggle application toolbar
#define cmWINDOW_TOOLBOX       0x10C1        //toggle application toolbox

//STANDARD HELP MENU COMMANDS

#define cmHELP_CONTENTS        0x10C2 //show help contents
#define cmHELP_INDEX           0x10C3 //show help index
#define cmHELP_SEARCH          0x10C4 //invoke Search Topic dialog
#define cmHELP_PREVIOUS        0x10C5 //show previous help topic
#define cmHELP_USING           0x10C6 //show help on using help
#define cmHELP_ABOUT           0x10C7 //invoke About dialog

//TETRIS COMMANDS

#define cmTETRIS_TIMER         0x10C8 //used by tetris internally

class Tcommands: public Tset
{
  public:
    static Tset global;
    Tset *local;
    Tcommands( void );
    Tcommands( Tset &_local );
    void operator ~ ( void ); //clear local commands
    void operator ! ( void ); //[0..255] local commands

  friend Tcommands& operator << ( Tcommands &set, uint member );
  friend Tcommands& operator >> ( Tcommands &set, uint member );
  friend Tcommands& operator << ( Tcommands &set, Tcommands &set1 );
  friend Tcommands& operator >> ( Tcommands &set, Tcommands &set1 );
  friend int operator &( Tcommands &set, uint member );
  friend int operator &( uint member, Tcommands &set );
};

inline int operator & ( uint member, Tcommands &set )
{
  return set&member;
}

#endif //_PVCMD_H

boolean cenabled( uint cmd );
boolean cdisabled( uint cmd );
void cenable( uint cmd );
void cdisable( uint cmd );
void cstate( uint cmd, boolean enable );
void set_cmd( Tcommands *cmd );
Tcommands *get_cmd( void );
