//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVCOMBO.H                            |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Combo-box interface                  |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#ifndef _PVCOMBO_H
#define _PVCOMBO_H
class Tprompt_item: public Titem
{
//<R> means read-only
//<R/W> means read/write
  public:
    char prompt_len; //<R> length of the prompt string
    Tprompt_item( char *_prompt, int _xl );
};

class Tcombo_item: public Tprompt_item, public Tlb_list
{
  public:
    Tcombo_item( char *_prompt, int _xl );
    Tcombo_item( char *_prompt, int _xl, Tlb_list *_list );
    virtual void set_data( uint i ) = 0;
    virtual void get_data( char *s ) = 0;
};

class Tcombo_list: public Tlist_box
{
  public:
    Tcombo_list( uint &_data, int _xl, int _max_print, Tlb_list *_list );
    virtual ~Tcombo_list( void );

  protected:
    virtual void set_palette( void );
    virtual boolean release_focus( void );
    virtual void event_handler( Tevent &ev );
};

class Tcombo: public Ticon
{
//<R> means read-only
//<R/W> means read/write
  public:
    int open_xl; //<R/W>
    int open_yl; //<R/W>
    Tcombo( void );
    virtual void open_combo( void );
    virtual void close_combo( void );
    virtual void set_index( void );
    virtual void get_index( void );

  protected:
    boolean open;
    uint dta;
    virtual void initialize( void );
    virtual void event_handler( Tevent &ev );
    virtual void press( void );
    virtual Tcombo_list *init_combo_list( void );
};

class Tcombo_box: public Tcombo_item
{
//<R> means read-only
//<R/W> means read/write
  public:
    Tcombo *combo; //<R>
    Tcombo_box( char *_prompt, uint &_data, int _xl );
    Tcombo_box( char *_prompt, uint &_data, int _xl, Tlb_list *_list );
    virtual ~Tcombo_box( void );
    uint cursor( void );
    virtual void set_data( uint i );
    virtual void get_data( char *s );

  protected:
    char *data_txt;
    uint data_num;
    uint *dta;
    virtual void draw( void );
    virtual void event_handler( Tevent &ev );
    virtual void ok_item( void );

  private:
    void init( uint &_data );
};
#endif

//PREFIXES

void _combo_lines( int cl );     int __combo_lines( void );

//CONSTRUCTORS FOR USE WITH DIALOG BOXES

Tcombo_box *combo_box( char *t, uint &data, int _xl );
Tcombo_box *combo_box( char *t, uint &data, int _xl, Tlb_list *_list );
//Tcombo *tcombo_box( char *t, char *data, int len, int size );
