//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVDIALOG.H                           |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Dialog boxes support interface       |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#ifndef _PVDIALOG_H
#define _PVDIALOG_H

typedef void ( * Tdlg_handler ) ( Titem *p );
typedef boolean ( * Tdlg_validator ) ( uint x );

class Tdialog: public Twindow
{
  public:
    Tdialog( char *t, int _xl, int _yl );
    virtual boolean valid( uint stop_st );
    virtual uint exec( void );

  protected:
    Titem *first_focused;
    Tdlg_handler dlg_handler;
    Tdlg_validator dlg_validator;
    virtual boolean isit_4u( Tevent &ev );
    virtual void event_handler( Tevent &ev );

  private:
    Tdialog *dlg_saved;

  friend void extern_dialog( Tdialog *p );
  friend void put_item( Titem *item, int item_xl, int item_yl );
  friend void handler( Tdlg_handler p );
  friend void validator( Tdlg_validator p );
  friend void done_dialog( void );
};
#endif

//DIALOG ITEMS ARRANGING

Tdialog *dialog( char *t );
void extern_dialog( Tdialog *p );
void put_item( Titem *item, int item_xl, int item_yl );
void hspacing( int s );
void vspacing( int s );
void hor( void );
void ver( void );
boolean fill( void );
void nl( void );
void nc( void );
void push( void );
void pop( void );
Titem *frame( char *t );
Titem *frame( void );
void endfr( void );
void hspace( void );
void vspace( void );
void space( void );
void hspaces( int tb );
void vspaces( int tb );
void spaces( int tb );
void mark( void );
void mark0( void ); void mark1( void );
void mark2( void ); void mark3( void );
void mark4( void ); void mark5( void );
void mark6( void ); void mark7( void );
void mark8( void ); void mark9( void );
void gmrk( void );
void gmrk0( void ); void gmrk1( void );
void gmrk2( void ); void gmrk3( void );
void gmrk4( void ); void gmrk5( void );
void gmrk6( void ); void gmrk7( void );
void gmrk8( void ); void gmrk9( void );
void gmrc( void );
void gmrc0( void ); void gmrc1( void );
void gmrc2( void ); void gmrc3( void );
void gmrc4( void ); void gmrc5( void );
void gmrc6( void ); void gmrc7( void );
void gmrc8( void ); void gmrc9( void );
void gmrl( void );
void gmrl0( void ); void gmrl1( void );
void gmrl2( void ); void gmrl3( void );
void gmrl4( void ); void gmrl5( void );
void gmrl6( void ); void gmrl7( void );
void gmrl8( void ); void gmrl9( void );

//DIALOG EXECUTING

void end_of_dialog( void );
void done_dialog( void );
uint run( void );
void bok( void );
boolean bkc( void );
boolean bkch( void );
boolean byn( void );
boolean bynh( void );
uint bync( void );
uint bynch( void );
boolean bra( void );
boolean brah( void );

//DIALOG HANDLING

void handler( Tdlg_handler p );
void validator( Tdlg_validator p );
void focus( Titem *p );
void set_enable( Titem *p, boolean f );
Titem *current( void );

//PREFIXES

void _aleft( void );               char __align( void );
void _aright( void );
void _acenter( void );
void _focused( void );             boolean __focused( void );
void _stay( void );                boolean __stay( void );
