//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVINPUT.H                            |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Input box interface                  |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#ifndef _PVINPUT_H
#define _PVINPUT_H

class Tinput_editor: public Tmemo
{
//<R> means read-only
//<R/W> means read/write
  public:
    Tinput_editor( char *_line, int _max_len, int _xl );
    virtual void scroll_to( int _x, int _y );

  protected:
    virtual void get_focused( void );
#ifndef HGR
    virtual void set_palette( void );
#endif
    virtual void event_handler( Tevent &ev );
    virtual void convert_event( Tevent &ev );
    Ticon *left_icon;
    Ticon *right_icon;
};

class Tinput: public Tcombo_item
{
  public:
#ifndef NOHIST
    void *history_id;
#endif
    Tinput_editor *editor;
    Tinput( char *_prompt, char *_line, int _max_length, int _xl );
#ifndef NOHIST
    Tinput( char *_prompt, char *_line, int _max_length, int _xl, Tlb_list *_hist );
#endif
    virtual void set_data( uint i );
    virtual void get_data( char *s );
    void set_txt( char *s );
    void get_txt( char *s );

  protected:
    virtual void draw( void );
    virtual void get_focused( void );
    virtual boolean release_focus( void );

  private:
    void init( char *_line, int _max_length, int _xl );
};

class Tlinput: public Tinput
{
  public:
    Tlinput ( char *_prompt, long &_data, long _min, long _max );
#ifndef NOHIST
    Tlinput( char *_prompt, long &_data, long _min, long _max, Tlb_list *_hist );
#endif
    virtual boolean valid( uint stop_st );
    void set_num( long n );
    long get_num( void );

  private:
    boolean hex;
    long *data;
    long min;
    long max;
    char lin[12];
    char len;
    char init_len( long _min, long _max );
    void init( long &_data, long _min, long _max );
};

class Tiinput: public Tlinput
{
  public:
    Tiinput( char *_prompt, int &_data, int _min, int _max );
#ifndef NOHIST
    Tiinput( char *_prompt, int &_data, int _min, int _max, Tlb_list *_hist );
#endif
    virtual boolean valid( uint stop_st );

  private:
    long tmp;
    int *dta;
};

class Tsinput: public Tlinput
{
  public:
    Tsinput( char *_prompt, short &_data, short _min, short _max );
#ifndef NOHIST
    Tsinput( char *_prompt, short &_data, short _min, short _max, Tlb_list *_hist );
#endif
    virtual boolean valid( uint stop_st );

  private:
    long tmp;
    short *dta;
};

class Twinput: public Tlinput
{
  public:
    Twinput( char *_prompt, word &_data, word _min, word _max );
#ifndef NOHIST
    Twinput( char *_prompt, word &_data, word _min, word _max, Tlb_list *_hist );
#endif
    virtual boolean valid( uint stop_st );

  private:
    long tmp;
    word *dta;
};

class Tcinput: public Tlinput
{
  public:
    Tcinput( char *_prompt, char &_data, char _min, char _max );
#ifndef NOHIST
    Tcinput( char *_prompt, char &_data, char _min, char _max, Tlb_list *_hist );
#endif
    virtual boolean valid( uint stop_st );

  private:
    long tmp;
    char *dta;
};

#ifndef NOFLOAT
class Tdinput: public Tinput
{
  public:
    Tdinput( char *_prompt, double &_data, double _min, double _max, char _decimals );
#ifndef NOHIST
    Tdinput( char *_prompt, double &_data, double _min, double _max, char _decimals, Tlb_list *_hist );
#endif
    virtual boolean valid( uint stop_st );
    void set_num( double n );
    double get_num( void );

  private:
    double *data;
    double min;
    double max;
    char lin[50];
    char integer;
    char decimals;
    char len;
    char init_len( double &data, double _min, double _max, char _decimals );
    virtual void get_focused( void );
    virtual boolean release_focus( void );
    void init( void );
};

class Tfinput: public Tdinput
{
  public:
    Tfinput( char *_prompt, float &_data, float _min, float _max, char _decimals );
#ifndef NOHIST
    Tfinput( char *_prompt, float &_data, float _min, float _max, char _decimals, Tlb_list *_hist );
#endif
    virtual boolean valid( uint stop_st );

  private:
    double tmp;
    float *dta;
    void init( void );
};
#endif //NOFLOAT

#endif

//PREFIXES

#ifndef NOHIST
void *_history( void *history_id );  void *__history( void );
#endif
void _hexnum( void );                boolean __hexnum( void );

//CONSTRUCTORS FOR USE WITH DIALOG BOXES

Tinput *input( char *t, char *data, int len, int size );
Tlinput *linput( char *t, long &data, long min, long max );
Tiinput *iinput( char *t, int &data, int min, int max );
Tsinput *sinput( char *t, short &data, short min, short max );
Tcinput *cinput( char *t, char &data, char min, char max );
Twinput *winput( char *t, word &data, word min, word max );
#ifndef NOFLOAT
Tdinput *dinput( char *t, double &data, double min, double max, char decimals );
Tfinput *finput( char *t, float &data, float min, float max, char decimals );
Tfinput *minput( char *t, float &data, float max );
#endif
