//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVLBOX.H                             |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     List box interface                   |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#ifndef _PVLBOX_H
#define _PVLBOX_H

#define lbfCHECKED  0x01
#define lbfTITLE    0x02
#define lbfDISABLED 0x04

struct Tlb_item
{
  char flags;
  char data[];
};

typedef Tlb_item* Tlb_arr[1];
typedef void (* Tlb_item_killer) ( void *p );
typedef int (* Tlb_item_comparator) ( const Tlb_item *p1, const Tlb_item *p2 );

class Tlb_list: public Tlist
{
  public:
    uint data_size; //size of the data, associated w/ every item in the list
    uint _hsize;
    uint _hbeg_print;
    int _hmax_print;
    uint _hmax_size;
    boolean _changed;
    boolean _overflow;
    uint &hsize;
    uint &hbeg_print;
    int &hmax_print;
    uint &hmax_size;
    boolean &changed; //TRUE if list has been modified
    boolean &overflow; //TRUE if list overflow
    Tlb_arr *items_ptr; //pointer to array of pointers to the items
    Tlb_item_killer lb_item_killer;
    Tlb_item_comparator lb_item_comparator;
    Tlb_list( void );
    Tlb_list( Tlb_list *_list );
    Tlb_list( uint &v_count, uint &v_current, uint &v_beg_print, int &v_max_print,
              uint &h_size, uint &h_beg_print, int &h_max_print );
    virtual ~Tlb_list( void );
    virtual void clear( void ); //empty the list
    virtual uint add( void *data ); //add an item to the list
    virtual void ins( uint i, void *data ); //insert an item before the i-th item
    virtual void del( uint i ); //delete i-th item
    virtual void get( uint i, void *data ); //get the i-th item
    virtual void put( uint i, void *data ); //replace the i-th item
    virtual void sort( void ); //sort items in the list
    void sort_range( uint from, uint how_many );
    uint bin_search( Tlb_item *p ); //binary search of item p
    uint bin_search_range( Tlb_item *p, uint from, uint how_many );
    virtual void up( void ); //select previous item
    virtual void down( void ); //select next item
    virtual void top( void ); //select the first item
    virtual void bottom( void ); //select the last them
    virtual void at( uint i ); //scroll to i-th item
    virtual void gettxt( uint i, char *t ); //get i-th item as a string
    virtual void *getptr( uint i ); //get ptr to i-th item
    virtual void error( int error_code ); //called on error
    void add_title( char *data );
    void add_blank( void );
    uint findft( char *t ); //find first text, use findn to find next
    void getdata( uint i, void *data ); //get the data associated w/ the i-th item
    void item_data( Tlb_item *p, void *data );
    void item_str( Tlb_item *p, char *s );
    void check( uint i, boolean f ); //check i-th item
    boolean checked( uint i ); //TRUE if i-th item is checked
    void set_enable( uint i, boolean f ); //enable/disable i-th item
    boolean enabled( uint i ); //TRUE if i-th item is enabled
    void set_comparator( Tlb_item_comparator _lb_item_comparator );

  protected:
    virtual void inc_count( void );
    virtual void dec_count( void );
    Tlb_item *alloc_lb_item( char *data );
    void free_lb_item( Tlb_item *p );
    void flip( uint i );
    void multi_flip( uint from, uint to );
};

class Tlist_box: public Titem, public Tlb_list
{
  public:
    Tvscroll_bar *v_bar;
    Thscroll_bar *h_bar;
    Tlist_box( uint &_data, int _xl, int _yl );
    Tlist_box( uint &_data, int _xl, int _yl, Tlb_list *_list );

  protected:
    virtual void draw( void );
    virtual void event_handler( Tevent &ev );
    virtual void ok_item( void );

  private:
    uint *dta;
    void init( uint &_data );
};
#endif

//PREFIXES

void _lsize( uint size );    uint __lsize( void );
void _ldata( void *data );         void *__ldata( void );
void _litem_comparator( Tlb_item_comparator _comparator );
                                   Tlb_item_comparator __litem_comparator( void );
void _litem_killer( Tlb_item_killer _killer );
                                   Tlb_item_killer __litem_killer( void );

//CONSTRUCTORS FOR USE WITH DIALOG BOXES

Tlist_box *list_box( char *t, uint &data, int _xl, int _yl );
Tlist_box *list_box( char *t, uint &data, int _xl, int _yl, Tlb_list *list );
Tlist_box *mslist_box( char *t, uint &data, int _xl, int _yl );
Tlist_box *mslist_box( char *t, uint &data, int _xl, int _yl, Tlb_list *list );
