//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVSCROLL.H                           |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Scroll bar interface                 |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#ifndef _PVSCROLL_H
#define _PVSCROLL_H
class Tscroll_bar: public Titem
{
  public:
    uint *count;
    uint *beg_print;
    int *max_print;
    int delta;
    Ticon *icon_up;
    Ticon *icon_down;
    Tscroll_bar( int _xl, int _yl, uint &_count, uint &_beg_print );
    virtual void set_flags( uint _flags_word, boolean enable );
    void update( void );

  protected:
    char sb_begin;
    char sb_length;
    void do_update( void );
    virtual void event_handler( Tevent &ev );
#ifndef NOMOUSE
    virtual boolean mouse_on_pgup( Tevent &ev ) = 0;
    virtual boolean mouse_on_pgdn( Tevent &ev ) = 0;
    virtual boolean mouse_on_bar( Tevent &ev ) = 0;
    virtual void goto_bar( Tevent &ev ) = 0;
#endif
    virtual char get_bar_length( void ) = 0;
    void up( void );
    void down( void );
    void page_up( void );
    void page_down( void );
    void home( void );
    void end( void );
};

class Tvscroll_bar: public Tscroll_bar
{
  public:
    Tvscroll_bar( int _len, uint &_count, uint &_beg_print );

  protected:
    virtual void calc_bounds( int delta_xl, int delta_yl );
    virtual void draw( void );
    virtual void initialize( void );
    virtual void event_handler( Tevent &ev );

  private:
#ifndef NOMOUSE
    virtual boolean mouse_on_pgup( Tevent &ev );
    virtual boolean mouse_on_pgdn( Tevent &ev );
    virtual boolean mouse_on_bar( Tevent &ev );
    virtual void goto_bar( Tevent &ev );
#endif
    virtual char get_bar_length( void );
};

class Thscroll_bar: public Tscroll_bar
{
  public:
    Thscroll_bar( int _len, uint &_count, uint &_beg_print );

  protected:
    virtual void calc_bounds( int delta_xl, int delta_yl );
    virtual void draw( void );
    virtual void initialize( void );

  private:
#ifndef NOMOUSE
    virtual boolean mouse_on_pgup( Tevent &ev );
    virtual boolean mouse_on_pgdn( Tevent &ev );
    virtual boolean mouse_on_bar( Tevent &ev );
    virtual void goto_bar( Tevent &ev );
#endif
    virtual char get_bar_length( void );
};
#endif
