//  ____________________________________________________
// |                                                    |
// |  Project:     POWER VIEW INTERFACE                 |
// |  File:        PVTXT.H                              |
// |  Compiler:    WPP386 (10.6)                        |
// |                                                    |
// |  Subject:     Static & dynamic text interface      |
// |                                                    |
// |  Author:      Emil Dotchevski                      |
// |____________________________________________________|
//
// E-mail: zajo@geocities.com
// URL:    http://www.geocities.com/SiliconValley/Bay/3577

#include "PVitems.h"

#ifndef _PVTXT_H
#define _PVTXT_H

#define _TATTR_NORMAL   1
#define _TATTR_BOLD     2
#define _TATTR_SELECTED 3
#define _TATTR_DISABLED 4
#define _TALIGN_LEFT    1
#define _TALIGN_CENTER  2
#define _TALIGN_RIGHT   3

class Tdtext: public Titem
{
//<R> means read-only
//<R/W> means read/write
  public:
    char *tx; //<R>
    char align; //<R/W>
    char color; //<R/W>
    Tdtext( int _xl, int _yl );
    virtual ~Tdtext( void );
    virtual void set_txt( char *t );

  protected:
    virtual void set_palette( void );
    virtual void draw( void );
    int print( boolean f );
};

class Tstext: public Tdtext
{
  public:
    Tstext( char *t, int _xl );
};

#endif

//PREFIXES

void _taleft( void );              char __talign( void );
void _taright( void );
void _tacenter( void );
void _tnormal( void );             char __tcolor( void );
void _tbold( void );
void _tselected( void );
void _tdisabled( void );

//CONSTRUCTORS FOR USE WITH DIALOG BOXES

Tdtext *dtext( int _xl, int _yl );
Tstext *stext( char *txt, int _xl, ... );
Tstext *vstext( char *txt, int _xl, va_list argptr );
