/*
 EPSHeader

   File: log.c
   Author: J. Kercheval
   Created: Sat, 06/08/1991  09:24:14
*/
/*
 EPSRevision History

   J. Kercheval  Sat, 06/08/1991  09:24:27  move from fileio.c
   J. Kercheval  Wed, 06/26/1991  21:30:57  use standard fileio
   J. Kercheval  Fri, 07/12/1991  23:09:16  use stderr as default
*/


#include <stdio.h>
#include <string.h>
#include "log.h"


/*============================================================================

                          LOG FILE ROUTINES

============================================================================*/


static BOOLEAN log_is_open = FALSE;     /* if true then file has been opened */
static BOOLEAN use_stderr = TRUE;       /* if true log to stderr */

static FILE *log_file;          /* log_file is the output log file pointer */


/*----------------------------------------------------------------------------
*
*  open the log file after closing any existing log file
*
----------------------------------------------------------------------------*/

BOOLEAN log_open(char *fname, BOOLEAN quiet, BOOLEAN overwrite)
{
    char open_type[3];          /* used to determine the open file type */

    /* assign the file open type */
    if (overwrite) {
        strcpy(open_type, "w");
    }
    else {
        strcpy(open_type, "a");
    }

    /* close the log if already open */
    if (log_is_open)
        log_close();

    use_stderr = !quiet;

    /* open file if non-zero file name */
    if (strlen(fname)) {
        /* try to open the log file */
        if ((log_file = fopen(fname, open_type)) == (FILE *) NULL) {
            return FALSE;
        }
        else {

            /* ah, sweet success */
            log_is_open = TRUE;
            return TRUE;
        }
    }
    else {

        /* no log file */
        log_is_open = FALSE;
        return TRUE;
    }
}


/*----------------------------------------------------------------------------
*
*  close the log file, if open
*
----------------------------------------------------------------------------*/

void log_close()
{
    if (log_is_open) {
        fclose(log_file);
        log_is_open = FALSE;
    }
}


/*----------------------------------------------------------------------------
*
*  log message to stderr and log_file if open
*
----------------------------------------------------------------------------*/

void log_message(char *message)
{
    if (log_is_open) {
        fprintf(log_file, "%s\n", message);
    }
    if (use_stderr) {
        fprintf(stderr, "%s\n", message);
    }
}
