/*
 EPSHeader

   File: tagio.h
   Author: J. Kercheval
   Created: Wed, 07/17/1991  21:47:25
 */
/*
  EPSRevision History

   J. Kercheval  Sun, 08/18/1991  20:33:56  Added fill_buffer()
   J. Kercheval  Thu, 09/05/1991  20:12:29  add MergeFile()
 */

#include "flags.h"
#include "arglist.h"


/*----------------------------------------------------------------------------
 *
 * OutputTag() places the tag in the correct format into the output stream
 *
 ---------------------------------------------------------------------------*/

void OutputTag(FILE * outfile, char *line, char *symbol, char *infname,
                long int line_number, long int char_number, Flags * flags);


/*----------------------------------------------------------------------------
 *
 * FillBuffer() fills the passed buffer parameter with bufsize characters
 * (or as many as are available) and places and null character '\0' at the
 * end of the buffer.  This routine returns TRUE if successful and FALSE if
 * eof(infile) is true.  Note: if a bufsize parameter is passed and the read
 * is successful for bufsize characters, then buffer[bufsize] will be
 * overwritten with the null character.  Do not pass a bufsize the maximum
 * size of the buffer.  This null terminated buffering scheme assumes the
 * source file has no null character embedded within it.
 *
 ---------------------------------------------------------------------------*/

    BOOLEAN FillBuffer(FILE * infile, char *buffer, long int bufsize);


/*----------------------------------------------------------------------------
 *
 * GetLine() will read a line not to exceed n-1 chars from f and will return
 * TRUE if any characters parsed
 *
 ---------------------------------------------------------------------------*/

    BOOLEAN GetLine(FILE * f, char *line, int n);


/*----------------------------------------------------------------------------
 *
 * MergeFile() will take the temporary file and merge it into the potentially
 * existing tag file.  During the merge, any tags from the input files which
 * were processed during this session will be deleted from the tag file to
 * prevent innaccurate tagging information.
 *
 ---------------------------------------------------------------------------*/

    void MergeFile(char *input_filename, char *output_filename,
                    ArgList arglist, Flags * flags);
