
/* ---------------------------------------------------------------------*/
/*									*/
/*	XMS Interface for Borland C/C++, Version 1.1			*/
/*	Developed by Tanescu A. Horatiu					*/
/*	April 1997							*/
/*									*/
/* ---------------------------------------------------------------------*/
/*	C sources							*/
/* ---------------------------------------------------------------------*/
/*									*/
/*	XMSERR.C							*/
/*									*/
/*	XMS Error Functions						*/
/*	(xmserrormsg, pxmserror)					*/
/*									*/
/* ---------------------------------------------------------------------*/

#include <stdio.h>
#include "xms.h"

/* array of XMS error message strings
 */

char *xms_errlist[] = {
/* 0x80 */    "Function not implemented",
/* 0x81 */    "VDISK device detected",
/* 0x82 */    "An A20 error occurred",
/* 0x83 */    "",
/* 0x84 */    "",
/* 0x85 */    "",
/* 0x86 */    "",
/* 0x87 */    "",
/* 0x88 */    "",
/* 0x89 */    "",
/* 0x8A */    "",
/* 0x8B */    "",
/* 0x8C */    "",
/* 0x8D */    "",
/* 0x8E */    "A general driver error occurred",
/* 0x8F */    "An unrecoverable driver error occurred",
/* 0x90 */    "The HMA does not exist",
/* 0x91 */    "The HMA is already in use",
/* 0x92 */    "DX is less than the /HMAMIN= parameter",
/* 0x93 */    "The HMA is not allocated",
/* 0x94 */    "The A20 line is still enabled",
/* 0x95 */    "",
/* 0x96 */    "",
/* 0x97 */    "",
/* 0x98 */    "",
/* 0x99 */    "",
/* 0x9A */    "",
/* 0x9B */    "",
/* 0x9C */    "",
/* 0x9D */    "",
/* 0x9E */    "",
/* 0x9F */    "",
/* 0xA0 */    "All extended memory is allocated",
/* 0xA1 */    "All available extended memory handles are in use",
/* 0xA2 */    "Invalid handle",
/* 0xA3 */    "Invalid SourceHandle",
/* 0xA4 */    "Invalid SourceOffset",
/* 0xA5 */    "Invalid DestHandle",
/* 0xA6 */    "Invalid DestOffset",
/* 0xA7 */    "Invalid length",
/* 0xA8 */    "The move has an invalid overlap",
/* 0xA9 */    "A parity error occurred",
/* 0xAA */    "The block is not locked",
/* 0xAB */    "The block is locked",
/* 0xAC */    "Block lock count overflow",
/* 0xAD */    "Lock failure",
/* 0xAE */    "",
/* 0xAF */    "",
/* 0xB0 */    "A smaller UMB is available",
/* 0xB1 */    "No UMBs are available",
/* 0xB2 */    "Invalid UMB segment number"
};

/* number of XMS error message strings
 */

int xms_nerr = sizeof(xms_errlist) / sizeof(xms_errlist[0]);

/* xmserrormsg - return a pointer to an XMS error message string
 */

char* xmserrormsg(int errorcode)
{
  char* cp;

  int x = errorcode - 0x80;
  if (x < xms_nerr && x >= 0)
    cp = xms_errlist[x];
  else
    cp = "Unknown error";

  return (cp);
}

/* pxmserror - print an XMS error message
 */

void pxmserror(const char *s)
{
  fprintf(stderr, "%s: %s\n", s, xmserrormsg(xmserrno));
}