
/* ---------------------------------------------------------------------*/
/*									*/
/*	XMS Interface for Borland C/C++, Version 1.1			*/
/*	Developed by Tanescu A. Horatiu					*/
/*	April 1997							*/
/*									*/
/* ---------------------------------------------------------------------*/
/*	C sources							*/
/* ---------------------------------------------------------------------*/
/*									*/
/*	XMSUMB.C							*/
/*									*/
/*	Upper Memory Blocks Management Functions			*/
/*	(umballoc, umbfree, umbrealloc)					*/
/*									*/
/* ---------------------------------------------------------------------*/

#include "xms.h"

#pragma inline

/* umballoc - request upper memory block
 */

unsigned int umballoc(unsigned int* size)
{
  _DX = *size;
  asm	xor	bl, bl
  asm	mov	ah, 0x10
  asm	call	dword ptr [xmscontrol]
  *size = _DX;
  asm	or	ax, ax
  asm	je	UMBAllocFailed
  asm	mov	xmserrno, 0
  return (_BX);
UMBAllocFailed:
  asm	mov	xmserrno, bl
  return (_AX);
}

/* umbfree - release upper memory block
 */

int umbfree(unsigned int umbseg)
{
  asm	mov	dx, umbseg
  asm	xor	bl, bl
  asm	mov	ah, 0x11
  asm	call	dword ptr [xmscontrol]
  asm	mov	xmserrno, bl
  return (_AX);
}

/* umbrealloc - reallocate upper memory block
 */

int umbrealloc(unsigned int umbseg, unsigned int* size)
{
  _BX = *size;
  asm	mov	dx, umbseg
  asm	mov	ah, 0x12
  asm	call	dword ptr [xmscontrol]
  asm	or	ax, ax
  asm	je	UMBReAllocFailed
  asm	mov	xmserrno, 0
  return (_AX);
UMBReAllocFailed:
  asm	mov	xmserrno, bl
  *size = _DX;
  return (_AX);
}