/*	IPXTCPCFG - address configuration for TCP via IPX
 *
 *	Jerzy Tarasiuk				12-Jul-91
 *
 *	Copyright (c) 1991, Jerzy Tarasiuk <JT@PLEARN>.
 *	Free software. You can use, redistribute it and/or modify
 *	it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <nwbindry.h>
#include <nwconn.h>

#define	cpleft	\
"IPXTCPCFG - address configuration for TCP via IPX\n\
Free software: NO WARRANTY. (c) 1991 <JT@PLEARN>.\n"
#define	usage	\
"\nIPXTCPCFG arguments:\n\
 arg1	database file name (NetWare node list)\n\
 arg2	gateway user name (as NetWare call gives)\n\
 arg3	configuration file name ()\n\
 arg4	name prefix (to precede station name)\n\
(look documentation for file format specification)\n\n\
Copyright (c) 1991, Jerzy Tarasiuk, <JT@PLEARN>\n\
Free software - you can use and redistribute it,\n\
see documentation in file READ.ME! for details.\n"

#define	mxconn	5	/* max # of NET connections to scan */
#define	mxinf	80
#define	mxnam	15
#define	mxbuf	256
#define	mxcwd	64
#define	local	static
#define	global

typedef	unsigned char	bool;
typedef	unsigned char	byte;
typedef	unsigned int	word;

local	bool	AdrIdn(ea1,ea2)
	byte	ea1[6],ea2[6];
{	int	i;
	for (i=0;i<6;i++)	if (ea1[i]!=ea2[i])	return	0;
        return	1;
}

local	bool	ChkLog(uinfo,uname)
	char	*uinfo,*uname;
{	word	conmax,conind,connum,uindx;
	bool	ckadr;
	byte	netadr[6],netnum[4],phyadr[6];
	WORD	cnnlst[mxconn],concnt,socket;
        ckadr=uinfo!=NULL;
	if (ckadr)	for (uindx=0;uindx<6;uindx++)
				sscanf(uinfo+2*uindx,"%2x",netadr+uindx);
	GetObjectConnectionNumbers(uname,OT_USER,&concnt,cnnlst,mxconn);
        if (!ckadr)	return	concnt>0;
	conmax=min(concnt,mxconn);
	for (conind=0;conind<conmax;conind++)
	{	connum=cnnlst[conind];
		GetInternetAddress(connum,netnum,phyadr,&socket);
		if (AdrIdn(phyadr,netadr))	return	1;
	}	if (concnt<=mxconn)	return	0;
	for (connum=cnnlst[mxconn-1]+1;connum<250;connum++)
	{	socket=0xFFFF;
		GetInternetAddress(connum,netnum,phyadr,&socket);
		if (socket!=0xFFFF)
                	if (AdrIdn(phyadr,netadr))	return	1;
	}	return	0;
}

local	void	Error(msg)	/* error message and exit */
	char	*msg;
{	printf("*** %s ***\n",msg);
	exit(4);
}

local	char	*Insert(cur,end,str)
	char	*cur,*end,*str;
{	char	tmp[mxbuf+1];
	int	lng;	lng=strlen(str);
	if (cur+lng>end)	Error("String buffer overflow.");
	strcpy(tmp,cur);	strcpy(cur,str);	cur+=lng;
	strcpy(cur,tmp);	return	cur;
}

local	void	NoFile(fname)
	char	*fname;
{	printf("Cannot open file: %s\n",fname);
	printf("Invoke without arguments for help.");
        exit(4);
}

local	void	UsageInfo(argc)	/* display usage help and exit */
	int	argc;
{	if (argc>1)	Error("Insufficient arguments (no arg = help).");
	printf(usage);	exit(0);
}

local	void	GetFarS(target,segment,offset,length)
	char	*target;	/* get string from far address	*/
        word	segment,offset,length;	/* any memory model	*/
{	word	index=0;
	while (index<length)
		*target++=peekb(segment,offset+index++);
}

local	bool	IpxPkt(vect)	/* verify packet driver name="IPX"	*/
{	union	REGS	r;	/* don't work with some old drivers	*/
	struct	SREGS	s;	/* (specs 1.07 and before, probably	*/
        char	n[5];	n[4]=0;	/*  no such IPXPKT driver existed)	*/
	segread(&s);	r.x.ax=0x01FF;	r.x.bx=0xFFFF;
        int86x(vect,&r,&r,&s);
        if (r.x.flags&1)	return	0;        /* if old driver - bad */
        GetFarS(n,s.ds,r.x.si,4);
/*      printf("Packet driver: \"%s\"\n",n);
	printf("version %5d, type %5d, class %3d, number %3d, funct %1d\n",
	n,r.x.bx,r.x.dx,r.h.ch,r.h.cl,r.h.al,-1);	*/
        return	!strcmp(n,"IPX");	/* 1 (=OK) if IPXPKT driver */
}

local	bool	GetVect(vect)	/* look for IPXPKT or free vector */
	int	*vect;
{	word	vs2,vec,vps,vpo,vfr=0;
	char	tmp[13];	tmp[12]='\0';
	for (vec=0x60;vec<=0x80;vec++)	/* scan 0x60..0x80 (inclusive) */
        {	vs2=vec<<2;
        	vps=peek(0,vs2+2);
        	vpo=peek(0,vs2);
		if (!(vps|vpo))	/* unused vector - save number as free */
                {	if (!vfr)	vfr=vec;	continue;	}
                GetFarS(tmp,vps,vpo,12);	/* get possible signature */
                if (strcmp(tmp+3,"PKT DRVR"))	continue;	/* .. bad */
		if (IpxPkt(vec))	/* IPXPKT driver at this vector */
                {	*vect=vec;	return	1;	}
        }	*vect=vfr;	return	0;	/* no driver found */
}

local	char	name[mxnam+1];	/* local computer name */
local	word	myconn;		/* server connection name */

local	int	GetNumb(fname,gwusr)
	char	*fname,*gwusr;	/* assign unique number for computer */
{	byte	phyadr[6];	/* and check if gateway is available */
	char	uinfo[mxinf+1],*uiptr;
	FILE	*users;
        int	numb=0,temp,mxun=1,lookgw=1;
	myconn=GetConnectionNumber();
	if (!myconn)	Error("Non-network komputer or net fault.");
	if ((users=fopen(fname,"rt"))==NULL)	return	0;
	GetStationAddress(phyadr);
	sprintf(name,"%2.2x%2.2x%2.2x%2.2x%2.2x%2.2x ",
		phyadr[0],phyadr[1],phyadr[2],phyadr[3],phyadr[4],phyadr[5]);
	while (fgets(uinfo,mxinf,users)!=NULL)	/* scan database */
	{ uiptr=uinfo; while (*uiptr==' ') uiptr++;
          while (*uiptr!='\0')	if (*++uiptr==' ')	break;
          while (*uiptr==' ') *uiptr++='\0';
          if (sscanf(uinfo,"%d",&temp))
	    if (temp)
	      if (temp==1)
		{ if (lookgw)	if (ChkLog(uiptr,gwusr))	lookgw=0;
				else				lookgw=-1;
                }
              else	if (!strncmpi(name,uiptr,13))
		{ numb=temp; strncpy(name,uiptr+13,mxnam); name[mxnam]='\0';
		  for (temp=0;name[temp]!='\0';temp++)
                    if (name[temp]==' ') name[temp]='_';
		      while (temp--)	if (name[temp]!='_')	break;
					else	name[temp]='\0';
		}	else	mxun=max(mxun,temp);
	}
        if (lookgw>0)	if (ChkLog(NULL,gwusr))	lookgw=0;
        if (lookgw)	Error("Gateway not logged on.");
        if (ferror(users))	/* check for file read error */
	{	perror("IPXTCPCF user list");
		exit(4);
	}	fclose(users);
	if (!numb)	numb=mxun+myconn; /* if not found in database */
       	return	numb;
}

local	bool	pktf;
local	int	numb,vect;

local	void	Configure(cfgname,prfx)
	char	*cfgname,*prfx;
/*
 *	The "configuration" means creating several files which names
 *	are specified in the configuation file, in current directory.
 *	The data for them is also in the configuration file.
 *	After it is read, each line is scanned for special sequences
 *	which, if found, are processed before writing the line.
 *	$$ - put $ here
 *	$c - ignore remainder of this line (comment)
 *	$d - put current directory here
 *	$f - open new output file
 *	$l - write line if !pktf
 *	$n - put name here
 *	$i - put numb here
 *	$v - put vect here
 */
{	FILE	*cfg,*out;	bool	wrt;
	char	act,buf[mxbuf+1],cod[9],cwd[mxcwd+1],*cur,*end,*tmp;
	end=buf+mxbuf;	if (getcwd(cwd,mxcwd)==NULL)	Error("Cannot GetDir.");
	if ((out=fopen("CON","wt"))==NULL)	Error("Cannot write to CON");
	if ((cfg=fopen(cfgname,"rt"))==NULL)       	NoFile(cfgname);
	while ((fgets(buf,mxbuf,cfg))!=NULL)
	{	cur=buf;
		for (wrt=1;(cur=strchr(cur,'$'))!=NULL;)
		{	strcpy(cur,cur+1);
                       	if ((act=*cur)=='$')
			{	cur++;	continue;	}
			strcpy(cur,cur+1);
                       	switch (act)
			{ case 'c':	wrt=cur!=buf;
					*cur++='\n';	*cur='\0';
					break;
                          case 'd':	cur=Insert(cur,end,cwd);
                			break;
			  case 'f':	goto	reopen;
			  case 'l':	wrt=!pktf;
					break;
			  case 'n':	cur=Insert(cur,end,prfx);
					cur=Insert(cur,end,name);
					break;
			  case 'i':	sprintf(cod,"%d",numb);
					cur=Insert(cur,end,cod);
					break;
                          case 'v':	sprintf(cod,"0x%2.2X",vect);
					cur=Insert(cur,end,cod);
					break;
                          default:	Error("Bad config file.");
                        }
                }
		if (wrt) fputs(buf,out);
                continue;
	reopen:	fclose(out);
/*		cur+=strspn(cur," ");
                if (*(tmp=cur+strlen(cur)-1)=='\n')	*tmp='\0';
 */		*cur='\0';
                printf("Creating \"%s\".\n",buf);
		if ((out=fopen(buf,"wt"))==NULL)
        		Error("File creation error.");
        }	fclose(out);
}

global	void	main(argc,argv)
	int	argc;
	char	*argv[];
/*
 *	argv[0]	program name (not used)
 *	argv[1]	database file name
 *	argv[2] gateway user name
 *	argv[3]	configuration file name
 *	argv[4]	name prefix (optional)
 */
{	printf(cpleft);	pktf=GetVect(&vect);
	if (!vect)	Error("No vector for packet driver.");
/*	if (!pktf)	printf("Load ");
	printf("IPX packet driver at vector 0x%2.2x\n",vect);	*/
	if (argc<4)	UsageInfo(argc);
	numb=GetNumb(argv[1],argv[2]);
	if (!numb)	NoFile(argv[1]);
/*	printf("numb=%3.3d, name=\"%s\"\n",numb,name);	*/
        if (argc>4)	Configure(argv[3],argv[4]);
        else		Configure(argv[3],"");
}
