include ppp.asi

; XBUFFER = 1

PPPINITFCS = 0ffffh
PPPGOODFCS = 0f0b8h

PPPMAXPACKET = 16384
PPPPACKHEADSIZE = 16

PPP_PACKETFLAG =07eh
PPP_CONTROLFLAG =07dh

ST_NOTHING = 0
ST_EXPECT3 = 1
ST_PROT1 = 2
ST_PROT2 = 3
ST_DATA = 4

	public EncodePacket, DecodePacketByte, FetchPacketByte
	public GetBuffer, FreeBuffer, xltabxmit, xltabrcv, 
	public packetflags, StartXmit
	public pppdown,xmittop,xmitbot,xmitbuf,FetchPacketByte
	public DecodePacketInit, ClearAllBufs, RemoveRecvBuffer
	public buffers, rcvptrs
	extrn ProcessPPPPacket : PROC, IsXmitDone : PROC, vjerror : PROC
	extrn SendFirstByte :PROC, LCPDown : PROC
	extrn stat_packrcvd:PROC, stat_packxmit:PROC
	extrn stat_bytercvd:PROC, stat_bytexmit:PROC
	extrn stat_errrcvd:PROC,stat_errxmit:PROC,stat_packlost:PROC
	extrn asyncbuf : PROC, asyncdrop : PROC, nocts : byte
	extrn logsend : PROC, commport : word, receiveddispatch : byte
	extrn clflags : word
CGROUP group TSR,CONFIG
	assume cs:cgroup,ds:cgroup

TSR segment word public 'CODE'
;
; this is the standard table for calculating the FCS bytes
;
fcstab LABEL WORD
	dw      00000h, 01189h, 02312h, 0329bh, 04624h, 057adh, 06536h, 074bfh
	dw      08c48h, 09dc1h, 0af5ah, 0bed3h, 0ca6ch, 0dbe5h, 0e97eh, 0f8f7h
	dw      01081h, 00108h, 03393h, 0221ah, 056a5h, 0472ch, 075b7h, 0643eh
	dw      09cc9h, 08d40h, 0bfdbh, 0ae52h, 0daedh, 0cb64h, 0f9ffh, 0e876h
	dw      02102h, 0308bh, 00210h, 01399h, 06726h, 076afh, 04434h, 055bdh
	dw      0ad4ah, 0bcc3h, 08e58h, 09fd1h, 0eb6eh, 0fae7h, 0c87ch, 0d9f5h
	dw      03183h, 0200ah, 01291h, 00318h, 077a7h, 0662eh, 054b5h, 0453ch
	dw      0bdcbh, 0ac42h, 09ed9h, 08f50h, 0fbefh, 0ea66h, 0d8fdh, 0c974h
	dw      04204h, 0538dh, 06116h, 0709fh, 00420h, 015a9h, 02732h, 036bbh
	dw      0ce4ch, 0dfc5h, 0ed5eh, 0fcd7h, 08868h, 099e1h, 0ab7ah, 0baf3h
	dw      05285h, 0430ch, 07197h, 0601eh, 014a1h, 00528h, 037b3h, 0263ah
	dw      0decdh, 0cf44h, 0fddfh, 0ec56h, 098e9h, 08960h, 0bbfbh, 0aa72h
	dw      06306h, 0728fh, 04014h, 0519dh, 02522h, 034abh, 00630h, 017b9h
	dw      0ef4eh, 0fec7h, 0cc5ch, 0ddd5h, 0a96ah, 0b8e3h, 08a78h, 09bf1h
	dw      07387h, 0620eh, 05095h, 0411ch, 035a3h, 0242ah, 016b1h, 00738h
	dw      0ffcfh, 0ee46h, 0dcddh, 0cd54h, 0b9ebh, 0a862h, 09af9h, 08b70h
	dw      08408h, 09581h, 0a71ah, 0b693h, 0c22ch, 0d3a5h, 0e13eh, 0f0b7h
	dw      00840h, 019c9h, 02b52h, 03adbh, 04e64h, 05fedh, 06d76h, 07cffh
	dw      09489h, 08500h, 0b79bh, 0a612h, 0d2adh, 0c324h, 0f1bfh, 0e036h
	dw      018c1h, 00948h, 03bd3h, 02a5ah, 05ee5h, 04f6ch, 07df7h, 06c7eh
	dw      0a50ah, 0b483h, 08618h, 09791h, 0e32eh, 0f2a7h, 0c03ch, 0d1b5h
	dw      02942h, 038cbh, 00a50h, 01bd9h, 06f66h, 07eefh, 04c74h, 05dfdh
	dw      0b58bh, 0a402h, 09699h, 08710h, 0f3afh, 0e226h, 0d0bdh, 0c134h
	dw      039c3h, 0284ah, 01ad1h, 00b58h, 07fe7h, 06e6eh, 05cf5h, 04d7ch
	dw      0c60ch, 0d785h, 0e51eh, 0f497h, 08028h, 091a1h, 0a33ah, 0b2b3h
	dw      04a44h, 05bcdh, 06956h, 078dfh, 00c60h, 01de9h, 02f72h, 03efbh
	dw      0d68dh, 0c704h, 0f59fh, 0e416h, 090a9h, 08120h, 0b3bbh, 0a232h
	dw      05ac5h, 04b4ch, 079d7h, 0685eh, 01ce1h, 00d68h, 03ff3h, 02e7ah
	dw      0e70eh, 0f687h, 0c41ch, 0d595h, 0a12ah, 0b0a3h, 08238h, 093b1h
	dw      06b46h, 07acfh, 04854h, 059ddh, 02d62h, 03cebh, 00e70h, 01ff9h
	dw      0f78fh, 0e606h, 0d49dh, 0c514h, 0b1abh, 0a022h, 092b9h, 08330h
	dw      07bc7h, 06a4eh, 058d5h, 0495ch, 03de3h, 02c6ah, 01ef1h, 00f78h

;
; control character translation table, all control chars must be xlated for now
; control chars may be negotiated with LCP
;
xltabxmit db	0ffh,0ffh,0ffh,0ffh
xltabrcv db	0,0,0,0

xmitfcs	dw	0		; FCS sum for transmit
rcvfcs	dw	0		; FCS sum for receive
packetflags dw PF_XMITSEPERATOR	; flags for modes
rcvstate	dw	ST_NOTHING	; state the receiver is in
protocol dw	0		; received protocol

xmitbuf db	MRU + 6 DUP (?)	; main XMIT buffer
buffers	BUFFER	MAXBUF DUP (<>)	; temp buffers
xmitholdbuf	BUFFER ?	; xmit holding buffer

rcvptrs dw	MAXBUF DUP (?)	; pointers to received buffers
rcvcnt	dw	0		; number of buffers that are receive buffers
xmittop dw	0		; end of current transmit or zero for none
xmitbot	dw	cgroup:xmitbuf	; next char to transmit
rcvbufp	dw	0		; pointer to receive buffer
rcvbufv dw	0		; pointer to a receive buffer
firststartflag db 0		; Set true after first start flag is received
ifdef XBUFFER
xbuf	db	1700 DUP (?)
xbp	dw	offset cgroup:xbuf
acnt	dw	0
abuf	db	1700 DUP (?)
endif

;
; Routine to insert a buffer into the received queue
;
InsertRecvBuffer PROC
	mov	bx,[rcvcnt]	; get counter
	shl	bx,1		; *2
	mov	[rcvptrs+bx],si	; save value
	inc	[rcvcnt]	; inc counter
	ret
InsertRecvBuffer ENDP
;
; routine to get the next receive buffer out of the queue
;
RemoveRecvBuffer PROC
	mov	cx,[rcvcnt]	; get counter
	or	cx,cx		; is zero?
	stc			; err if so
	jz 	rrb_x		; and get out
	push	[rcvptrs]	; otherwise push first pointer
	dec	cx		; decrement
	mov	[rcvcnt],cx	; save new value
	jz	rrb_x2		; out if now zero
	mov	si,offset cgroup:rcvptrs	; else move data down
	mov	di,si		;
	inc	si
	inc	si
	rep	movsw
rrb_x2:
	pop	si		; get buffer pointer into si
	clc
rrb_x:
	ret	
RemoveRecvBuffer ENDP

;
; routine to find a free buffer
;
GetBuffer	PROC
	mov	si,offset cgroup:buffers	; SI = first buffer
	mov	cx,MAXBUF		; cx = total
gbl:
	test	[si].buflags,BU_INUSE	; buffer in use?
	jz	gotbuf			; no, return it
	add	si,size BUFFER	; else next buffer
	loop	gbl			; loop till done
	stc				; no buffers
	ret
gotbuf:
	mov	[si].buflags,BU_INUSE	; mark it in use
	mov	[si].bulen,0		; length = 0
	mov	[si].buprot , 0		; protocol = 0
	ret
GetBuffer	ENDP
;
; free a buffer when done
;
FreeBuffer PROC
	mov	[si].buflags,0
	clc
	ret
FreeBuffer ENDP
;
; clear all buffers
;
ClearAllBufs PROC
	mov	si,offset cgroup:buffers	; SI = first buffer
	mov	cx,MAXBUF		; cx = total
cabl:
	call	FreeBuffer
	add	si,size BUFFER
	loop	cabl
	ret	
ClearAllBufs ENDP
;
; copy data to an internal buffer and start a transmission if necessary
;
StartXmit	PROC
	push	ax
	push	si
	push	cx
sxl:
	test	[packetflags],PF_SYNCXMITREADY
	jz	StartXmitCont
	test	[nocts],0ffh 	; dump the last packet if CTS not asserted
	jnz	startxmitcont
	call	IsXmitDone
	jz	Sxl
	call	SendFirstByte
	jmp	Sxl

startxmitcont:
	pop	cx
	pop	si
	pop	ax
	mov	di,offset cgroup:xmitholdbuf
	push	di
	mov	[di].bulen,cx		; else set up params
	or	[di].buflags,BU_XMIT
	mov	[di].buprot,ax
	lea	di,[di].bubuf
	rep	movsb			; move the data to our buf
	pop	di
	cli
	or	[packetflags],PF_SYNCXMITREADY
	or	[receiveddispatch],TRANSMIT_HANDLING
	sti
	call	IsXmitDone
	jz	sxd
	push	di
	call	SendFirstByte		; send a byte
	pop	di
	clc
sxd:
	pushf
	and	[receiveddispatch],NOT TRANSMIT_HANDLING
	popf
	ret
StartXmit	ENDP
;
; procedure to test the bit in the hardware translation tab
;
testxlate	PROC
	push	ax		; 8th bit is don't care
;	and	al,07fh
	cmp	al,20h
	jnc	xlok
	push	dx
	mov	dl,1		; dl = bit mask
	mov	cl,al
	and	cl,7
	shl	dl,cl
	mov	bl,al		; bx = pointer to byte
	shr	bl,3
	sub	bh,bh
	test	[bx+di],dl	; test the value
	pop	dx
	pop	ax
	ret
xlok:
	pop	ax
	sub	ah,ah
	ret
testxlate	ENDP
;
; get the next byte to transmit
;
FetchPacketByte PROC
	test	[packetflags],PF_XMITSEPERATOR ; see if is first packet
	jz	fpnotfirst
	mov	al,PPP_PACKETFLAG	; if so send a seperator
	and	[packetflags],NOT PF_XMITSEPERATOR ; and mark gone
	ret
fpnotfirst:
	mov	si,[xmitbot]		; see if data left in buf
	cmp	si,[xmittop]
	jc	fpbok
	mov	[xmittop],0		; no, assume done
	
	test	[packetflags],PF_PKTASYNC
	jz	fpnodrop
	call	asyncdrop
	and	[packetflags],NOT PF_PKTASYNC

fpnodrop:
	test	[packetflags],PF_SYNCXMITREADY  ; see if sync xmit ready
	mov	si,offset cgroup:xmitholdbuf	; assume so
	jnz	fpgotbuf			; yes, got it
	push	ds
	call	asyncbuf			; see if have async
	jnc	fpgotasync			; yes, do it
	pop	ds
	stc					; else nothing
	ret
fpgotasync:
	or	[packetflags],PF_PKTASYNC
	call	EncodePacket
	pop	ds
	call	logsend
	call	stat_packxmit
	jmp	fpbjn
fpgotbuf:
	push	si
	mov	cx,[si].bulen		; now we have found an xmit buf
	mov	dx,[si].buprot
	lea	si,[si].bubuf		; so get the length
	call	EncodePacket
	call	logsend
	call	stat_packxmit
	pop	si			; free the buffer
	and	[packetflags],NOT PF_SYNCXMITREADY
fpbjn:
	mov	[xmitbot],offset cgroup:xmitbuf		; set up the transmit fields
	add	ax,offset cgroup:xmitbuf
	mov	[xmittop],ax
fpbok:
	test	[packetflags],PF_XMITCONTROL
	jz	fpnopriorcontrol
	and	[packetflags],NOT PF_XMITCONTROL
	mov	si,[xmitbot]
	inc	[xmitbot]
	lodsb
	cmp	si,[xmittop]
	jc	fcnz
	mov	[xmittop],0
	or	[packetflags],PF_XMITSEPERATOR ; mark to send out packet sep
fcnz:
	call	stat_bytexmit
	xor	al,020h
	ret


fpnopriorcontrol:
	mov	si,[xmitbot]		; get a char and return
	lodsb
	test	al,al    	; 8th bit set, no extend
	js	fp_noextend
	cmp	al,7dh      	; greater than or equal 7dh do extend
	jnc	fp_extend
	cmp	al,20h		; less than 20h conditional extend
	jnc	fp_noextend	; else no extend
fp_chkextend:
	mov	di,offset cgroup:xltabxmit
	call	testxlate
	jz	fp_noextend
fp_extend:
	or	[packetflags],PF_XMITCONTROL
	mov	al,PPP_CONTROLFLAG ; put out control flag
	dec	si
fp_noextend:
	mov	[xmitbot],si
	cmp	si,[xmittop]
	jc	nosep
	mov	[xmittop],0
	or	[packetflags],PF_XMITSEPERATOR ; mark to send out packet sep
nosep:
	call	stat_bytexmit
	clc
	ret
FetchPacketByte	ENDP
;
; handle FCS calculation of a byte
; note that the PPP control flags are NOT counted as part of the calculation
;
encode_fcs	PROC
	stosb			; save character
; calculate FCS for xmit
	mov	bl,byte ptr [xmitfcs]
	xor	bl,al
	sub	bh,bh
	shl	bx,1
	mov	bx,[bx + fcstab]
	xor	bl,byte ptr [xmitfcs+1]
	mov	[xmitfcs],bx
	ret
encode_fcs	ENDP
;
; recieve a char, calculate FCS.  Translate is done in interrupt routine
;
decode_fcs Proc
	mov	bl,byte ptr [rcvfcs]
	xor	bl,al
	sub	bh,bh
	shl	bx,1
	mov	bx,[bx + fcstab]
	xor	bl,byte ptr [rcvfcs+1]
	mov	[rcvfcs],bx
	ret
decode_fcs Endp
;
; encode a packet, encodes entire packet at once
;
; si = packetp
; cx = packetlen
; dx = protocol
;

EncodePacket PROC
	mov	[xmitFCS],PPPINITFCS	; init the FCS
	mov	di,offset cgroup:xmitbuf	; put it in xmit buffer
ep_notfirst:
	and	[packetflags],NOT PF_NOCOMPRESS ; get the compression status
    	cmp	dx,0c000h		; not compressing anything in this class
					; although this is looser than the specs say
	jc	ep_compressable		; compressable,
	or	[packetflags],PF_NOCOMPRESS ; not compresable
ep_compressable:
	test	[packetflags],PF_XMITADRCOMPRESS ; see if address ompression
	jz	ep_noadrcompress
	test	[packetflags],PF_NOCOMPRESS	; yes, but only if compressing
					; (specs aren't specific, just do it this way)
	jz	ep_adrcompress
ep_noadrcompress:
	mov	al,0ffh			; two address bytes
	call	encode_fcs
	mov	al,3
	call	encode_fcs
ep_adrcompress:
	test	[packetflags],PF_XMITPROTOCOMPRESS ; protocol compression?
	jz	ep_noprotocompress	; no
	test	[packetflags],PF_NOCOMPRESS ; yes but only if compressing
	jnz	ep_noprotocompress
	or	dh,dh             	; hack, this isn't sufficient in the general case
	jnz	ep_noprotocompress
	mov	al,dh			; ok, do compression
	add	al,dl
	call	encode_fcs
	jmp	ep_fcs
ep_noprotocompress:
	mov	al,dh			; no compression, do it out full
	call	encode_fcs
	mov	al,dl
	call	encode_fcs
ep_fcs:
	lodsb				; now move all the data
	call	encode_fcs
	loop	ep_fcs
	mov	ax,word ptr [xmitfcs]   ; now move the FCS
	not	ax			; has to be inverted
	stosw				; yes store little-endian
	mov	ax,di
	mov	di,offset cgroup:xmitbuf
	sub	ax,di
	ret
EncodePacket ENDP


; al = char
;
DecodePacketInit PROC
	mov	si,[rcvbufv]
	or	si,si
	jnz	dpi_gotbuf
	call	GetBuffer
	jc	dpi_nobuf
	mov	[rcvbufv],si
dpi_gotbuf:
	and	[packetflags], NOT PF_CONTROLCHAR
	mov	[rcvstate],ST_NOTHING
	mov	[rcvfcs],PPPINITFCS
	lea	si,[si].bubuf
	mov	[rcvbufp],si
ifdef XBUFFER
;	mov	[xbp],offset cgroup:xbuf
endif
dpi_nobuf:
	ret
dp_lostpack:
	jmp	vjerror
DecodePacketInit ENDP
ifdef XBUFFER
insxbuf PROC
	mov	di,[xbp]
	stosb
	cmp	di,offset cgroup:xbuf+1700
	jc	insxx
   	mov	di,offset cgroup:xbuf
insxx:
	mov	[xbp],di
	ret
insxbuf ENDP
endif
;
; decodes a packet.  Called from the receive interrupt, one char at a time,
; and is thus implmemnted as a state machine
;
DecodePacketByte PROC
	test	[clflags],X_OPTION	; xon/xoff enabled?
	jz	dpb_noxonxoff		; no continue
	cmp	al,13h			; XOFF?
	jnz	dpb_notxoff		; no check for xon
	or	[nocts],1		; else mark it
	ret
dpb_notxoff:
	cmp	al,11h			; XON?
	jnz	dpb_noxonxoff		; no, continue with processing
	mov	[nocts],0		; else turn it on
	call	FetchPacketByte		; get a byte
	jc	dpb_noxonsend		; get out if no data to send
	mov	dx,[commport]		; get the comm port
	out	dx,al			; out the data
dpb_noxonsend:
	ret
dpb_noxonxoff:
	test	[rcvbufv],0ffffh	; see if have a buffer
	jnz	dpb_gotbuf		; got one, continue
	push	ax
	call	DecodePacketInit	; resync & try getting a buf
	pop	ax
	test	[rcvbufv],0ffffh	; got one now?
	jnz	dpb_gotbuf		; yes, continue
	mov	[firststartflag],0	; ignore till packet flag
	ret
dpb_gotbuf:
ifdef XBUFFER
	call	insxbuf
endif
	test	[firststartflag],0ffh	; anything received yet?
	jnz	decodestart		; yes, go ahead and decode
	cmp	al,PPP_PACKETFLAG	; else wade until we get a packet flag
	jnz	nodecode
	or	[firststartflag],1	; got one, ready to start decoding
	call	DecodePacketInit
nodecode:
	ret

decodestart:
	call	stat_bytercvd
	mov	di,offset cgroup:xltabrcv
	call	testxlate		; is character hardware control?
	jz	dpnoignore		; no, process it
	ret				; else ignore it
dpnoignore:
	test	[packetflags],PF_CONTROLCHAR; was last char a PPP_CONTROL?
	jz	dpc1			; no, continue
	cmp	al,PPP_PACKETFLAG	; check for packet flag after cont flag
	jnz	dpc0			; no, things are ok
	call	vjerror
	jmp	DecodePacketInit	; else reinit
dpc0:
	xor	al,20h			; yes, update this char
	jmp	dpc2			; and continue
dpc1:
	cmp	al,PPP_CONTROLFLAG	; else see if is control flag
	jnz	dpc2			; no, continue
	or	[packetflags],PF_CONTROLCHAR; mark it.
	ret
dpc2:
	cmp	[rcvstate],ST_NOTHING	; see if can be packet flag at start
	jnz	dp_nsn			; no, continue
	cmp	al,PPP_PACKETFLAG	; else is packet flag
	jnz	dpb_firstchr		; no, continue
	jmp	DecodePacketInit
dpb_firstchr:
	cmp	al,0ffh			; is it?
	jz	dpbexp3 			; yes, now need a 3
	jmp	dp_protbyte		; else continue with protocol byte
dpbexp3:
	call	decode_fcs		; expecting address
	mov	[rcvstate],ST_EXPECT3	; expecting a 3
	and	[packetflags],NOT PF_CONTROLCHAR ; kill this mode
	ret
dp_nsn:
	cmp	[rcvstate],ST_EXPECT3	; are we expecting the 3 after the address?
	jnz	dp_ns3			; no continue
	cmp	al,3
	jz	dp_3cont
	call	DecodePacketInit	; resync
	mov	[firststartflag],0	; ignore till packet flag
	call	vjerror
	jmp	stat_packlost
dp_3cont:
	call	decode_fcs		; else check for it
	mov	[rcvstate],ST_PROT1	; else got a three, expect protocol now
	and	[packetflags],NOT PF_CONTROLCHAR ; kill this mode
	ret
dp_ns3:
	cmp	[rcvstate],ST_PROT1	; are we expecting first protocol?
	jnz	dp_np1			; no, continue
dp_protbyte:
	call	decode_fcs		; get char
	test	al,1			; see if is compressed
	jz	dp_prot		  	; no, save it	
	sub	ah,ah			; yes, save it as compressed
	xchg	al,ah
	mov	[protocol],ax
	mov	[rcvstate],ST_DATA	; and go on to data phase
	and	[packetflags],NOT PF_CONTROLCHAR ; kill this mode
	ret
dp_prot:
	mov	byte ptr [protocol+1],al	; not compressed, must get 2nd byte
					; remember endianness!!!!
	mov	[rcvstate],ST_PROT2
	and	[packetflags],NOT PF_CONTROLCHAR ; kill this mode
	ret
dp_np1:
	cmp	[rcvstate],ST_PROT2	; expecting 2nd protocol byte?
	jnz	dp_np2			; no, continue
	call	decode_fcs		; yes, save it
	mov	byte ptr [protocol],al
	mov	[rcvstate],ST_DATA	; and go to data state
	and	[packetflags],NOT PF_CONTROLCHAR ; kill this mode
	ret
dp_np2:
	cmp	[rcvstate],ST_DATA	; expecting data
	jz	dp_data			; yes do it
	call	vjerror
	jmp	DecodePacketInit	; Else resynching, reinit receiver
dp_data:
	cmp	al,PPP_PACKETFLAG	; see if we have the packet flag
	jz	dp_dataend		; if so, end of data
dp_dodata:
	and	[packetflags],NOT PF_CONTROLCHAR ; kill this mode
	call	decode_fcs		; else decode it
	mov	di,[rcvbufp]		; save it
	stosb
	inc	[rcvbufp]		; and index to next byte
	ret
dp_dataend:
	test	[packetflags],PF_CONTROLCHAR ; 7d 5d is treated as data
	jnz	dp_dodata
	mov	di,[rcvbufp]		; done, get buffer pointer
	sub	di,2			; get rid of FCS bytes
	mov	bx,[rcvfcs]		; get the final FCS
ifdef XBUFFER
	push	[xbp]
endif
	cmp	bx,PPPGOODFCS		; see if FCS matches
	jnz	dp_badrcv		; no, error
ifdef XBUFFER
	add	sp,2
endif
	call	stat_packrcvd
	mov	si,[rcvbufv]		; get buffer variable
	lea	bx,[si].bubuf 		; get beginning of buf
	sub	di,bx			; length
	mov	[si].bulen,di		; save it
	mov	ax,[protocol]		; save the protocol in the
	mov	[si].buprot,ax		; received buffer
	call	InsertRecvBuffer		; insert it so we can grab it at
					; end of interrupt
	mov	[rcvbufv],0		; don't reuse buffer
	jmp	DecodePacketInit	; Now Reinit
dp_badrcv:
	call	DecodePacketInit	; Reinit
ifdef XBUFFER
;	mov	si,offset cgroup:xbuf
	pop	cx
;	sub	cx,si
;	mov	[acnt],cx
;	mov	di,offset cgroup:abuf
;	rep	movsb
endif
	call	vjerror
	jmp	stat_errrcvd
DecodePacketByte ENDP

; Actually, the modem has gone offline
;
PPPDown PROC
	call	ClearAllBufs
	call	LCPDown
	ret
PPPDown ENDP
TSR	ENDS
CONFIG	segment word public 'CODE'
CONFIG	ENDS
	end