REM  Download Fixed Pitch fonts to LaserJet printer
@echo OFF
REM Syntax is:  LOADFNTS  [Device]

cls

:: ========================================
:: Allow user to specify alternative Output Device on command line
:: Use PRN as default when no device given
set DEVOUT=%1
if '.%DEVOUT%' == '.' set DEVOUT=PRN

:: Check Source Directory for fonts

REM  Development directory - where files are created
:: set SD=F:\PC\FONT\LJFONT\OUTPUT

REM  Current directory - where the files normally reside on User's machine
::
set SD=.
if not exist %SD%\HV6X12.SFP goto :NoFontFiles

:: ========================================
echo.
echo Downloading HVLJFonts to LASERJET Printer
call RESETLJ.BAT %DEVOUT%
echo Printer INITIALIZATION completed
echo.

:: ========================================
REM 50cpi
call LOADFONT.BAT 1 %SD%\HV6X12.SFP %DEVOUT%

REM  20cpi
call LOADFONT.BAT 2 %SD%\HV15X30.SFP %DEVOUT%

REM  18.75cpi
call LOADFONT.BAT 3 %SD%\HV16X34.SFP %DEVOUT%

REM  8.33cpi
call LOADFONT.BAT 4 %SD%\HV36X72.SFP %DEVOUT%


REM  8x16 font not included in Evaluation
if not exist %SD%\HV8X16.SFP goto :EvalOnly

REM These fonts only included in Licenced version

REM  37.5cpi
call LOADFONT.BAT 5 %SD%\HV8X16.SFP %DEVOUT%

REM  30cpi
call LOADFONT.BAT 6 %SD%\HV10X20.SFP %DEVOUT%

REM  25cpi
call LOADFONT.BAT 7 %SD%\HV12X24.SFP %DEVOUT%

REM  16.67cpi
call LOADFONT.BAT 8 %SD%\HV18X36.SFP %DEVOUT%

REM  15cpi
call LOADFONT.BAT 9 %SD%\HV20X44.SFP %DEVOUT%

REM  12.5cpi
call LOADFONT.BAT 10 %SD%\HV24X52.SFP %DEVOUT%

REM  10cpi
call LOADFONT.BAT 11 %SD%\HV30X60.SFP %DEVOUT%

:EvalOnly

echo.
echo SOFT FONT DOWNLOAD COMPLETED!
echo.
echo These PCL Bitmapped HVLJFonts are Copyrighted Material.
echo They may only be used on machines for which you have purchased 
echo a user licence from Procon Construction Systems.
echo.
goto :DONE

:: ========================================
:NoFontFiles
echo.
echo Font Files not in this directory.  No fonts downloaded.
:DONE
set DEVOUT=
set SD=
:: ========================================

