TPI()                                                                  TPI()


NAME
       tpi - prepare a test file for printing with optional borders
             and extremely flexible formatting styles.

SYNOPSIS

       tpi [-rnlxbtsfhpo?PLTARGFV] [filename] [@inifilename]

DESCRIPTION

       TPI is a program that will print text files in an orderly 
       fashion to standard output or to a file.  Several formatting 
       options are available on the command line or in the form of 
       a (.INI) file.
       
       TPI will by default read a .INI file called TPI.INI for the 
       standard settings. The .INI file must reside in the same 
       directory as the TPI.EXE.  If the file is not found an error 
       will be produced. 
       
       You may override the default .INI file settings by specifying an 
       alternate .INI file on the command line.
       
       Any parameter that is given on the command line will override 
       the corresponding .INI file setting.  This feature is useful 
       for testing adjustments for permanent modifications to the 
       default .INI file or for special cases.
        
OPTIONS

   -T<string>: Header String

       string: is a text string to be placed in the header of each 
               page if the header contains spaces or command line 
               control characters it must be enclosed in double 
               quotes (ie -T"My Header").  The default behavior is 
               to have no header.  To include the header simply
               define one.

   -t<string>: Footer String.  Footer text is not allowed in a type 0
               footer.

       string: same as -T

   -F<string>: Left justified footer string for use in a Type 2 
               footer

       string: same as -T

   -l<value> : Left Side of Box Position

        value: is a decimal integer that controls the position of 
               the left side of the print box.

   -r<value> : Right Side of Box Position

        value: is a decimal integer that controls the position of 
               the right side of the print box. Note that the value 
               must be greater than the value given with the '-l' 
               option.

   -f<value> : Footer Style

        value: is a decimal integer that controls the style of the footer.
               0 ==> Filename, Date (default)
               1 ==> Display only text in '-t' option 
               2 ==> Display only text in '-t' option and left
                     justified FooterLeft .INI tag or '-F' option.

   -L<value> : Lines Per Page

        value: is a decimal integer that controls how long the page to
               be printed will be

   -b<value> : Box Line Type

        value: is a single digit and must be 0, 1, or 2 which determines
               what type of box is to be drawn around the listing.
                 0 ==> Simple header and footer lines only
                 1 ==> Single line box (requires extended PC character set)
                 2 ==> Double line box (requires extended PC character set)
                 3 ==> No borders whatsoever

   -R<range> : Print only a page range from the full set

        range: The range format consists of a dual number set "(n1,n2)" that
               will print pages n1 through n2 inclusive (i.e. -R(123,125)).
               To print a single page, start and end The range on the same 
               number.

   -A<range> : Adjust for Tab Settings

        range: the tab stops are entered in the same format as the -R settings.
               The most common setting is -A(9,17).  This will properly 
               process default tabs (eight characters) for most computers.  
               If you use three character tabs a setting of -A(4,7) is useful.

   -G<string>: .INI file sup-group name

       string: the string should correspond to a group defined as [string] 
               in the .INI file in use.  If the group is located,  The 
               parameters within the group will be processed

   -s        : Read the file from standard input

               The file will be read from standard input as opposed 
               to being read from a file

   -x        : Toggle IBM-PC High Characters (Box Characters & such)
               
               The default operation of TPI is to strip all but strict ASCII
               characters.  If this switch is set TPI will toggle the
               ability to pass high order characters as normal ASCII.  
               Setting this parameter in the command line will toggle 
               the state defined by the default or the EnableHighChar .INI 
               parameter.

   -n        : Toggle line numbering setting

               The default setting is to place line numbers on all of 
               the input lines.  The .INI parameter EnableLineNum can 
               turn this feature off or on.  This command parameter will 
               toggle the default and .INI state of the line numbering 
               feature.

   -p        : Toggle page breaks
   
               Default is off.  This will enable the program to skip to 
               the next page if text matching the PageBreakCode
               (option P) is encountered. Setting this parameter in the 
               command line will toggle the state defined by
               the default or the EnablePageBreak .INI parameter.

   -P<string>: Set nonstandard page break character sequence.

               Set the text that will cause a page break.  This will
               normally be some sort of compiler directive.  Note the
               default is the form feed character.  If page breaks
               are enabled, the form feed character is the default
               separator.  See the PageBreakCode .INI parameter for
               more info.

   -o<string>: Use output file named <string> instead of stdout.

       string: A DOS filename that will be overwritten if it exists
               which will contain the output instead of dumping the 
               output to the console.  A DOS output device may also
               be given here (e.g., LPT1, LPT2, COM1 . . . ).  No spaces
               may be placed between the 'o' and the filename.  Using
               this parameter can increase processing time by 400%!.


   -H, h, ?  : HELP! (dump this file to stdout)

EXAMPLES

       TPI filename -l5 -r80 -L60 -T"My File Header" -tfilename > PRN
       
       TPI filename -f1 -t"My File Footer" -tfilename > PRN

       TPI filename > COM1
       
       TPI filename @c:\data\TPI_LJ.INI > PRN
       
       dir | tpi -s -T"My Directory!" | more 

       tpi -? | tpi -s -Gport12 -n -oLPT1

       TPI revect.asm -p -P.page -Gport12 -oLPT1

     [Special for NetWare & 4Dos types, to quickly print a slew of *.c]

       for nam in (*.c) (TPI %nam -Gfast -odump ^ nprint dump ^ del dump)

FILES

       TPI.EXE is the TPI executable.  While previous versions used
       external .EXE files to initialize printers the current does not.
       The default initialization file is TPI.INI and this help file 
       is TPI.MAN

INIT FILE DEFINITION

       The program will test the full [drive:]path where the TPI.EXE 
       file resides for the existence of a TPI.INI file.  This text 
       file contains default settings for all of the command line 
       options and a few additional ones. See the TPI.INI file for 
       examples of these parameters.

       The current recognized .INI file parameters are as follows.

       LeftBox          = <value>
       RightBox         = <value>
       BorderType       = <value>
       LinesPerPage     = <value>
                        
       TabSet           = <range>       (example    = (9,17)   )
                        
       Title            = <text string> (Do not use quotes here)
                        
       FooterType       = <value>
                        
       Footer           = <text String>
                        
       PrinterInit      = <text string> (.INI file only)
                          This parameter will be sent to the printer
                          before any text at the beginning of the job.
                          Text is sent exactly as typed with a few 
                          exceptions;
                            \E    translates to <Esc> or 0x1b
                            \\    translates to a single backslash
                            \nnn  translates to character represented
                                  by the decimal nnn (e.g. <esc> = \027)
                        
       VolIndexPage     = <value> (.INI file only)
                          this value will select and contain the volume
                          page number for the file set.  This parameter
                          will correspond to the prior page printed.  If
                          This parameter is selected, it will be updated 
                          when the current printing file is complete.
                        
                          This parameter will also force the output to an 
                          even number of pages, a blank will be produced 
                          if an odd number is printed as part of the run.
                        
                          Setting this value to 0 in the .INI file will
                          cause the first volume page to be number 1. On
                          successive runs of TPI the .INI file will be
                          updated to start the volume page number
                          immediately after the prior page number.
                        
                          Note that you MUST have read/write access to
                          the .INI file that you are using.  On our
                          network the default value is set to -1 to
                          disable the volume option.  
                        
       PrinterTabSel    = <value> (.INI file only)
                          This value when set to a positive integer will 
                          enable the tabbing function to align the right 
                          border.  In normal mode the right border is moved 
                          to by padding spaces.  If your printer is a serial 
                          printer this may save much time.
                        
       PrinterTabEsc    = <text string> (.INI file only)
                          this string allows the user to place an escape 
                          sequence at all of the points that are to be 
                          optimized using PrinterTabSel.  The string may 
                          contain control characters in the same format as
                          the PrinterInit parameter.

       EnableLineNum    = (1|0)
                          this will turn on or off the line numbering feature
                        
       EnableHighChar   = (1|0)
                          A '1' will allow the passing of characters 128-255. 
                          This is equivalent to the -x command line 
                          parameter.

       EnablePageBreak  = <value>
                          Allow the program to break to a new page if the
                          string matching PageBreakCode is encountered.

       PageBreakCode    = <text string> (default = $FF)
                          This string will cause TPI to perform a logical
                          page break if it is encountered within the file.
                          For an example, some assembly programs use
                          ".page" to signify a page break other text files
                          use a form feed character directly.  The caret
                          '^' character may be used to indicate the
                          beginning of line if it is the first character
                          in the PageBreakCode.  
                          
                          If you want to break for assembly programs where
                          the code is a left justified .page instruction,
                          the code would be defined as "^.page" this
                          will keep the occurrence of a "structure.page"
                          type text string from causing the page break.

                          Also note that having a FF character in the
                          .INI file would disrupt things so the
                          text $FF is mapped to a 0x0C character.

       OutputFile       = <text string>
                          If this parameter is selected TPI output will be
                          directed to this file.  It vastly improves
                          processing time (up to 400%) especially under a 
                          DOS window when running MS Windows. This is the
                          same file mentioned in the command line '-o' 
                          parameter.


       In the .INI file a line beginning with '#' is a comment and blank
       lines are allowed. It was an oversight on my part to make it a
       '#' instead of a ';' but I will fix this in a future release of
       my .INI file.

ENVIRONMENT

       A temporary directory must be defined in the 'TEMP' environment 
       variable if redirection from Standard Input is to be used or
       if the VolPageIndex .INI parameter is set to anything but -1. To
       set this in a DOS environment use the command;

                SET TEMP=C:\TEMP

       Normally the output of TPI is directed to stdout or the screen 
       then redirected to a printer (LPT1) or a comm port.  Be warned
       that LPT emulation in a DOS window under MS Windows is extremely 
       slow.  When we use TPI for multiple large files that will get sent 
       to a network printer, we use the following sequence;

               TPI ..parms.. >> tempfil
               TPI ..parms.. >> tempfil
               TPI ..parms.. >> tempfil
               TPI ..parms.. >> tempfil
               NPRINT tempfil

       Note that we have the HP PCL job separation code as part of our 
       normal init sequence. (TPI.INI)

DIAGNOSTICS

       Errors will be directed to standard error. A program termination
       will return (errorlevel > 0).

IDENTIFICATION

       TPI was written by and is owned by D. Miller Lowe.

       Use of TPI is supplied FREE of charge or obligation! In addition 
       I plan to support it for the next couple of years as well as port 
       it to UNIX and VMS (currently under development but a need a VMS 
       platform to compile on).

       In no way will D. Miller Lowe be liable for any damages or
       financial losses causes directly or indirectly by using TPI.

       Please Email reactions to TPI and this man page to one of the 
       below addresses;

       Internet                     : dlowe@world.std.com 
       General BBS in San Diego, CA : Miller Lowe
       U.S. Mail                    : 2504 Manzana Way
                                      San Diego, CA  92139

       To check the current revision of the TPI executable type TPI with
       no parameters.  The revision at the time of this documents last
       update was 3.24.

FUTURE ENHANCEMENTS

       I am always looking for ideas for my pet TPI program! Any feedback
       will be considered... some things that I am currently
       thinking about adding are.

       o  Page break regular expressions using regex() "UNIX Style" syntax
          with the option to break before or after the search target.

       o  Some sort of header and footer definition language that will 
          allow complete custom headers and footers to be defined in the 
          .INI file

       o  a -O option to work in concert with '-o' which will allow an 
          append to the output file

       o  Your Idea Here.....

       o  This space for rent!

KNOWN BUGS (Weirdness)

       *  Converts all chars as follows;

            Tab            - Converts to default tab size defined 
                             by TabSet range in default TPI.INI

            Carriage Return- Ignored completely.

            Line Feed      - Interpreted as end of line

            Form Feed      - if page breaks are not enabled (see -p
                             or EnablePageBreak) or if breaks are 
                             enabled and a non-default (FF) page
                             break code is defined (see -P and
                             PageBreakCode) a form feed will be
                             converted to a blank.

            High Characters passed to the output if EnableHighChar
                             is set, otherwise replaced by blanks.
            Normal
            Characters     - always passed to the output.

            (All others)   - Replaced by Blanks!

            NOTE: The -x option will allow passage of high characters.
                
                
       *  Not enough error checking is performed on the parameters
        
       *  Slow speed over a serial line, Using the PrinterTabEsc helps

       *  Sometimes the last line of a file will cause the right-hand
          box character to screw up.  I have seen this in an output but 
          can't find a source file that causes the error.  If 
          you have one, please please send me a sample that causes this 
          error.

       *  Using more than one page break on a single line may cause
          a memory violation and terminate the program.

INFO

       TPI was developed over years using Microsoft C/C++ compilers 
       V4.00 - V7.00, GNU dosRCS ver 5.6.4 (beta) and GNU Awk (GAWK).

       (So far in 'C') but the code is relatively portable.

       NOTE:  I perform all of the .INI file processing with only 29
              lines of calls to my .INI modules, including update.  For 
              more information on an easy way to add .INI type setups 
              to your C programs contact me at an address above.

       $Id: tpi.man 1.10 1993/02/11 20:43:18 dlowe Exp $

       $Log: tpi.man $
         Revision 1.10  1993/02/11  20:43:18  dlowe
         formatting errors

         Revision 1.9  1993/02/04  11:11:26  dlowe
         many many corrections and grammer fixes.

         Revision 1.8  1993/01/24  19:19:50  dlowe
         corrections and more detail.

         Revision 1.7  1993/01/24  07:47:59  dlowe
         added output to file using the -o option.

         Revision 1.6  1993/01/24  05:33:37  dlowe
         Added p and P options that correspond to EnablePageBreak and
         PageBreakOn respectively.

         Revision 1.5  1993/01/07  20:07:34  dlowe
         Added border type 3 (no borders)

         Revision 1.4  1993/01/05  05:12:15  dlowe
         Brought version up to 3.22 after enabling the new .INI module
         which allows updating of the .INI file for the VolPageIndex
         parameter.  Fixed spelling errors and enhances the man page.

         Revision 1.3  1993/01/03  06:06:19  dlowe
         Corrected some spelling errors

         Revision 1.2  1992/12/31  05:29:56  dlowe
         Slight corrections.

         Revision 1.1  1992/12/31  03:47:18  dlowe
         Initial configured revision
