----------------------------------------------------------
        .DATA

;-----  Command  character list

chars   DB      "0123"
1chars  EQU     $-chars           ; length of command character list

;-----  Jump (case) table of addresses

table   DW      case0,case1,case2,case3,endcase

;-----  Various strings

etc...

-----------------------------------------------------------------
        .CODE
start:
        mov     ax,@data          ; initialize DS & ES
        mov     ds,ax
        mov     es,ax

etc...

------------------------------------------------------------------

;-----  Prepare DI equal to the case statement number times2,
        indexing the 2-byte addresses in the jump table.

        mov     dx,OFFSET errmsg  ; Prepare for possible error
        mov     di,OFFSET chars   ; Point to command character table
        mov     cx,1chars+1       ; Load length of character table
        cld                       ; Scan forward
        repne   scasb             ; Find the command character 
        sub     di,OFFSET chars+1 ; Point to procedure
        shl     di,1              ; Convert to word address
        jmp     table[di]         ; Jump to case 0,1,2,3, or endcase

etc...

---------------------------------------------------------------------  

End of listings.