/*  asmhdr - process assembly language headers

    usage:  asmhdr document_file *.asm

    Borland   C>tcc -mc asmhdr.c wildargs.obj

    You may have to specify correct path information
    for the wildargs obj files.  Compile with compact
    memory model.  This program was written for Turbo
    C but it would be easy to modify for Microsoft C.

    John Otken, Soft Advances
*/

#include <alloc.h>      /* use malloc.h for microsoft c */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define LINE_SIZE       256
#define MAX_ROUTINES    1000    /* maximum routines */
#define READ_TEXT       "rt"
#define WRITE_TEXT      "wt"


/* prototypes begin */
void process_asm_file(char *fn);
void out_of_memory(void);
int stricmp_pt(struct index_tag *a, struct index_tag *b);
/* prototypes end */


struct index_tag {
    char *routine_name;
    char *routine_header;
} index[MAX_ROUTINES];


int index_cnt = 0;              /* number of index entries */
unsigned long coreused = 0;     /* total storage used */


void main(int argc, char *argv[])
{
    int i;
    FILE *fo;

    if (argc < 3) {
        printf("asmhdr outfile *.asm");
        exit(0);
    }

    i = 1;
    fo = fopen(argv[i], READ_TEXT);
    if (fo != NULL) {
        printf("Error: %s exists!  Overwriting source file?\n", argv[i]);
        fclose(fo);
        exit(1);
    }

    fo = fopen(argv[i], WRITE_TEXT);
    if (fo == NULL) {
        printf("Error opening output file: %s\n", argv[i]);
        exit(1);
    }

    for(i = 2; i < argc; i++)
        process_asm_file(argv[i]);

    qsort(&index[0], index_cnt, sizeof(index[0]), stricmp_pt);

    for(i = 0; i < index_cnt; i++)
        fprintf(fo,"%s\n",index[i].routine_header);
    fclose(fo);

    printf("Used %d of %d index entries.\n", index_cnt, MAX_ROUTINES);
    printf("Used %lu bytes.\n", coreused);
                  /* microsoft c does not have a coreleft function */
    printf("%lu free bytes.\n", (unsigned long) coreleft());
}




void process_asm_file(char *fn)
{
    char *p, *q;

    char line[LINE_SIZE],   /* file line buffer */
         buf[3000];         /* temp buffer */

    FILE *fi;

    fi = fopen(fn, READ_TEXT);
    if (fi == NULL) {
        printf("Error opening input file: %s\n", fn);
        exit(1);
    }

    while (fgets(line, LINE_SIZE, fi) != NULL) {
        if (line[0] == ';'  &&  line[1] == ';'  &&  line[2] == '\t') {

            p = buf;
            do {
                p = stpcpy(p, line);
            } while (fgets(line, LINE_SIZE, fi) != NULL  &&  line[0] == ';');
            if (*(p-1) == '\n'  &&  *(p-2) == ';')  p -= 2;
            *p = '\0';
            if ((index[index_cnt].routine_header = strdup(buf)) == NULL)
                out_of_memory();
            coreused += strlen(buf)+1;

            p = &buf[3];        /* extract routine name from header */
            q = buf;
            while (*p != '\n') {
                if (*p == ' ')  *p = '_';
                *q++ = *p++;
            }
            *q = '\0';

            if ((index[index_cnt++].routine_name = strdup(buf)) == NULL)
                out_of_memory();
            coreused += strlen(buf)+1;
        }
    }
    fclose(fi);
}




void out_of_memory(void)
{
    printf("Out of memory");
    exit(1);
}




int stricmp_pt(struct index_tag *a, struct index_tag *b)
{
    return stricmp(a->routine_name, b->routine_name);
}
