/*
    coop.h - contains structures for simulated Objects

*/



// -----------------------------------------------------------------
// ------------Structure TWLL---------------------------------------
// -----------------------------------------------------------------
//
//  This is our root structure or Super Class.
//

struct TWLL {
    struct TWLL *prev;
    struct TWLL *next;
    int     type;
#define DATA    1
#define MY_DATA     2
#define OTHER_DATA 3
  };

  
// -----------------------------------------------------------------
// ------------Structure TWLL_HEAD----------------------------------
// -----------------------------------------------------------------
// 
//  This is our header struct for the linked list
//

struct TWLL_HEAD {
    struct TWLL *top;
    int   cnt;
    };


// -----------------------------------------------------------------
// ------------Structure DATA_TWLL----------------------------------
// -----------------------------------------------------------------
//
//  Here is a struct that Inherits two pointers from TWLL.  
//  By always placing TWLL at the beginning then 
//  TWLL functions can make the assumption that both pointers
//  are at the start of the structure.
//

struct DATA_TWLL {
    struct TWLL inherit;
    int x;
    int y;
    };

// -----------------------------------------------------------------
// ------------Structure MY_DATA_TWLL-------------------------------
// -----------------------------------------------------------------
//
//  Here is a stuct that inherits the two
//  pointers from TWLL and the x and y fields from DATA_TWLL.
//

struct MY_DATA_TWLL {
    struct DATA_TWLL inherit;
    char   a[10];
    char   b[10];
    };

// -----------------------------------------------------------------
// ------------Structure OTHER_DATA_TWLL----------------------------
// -----------------------------------------------------------------
// 
//  Here is one last structure using TWLL and DATA_TWLL.
//  Since it uses the same structure (DATA_TWLL) as MY_DATA_TWLL,
//  this class is a sibling of MY_DATA_TWLL
//

struct OTHER_DATA_TWLL {
    struct DATA_TWLL inherit;
    int a;
  };


