/* 
 * Winaux functions module
 *
 * Written by Bill Hall
 * 3665  Benton Street, #66
 * Santa Clara, CA 95051
 *
 */

#define NOCOMM
#define NOKANJI
#define NOMINMAX
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <io.h>
#include <stdio.h>
#include <ascii.h>
#include <windows.h>
#include <ttycls.h>
#include "winaux.h"

/* local function declaractions */
static void NEAR ShowAboutBox(HWND hWnd);

void NEAR DispatchString(HWND hWnd, WORD wParam, LONG lParam)
{
#define LBUFLEN	100

    BYTE buf[LBUFLEN];
    int len, i, count;
    
    len = (int)wParam;
    
    while (len > 0) { /* read and dispatch each part of buffer until done */								
	count = min(len, LBUFLEN);
	for (i = 0; i < count; i++)
	    buf[i] = *(LPSTR)lParam++;
    	TTYDisplay((PTTYWND)GetWindowWord(hWnd,0),(short)count, buf);
	if (LogToFile)
	    write(hFile, buf, count);
	len -= count;
    }	
}

static void NEAR ShowAboutBox(HWND hWnd)
{

    FARPROC fp;
    HANDLE hInstance = GetWindowWord(hWnd, GWW_HINSTANCE);

  /* make a proc instance for the about box window function */
    fp = MakeProcInstance((FARPROC)AboutBoxProc, hInstance);
  /* create a modal dialog box */
    DialogBox(hInstance, MAKEINTRESOURCE(DT_ABOUT),hWnd,fp);
}

/* process the menu */
void NEAR WndCommand(HWND hWnd, WORD wParam)
{

    HMENU hMenu = GetMenu(hWnd);

    switch (wParam) {

	case IDM_LOG:
	    if (LogToFile)
	        write(hFile, szEndLog, strlen(szEndLog));
	    else 
		write(hFile, szBeginLog, strlen(szBeginLog));
	    LogToFile = (LogToFile ? FALSE : TRUE);
            CheckMenuItem(hMenu,wParam,LogToFile ? MF_CHECKED : MF_UNCHECKED);
	    break;

	case IDM_ABOUT:
	    ShowAboutBox(hWnd);
	    break;

	case IDM_CRONLF:
	    MWnd.CRonLF = (MWnd.CRonLF ? FALSE : TRUE);
	    CheckMenuItem(hMenu,wParam,MWnd.CRonLF ? MF_CHECKED : MF_UNCHECKED);
	    break;

	case IDM_CLEAR:
	    TTYClear(&MWnd);
	    break;
    }
}

/* paint the main window */
void NEAR MainWndPaint(hWnd, lpps)
HWND hWnd;
LPPAINTSTRUCT lpps;
{

    HDC hDC = lpps->hdc;

  /* if the window is iconic, draw the icon */
    if (IsIconic(hWnd)) {
	RECT rIcon;
	GetClientRect(hWnd, (LPRECT)&rIcon);
	Rectangle(hDC, 0,0,rIcon.right, rIcon.bottom);
        TextOut(hDC,2,rIcon.bottom/3,(LPSTR)szIconTitle,strlen(szIconTitle));
    }
  /* otherwise update the text in the window */
    else 
	TTYWndPaint(&MWnd, lpps->hdc, lpps->rcPaint.top, lpps->rcPaint.bottom);
}

/* set the window handle variable */
int SetWinIni(HWND hWnd)
{
    char buf[20];
    return (WriteProfileString((LPSTR)szAppName, (LPSTR)szhWnd, 
			(LPSTR)itoa(hWnd, buf, 10)));
}

/* adjust where text is to be displayed if window is resized */
void NEAR AdjustHeight(short width, short height)
{
     
    MWnd.Width = width;
    MWnd.Height = height;
    MWnd.Pos.y = height - MWnd.CHeight - 1;
    InvalidateRect(MWnd.hWnd, (LPRECT)NULL, TRUE);
}

/* This is the window proc for the about box when it is displayed */
BOOL FAR PASCAL AboutBoxProc(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{

    switch (message) {

      /* nothing to initialize */
	case WM_INITDIALOG:
	    break;

      /* this dialog box has only an OK button */
	case WM_COMMAND:
	    switch (wParam) {
		case IDOK:
		case IDCANCEL:
		/* destroy the dialog box */
		    EndDialog(hDlg,TRUE);
		    break;
		default:
		    return FALSE;		/* we did not process */
	    }
	    break;
	    
	default:
	    return FALSE;
    }
    return TRUE;		/* we processed message */
}
