/* 
 * Winvue function support module module
 *
 * Written by Bill Hall
 * 3665  Benton Street, #66
 * Santa Clara, CA 95051
 *
 */

#define NOCOMM		
#define NOKANJI
#define NOATOM
#define NOBITMAP
#define NOMINMAX
#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include <ascii.h>
#include <io.h>

#include <ttycls.h>
#include "winvue.h"

/* local function declaractions */
static void NEAR ShowAboutBox(HWND hWnd);
static int NEAR CloseTheFile(BOOL);
static void NEAR EnableMenus(HMENU hmenu, BOOL op);

/* read next buffer of data from file or close the file */
void NEAR ProcessFile()
{
    int numread, size;
    size = min(MWnd.MaxCols, MAX_STR_LEN);

  /* user cancelled the file display */
    if (Break) {
	hFile = CloseTheFile(TRUE);
	Break = FALSE;
    }
    else if (!(Pause || IsIconic(MWnd.hWnd))) {
      /* read next buffer of data */
        if ((numread = read(hFile, instr, size)) == 0)
      /* no more data (or perhaps a read error) */
 	    hFile = CloseTheFile(FALSE);
        else
      /* post the buffer and its length for later processing */
	    PostMessage(MWnd.hWnd, WM_USER, numread, (LONG)(LPSTR)instr);
    }
}

/* close the file, enable inactive menus, and switch message processor */
static int NEAR CloseTheFile(param)
{
    
    HMENU hmenu = GetMenu(MWnd.hWnd);

    Pause = FALSE;		/* reset the pause button */
    EnableMenus(hmenu, TRUE);   /* enable grayed menus */

    DoMessage = DoGetMessage;   /* change the message processing pointer */

  /* show the result to the user */
    if (param)
	ShowMessage(MWnd.hWnd,(char *)NULL,IDS_CANCEL,
					MB_OK | MB_ICONEXCLAMATION);
    else
	ShowMessage(MWnd.hWnd,(char *)NULL,IDS_DONE,
					MB_OK | MB_ICONASTERISK);
    return(close(hFile));
}

/* open the file, display its name, and change the message function pointer */
int FAR OpenTheFile(char *pfilename)
{

    int hfile;
    char winname[30];
    
  /* open the file */
    hfile = OpenFile(pfilename, (LPOFSTRUCT)&fstruct, OF_READ);

    if (hfile != -1) {
      /* change the window title */
	strcpy(winname, szWinTitle);
        strcat(winname, strrchr(fstruct.szPathName,'\\') + 1);
        SetWindowText(MWnd.hWnd, winname);
      /* change message function pointer */
	DoMessage = DoPeekMessage;
    }
    else 
     /* open failed */
	ShowMessage(MWnd.hWnd,pfilename,IDS_CANNOT_OPEN,
					MB_OK | MB_ICONEXCLAMATION);
    return(hfile);
}

/* 
   Display a simple message box according to the message number.
   Merge a string into the message if mergestr != NULL
*/
void ShowMessage(HWND hWnd, char *mergestr, int msgnum, int style)
{

    char szMsg[MAX_STR_LEN];
    char szTemp[MAX_STR_LEN / 2];
    HANDLE hInst = GetWindowWord(hWnd, GWW_HINSTANCE);

    if (mergestr) {
	LoadString(hInst, msgnum, (LPSTR)szTemp, sizeof(szTemp));
        DlgMergeStrings(szTemp, szFileNameSave, szMsg);
    }
    else
        LoadString(hInst, msgnum, (LPSTR)szMsg, sizeof(szMsg));
    
  /* put up this simple message box */
    MessageBox(hWnd,(LPSTR)szMsg, (LPSTR)szAppName, style);

}

/* create 'about' dialog box */
static void NEAR ShowAboutBox(HWND hWnd)
{

    FARPROC fp;
    HANDLE hInstance = GetWindowWord(hWnd, GWW_HINSTANCE);

  /* make a proc instance for the about box window function */
    fp = MakeProcInstance((FARPROC)AboutBoxProc, hInstance);
  /* create a modal dialog box */
    DialogBox(hInstance, MAKEINTRESOURCE(DT_ABOUT),hWnd,fp);
  /* free the proc instance */
    FreeProcInstance(fp);
}

/* activate or disable certain menus during file display */
static void NEAR EnableMenus(HMENU hmenu, BOOL op)
{

    EnableMenuItem(hmenu, IDM_FILENAME, (op ? MF_ENABLED : MF_GRAYED));
    EnableMenuItem(hmenu, IDM_SYSFONT, (op ? MF_ENABLED : MF_GRAYED));
    EnableMenuItem(hmenu, IDM_OEMFONT, (op ? MF_ENABLED : MF_GRAYED));
    EnableMenuItem(hmenu, IDM_MASK, (op ? MF_ENABLED : MF_GRAYED));

    EnableMenuItem(hmenu, IDM_CANCEL, (op ? MF_GRAYED : MF_ENABLED));
    EnableMenuItem(hmenu, IDM_PAUSE, (op ? MF_GRAYED : MF_ENABLED));
    EnableMenuItem(hmenu, IDM_RESUME, (op ? MF_GRAYED : MF_ENABLED));
}

/* process the menu */
void NEAR WndCommand(HWND hWnd, WORD wParam)
{

    HMENU hMenu = GetMenu(hWnd);
    HANDLE hInstance = GetWindowWord(hWnd, GWW_HINSTANCE);
    int result;

    switch (wParam) {

	case IDM_ABOUT:
	    ShowAboutBox(hWnd);
	    break;

	case IDM_FILENAME:
	    result = DialogBox(hInstance, MAKEINTRESOURCE(DT_OPEN),hWnd,
			MakeProcInstance((FARPROC)DlgFnOpen, hInstance));
	  /* file open succeeded */
	    if (result) {
	        if ((hFile = OpenTheFile(szFileNameSave)) != -1) {
		    TTYClear(&MWnd);
		    EnableMenus(hMenu, FALSE);
		    Pause = FALSE;
	        }
	    }
	    break;

      /* suspend file display */
	case IDM_PAUSE:
	    Pause = TRUE;
	    CheckMenuItem(hMenu, IDM_PAUSE, MF_CHECKED);
	    CheckMenuItem(hMenu, IDM_RESUME, MF_UNCHECKED);
	    break;

      /* resume file display */
	case IDM_RESUME:
	    Pause = FALSE;
	    CheckMenuItem(hMenu, IDM_RESUME, MF_CHECKED);
	    CheckMenuItem(hMenu, IDM_PAUSE, MF_UNCHECKED);
	    break;

      /* cancel file display */
	case IDM_CANCEL:
	    Break = TRUE;
	    break;

      /* change between system and oem font */
	case IDM_SYSFONT:
	    MWnd.hFont = NULL;
	    CheckMenuItem(hMenu, IDM_SYSFONT, MF_CHECKED);
	    CheckMenuItem(hMenu, IDM_OEMFONT, MF_UNCHECKED);
	    break;

	case IDM_OEMFONT:
	    MWnd.hFont = GetStockObject(OEM_FIXED_FONT);
	    CheckMenuItem(hMenu, IDM_SYSFONT, MF_UNCHECKED);
	    CheckMenuItem(hMenu, IDM_OEMFONT, MF_CHECKED);
	    break;

      /* mask out bit 8 of each byte in file */
	case IDM_MASK:
	    MWnd.ebitmask = 
			(MWnd.ebitmask == (BYTE)0xff ? (BYTE)0x7f : (BYTE)0xff);
	    CheckMenuItem(hMenu, wParam,
    		   	(MWnd.ebitmask == 0x7f ? MF_CHECKED : MF_UNCHECKED));
	    break;
    }
}

/* paint the main window */
void NEAR MainWndPaint(hWnd, lpps)
HWND hWnd;
LPPAINTSTRUCT lpps;
{

    HDC hDC = lpps->hdc;

  /* if the window is iconic, draw the icon */
    if (IsIconic(hWnd)) {
	RECT rIcon;
	GetClientRect(hWnd, (LPRECT)&rIcon);
	Rectangle(hDC, 0,0,rIcon.right, rIcon.bottom);
        TextOut(hDC,2,rIcon.bottom/3,(LPSTR)szIconTitle,strlen(szIconTitle));
    }
  /* otherwise update the text in the window */
    else 
	TTYWndPaint(&MWnd, lpps->hdc, lpps->rcPaint.top, lpps->rcPaint.bottom);
}

/* adjust where text is to be displayed if window is resized and redraw */
void NEAR AdjustHeight(short width, short height)
{
     
    MWnd.Width = width;
    MWnd.Height = height;
    MWnd.Pos.y = height - MWnd.CHeight - 1;
    InvalidateRect(MWnd.hWnd, (LPRECT)NULL, TRUE);
}

/* the following routine comes from the Microsoft TEMPLATE application */
/*=============================================================================
 DLGMERGESTRINGS scans string1 for merge spec (%%). If found, insert string2 at
 that point, and then append remainder of string1.  Result in string3.
==============================================================================*/
BOOL FAR DlgMergeStrings (szSrc, szMerge, szDst)
 char	*szSrc;
 char	*szMerge;
 char	*szDst;
 {
    char *pchSrc;
    char *pchDst;
    unsigned int wMerge;

    wMerge = '%';
    wMerge <<= 8;
    wMerge |= '%';

    pchSrc = szSrc;
    pchDst = szDst;

    /* Find merge spec if there is one. */
    while (*(unsigned *)pchSrc != wMerge) {
	*pchDst++ = *pchSrc;

	/* If we reach end of string before merge spec, just return. */
	if (!*pchSrc++)
	    return FALSE;

    }
    /* If merge spec found, insert sz2 there. (check for null merge string */
    if (szMerge) {
	while (*szMerge)
	    *pchDst++ = *szMerge++;

    }

    /* Jump over merge spec */
    pchSrc++,pchSrc++;


    /* Now append rest of Src String */
    while (*pchDst++ = *pchSrc++);
    return TRUE;

} /* end dlgmergestrings */
