/* 
 * Winvue initialization module
 *
 * Written by Bill Hall
 * 3665  Benton Street, #66
 * Santa Clara, CA 95051
 *
 */

#define NOCOMM		
#define NOKANJI
#define NOATOM
#define NOBITMAP
#define NOMINMAX
#include <windows.h>
#include <stdlib.h>
#include <ttycls.h>
#include <ascii.h>
#include "winvue.h"

/* local function declarations */
static BOOL NEAR RegisterWindowClass(HANDLE);
static BOOL NEAR MakeAndShowMainWnd(HANDLE, int);
static int NEAR OpenCmdlineFile(LPSTR lptr);
static void NEAR GetPrevInstanceData(HANDLE);

/* enter here to initialize the program */
BOOL FAR InitProgram(hInstance,hPrevInstance, lpszCmdLine, cmdShow)
HANDLE hInstance, hPrevInstance;
LPSTR lpszCmdLine;
int cmdShow;
{

  /* set a pointer to the appropriate message function */
   DoMessage = DoGetMessage;

  /* if first instance, do these things */
    if (hPrevInstance == NULL) {
      /* get icon string */
        LoadString(hInstance,IDS_ICONSTRING,(LPSTR)szIconTitle,
				sizeof(szIconTitle));
      /* register window class */
	if (!RegisterWindowClass(hInstance))
	    return FALSE;
      /* load the menu accelerators */
	hAccel = LoadAccelerators(hInstance, (LPSTR)szAppName);
    }

  /* otherwise, just load data normally obtained during registration */
    else
	GetPrevInstanceData(hPrevInstance);

  /* create the window */
    if (!MakeAndShowMainWnd(hInstance,cmdShow))
	return FALSE;

  /* see if a file was specified on the command line */
    hFile = OpenCmdlineFile(lpszCmdLine);

  /* show success */
    return TRUE;
}

/* register the windows class */
static BOOL near RegisterWindowClass(hInstance)
HANDLE hInstance;
{

    PWNDCLASS pWndClass;
    HANDLE hTemp;

  /* get the application name from the resources */
    LoadString(hInstance,IDS_APPNAME,(LPSTR)szAppName,sizeof(szAppName));

  /* make space for the WNDCLASS structure in the heap */
    hTemp = LocalAlloc(LPTR,sizeof(WNDCLASS));
    pWndClass = (PWNDCLASS)LocalLock(hTemp);
	
  /* enter data */
    pWndClass->hCursor = LoadCursor(NULL, IDC_ARROW);	/* stock cursor */
    pWndClass->hIcon = NULL;				/* no icon */
    pWndClass->lpszMenuName = (LPSTR)szAppName;		/* this menu */
    pWndClass->lpszClassName = (LPSTR)szAppName;	/* class name */
    pWndClass->hbrBackground = (HBRUSH)(COLOR_WINDOW + 1); /* background */
    pWndClass->hInstance = hInstance;			/* instance */
    pWndClass->style = CS_VREDRAW | CS_HREDRAW;		/* style */
    pWndClass->lpfnWndProc = MainWndProc;	/* pointer to wind proc */
    pWndClass->cbWndExtra = sizeof(PTTYWND);   /* space for ptr to MWnd */

  /* if failure, return FALSE */
    if (!RegisterClass((LPWNDCLASS)pWndClass))
	return FALSE;

  /* success, so free up heap data and show ok */
    LocalUnlock(hTemp);
    LocalFree(hTemp);
    return TRUE;
}

/* if we don't need to register the window, we have to load these strings */
static void NEAR GetPrevInstanceData(HANDLE hPrevInstance)
{

    GetInstanceData(hPrevInstance, (PSTR)szAppName, sizeof(szAppName));
    GetInstanceData(hPrevInstance, (PSTR)szIconTitle, sizeof(szIconTitle));
    GetInstanceData(hPrevInstance, (PSTR)&hAccel, sizeof(hAccel));
}

/* create a window of the class registered above */
static BOOL NEAR MakeAndShowMainWnd(hInstance, cmdShow)
HANDLE hInstance;
int cmdShow;
{

  /* get the text for the title */
    LoadString(hInstance, IDS_WINTITLE, (LPSTR)szWinTitle,sizeof(szWinTitle));

  /* create the window */
    MWnd.hWnd = CreateWindow((LPSTR)szAppName,	/* class */
			     (LPSTR)szWinTitle,	/* title string */
			     WS_OVERLAPPEDWINDOW,	/* style */
			     CW_USEDEFAULT,0,
			     CW_USEDEFAULT,0,
			     (HWND)NULL,	/* no parent */
			     (HMENU)NULL,	/* class menu */
			     (HANDLE)hInstance,	/* instance */
			     (LPSTR)&MWnd);	/* ptr to window structure */

  /* if successful, display the window */
    if (MWnd.hWnd && MWnd.hVidBuf) {
	ShowWindow(MWnd.hWnd, cmdShow);
        UpdateWindow(MWnd.hWnd);
	return TRUE;
    }
  /* return failure */
    return FALSE;
}

/* read the command line and open a file, if any */
static int NEAR OpenCmdlineFile(LPSTR cmdline)
{

    char ch;
    int i, len;
    HANDLE hname;
    char *pname;
    LPSTR lptr;
    int hfile = 0;

    lptr = cmdline;
    len = 0;

  /* isolate first field in command line */
    while (ch = *lptr++)
	if (ch == ' ')
	    break;
	else
	    len++;

    if (len) {
      /* make space for file name in heap */
	if (hname = LocalAlloc(LPTR, len + 1)) {
	    pname = LocalLock(hname);
	  /* copy the name */
	    for(i = 0; i < len; i++)
		*(pname + i) = *cmdline++;
	    *(pname + len) = NUL;
	  /* try opening the file */
	    hfile = OpenTheFile(pname);	    
	  /* discard the heap allocation */
	    LocalUnlock(hname);
	    LocalFree(hname);
	}
    }
    return hfile;
}

/* this routine is called upon receipt of the WM_CREATE message */
void WndCreate(hWnd, lParam)
HWND hWnd;
LONG lParam;
{

    HDC hDC;
    TEXTMETRIC TM;
    short width, height, cwidth, cheight;
    LPCREATESTRUCT pCS;
    PTTYWND pMWnd;
    
  /* we are going to create a buffer for a window this large */
    width = GetSystemMetrics(SM_CXFULLSCREEN);
    height = GetSystemMetrics(SM_CYFULLSCREEN);

  /* get the font size */
    hDC = GetDC(hWnd);
    GetTextMetrics(hDC, &TM);
    cwidth = TM.tmAveCharWidth;
    cheight = TM.tmHeight + TM.tmExternalLeading;
    ReleaseDC(hWnd, hDC);

  /* here we retrieve the pointer to our local window stucture */
    pCS = (LPCREATESTRUCT)lParam;
    pMWnd = (PTTYWND)LOWORD(pCS->lpCreateParams);

  /* initialize the extra data to the pointer to the TWnd structure */
    SetWindowWord(hWnd,0,(WORD)pMWnd);

  /* now create the text buffer and set some defaults */
    InitTTYWindow(pMWnd,0,0,width,height,cwidth,cheight,
				FALSE,FALSE,TRUE,0,0xff);
}
