/* 
 * WNTERM Main Module
 *
 * Written by
 * William S. Hall
 * 3665 Benton Street, #66
 * Santa Clara, CA 95051
*/

#define NOKANJI
#define NOATOM
#define NOSOUND
#include <windows.h>
#include <limits.h>
#include <string.h>
#include "ttycls.h"
#define EXTERN
#include "wnterm.h"

/* program entry point */
int FAR PASCAL WinMain(hInstance, hPrevInstance, lpszCmdLine, cmdShow)
HANDLE hInstance, hPrevInstance;
LPSTR lpszCmdLine;
int cmdShow;
{

    MSG msg;

  // initialize program
    if (!InitProgram(hInstance,hPrevInstance, lpszCmdLine, cmdShow))
	return FALSE;

  // stay in this loop until window is destroyed.
    while (TRUE) {
        if (PeekMessage((LPMSG)&msg,NULL,0,0,PM_REMOVE)) {
	    if (msg.message == WM_QUIT)
		break;
	    TranslateMessage((LPMSG)&msg); // translate keydown/up to chars.
	    DispatchMessage((LPMSG)&msg);  // call the appropriate window proc.
	}
	else if (!IsIconic(MWnd.hWnd))	   // don't read comm port if iconic.
	    ProcessComm();
    }
    return (int)msg.wParam;	// terminate program.
}

/* Main window procedure */
long FAR PASCAL MainWndProc(hWnd,message,wParam,lParam)
HWND hWnd;
unsigned message;
WORD wParam;
LONG lParam;
{

    // get our data structure for the window.
    PTTYWND pMWnd = (PTTYWND)GetWindowWord(hWnd,0); 
    PAINTSTRUCT ps;
    register int i;

    switch(message) {

      // control scrolling with this key.
	case WM_KEYDOWN:
	    if (wParam == VK_SCROLL)
	        ScrollLock = GetKeyState(VK_SCROLL) & 1;
	    break;

      // process menu command.
	case WM_COMMAND:
	    WndCommand(hWnd, wParam, lParam);
	    break;

    /* 
       When a character is received, and send it to tty display procedure.
       This is the action when terminal is off-line
    */
	case WM_CHAR:
	    HideCaret(hWnd);
	  // the loop is a crude way to handle repeat characters
	    for (i = 0; i < LOWORD(lParam); i++)
	        TTYDisplay(pMWnd, (short)1, (BYTE *)&wParam);
	    SetCaretPos(pMWnd->Pos.x, pMWnd->Pos.y);
	    ShowCaret(hWnd);
	    break;

      // recreate caret and reset its position
    	case WM_SIZE:
	    pMWnd->Width = LOWORD(lParam);
	    pMWnd->Height = HIWORD(lParam);
	    pMWnd->Pos.y = pMWnd->Height - pMWnd->CHeight - 1; 
	    if (hWnd == GetFocus()) {
	        CreateCaret(hWnd, (HBITMAP)NULL,2,pMWnd->CHeight);
	        SetCaretPos(pMWnd->Pos.x, pMWnd->Pos.y);
	        ShowCaret(hWnd);
	    }
	    break;

      // window has focus, so window can create a caret.
	case WM_SETFOCUS:
	    CreateCaret(hWnd, (HBITMAP)NULL,2,pMWnd->CHeight);
	    SetCaretPos(pMWnd->Pos.x, pMWnd->Pos.y);
	    ShowCaret(hWnd);
	    break;

      // window has lost focus, so window must kill the caret.
	case WM_KILLFOCUS:
	    HideCaret(hWnd);
	    DestroyCaret();
	    break;

      // main window now exists so do some initialization.
	case WM_CREATE:
	    WndCreate(hWnd,(LPCREATESTRUCT)lParam);
	    break;

      // have to close comm port if open before killing window.
	case WM_CLOSE:
	    if (cid >= 0) {
		CloseComm(cid);
		cid = INT_MIN;
	    }
	    DestroyWindow(hWnd);
	    break;

      // This application is being destroyed by Windows exec.
	case WM_ENDSESSION:
	    if (wParam)		// if true, close the comm port.
		if (cid >= 0) {
		    CloseComm(cid);
		    cid = INT_MIN;
		}
	    break;

      // tell program to exit.
	case WM_DESTROY:
	    PostQuitMessage(0);
	    break;

      // if iconic, paint the icon window, otherwise redraw text buffer.
	case WM_PAINT:
	    BeginPaint(hWnd, (LPPAINTSTRUCT)&ps);
	    MainWndPaint(hWnd, (LPPAINTSTRUCT)&ps);
	    EndPaint(hWnd, (LPPAINTSTRUCT)&ps);
	    break;

      // all other messages go through here.
	default:
	    return ((long)DefWindowProc(hWnd,message,wParam,lParam));
    }
    return(0L);	/* this means we processed the message */
}

/* 
 * Subclass window procedure.  When we are on-line, all window 
 *  messages come here first
 */
LONG FAR PASCAL MainWndSubProc(hWnd, message, wParam, lParam)
HWND hWnd;
unsigned message;
WORD wParam;
LONG lParam;
{

    PTTYWND pMWnd = (PTTYWND)GetWindowWord(hWnd,0);
    register int i;

  // we are only interested in these messages.
    switch(message) {

      // buffer from comm port has been posted to us.
	case WM_USER:
	    HideCaret(hWnd);
	    Buflen = TTYDisplay(pMWnd, (short)wParam, Buffer);
	    SetCaretPos(pMWnd->Pos.x, pMWnd->Pos.y);
	    ShowCaret(hWnd);
          // if anything left over, move it to front.
	    if (Buflen)	
		memmove(Buffer, Buffer+(int)wParam-Buflen, Buflen);
	    break;

      // transmit key from keyboard.  Loop is crude way to handle repeat chars.
	case WM_CHAR:
	    for (i = 0; i < LOWORD(lParam); i++)
	        WriteComm(cid, (LPSTR)&wParam,1);
	    if (!MWnd.LocalEcho)	// if no local echo, then done
		break;

    // all other messages must go thru normal channels.
	default:
	    return(CallWindowProc(fpMainWndProc,hWnd,message,wParam,lParam));
    }
    return(0L);
}
