/* makeid.c	creates a list of #define statements on stdout.  can be
 *		redirected to a header file:
 *
 *		C> makeid strings.rsc > myincl.h
 *
 *	(c) Copyright 1990 Aspen Scientific
 *	All Rights Reserved
 */

#include <stdio.h>
#include "resource.h"

void	fatal(char *str);

void
main(int argc, char **argv)
{
	register int	i;
	StringResource	*res;

	if (argc == 1)
	{
		fprintf(stderr, "usage:: makeid ResourceFile1 <file2> <file3> ..\n");
		exit(1);
	}
	for (i=1; i < argc; ++i) {
		res = LoadResources(argv[i]);

		if (res == NULL)
			fatal("error loading strings.rsc");

		while (res) {
			printf("#define\t%s\t\t%d\n",
				GetResourceName(res), GetResourceID(res));
#ifdef DEBUG
			printf("\t\"%s\"\n", GetResourceString(res));
#endif
			res = NextResource(res);
		}

		FreeResources(res);
	}

	exit(0);
}

void
fatal(char *str)
{
	fprintf(stderr, "fatal: %s\n", str);
	exit(2);
}
