'***********************************************************************
'                               PBBI.BAS                               *
'   PBBI is a program to update the declaration header file PB.BI,     *
' used with Microsoft BASIC compiler (BC) version 7, for a new or      *
' replacement library module.   Usually, it is run by the $$$.BAT file *
' produced by DOLIB.EXE.  However, it can be run as a standalone       *
' program if the file PB.BI is in the default directory.  When run as  *
' a standalone, call with: "PBBI <filespec>" where <filespec> is a     *
' complete specification (including drive and path) to the module      *
' source file.                                                         *
'    If the source file contains coded SUB or FUNCTION declaration     *
' statements (enclosed in square brackets), the PB.BI header file will *
' be updated; the previous version of PB.BI will be renamed to PB.BKE. *
' If the source file does not contain coded declaration statements,    *
' the new PB.BI will be identical to PB.BKE.  An existing SUB or       *
' FUNCTION declaration statement in the PB.BI file for the same        *
' procedure name will be replaced.  A new declaration will be added.   *
'----------------------------------------------------------------------*
'               Written by M. L. Lesser, April 14, 1990                *
'                 Compiled with BC v. 7.1, switch "/O"                 *
'      Linked to NOCOM, NOLPT and NOFLTIN with switches "/E/NOE"       *
'***********************************************************************

    DEFINT I-N
    DEFSTR D,F,P,T
    DIM DECLARATIONS(32), FILENAME, I, J, K, N, PROCNAME(32), T, TEXT

    OPEN COMMAND$ FOR INPUT AS #1 LEN=5120            'Source code file
    LET N = 0
' Search source file for coded embedded procedure declarations:
    WHILE NOT EOF(1)
        LINE INPUT #1, TEXT                     
        LET I = INSTR(UCASE$(TEXT),"[DECLARE")
        IF I THEN                                      'Found one
            LET J = INSTR(TEXT,"]")
            LET DECLARATIONS(N) = RTRIM$(MID$(TEXT,I+1,J-I-1))
            LET N = N + 1
        END IF
    WEND
    LET N = N - 1                       'Index of last used array member
    CLOSE #1
' Parse for procname (second token after "declare").  May end with
'  either a <SP> or a "(", or be the last token in the declaration.
    LET T = "%&!#@$"                    'Data type symbols
    FOR I = 0 TO N
        LET TEXT = LTRIM$(MID$(DECLARATIONS(I),8))
        LET TEXT = LTRIM$(MID$(TEXT,INSTR(TEXT," ") + 1))
        LET J = INSTR(TEXT," "): K = INSTR(TEXT,"(")
        IF J = 0 AND K = 0 THEN
            PROCNAME(I) = TEXT
        ELSEIF J = 0 AND K <> 0 THEN
            LET PROCNAME(I) = LEFT$(TEXT,K-1)
        ELSEIF J <> 0 AND K = 0 THEN
            LET PROCNAME(I) = LEFT$(TEXT,J-1)
        ELSEIF J < K THEN
            LET PROCNAME(I) = LEFT$(TEXT,J-1)
        ELSE
            LET PROCNAME(I) = LEFT$(TEXT,K-1)
        END IF
' Delete any trailing type designation symbol:
        IF INSTR(T,RIGHT$(PROCNAME(I),1)) THEN
            LET PROCNAME(I) = LEFT$(PROCNAME(I),LEN(PROCNAME(I)) - 1)
        END IF
    NEXT I
' Update PB.BI file, renaming old version to PB.BKE:
    IF DIR$("PB.BKE") <> "" THEN KILL "PB.BKE"  'Delete old back file
    NAME "PB.BI" AS "PB.BKE"
    OPEN "PB.BKE" FOR INPUT AS #1 LEN=1024
    OPEN "PB.BI" FOR OUTPUT AS #2 LEN=1024
    WHILE NOT EOF(1)
        LINE INPUT #1, TEXT
        FOR I = 0 TO N
            IF INSTR(UCASE$(TEXT),UCASE$(PROCNAME(I))) THEN GOTO FOUNDIT
        NEXT I
        PRINT #2, TEXT                  'If not in this module
FOUNDIT:
    WEND
' Add new declarations at end of PB.BI:
    FOR I = 0 TO N
        PRINT #2, DECLARATIONS(I)
    NEXT I
    CLOSE
END
