	.xlist				; NetBIOS include file

;
; NetBIOS command codes
;
NB_CALL_WAIT			equ  10h
NB_CALL				equ  90h
NB_LISTEN_WAIT			equ  11h
NB_LISTEN			equ  91h
NB_HANG_UP_WAIT			equ  12h
NB_HANG_UP			equ  92h
NB_SEND_WAIT			equ  14h
NB_SEND				equ  94h
NB_RECEIVE_WAIT			equ  15h
NB_RECEIVE			equ  95h
NB_SEND_DATAGRAM_WAIT		equ  20h
NB_SEND_DATAGRAM		equ 0A0h
NB_RECEIVE_DATAGRAM_WAIT	equ  21h
NB_RECEIVE_DATAGRAM		equ 0A1h
NB_SEND_BROADCAST_WAIT		equ  22h
NB_SEND_BROADCAST		equ 0A2h
NB_RECEIVE_BROADCAST_WAIT	equ  23h
NB_RECEIVE_BROADCAST		equ 0A3h
NB_ADD_NAME_WAIT		equ  30h
NB_ADD_NAME			equ 0B0h
NB_DELETE_NAME_WAIT		equ  31h
NB_DELETE_NAME			equ 0B1h
NB_RESET			equ  32h
NB_CANCEL			equ  35h
NB_ADD_GROUP_NAME_WAIT		equ  36h
NB_ADD_GROUP_NAME		equ 0B6h

NB_INVALID_COMMAND		equ  7Fh

DATAGRAM_MAX		equ	512	; maximum length of a datagram
OK_RetCode		equ	0


;
; NetBIOS Command Block
;
ncb	struc
  Ncb_Command		db	?	; command (function) code
  Ncb_RetCode		db	?	; return code or 0xFF if cmd pending
  Ncb_Lsn		db	?	; local session number
  Ncb_Num		db	?	; name number returned by AddName
  Ncb_BufferOff		dw	?	; message buffer offset
  Ncb_BufferSeg		dw	?	; message buffer segment
  Ncb_Length		dw	?	; message buffer length
  Ncb_CallName		db  16 dup(?)	; remote name
  Ncb_Name		db  16 dup(?)	; local name (see AddName)
  Ncb_Rto		db	?	; receive timeout
  Ncb_Sto		db	?	; send timeout
  Ncb_PostOff		dw	?	; pointer to procedure that executes
  Ncb_PostSeg		dw	?	;     when nowait function completes
  Ncb_Lana_Num		db	?	; 0 for primary adapter, 1 secondary
  Ncb_Cmd_Cplt		db	?	; 0 when nowait function completes
  Ncb_Reserved		db  14 dup(?)	; reserved for use by NetBIOS
ncb	ends	; member names from "C Programmer's Guid to NetBIOS" by WDS

	.list				; end of netbios.inc
