	title	NetBIOS Miscellaneous
	include	asm.inc
	include	netbios.inc


	public	clear_ncb
	public	netbios_add_name
	public	netbios_call
	public	netbios_cancel
	public	netbios_check
	public	netbios_delete_name
	public	netbios_hang_up
	public	netbios_receive_wait
	public	netbios_send_broadcast
	public	netbios_send_datagram
	public	netbios_send_wait
	public	put_netbios_name


	.data?

temp_ncb	ncb	<>	; netbios control block for temporary use

	.code
	extn	putchar,strncpy,save_most


;;	clear ncb
;
;	entry	DS:SI	ncb ptr
;
clear_ncb proc
	pushm	ax,cx,di,es
	mov	ax,ds
	mov	es,ax
	mov	di,si
	xor	ax,ax
	mov	cx,size ncb
	rep	stosb
	popm	es,di,cx,ax
	ret
clear_ncb endp


;;	netbios add name
;
;	entry	DS:SI	asciiz name (less than 16 characters long)
;	exit	Cf	if error
;		AL	name number (or return code if error)
;
netbios_add_name proc
	call	save_most
	call	zero_temp_ncb		; copy name to control block
	call	write_temp_ncb
	lea	di,Ncb_Name[di]
	mov	cx,size Ncb_Name+1	;  (+1 is for \0, OK to overflow \0
	call	strncpy			;   into next field)

	call	read_temp_ncb
	mov	Ncb_Command[si],NB_ADD_NAME_WAIT
	call	netbios_call
	jc	nan1			;  if error

	mov	al,Ncb_Num[si]
nan1:	ret
netbios_add_name endp


;;	netbios call
;
;	entry	DS:SI	netbios control block
;	exit	AX	return code (0xFF if function pending)
;		Cf	if error
;
netbios_call proc
	push	es
	mov	ax,ds			; call NetBIOS
	mov	es,ax			;  ES:BX points to control block
	xchg	bx,si
	int	5Ch
	xchg	bx,si

	mov	al,Ncb_Cmd_Cplt[si]	; get return code
	and	ax,0FFh			;  (AH=0)
	jz	ncb1			;  if successful completion (Cf==0)

	cmp	al,0FFh			; set Cf if error (AL!=0xFF)

ncb1:	pop	es
	ret
netbios_call endp


;;	netbios cancel
;
;	entry	DS:SI	netbios command block
;	exit	AX	final return code
;		Cf	if error
;
netbios_cancel proc
	pushm	si,ds
	pushm	si,ds			; (push again, pop into NCB below)

	call	read_temp_ncb		; clear control block
	call	clear_ncb

	pop	Ncb_BufferSeg[si]	; set control block fields
	pop	Ncb_BufferOff[si]
	mov	Ncb_Command[si],NB_CANCEL

	call	netbios_call
	popm	ds,si
	ret
netbios_cancel endp


;;	netbios check
;
;	exit	Cf	if no netbios driver
;	uses	AX,SI
;
netbios_check proc
	push	ds			; check if vector 5C is zero
	mov	ax,0
	mov	ds,ax
	mov	si,4*5Ch
	lds	si,[si]			;  (this will fault in protect mode)
	mov	ax,ds
	or	ax,si
	jz	nbc1			;  if no NetBIOS driver (Cf==0)

	call	read_temp_ncb
	call	clear_ncb
	mov	Ncb_Command[si],NB_INVALID_COMMAND
	call	netbios_call

nbc1:	cmc				; flip error flag
	pop	ds
	ret
netbios_check endp


;;	netbios delete name
;
;	entry	DS:SI	asciiz name (less than 16 characters long)
;	exit	Cf	if error
;		AL	return code
;
netbios_delete_name proc
	call	save_most
	call	zero_temp_ncb		; copy name to control block
	call	write_temp_ncb
	lea	di,Ncb_Name[di]
	mov	cx,size Ncb_Name+1	;  (+1 is for \0, OK to overflow \0
	call	strncpy			;   into next field)

	call	read_temp_ncb
	mov	Ncb_Command[si],NB_DELETE_NAME_WAIT
	call	netbios_call
	ret
netbios_delete_name endp


;;	netbios hang up
;
;	entry	AL	session number
;	exit	AL	return code
;		Cf	if error
;
netbios_hang_up proc
	pushm	si,ds
	call	read_temp_ncb
	call	zero_temp_ncb
	mov	Ncb_Lsn[si],al
	mov	Ncb_Command[si],NB_HANG_UP_WAIT
	call	netbios_call
	popm	ds,si
	ret
netbios_hang_up endp


;;	netbios receive wait
;
;	entry	AL	local session number
;		CX	buffer length
;		ES:DI	buffer pointer
;	exit	AL	return code
;		CX	bytes received (0 if session closed or error)
;		Cf	if error (session closed is not an error)
;
netbios_receive_wait proc
	pushm	si,ds
	call	read_temp_ncb
	call	zero_temp_ncb

	mov	Ncb_Lsn[si],al
	mov	Ncb_Length[si],cx
	mov	Ncb_BufferOff[si],di
	mov	Ncb_BufferSeg[si],es

	mov	Ncb_Command[si],NB_RECEIVE_WAIT

	call	netbios_call
	jnc	nrw1			; if receive OK

	mov	cx,0			; else check return code
	cmp	al,0Ah
	je	nrw2			;  if session closed, then no error
	stc				;  else return error
	jmp	nrw2

nrw1:	mov	cx,Ncb_Length[si]
nrw2:	popm	ds,si
	ret
netbios_receive_wait endp


;;	netbios send broadcast
;
;	entry	AL	add name number
;		CX	buffer length
;		ES:DI	buffer
;	exit	AL	return code
;		Cf	if error
;	note	waits until datagram sent over network
;
netbios_send_broadcast proc
	pushm	si,ds
	call	read_temp_ncb
	call	clear_ncb
	mov	Ncb_Num[si],al
	mov	Ncb_Length[si],cx
	mov	Ncb_BufferOff[si],di
	mov	Ncb_BufferSeg[si],es
	mov	Ncb_Command[si],NB_SEND_BROADCAST_WAIT
	call	netbios_call
	popm	ds,si
	ret
netbios_send_broadcast endp


;;	netbios send datagram
;
;	entry	AL	add name number
;		CX	buffer length
;		ES:DI	buffer
;		DS:SI	asciiz call name (destination)
;	exit	AL	return code
;		Cf	if error
;	note	waits until datagram sent over network
;
netbios_send_datagram proc
	call	save_most		; initialize datagram control block
	pushm	ds,si
	call	zero_temp_ncb
	call	read_temp_ncb
	mov	Ncb_Num[si],al		;  set "add name" number,
	mov	Ncb_Length[si],cx	;   buffer length and pointer
	mov	Ncb_BufferOff[si],di
	mov	Ncb_BufferSeg[si],es
	popm	si,ds

	call	write_temp_ncb		; copy destination name into block
	lea	di,Ncb_CallName[di]
	mov	cx,size Ncb_CallName+1
	call	strncpy

	call	read_temp_ncb		; send datagram and wait
	mov	Ncb_Command[si],NB_SEND_DATAGRAM_WAIT
	call	netbios_call
	ret
netbios_send_datagram endp


;;	netbios send wait
;
;	entry	AL	session number
;		CX	length
;		ES:DI	buffer pointer
;	exit	AL	return code
;		Cf	if error
;
netbios_send_wait proc
	pushm	si,ds
	call	read_temp_ncb
	call	zero_temp_ncb

	mov	Ncb_Lsn[si],al
	mov	Ncb_Length[si],cx
	mov	Ncb_BufferOff[si],di
	mov	Ncb_BufferSeg[si],es

	mov	Ncb_Command[si],NB_SEND_WAIT

	call	netbios_call
	popm	ds,si
	ret
netbios_send_wait endp


;;	put netbios name
;
;	entry	DS:SI	name field of control block
;	uses	AX,SI
;
put_netbios_name proc
	push	cx
	mov	cx,size Ncb_CallName
pnn1:	lodsb
	cmp	al,' '
	jbe	pnn2
	cmp	al,'~'
	jbe	pnn3
pnn2:	mov	al,' '
pnn3:	call	putchar
	loop	pnn1
	pop	cx
	ret
put_netbios_name endp


;;	read temp ncb
;
;	exit	DS:SI	temporary netbios control block
;
read_temp_ncb proc
	mov	si,@data
	mov	ds,si
	lea	si,temp_ncb
	ret
read_temp_ncb endp


;;	write temp ncb
;
;	exit	ES:DI	temporary netbios control block
;
write_temp_ncb proc
	mov	di,@data
	mov	es,di
	lea	di,temp_ncb
	ret
write_temp_ncb endp


;;	zero temp ncb
;
zero_temp_ncb proc
	pushm	ax,si,ds
	call	read_temp_ncb
	call	clear_ncb
	popm	ds,si,ax
	ret
zero_temp_ncb endp

	end
