program TestTerm;

uses DOS,CRT;

const
  PORT = 0;

var
  Regs : Registers;
  inChar : Char;

function CharPresent : Boolean;
  begin
  with Regs do
    begin
    dx := PORT;
    ah := 3;
    Intr($14,Regs);
    CharPresent := Odd(ah) and ((ax and $8000) = 0);
    end
  end; {CharPresent}

procedure SetParms;
  begin
  with Regs do
    begin
    dx := PORT;
    ah := 0;
    al := $A3; {2400,8,N,1}
    Intr($14,Regs);
    end;
  end; {SetParms}


function GetSerialChar : Char;
  begin
  with Regs do
    begin
    dx := PORT;
    ah := 2;
    Intr($14,Regs);
    GetSerialChar := Char(al);
    end;
  end; {SetParms}


procedure SendChar(inChar : Char);
  begin
  with Regs do
    begin
    dx := PORT;
    ah := 1;
    al := Byte(inChar);
    Intr($14,Regs);
    end;
  end; {SendChar}

begin
CheckBreak :=FALSE;
DirectVideo := TRUE;
SetParms;
repeat
   if CharPresent then
     begin
     Write(Char(Byte(GetSerialChar) and $7F));
     end;
   if KeyPressed then
     begin
     inChar := ReadKey;
     if (inChar = #0) and KeyPressed and (ReadKey = #45) then
       Halt; {Exit on Alt-X}
     SendChar(inChar)
     end
   until FALSE;
 end.

end. {TestTerm}
