/*	Routine- Test */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <tools/viewport.h>

char    *get_prompt( char *str, viewport *prompt )
{
    int c;
    char *startstr = str;
    v_clear  ( prompt );
    v_gotorc ( prompt, 0, 0 );
    while( (c = getch()) != '\r' )
    {
        *str ++ = c;
        v_putc( prompt, c, 1 );
    }
    *str = '\0';
    return startstr;
}

int main()
{
    static int c;
    static char buf[256];
    static viewport v, prompt;


    v_startup( C4350 );

    v_construct  ( &v );
    v_saveok     ( &v, 1 );
    v_clearok    ( &v, 1 );
    v_size       ( &v, 10, 10 );
    v_foreground ( &v, CYAN );
    v_background ( &v, RED  );

    v_open      ( &v );

    getch(); v_move    ( &v,  5, 5 );   // move to (5,5)
    getch(); v_move_rel( &v,  0, 1);    // left
    getch(); v_move_rel( &v,  1, 0);    // up
    getch(); v_move_rel( &v,  0, -1);   // right
    getch(); v_move_rel( &v, -1, 0);    // down
    getch(); v_move( &v, 100, 100 );    // lower-right corner

    getch(); v_gotorc   (&v, 1,   2 );  // Write a few characters
             v_putc     (&v, '1', 0 );
    getch();
    c =      v_getc     (&v);           // and read them
             v_puts     (&v, "got " ); // overwrite with message
             v_putc     (&v, c,   0 );

    getch(); v_gotorc   (&v, 100, 100 ); // (deliberately large)
             v_putc     (&v, '2', 1   );

    getch(); v_gotorc   (&v, 0, 0 );
             v_puts     (&v, "This.is.a.longish.string" );

    getch();            // Test scrolling:

    v_move  ( &v, 0, 0 );
    v_gotorc( &v, 0, 0 ); v_puts(&v, "+--------+");
    v_gotorc( &v, 1, 0 ); v_puts(&v, "|23456789|");
    v_gotorc( &v, 2, 0 ); v_puts(&v, "|23456789|");
    v_gotorc( &v, 3, 0 ); v_puts(&v, "|23456789|");
    v_gotorc( &v, 4, 0 ); v_puts(&v, "|23456789|");
    v_gotorc( &v, 5, 0 ); v_puts(&v, "|23456789|");
    v_gotorc( &v, 6, 0 ); v_puts(&v, "|23456789|");
    v_gotorc( &v, 7, 0 ); v_puts(&v, "|23456789|");
    v_gotorc( &v, 8, 0 ); v_puts(&v, "|23456789|");
    v_gotorc( &v, 9, 0 ); v_puts(&v, "+--------+");

    getch(); v_scroll_region( &v,  0,  1, 1, 1, 8, 8 ); // left
    getch(); v_scroll_region( &v,  1,  0, 1, 1, 8, 8 ); // up
    getch(); v_scroll_region( &v,  0, -1, 1, 1, 8, 8 ); // down
    getch(); v_scroll_region( &v,  -1, 0, 1, 1, 8, 8 ); // right
    getch(); v_scroll       ( &v,  0,  1 );             // left
    getch(); v_scroll       ( &v,  1,  0 );             // up
    getch(); v_scroll       ( &v,  0, -1 );             // down
    getch(); v_scroll       ( &v,  -1, 0 );             // right
    getch();

    v_close     ( &v );
    v_destroy   ( &v );

    v_construct (&v);                   // Test prompt line
    v_construct (&prompt);
    v_saveok     ( &v, 1 );
    v_clearok    ( &v, 1 );
    v_size       ( &v, 20, 20 );
    v_foreground ( &v, RED  );
    v_background ( &v, CYAN );
    v_open       ( &v );

    v_clearok    ( &prompt, 1 );
    v_size       ( &prompt, 1, 80 );
    v_move       ( &prompt, 40, 0 );
    v_open       ( &prompt );

    while( *get_prompt( buf, &prompt ) )
        ;

    v_destroy(&v);
    v_destroy(&prompt);

    return 0;
}
