/* 		window.c-- High-level Window Functions */


#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <tools/window.h>

void wputc( win *w, int c );    /* Test function in wputc.c */
/*============================================================*/
#include <conio.h>                      /* Debugging stuff */
#include <dos.h>

/*------------------------------------------------------------*/
static int Instance_count = 0;

win *w_construct( int win_height, int win_width )
{
    win *w;
    if( !(w = malloc(sizeof(win)) ) )
        return NULL;

    if( ++Instance_count == 1 ) /* Creating first window        */
    {
        v_startup( C4350 );     /* Start up video system.       */
    }

    w->row_off  = 0;    /* viewport in upper left corner of     */
    w->col_off  = 0;    /* of the buffer.                       */
    w->file_off = 0;    /* No lines above window in file        */
    w->bottom   = -1;   /* No lines read yet                    */
    w->import   = NULL; /* No overflow file by default.         */
    w->export   = NULL;
    w->remove   = NULL;
    w->insert   = NULL;
    w->engine_active    = 0;    /* engine not initialized       */
    w->update           = 0;    /* updating is disabled         */
    w->update_row_off   = 0;    /* when updating is enabled,    */
    w->update_col_off   = 0;    /* set cursor to top left of    */
    w->update_file_off  = 0;    /* viewport, buffer, and file.  */
    w->update_row       = 0;
    w->update_col       = 0;
    w->dirty            = 0;

                             /* Create text buffer and viewport */

    b_construct  ( &w->b, win_height, win_width );
    v_construct  ( &w->v );
    v_saveok     ( &w->v, 1 );
    v_clearok    ( &w->v, 1 );
    v_size       ( &w->v, win_height, win_width );
    v_foreground ( &w->v, BLACK         );
    v_background ( &w->v, LIGHTGRAY     );
    return w;
}

void w_destroy( win *w )        /* destroy the window */
{
    v_destroy  (&w->v);         /* destroy the viewport          */
    b_destruct (&w->b);         /* destroy the text buffer       */
    free( w );                  /* Free the space for the window */
    e_close( w );               /* Flush buffer to underlying file */
    engine_close( w );          /* Shut down the editor.           */

    if( --Instance_count == 0 ) /* Destroyed the last window.      */
    {
        v_shutdown  (   );      /* Shut down the video system.     */
    }
}
/*------------------------------------------------------------*/
void w_open( win *w )
{
    v_open  ( &w->v );          /* Display the viewport          */
    e_update( w, 1  );          /* Enable writes to the window   */
                                /* and position cursor at (0,0)  */
    if( !w->engine_active )     /* Edit engine is uninitialized. */
    {
        e_open( w );            /* Initialize buffer            */
        engine_open( w );       /* Initialize edit engine.      */
        w->engine_active = 1;   /* Mark it as initialized.      */
    }
}

void w_hide( win *w )
{
    e_update( w, 0 );           /* Disable viewport updating.   */
    v_deactivate( &w->v, 1 );
}
/*------------------------------------------------------------*/
void w_viewsize( win *w, int view_height, int view_width )
{
    v_size( &w->v, view_height, view_width );
}

void w_viewcolor( win *w, int foreground, int background )
{
    v_foreground ( &w->v, foreground  );
    v_background ( &w->v, background  );
}

void w_move_rel( win *w, int delta_row, int delta_col )
{
    /* Move delta_row rows down and delta_col columns to the right
     * I'm assuming that the window's hidden if updating is off.
     * This might not be the case, though. If this assumption
     * causes problems, add a "hidden" attribute to the either
     * the viewport structure (preferable) or the win structure
     * (less preferable, but it will work). If you do the former,
     * provide a v_visible() that evaluates true if the viewport
     * is visible.
     */

    if( !w->update )
        v_move_rel( &w->v, -delta_row, -delta_col );
    if( w->update )
    {
        w_hide( w );
        v_move_rel( &w->v, -delta_row, -delta_col );
        w_open( w );
    }
}

void w_move( win *w, int row, int col )
{
    /* Move delta_row rows down and delta_col columns to right */

    if( !w->update )
        v_move( &w->v, row, col );
    else
    {
        w_hide( w );
        v_move( &w->v, row, col );
        w_open( w );
    }
}

void w_file( win *w,
        char *(*import)( win *this, int lnum ),
        int   (*insert)( win *this, int lnum ),
        void  (*export)( win *this, int lnum, char *line, int nc,
                                                        int len ),
        void  (*remove)( win *this, int lnum, char *line, int nc,
                                                        int len )
      )
{
    /* Attach file-level support to the window functions. */

    w->import   = import;
    w->insert   = insert;
    w->export   = export;
    w->remove   = remove;
}
