;***********************************************************************
;                              BINGO.ASM                               *
;   BINGO.COM is a trivial TSR to be used only for checking whether    *
; DOS is testing for a calendar update during command-line input       *
; waits.  If automatic calendar updating is occurring, running BINGO   *
; will return the DOS prompt followed by a line feed and the message   *
; "Bingo" - the cursor will move to the following line (in the column  *
; following the "o").  If this occurs, BINGO will have removed itself  *
; from memory.                                                         *
;   If BINGO is run under a DOS shell that does not support automatic  *
; calendar updating, only the DOS prompt will return. Remove BINGO     *
; from memory by immediately running DEBING.                           *
;======================================================================*
;                Written by M. L. Lesser, July 4, 1991                 *
;  Assembled with TASM v 2.5 and linked with TLINK v 4.0, switch "/t"  *
;***********************************************************************

VECTOR  EQU     4*1AH

SHOWIT  MACRO   SYMBOL                  ;Use BIOS to display symbol
        MOV     AX,0E00H+SYMBOL
        INT     10H
ENDM

CODE SEGMENT PARA PUBLIC 'CODE'
        ASSUME CS:CODE, DS:CODE
        ORG     100H
BINGO   PROC NEAR
        JMP SHORT START         ;Initializer
        ALIGN   4
OLDINT  DD      0               ;Save original INT 1AH vector
NEWINT:         ;New INT 1ah intercept
        OR      AH,AH           ;Check for "read timer"
        JZ      US              ;It's for us
        JMP     CS:OLDINT       ;Else continue with INT 1AH
US:     PUSHF                   ;Simulate interrupt,
        CALL    CS:OLDINT       ;Returning to next statemnt
        STI
        PUSH    BP              ;Insurance, for some video adapters
        PUSH    AX              ;AX and ES are used in following
        PUSH    ES              ;  portion of NEWINT
        XOR     AX,AX           ;Restore original interrupt vector
        MOV     ES,AX
        MOV     AX,WORD PTR CS:OLDINT
        MOV     ES:[VECTOR],AX
        MOV     AX,WORD PTR CS:OLDINT + 2
        MOV     ES:[VECTOR+2],AX
        SHOWIT  0AH             ;;Line feed
IRPC    LETTER,Bingo
        SHOWIT  '&LETTER'
ENDM
        SHOWIT  0AH
        MOV     AX,CS           ;Release BINGO's memory
        MOV     ES,AX
        MOV     AH,49H
        INT     21H
        POP     ES
        POP     AX
        POP     BP
        IRET                    ;Return to COMMAND.COM

        ALIGN 16
START:                          ;Initialize interupt intercept
        MOV     AX,ES:[2CH]     ;Environment segment
        MOV     ES,AX
        MOV     AH,49H          ;Release environment memory segment
        INT     21H
        MOV     AX,351AH        ;Save old INT 1AH vector
        INT     21H
        MOV     WORD PTR OLDINT,BX
        MOV     WORD PTR OLDINT+2,ES
        MOV     AX,251AH        ;Replace with vector to NEWINT
        MOV     DX,OFFSET NEWINT
        INT     21H
        MOV     DX,OFFSET START         ;Release memory beyond START
        MOV     CL,4
        SHR     DX,CL                   ;Now in Paragraphs
        MOV     AX,3100H
        INT     21H
BINGO   ENDP
CODE    ENDS
        END     BINGO
