/*---------------------------------------------------------
  Drawing with the mouse
---------------------------------------------------------*/
#include <windows.h>
#include "winclass.h"
#include "initinst.h"

class SCRIBBLE : public MAINWINDOW
{
  protected:
    HDC hDC;

    LPSTR GetClassName() {return "Scribble";};
    void MouseMove ();
    void LButtonDown ();
    void LButtonUp ();

  public:
    SCRIBBLE () { hDC = NULL; };
};

/*---------------------------------------------------------
 When the user pushes down the left mouse button,
 get a device context and set the current position
---------------------------------------------------------*/
void SCRIBBLE::LButtonDown ()
{
  hDC = GetDC (hWnd);
  if (hDC)
  {
    MoveTo (hDC, getx(), gety());
    ShowCursor (FALSE);  // Turn off the mouse arrow.
    SetCapture (hWnd);   // Capture the mouse.
  }
}

/*---------------------------------------------------------
 When the mouse moves from one pixel position to another,
 draw a line if the device context is set
---------------------------------------------------------*/
void SCRIBBLE::MouseMove ()
{
  if (hDC)
    LineTo (hDC, getx(), gety());
}

/*---------------------------------------------------------
 When the user lifts up on the left mouse button,
 release the device context
---------------------------------------------------------*/
void SCRIBBLE::LButtonUp ()
{
  if (hDC)
  {
    ReleaseDC (hWnd, hDC);
    hDC = NULL;
    ShowCursor (TRUE);  // Turn the mouse arrow back on.
    ReleaseCapture();   // Release the mouse.
  }
}

/*---------------------------------------------------------
 Create a Scribble window
---------------------------------------------------------*/
BOOL InitInstance()
{
  static SCRIBBLE scribble;
  return scribble.Make();
}
