'FONTTEST.BAS
'A program to test the font stuff
'Started 4/4/96 by Chris Sequeira

DEFINT A-Z


DECLARE SUB PrintFont (text$, font(), rowNy, columnNx, col, mode)

COMMON SHARED fontYsize
COMMON SHARED startascii, endascii

COMMON SHARED textY
'****************************************************************
textY = 16

CLS
RANDOMIZE TIMER

INPUT "Type a font file name.", file$
INPUT "Type a text filename, plus extension.", textname$
file$ = file$ + ".fnt"

OPEN file$ FOR BINARY ACCESS READ AS #1
      GET #1, , id
      GET #1, , fontYsize
      GET #1, , startascii
      GET #1, , endascii

      REDIM font(startascii TO endascii, 8, fontYsize)
      FOR i = startascii TO endascii
            FOR y = 1 TO fontYsize
                  GET #1, , fontval
                  mask = &H80
                  FOR x = 8 TO 1 STEP -1
                        IF fontval AND mask THEN font(i, x, y) = 1
                        mask = mask / 2
                  NEXT x
            NEXT y
      NEXT i
CLOSE


SCREEN 12

      OPEN textname$ FOR INPUT AS #1
            DO
                  FOR i = 3 TO 24

                        LOCATE i, 1: PRINT SPACE$(79) 'clear line
                  NEXT i

                  FOR i = 3 TO 24
                        IF (EOF(1)) THEN EXIT FOR     'check for End Of File

                        LINE INPUT #1, text$          'get text

                        PrintFont text$, font(), i, 1, 15, 0

                  NEXT

                  'wait for click
                  DO
                        clicked$ = INKEY$
                  LOOP UNTIL clicked$ <> ""
            LOOP UNTIL (EOF(1))
      CLOSE


SUB PrintFont (text$, font(), rowNy, columnNx, col, mode)
      IF mode = 0 THEN
            x = (columnNx - 1) * 8 - 1: y = (rowNy - 1) * textY - 1
      ELSE
            x = columnNx: y = rowNy
      END IF

      FOR printem = 1 TO LEN(text$)
            daOne = ASC(MID$(text$, printem, 1))
            IF daOne >= startascii AND daOne <= endascii THEN
                  FOR i = 1 TO 8
                        FOR j = 1 TO fontYsize
                              IF font(daOne, i, j) THEN
                                    PSET (x + i, y + j), col
                              END IF
                        NEXT j
                  NEXT i
            END IF
            x = x + 8
      NEXT printem
END SUB

