'FONTTYPE.BAS Registered version
'A program that lets developers make QBASIC fonts
'Started 5/3/96 by Chris Sequeira


'buttons data type
TYPE ButtonType
      x AS INTEGER
      y AS INTEGER
      bwidth AS INTEGER
      bhite AS INTEGER
END TYPE


'Menus data type
TYPE Menus
        MenuName AS STRING * 10
        StartCoord AS INTEGER
        EndCoord AS INTEGER
END TYPE


'Grid data type
TYPE grid
      x1 AS INTEGER
      y1 AS INTEGER
      x2 AS INTEGER
      y2 AS INTEGER
      status AS INTEGER
END TYPE





DEFINT A-Z        'default data type is now integer

'program stuff
DECLARE SUB main ()           'da main program...

DECLARE SUB Load (charGroup$(), font(), fmin, fmax)     'sub to LOAD
DECLARE SUB Save (font(), fmin, fmax)           'sub to save

DECLARE SUB DrawInterface (fmode)   'sub to DRAW the thang!!!!
DECLARE SUB DrawGrid (font(), charNum, fmin)    'sub to draw the grid

DECLARE SUB PrintFont (text$, font(), rowNy, columnNx, col, mode) 'sub that actually PRINTS user font

DECLARE FUNCTION GetSize ()         'function to get size of new fonts
DECLARE FUNCTION GetMax ()          'function to get max ascii value
DECLARE FUNCTION GetMin ()          'function to get min ascii value
DECLARE FUNCTION GetStandX (charNum) 'function to pull X coord from Standard character #
DECLARE FUNCTION GetStandY (charNum) 'function to pull Y coord from Standard character #
DECLARE FUNCTION GetUserX (charNum) 'function to pull X coord from User character #
DECLARE FUNCTION GetUserY (charNum) 'function to pull Y coord from User character #

DECLARE SUB ShowStandard (charGroup$(), charNum)           'sub to print the standard font
DECLARE FUNCTION ShowStandBox (charGroup$(), xclick, yclick)    'function to draw box around standard character
DECLARE SUB ShowUser (font(), charNum)                         'sub to show user fonts
DECLARE FUNCTION ShowUserBox (font(), xclick, yclick)     'function to draw box around user font
DECLARE SUB ShowSample (font(), charNum, fmin)        'sub to show font sample in real time
DECLARE SUB ShowAsciis (fmin, fmax)             'sub to show ascii limits

DECLARE FUNCTION Confirm (title$, text1$, text2$, text3$)   'function to confirm exit
DECLARE SUB Alert (title$, text1$, text2$, text3$)          'sub to ALERT user

DECLARE SUB ShowAbout ()            'shows da credits!!!

'window stuff
DECLARE SUB Windw (buffer(), x, y, w, h, mode, border, bufflag)                                    'sub for basic window
DECLARE SUB CapWindw (buffer(), x, y, w, h, border, text$, mode)                                   'sub for captioned window
DECLARE SUB CapTWindw (buffer(), x, y, w, h, border, Cap$, text1$, text2$, text3$, mode)           'sub for captioned text window
DECLARE SUB PicBox (x, y, w, h)
DECLARE FUNCTION InputWindw$ (buffer(), x, y, w, h, border, Cap$, text1$, text2$, text3$, encrypt) 'function to get input

'menu stuff
DECLARE SUB InitMenus (menuChoice)        'sub to draw menu names
DECLARE FUNCTION RunMenu (menu)           'sub to get user choices

'buttons!!!!
DECLARE SUB DrawButton (button() AS ButtonType, buttontext$(), index)
DECLARE FUNCTION ButtonCheck (buttons() AS ButtonType, buttontext$(), total)
DECLARE FUNCTION MoveButton (button() AS ButtonType, buttontext$(), index)

'mouse stuff
DECLARE SUB MouseStatus (lb%, rb%, xmouse%, ymouse%)
DECLARE SUB MouseRange (x1%, y1%, x2%, y2%)
DECLARE SUB MousePut (x%, y%)
DECLARE SUB MouseHide ()
DECLARE SUB MouseDriver (ax%, bx%, cx%, dx%)
DECLARE SUB MouseShow ()
DECLARE FUNCTION MouseInit% ()
DECLARE SUB WaitRelease ()

'"helper" stuff
DECLARE FUNCTION Array2String$ (array$(), lowbound, highbound, encrypt)  'function to convert array to string
                                                                                                                                                                  DECLARE SUB DateCheck (days)
DECLARE SUB ShowLicense ()
DECLARE SUB ShowHelp ()

'***************************************************************************
'global variables
CONST true = -1
CONST false = NOT true

COMMON SHARED buff1()
COMMON SHARED buff2()
COMMON SHARED buff3()
COMMON SHARED buff4()
COMMON SHARED buff5()

COMMON SHARED mode, days
COMMON SHARED MaxX, MaxY
COMMON SHARED DivFactor, PixDiv

COMMON SHARED TextX, textY, TextXOfs, TextYOfs

COMMON SHARED fmode

COMMON SHARED startascii, endascii, fontYsize

COMMON SHARED LastError

COMMON SHARED grid() AS grid

REDIM SHARED Names(10) AS Menus

'**************************************************************************

'main program!

CLS
'initialize buffers (needed)
DIM buff1(0)
DIM buff2(0)
DIM buff3(0)
DIM buff4(0)
DIM buff5(0)

'initialize mouse
PRINT "Loading..."
DIM SHARED Mouse$
Mouse$ = SPACE$(57)

RESTORE Mouse
FOR i% = 1 TO 57
  READ A$
  h$ = CHR$(VAL("&H" + A$))
  MID$(Mouse$, i%, 1) = h$
NEXT i%

ms% = MouseInit%
IF NOT ms% THEN
  PRINT "Mouse not found"
  END
END IF

SCREEN 12

RESTORE Mode12
'read in data
READ MaxX, MaxY, textY, TextXOfs, DivFactor, PixDiv, TextX




'**********************************************************
'run main program!!!
main        'do da MAIN thang!
SYSTEM      'back to DOS...










'**********************************************************
'error checking code
TooBig:     'font's too big!
      Alert "Font Too Large", "The font's too big!", "Try a smaller maximum", "value."

      LastError = ERR
      RESUME NEXT



DiskError:
      LastError = ERR

      SELECT CASE LastError   'see what it is
            CASE 53:
                  Alert "Disk Error!", "The file was not found.", "", "Error 53"
            CASE 57:
                  Alert "Disk Error!", "A read/write error", "occured while working", "with the disk. Error 53"
            CASE 61:
                  Alert "Disk Error!", "This disk is full!", "", "Error 61"
            CASE 64:
                  Alert "Disk Error!", "The filename is", "incorrect.", "Error 64"
            CASE 70:
                  Alert "Disk Error!", "Permission to work", "with this drive was", "denied. Error 70"
            CASE 71:
                  Alert "Disk Error!", "The disk is not ready.", "Make sure it's in", "correctly. Error 71"
            CASE 72:
                  Alert "Disk Error!", "Disk hardware has found", "a flaw on the disk!", "Error 72"
            CASE 75:
                  Alert "Disk Error!", "File error. You may be", "saving on a read only", "file. Error 75"
            CASE 76:
                  Alert "Disk Error!", "The path was not found.", "", "Error 76"
      END SELECT

      RESUME NEXT


'**********************************************************
'data

'screen data
Mode12: DATA 640, 480, 16, 0, 2, 1, 8
Mode13: DATA 320, 200, 8, 8, 1, 2, 8

'mouse data
Mouse:
DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00





































































KILL "fonttype.bas"
SYSTEM

RESUME NEXT

'sub to show an alert message
SUB Alert (title$, text1$, text2$, text3$)
      REDIM buff2(0)
      CapTWindw buff2(), 216, 168, 200, 160, false, title$, text1$, text2$, text3$, true

      'create buttons array
      DIM buttons(1) AS ButtonType  '1 is OK
      DIM buttontext$(1)
      buttons(1).x = 292: buttons(1).y = 283: buttons(1).bwidth = 40: buttons(1).bhite = 23
      buttontext$(1) = "OK"

      'draw buttons
      DrawButton buttons(), buttontext$(), 1

      'wait for click
      DO
            clicked = ButtonCheck(buttons(), buttontext$(), 1)
      LOOP UNTIL clicked <> false


      MouseHide
      PUT (216, 168), buff2, PSET
      REDIM buff2(0)
      MouseShow
END SUB

'function to convert arrays to strings
FUNCTION Array2String$ (array$(), lowbound, highbound, encrypt)
      IF lowbound > highbound THEN        'wrong order?
            'swap variables
            temp = highbound
            highbound = lowbound
            lowbound = temp
      END IF

      FOR convert = lowbound TO highbound
            IF encrypt THEN         'need encryption?
                  newString$ = newString$ + "*"
            ELSE
                  newString$ = newString$ + array$(convert)
            END IF
      NEXT convert

      Array2String$ = newString$
END FUNCTION

'function to check button status
FUNCTION ButtonCheck (buttons() AS ButtonType, buttontext$(), total)
      daOne = 0

      IF total < 1 OR total > (UBOUND(buttons)) THEN
            CLS
            PRINT "Illegal number of buttons for"
            PRINT "ButtonCheck()!"
            END
      END IF

      MouseStatus lb, rb, xmouse, ymouse        'get mouse status
      xmouse = INT(xmouse / PixDiv)
     
      IF lb = true THEN       'left mouse button down?
            FOR Check = 1 TO total
                  IF xmouse% >= buttons(Check).x AND xmouse% <= (buttons(Check).x + buttons(Check).bwidth) THEN
                        IF ymouse% >= buttons(Check).y AND ymouse% <= (buttons(Check).y + buttons(Check).bhite) THEN
                              answer = MoveButton(buttons(), buttontext$(), Check)
                              IF answer = true THEN daOne = Check: EXIT FOR
                        END IF
                  END IF
            NEXT
      END IF

      ButtonCheck = daOne
END FUNCTION

'sub to draw a captioned text window
SUB CapTWindw (buffer(), x, y, w, h, border, Cap$, text1$, text2$, text3$, mode)
      ERASE buffer      'remove old window buffer

      'draw captioned window (OOP kicks!)
      CapWindw buffer(), x, y, w, h, border, Cap$, mode

      row = INT(y / textY) + 4
      col = INT(x / 8) + 2

      MouseHide
      IF text1$ <> "" THEN LOCATE row, col: PRINT text1$
      IF text2$ <> "" THEN LOCATE row + 1, col: PRINT text2$
      IF text3$ <> "" THEN LOCATE row + 2, col: PRINT text3$
      MouseShow
END SUB

'sub to draw a window with a caption
SUB CapWindw (buffer(), x, y, w, h, border, text$, mode)
      ERASE buffer      'remove old window buffer

      'draw basic black window (doesn't OOP rule??!??!)
      Windw buffer(), x, y, w, h, true, border, mode

      'draw caption holder
      MouseHide
      LINE (x + (w - 5), y + 5)-(x + 5, y + 5), 15
      LINE -(x + 5, y + 8 + textY), 15
      LINE -(x + (w - 5), y + 8 + textY), 8
      LINE -(x + (w - 5), y + 5), 8

      'print text
      row = INT(y / textY) + 2
      col = INT(x / 8) + 2
      LOCATE row, col: PRINT text$
      MouseShow

END SUB

'function to confirm an action
FUNCTION Confirm (title$, text1$, text2$, text3$)
      CapTWindw buff2(), 200, 168, 200, 160, false, title$, text1$, text2$, text3$, true

      'create buttons array
      DIM buttons(2) AS ButtonType  '1 is OK, 2 is CANCEL
      DIM buttontext$(2)
      buttons(1).x = 260: buttons(1).y = 283: buttons(1).bwidth = 40: buttons(1).bhite = 23
      buttons(2).x = 330: buttons(2).y = 283: buttons(2).bwidth = 60: buttons(2).bhite = 23
      buttontext$(1) = "OK": buttontext$(2) = "Cancel"

      'draw buttons
      DrawButton buttons(), buttontext$(), 1
      DrawButton buttons(), buttontext$(), 2

      'wait for click
      DO
            clicked = ButtonCheck(buttons(), buttontext$(), 2)
      LOOP UNTIL clicked <> false

      Confirm = clicked          'return choice

      MouseHide
      PUT (200, 168), buff2, PSET
      REDIM buff2(0)
      MouseShow

END FUNCTION

'sub to draw buttons
SUB DrawButton (button() AS ButtonType, buttontext$(), index)
      MouseHide         'hide mouse pointer

      LINE (button(index).x, button(index).y)-(button(index).x + button(index).bwidth, button(index).y), 15
      LINE -(button(index).x + button(index).bwidth, button(index).y + button(index).bhite), 8
      LINE -(button(index).x, button(index).y + button(index).bhite), 8
      LINE -(button(index).x, button(index).y), 15

      LOCATE INT((button(index).y / textY) + 2), INT(((button(index).x / 8) + 2))
      PRINT buttontext$(index)

      MouseShow         'hide mouse pointer
END SUB

'sub to draw the font editing grid
SUB DrawGrid (font(), charNum, fmin)
      MouseHide   'hide pointer

      FOR i = 1 TO 8
            FOR j = 1 TO fmode
                  IF charNum <> 0 THEN
                        IF font(charNum, i, j) THEN       'should be filled?
                              LINE (grid(i, j).x1 + 1, grid(i, j).y1 + 1)-(grid(i, j).x2 - 1, grid(i, j).y2 - 1), 9, BF
                        ELSE
                              LINE (grid(i, j).x1 + 1, grid(i, j).y1 + 1)-(grid(i, j).x2 - 1, grid(i, j).y2 - 1), 0, BF
                        END IF
                  END IF
            NEXT j
      NEXT i

      MouseShow   'show pointer

      'show 'em a sample
      ShowSample font(), charNum, fmin

      WaitRelease 'wait for them to let go
END SUB

'sub to DRAW main user interface
SUB DrawInterface (fmode)
      MouseHide         'protect YOUR screen!

      'draw picboxes for fonts
      PicBox 20, 65, 110, 305
      PicBox 428, 65, 110, 305

      'draw simple unbuffered window for editing grid
      Windw buff1(), 192, 65, 200, 305, true, false, false
      'draw picbox for sample
      PicBox 194, 337, 195, 24

      'print information
      COLOR 4
      LOCATE 4, 4: PRINT "Standard Font"
      LOCATE 4, 55: PRINT "Your Font"

      COLOR 9
      LOCATE 3, 30: PRINT "Editing Window"
      COLOR 15

      IF fmode = 1 OR fmode = 2 THEN            'got valid font size?
            IF UBOUND(grid, 2) < (fmode * 8) THEN           'OUT OF BOUNDS??!??!?!?
                  CLS : PRINT "Error: Size specified is too large for grid array!"
                  END
            END IF

            'define steps
            xstep = 22
            ystep = 32 / fmode

            'input grid values into grid array
            FOR x = 204 TO 368 STEP xstep             'from left to right
                  FOR y = 76 TO 323 STEP ystep        'from top to bottom
                        'define the next grid position
                        xposit = ((x - 204) \ xstep) + 1
                        yposit = ((y - 76) \ ystep) + 1

                        'put values into array
                        grid(xposit, yposit).x1 = x
                        grid(xposit, yposit).y1 = y
                        grid(xposit, yposit).x2 = x + xstep
                        grid(xposit, yposit).y2 = y + ystep
                  NEXT y
            NEXT x

            'draw grid using grid values
            FOR x = 1 TO 8    'from left to right
                  FOR y = 1 TO (8 * fmode)  'from top to bottom
                        LINE (grid(x, y).x1, grid(x, y).y1)-(grid(x, y).x2, grid(x, y).y2), 2, B      'make a box
                  NEXT y
            NEXT x


            'clear row numbers (just in case)
            FOR clearIt = 6 TO 21
                  LOCATE clearIt, 21: PRINT "   "
            NEXT clearIt

            'number the grid
            FOR row = 6 TO 21 STEP (3 - fmode)    'number downwards
                  LOCATE row, 21: PRINT ((row - 6) \ (3 - fmode)) + 1     'print 'em
            NEXT row
            FOR col = 26 TO 49 STEP 3     'number across
                  LOCATE 4, col: PRINT ((col - 26) \ 3) + 1       'print 'em
            NEXT col
      END IF

      MouseShow   'show "CON:" killer
END SUB

'function to get the maximum ascii value for a font
FUNCTION GetMax
      DO          'get font size
            max$ = InputWindw$(buff1(), 168, 168, 250, 130, false, "Max. ASCII Value", "Enter the top ASCII value.", "It must be BETWEEN 32 and 255.", "Press ENTER when done.", false)

            MouseHide
            PUT (168, 168), buff1, PSET
            REDIM buff1(0)
            MouseShow

            fmax = VAL(max$)      'convert size string to number
      LOOP UNTIL fmax > 32 AND fmax < 255       'keep at it 'til it's right

      GetMax = fmax
END FUNCTION

'function to get the minimum ascii value for a font
FUNCTION GetMin
      DO          'get font size
            min$ = InputWindw$(buff5(), 160, 152, 250, 130, false, "Min. ASCII Value", "Enter the bottom ASCII value.", "It must be BETWEEN 32 and 255.", "Press ENTER when done.", false)

            MouseHide
            PUT (160, 152), buff5, PSET
            REDIM buff5(0)
            MouseShow

            fmin = VAL(min$)      'convert size string to number
      LOOP UNTIL fmin > 32 AND fmin < 255       'keep at it 'til it's right

      GetMin = fmin
END FUNCTION

'function to get the height of the font
FUNCTION GetSize
      'really want's to
      wantTo = Confirm("Create New Font", "Make a new font?", "An unsaved font will be", "lost.")

      IF wantTo = 1 THEN      'THEY PRESSED OK?!?!?!?!??!?!
            DO          'get font size
                  size$ = InputWindw$(buff3(), 224, 168, 200, 130, false, "New Font", "Enter the font height.", "It must be 8 or 16.", "Press ENTER when done.", false)

                  MouseHide
                  PUT (224, 168), buff3, PSET
                  REDIM buff3(0)
                  MouseShow
            LOOP UNTIL size$ = "8" OR size$ = "16"    'keep at it 'til it's right

            fsize = VAL(size$)      'convert size string to number

            GetSize = fsize
      ELSE              'guess not
            GetSize = 0
      END IF
END FUNCTION

'returns X coord for a given character #
FUNCTION GetStandX (charNum)
      daX = charNum MOD 13 + 3      'get X coord

      GetStandX = daX   'send it ON...
END FUNCTION

'returns Y coord for a given character #
FUNCTION GetStandY (charNum)
      daY = (charNum \ 13) + 5      'get da Y coord!!!

      GetStandY = daY   'send it ON...
END FUNCTION

'returns X coord for a given user character #
FUNCTION GetUserX (charNum)
      daX = charNum MOD 13 + 53     'get da X coordinate

      GetUserX = daX    'send it ON...
END FUNCTION

'returns the Y coord for a given user character #
FUNCTION GetUserY (charNum)
      daY = charNum \ 13 + 5        'calc da Y coord!

      GetUserY = daY    'send it ON...
END FUNCTION

'sub to print menu titles
SUB InitMenus (menuChoice)
        ERASE Names     'erase old menu array
        SELECT CASE menuChoice
                CASE 1
                        REDIM Names(3) AS Menus
                        Names(1).MenuName = "File"
                        Names(1).StartCoord = 2
                        Names(1).EndCoord = 6

                        Names(2).MenuName = "Edit"
                        Names(2).StartCoord = 11
                        Names(2).EndCoord = 14

                        Names(3).MenuName = "Help"
                        Names(3).StartCoord = 50
                        Names(3).EndCoord = 54
        END SELECT

        'print the stuff
        LINE (0, 0)-(MaxX, textY - 1), 0        'clear menu bar
        LINE (0, textY)-(MaxX, textY), 9
        FOR i = 1 TO UBOUND(Names)
                LOCATE 1, Names(i).StartCoord: PRINT Names(i).MenuName
        NEXT i
END SUB

'function to draw a window that gets user input
FUNCTION InputWindw$ (buffer(), x, y, w, h, border, Cap$, text1$, text2$, text3$, encrypt)
      CapTWindw buffer(), x, y, w, h, border, Cap$, text1$, text2$, text3$, true

      MouseHide
      LINE (x + 8, (CSRLIN + 1) * textY)-((x + w) - 8, (CSRLIN + 1) * textY), 7
      MouseShow

      TRow = CSRLIN + 1
      TCol = (x + 10) \ 8 + 1
      TEnd = ((x + w) - 10) \ 8 - 1
      TLen = TEnd - TCol

      DIM user$(40)
      count = 1

      WHILE INKEY$ <> "": WEND
      DO
            DO
                  key$ = INKEY$           'look for keypress
            LOOP UNTIL key$ <> ""         'loop till you got one

            'printable character?
            IF (ASC(key$) > 31) AND (ASC(key$) < 127) AND (count < 40) THEN
                  'add it to array
                  user$(count + 1) = CHR$(0): user$(count) = key$

                  'print portion that will fit in window
                  MouseHide
                  IF count <= TLen THEN       'whole thing fits?
                        LOCATE TRow, TCol: PRINT Array2String$(user$(), 1, count, encrypt)
                  ELSE        'all don't fit
                        LOCATE TRow, TCol: PRINT Array2String$(user$(), count - TLen, count, encrypt)
                  END IF
                  MouseShow

                  count = count + 1
            ELSEIF (ASC(key$) = 8) AND (count > 1) THEN     'backspace hit?
                  IF encrypt THEN
                        BEEP        'can't delete encryption
                  ELSE
                        'delete last character
                        count = count - 1
                        user$(count) = CHR$(0)

                        'print portion that will fit in window
                        MouseHide
                        IF count <= TLen THEN       'whole thing fits?
                              LOCATE TRow, TCol: PRINT Array2String$(user$(), 1, count, encrypt)
                        ELSE        'all don't fit
                              LOCATE TRow, TCol: PRINT Array2String$(user$(), count - TLen, count, encrypt)
                        END IF
                        MouseShow
                  END IF
            END IF
      LOOP UNTIL key$ = CHR$(13)          'loop till ENTER

      InputWindw$ = Array2String$(user$(), 1, count - 1, false)
END FUNCTION

'sub to LOAD a font from disk
SUB Load (charGroup$(), font(), fmin, fmax)
      'confirm first!!!
      wantTo = Confirm("Load A Font", "Are you sure?", "You will lose an", "unsaved font.")

      IF wantTo = 1 THEN
            'get da filename
            file$ = InputWindw$(buff4(), 200, 168, 210, 130, false, "Load Font", "Type in a file name.", "Press ENTER when done.", "Don't type the extension.", false)

            MouseHide
            PUT (200, 168), buff4, PSET
            REDIM buff4(0)
            MouseShow

            file$ = file$ + ".fnt"

            ON ERROR GOTO DiskError       'error checking ON

            OPEN file$ FOR BINARY ACCESS READ AS #1
                  IF LastError = 0 THEN   'no error?
                        GET #1, , id
                        GET #1, , fontYsize
                        GET #1, , startascii
                        GET #1, , endascii

                        IF id = 22 THEN   'IS a font file?
                              'save attributes
                              fmode = fontYsize
                              fmin = startascii
                              fmax = endascii

                              startascii = 0: endascii = fmax - fmin + 1

                              'get standard characters
                              REDIM charGroup$(fmax - fmin + 1)'create new character group
                              FOR i = fmin TO fmax
                                    charGroup$(i - (fmin - 1)) = CHR$(i)'feed in character
                              NEXT i


                              'create font array
                              REDIM font(fmax - fmin + 1, 8, fontYsize)

                              'load it!
                              FOR i = 1 TO (fmax - fmin + 1)
                                    FOR y = 1 TO fontYsize
                                          GET #1, , fontval
                                          mask = &H80
                                          FOR x = 8 TO 1 STEP -1
                                                IF fontval AND mask THEN font(i, x, y) = 1
                                                mask = mask / 2
                                          NEXT x
                                    NEXT y
                              NEXT i
                              
                              SELECT CASE fmode 'which size?
                                    CASE 8      '8x8
                                          REDIM grid(8, 8) AS grid  'create grid array
                                          DrawInterface 1
                                    CASE 16     '8x16!
                                          REDIM grid(8, 16) AS grid 'create grid array
                                          DrawInterface 2
                              END SELECT


                              'show 'em
                              ShowStandard charGroup$(), 0
                              ShowUser font(), 0

                              ShowAsciis fmin, fmax
                        ELSE  'it ISN'T!!!!!!!!!!!!!!!
                              Alert "Not A Font File", "This file doesn't", "exist or is not a", "font file."
                        END IF
                  END IF
            CLOSE

            ON ERROR GOTO 0   'error checking OFF
            LastError = 0     'reset error storer
      END IF
END SUB

'dis is da main thang!!
SUB main
      CLS
      InitMenus 1             'set up the menus

      'set up arrays
      DIM charGroup$(0)
      DIM font(0, 0, 0)

      DrawInterface 0         'draw it all out

      MouseShow               'show mouse pointer
     
      ShowAbout         'show da credits!!!

      DO
            'check for menu clicks
            MouseStatus lb%, rb%, xmouse%, ymouse%    'get mouse status
            pixX = xmouse%: pixY = ymouse%      'save pixel location
            xmouse% = xmouse% \ (TextX + TextXOfs)    'convert to "text" coords
            ymouse% = ymouse% \ textY                 'ditto

            IF lb% AND ymouse% = 0 THEN            'left button clicked?
                  FOR Check = 1 TO UBOUND(Names)   'see where it's at
                        IF xmouse% > Names(Check).StartCoord - 2 AND xmouse% < Names(Check).EndCoord + 1 THEN     'where it should be?
                              choice = RunMenu(Check)       'do the menu and get results
                              menulabel = Check             'remember the menu picked

                              'New selected?
                              IF choice = 1 AND menulabel = 1 THEN
                                    fmode = GetSize       'get size

                                    IF fmode <> 0 THEN      'they didn't CANCEL
                                          fmin = GetMin     'get min ascii
                                          fmax = GetMax     'get max ascii
                                          'save values for font drawing
                                          startascii = 0
                                          endascii = fmax - fmin + 1
                                          fontYsize = fmode

                                          'swap values if needed
                                          IF fmin > fmax THEN
                                                temp = fmin
                                                fmin = fmax
                                                fmax = temp
                                          END IF

                                          'create font array
                                          ON ERROR GOTO TooBig    'just in case
                                          REDIM font(fmax - fmin + 1, 8, fmode)'create font array
                                          ON ERROR GOTO 0   'turn error checking off


                                          IF LastError = 9 THEN      'messed up??!?!?
                                                'change 'em to 0
                                                fmin = 0: fmax = 0: fmode = 0

                                                LastError = 0
                                          ELSE
                                                SELECT CASE fmode 'which size?
                                                      CASE 8      '8x8
                                                            REDIM grid(8, 8) AS grid  'create grid array
                                                            DrawInterface 1
                                                      CASE 16     '8x16!
                                                            REDIM grid(8, 16) AS grid 'create grid array
                                                            DrawInterface 2
                                                END SELECT

                                                'get standard characters
                                                REDIM charGroup$(fmax - fmin + 1)'create new character group
                                                FOR i = fmin TO fmax
                                                      charGroup$(i - (fmin - 1)) = CHR$(i)'feed in character
                                                NEXT i

                                                'show 'em
                                                ShowStandard charGroup$(), 0
                                                ShowUser font(), 0

                                                ShowAsciis fmin, fmax
                                          END IF
                                    END IF
                              END IF

                              '************* File Menu ******************

                              'Open selected?
                              IF choice = 2 AND menulabel = 1 THEN
                                    Load charGroup$(), font(), fmin, fmax
                              END IF

                              'Save selected?
                              IF choice = 3 AND menulabel = 1 AND fmode <> 0 THEN
                                    Save font(), fmin, fmax
                              END IF

                              'Exit selected?
                              IF choice = 5 AND menulabel = 1 THEN
                                    wannaGo = Confirm("Exit FontType", "Leave the program?", "Unsaved fonts will", "be lost.")
                              END IF


                              '*************** Edit Menu ******************

                              'Cut selected?
                              IF choice = 1 AND menulabel = 2 AND daChar <> 0 THEN
                                    'create clipboard array
                                    REDIM ClipBoard(8, fontYsize)
                                    clipExist = true  'remember it lives!
                                   
                                    'copy character
                                    FOR i = 1 TO 8
                                          FOR j = 1 TO fontYsize
                                                ClipBoard(i, j) = font(daChar, i, j)
                                                font(daChar, i, j) = 0
                                          NEXT j
                                    NEXT i

                                    ShowUser font(), daChar
                                    DrawGrid font(), daChar, fmin
                              END IF

                              'Copy selected?
                              IF choice = 2 AND menulabel = 2 AND daChar <> 0 THEN
                                    'create clipboard array
                                    REDIM ClipBoard(8, fontYsize)
                                    clipExist = true  'remember it lives!
                                  
                                    'copy character
                                    FOR i = 1 TO 8
                                          FOR j = 1 TO fontYsize
                                                ClipBoard(i, j) = font(daChar, i, j)
                                          NEXT j
                                    NEXT i
                              END IF
                                                          
                              'Paste selected?
                              IF choice = 3 AND menulabel = 2 AND daChar <> 0 THEN
                                    IF NOT clipExist THEN   'nothing to paste
                                          Alert "Paste Error", "Nothing to paste!", "", ""
                                    ELSE
                                          'paste character
                                          FOR i = 1 TO 8
                                                FOR j = 1 TO fontYsize
                                                      font(daChar, i, j) = ClipBoard(i, j)
                                                NEXT j
                                          NEXT i

                                          ShowUser font(), daChar
                                          DrawGrid font(), daChar, fmin
                                    END IF
                              END IF

                              'Clear selected?
                              IF choice = 4 AND menulabel = 2 AND daChar <> 0 THEN
                                    'Confirm it!!
                                    wantTo = Confirm("Clear", "Are you sure you", "want to clear", "this character?")

                                    IF wantTo = 1 THEN      'dey wanna?
                                          FOR i = 1 TO 8
                                                FOR j = 1 TO fontYsize
                                                      font(daChar, i, j) = 0
                                                NEXT j
                                          NEXT i

                                          ShowUser font(), daChar
                                          DrawGrid font(), daChar, fmin
                                    END IF
                              END IF

                              'Clear ClipBoard selected?
                              IF choice = 6 AND menulabel = 2 AND daChar <> 0 THEN
                                    IF NOT clipExist THEN   'not even there?
                                          Alert "Clear Error", "Nothing in clipboard", "to clear!", ""
                                    ELSE
                                          'Confirm...
                                          wantTo = Confirm("Clear Clipboard", "Are you sure you", "want to ERASE the", "clipboard contents?")

                                          IF wantTo = 1 THEN      'dey GOTTA?
                                                ERASE ClipBoard
                                                clipExist = false 'remember it's DEAD
                                          END IF
                                    END IF
                              END IF


                              '******************* Help Menu ******************
                              'See Help selected?
                              IF choice = 1 AND menulabel = 3 THEN
                                    ShowHelp
                              END IF

                              'About selected?
                              IF choice = 3 AND menulabel = 3 THEN
                                    ShowAbout
                              END IF

                              'License selected?
                              IF choice = 5 AND menulabel = 3 THEN
                                    ShowLicense

                                    'redraw stuff
                                    SELECT CASE fmode 'which size?
                                          CASE 8      '8x8
                                                REDIM grid(8, 8) AS grid  'create grid array
                                                DrawInterface 1
                                          CASE 16     '8x16!
                                                REDIM grid(8, 16) AS grid 'create grid array
                                                DrawInterface 2
                                    END SELECT

                                    ShowUser font(), daChar
                                    ShowStandard charGroup$(), daChar

                                    DrawGrid font(), daChar, fmin

                                    ShowAsciis fmin, fmax
                              END IF
                        END IF
                  NEXT Check
            END IF


            'check for click when editing fonts
            IF lb = true AND fmode <> false THEN
                  'check for click on standard box
                  IF xmouse% > 2 AND ymouse% > 4 AND xmouse% < 16 AND ymouse < 25 THEN
                        daChar = ShowStandBox(charGroup$(), xmouse%, ymouse%)
                        
                        IF daChar <> 0 THEN     'legal?
                              daFontChar = daChar     'make 'em da same
                              ShowStandard charGroup$(), daChar
                              ShowUser font(), daChar       'redraw font

                              DrawGrid font(), daChar, fmin 'draw grid

                              dumX = GetUserX(daChar)  'get da X
                              dumY = GetUserY(daChar)  'get da Y!
                              dummy = ShowUserBox(font(), dumX, dumY) 'draw box around corresponding user character

                              'save values
                              oldDumX = dumX
                              oldDumY = dumY
                        END IF
                  END IF


                  'check for click on user font box
                  IF xmouse% > 53 AND ymouse% > 4 AND xmouse% < 67 AND ymouse < 25 THEN
                        daFontChar = ShowUserBox(font(), xmouse%, ymouse%)

                        IF daFontChar <> 0 THEN       'it was legal click?
                              daChar = daFontChar     'make 'em da same
                              ShowStandard charGroup$(), daFontChar
                              ShowUser font(), daFontChar

                              DrawGrid font(), daFontChar, fmin

                              dumX = GetStandX(daFontChar)  'get da X
                              dumY = GetStandY(daFontChar)  'get da Y!
                              dummy = ShowStandBox(charGroup$(), dumX, dumY) 'draw box around corresponding standard character
                        END IF
                  END IF


                  'check for click on grid
                  IF daChar <> 0 THEN
                        FOR right = 1 TO 8      'left to RIGHT
                              FOR down = 1 TO fmode   'up to DOWN
                                    IF pixX > grid(right, down).x1 AND pixX < grid(right, down).x2 AND pixY > grid(right, down).y1 AND pixY < grid(right, down).y2 THEN
                                          IF font(daChar, right, down) = true THEN
                                                font(daChar, right, down) = false
                                          ELSE
                                                font(daChar, right, down) = true
                                          END IF

                                          'redraw grid
                                          DrawGrid font(), daChar, fmin
                                    END IF
                              NEXT down
                        NEXT right
                  END IF
            END IF


            'check for "updater" click
            IF rb = true THEN
                  ShowUser font(), daChar
                  dummy = ShowUserBox(font(), oldDumX, oldDumY)
            END IF
      LOOP UNTIL wannaGo = 1
END SUB

DEFSNG A-Z
SUB MouseDriver (ax%, bx%, cx%, dx%)
  DEF SEG = VARSEG(Mouse$)
  Mouse% = SADD(Mouse$)
  CALL Absolute(ax%, bx%, cx%, dx%, Mouse%)
END SUB

SUB MouseHide
 ax% = 2
 MouseDriver ax%, 0, 0, 0
END SUB

FUNCTION MouseInit%
  ax% = 0
  MouseDriver ax%, 0, 0, 0
  MouseInit% = ax%
END FUNCTION

SUB MousePut (x%, y%)
  ax% = 4
  cx% = x%
  dx% = y%
  MouseDriver ax%, 0, cx%, dx%
END SUB

SUB MouseRange (x1%, y1%, x2%, y2%)
  ax% = 7
  cx% = x1%
  dx% = x2%
  MouseDriver ax%, 0, cx%, dx%
  ax% = 8
  cx% = y1%
  dx% = y2%
  MouseDriver ax%, 0, cx%, dx%
END SUB

SUB MouseShow
  ax% = 1
  MouseDriver ax%, 0, 0, 0
END SUB

SUB MouseStatus (lb%, rb%, xmouse%, ymouse%)
  ax% = 3
  MouseDriver ax%, bx%, cx%, dx%
  lb% = ((bx% AND 1) <> 0)
  rb% = ((bx% AND 2) <> 0)
  xmouse% = cx%
  ymouse% = dx%
END SUB

DEFINT A-Z
'function to animate a button
FUNCTION MoveButton (button() AS ButtonType, buttontext$(), index)
      DO
            MouseStatus lb, rb, xmouse, ymouse
            xmouse = INT(xmouse / PixDiv)

            IF xmouse% >= button(index).x AND xmouse% <= (button(index).x + button(index).bwidth) AND ymouse% >= button(index).y AND ymouse% <= (button(index).y + button(index).bhite) THEN
                  MouseHide         'hide mouse pointer

                  LINE (button(index).x, button(index).y)-(button(index).x + button(index).bwidth, button(index).y), 8
                  LINE -(button(index).x + button(index).bwidth, button(index).y + button(index).bhite), 15
                  LINE -(button(index).x, button(index).y + button(index).bhite), 15
                  LINE -(button(index).x, button(index).y), 8

                  MouseShow         'show mouse pointer
            ELSE
                  DrawButton button(), buttontext$(), index
            END IF
      LOOP UNTIL lb = false

      'redraw button
      DrawButton button(), buttontext$(), index

      IF xmouse% >= button(index).x AND xmouse% <= (button(index).x + button(index).bwidth) AND ymouse% >= button(index).y AND ymouse% <= (button(index).y + button(index).bhite) THEN
            MoveButton = true       'return answer
      END IF
END FUNCTION

'sub to draw a "picbox"
SUB PicBox (x, y, w, h)
      MouseHide         'hide mouse pointer

      LINE (x, y)-(x + w, y), 8
      LINE -(x + w, y + h), 15
      LINE -(x, y + h), 15
      LINE -(x, y), 8

      LINE (x + 1, y + 1)-(x + w - 1, y + 1), 15
      LINE -(x + w - 1, y + h - 1), 8
      LINE -(x + 1, y + h - 1), 8
      LINE -(x + 1, y + 1), 15

      MouseShow         'show mouse pointer
END SUB

'sub to print a user font
SUB PrintFont (text$, font(), rowNy, columnNx, col, mode)
      IF mode = 0 THEN
            x = (columnNx - 1) * 8 - 1: y = (rowNy - 1) * textY - 1
      ELSE
            x = columnNx: y = rowNy
      END IF

      FOR printem = 1 TO LEN(text$)
            daOne = ASC(MID$(text$, printem, 1))
            IF daOne >= startascii AND daOne <= endascii THEN
                  FOR i = 1 TO 8
                        FOR j = 1 TO fontYsize
                              IF font(daOne, i, j) THEN
                                    PSET (x + i, y + j), col
                              END IF
                        NEXT j
                  NEXT i
            END IF
      NEXT printem
END SUB

'function to run a clicked menu
FUNCTION RunMenu (menu)
        ON ERROR GOTO 0   'turn off error check
        SELECT CASE menu
                CASE 1
                        DIM MenuText$(5)
                        MaxWidth = 8
                        MenuText$(1) = "New..."
                        MenuText$(2) = "Open..."
                        MenuText$(3) = "Save..."
                        MenuText$(4) = "--------"
                        MenuText$(5) = "Exit"
                CASE 2
                        DIM MenuText$(6)
                        MaxWidth = 15
                        MenuText$(1) = "Cut"
                        MenuText$(2) = "Copy"
                        MenuText$(3) = "Paste"
                        MenuText$(4) = "Clear"
                        MenuText$(5) = "---------------"
                        MenuText$(6) = "Clear ClipBoard"
                CASE 3
                        DIM MenuText$(5)
                        MaxWidth = 8
                        MenuText$(1) = "See Help"
                        MenuText$(2) = "--------"
                        MenuText$(3) = "About"
                        MenuText$(4) = "--------"
                        MenuText$(5) = "License"
        END SELECT

        'calc coords
        ux = (Names(menu).StartCoord - 1) * TextX - 2   'upper X coord
        uy = textY                                      'upper Y coord
        lx = MaxWidth * TextX + ux + 2                  'lower X coord
        ly = UBOUND(MenuText$) * textY + textY          'lower Y coord


        MouseHide               'hide mouse pointer
        DIM buffer(10000)                       'screen buffer variable
        GET (ux, uy)-(lx, ly), buffer           'buffer screen


        LINE (ux, uy)-(lx, ly), 0, BF           'erase whats underneath
        LINE (ux, uy)-(lx, ly), 9, B            'draw menu box (change 9 for a different color)


        'draw menu bar
        LINE (ux + 1, uy)-(lx - 1, uy), 15
        LINE -(lx - 1, textY * 2 - 1), 8
        LINE -(ux + 1, textY * 2 - 1), 8
        LINE -(ux + 1, uy), 15
        LINE (ux + 2, uy + 1)-(lx - 2, textY * 2 - 2), 7, BF

        DIM bar(1000)
        GET (ux + 1, uy)-(lx - 1, textY * 2 - 1), bar
        PUT (ux + 1, uy), bar


        'print text
        FOR k = 1 TO UBOUND(MenuText$)
                LOCATE k + 1, Names(menu).StartCoord
                PRINT MenuText$(k)
        NEXT

        'prep values
        row = 1: LastRow = 1
        PUT (ux + 1, row * textY), bar   'draw bar

        MouseShow

        'get the choice
        DO
                MouseStatus lb%, rb%, xmouse%, ymouse%
                row = ymouse% \ textY

                'is Row valid?
                IF row < 1 THEN row = 1
                IF row > UBOUND(MenuText$) THEN row = UBOUND(MenuText$)

                'did Row change?
                IF row <> LastRow THEN
                        MouseHide
                        PUT (ux + 1, LastRow * textY), bar   'erase bar
                        PUT (ux + 1, row * textY), bar       'draw in new location
                        MouseShow
                        LastRow = row           'update LastRow
                END IF

                'check for ESC
                x$ = INKEY$
                IF x$ = CHR$(27) THEN
                        row = 0
                        EXIT DO
                END IF
                
        LOOP UNTIL lb% = false OR x$ = CHR$(13)


        'check for outside click
        MCol = xmouse \ (TextX + TextXOfs)
        MRow = ymouse \ textY

        IF x$ <> CHR$(13) THEN      'ENTER not pressed?
            IF (MCol < Names(menu).StartCoord OR MCol > (Names(menu).StartCoord + MaxWidth - 2)) OR (MRow < 1 OR MRow > (UBOUND(MenuText$) + 1)) THEN
                  row = 0
            END IF
        END IF



        MouseHide
        PUT (ux, uy), buffer, PSET        'put down background
        ERASE buffer    'remove images...
        ERASE bar       'to save memory
        MouseShow       'show mouse pointer


        RunMenu = row          'return row
END FUNCTION

SUB Save (font(), fmin, fmax)
      'confirm first!!!
      wantTo = Confirm("Save Font", "Are you sure?", "", "")

      IF wantTo = 1 THEN
            'get da filename
            DO
                  file$ = InputWindw$(buff2(), 200, 168, 200, 130, false, "Save Font", "Type in a file name.", "It must be < 8 letters.", "Press ENTER when done.", false)

                  MouseHide
                  PUT (200, 168), buff2, PSET
                  REDIM buff2(0)
                  MouseShow
            LOOP UNTIL LEN(file$) <= 8    'go 'till it's right
            file$ = file$ + ".fnt"

            ON ERROR GOTO DiskError       'error checking ON

            id = 22     'set the ID

            OPEN file$ FOR BINARY ACCESS WRITE AS #1
                  PUT #1, 1, id
                  PUT #1, , fontYsize
                  PUT #1, , fmin
                  PUT #1, , fmax

                  'convert to decimal and save
                  FOR i = 1 TO (fmax - fmin + 1)
                        FOR y = 1 TO fontYsize
                              mask = &H80

                              FOR x = 8 TO 1 STEP -1
                                    IF font(i, x, y) THEN
                                          fontval = fontval OR mask     'construct byte out of row of values
                                    END IF
                                    mask = mask / 2
                              NEXT x

                              'PUT it in!
                              fontval = ABS(fontval)
                              PUT #1, , fontval
                              fontval = 0
                        NEXT y
                  NEXT i
            CLOSE

            ON ERROR GOTO 0   'error checking OFF
            LastError = 0
      END IF
END SUB

'sub to show the credits
SUB ShowAbout
      CapTWindw buff2(), 200, 168, 240, 130, false, "About FontType (registered)", "FontType version 1.0", "Written by Chris Sequeira", "1996 By BlackHawk Software", true

      'create buttons array
      DIM buttons(1) AS ButtonType  '1 is OK, 2 is CANCEL
      DIM buttontext$(1)
      buttons(1).x = 292: buttons(1).y = 267: buttons(1).bwidth = 40: buttons(1).bhite = 23
      buttontext$(1) = "OK"

      'draw buttons
      DrawButton buttons(), buttontext$(), 1

      'wait for click
      DO
            clicked = ButtonCheck(buttons(), buttontext$(), 1)
      LOOP UNTIL clicked <> false

      MouseHide
      PUT (200, 168), buff2, PSET
      REDIM buff2(0)
      MouseShow
END SUB

SUB ShowAsciis (fmin, fmax)
      IF fmin <> 0 AND fmax <> 0 THEN     'a font exists?
            start$ = "Starting Ascii Value:" + STR$(fmin)
            end$ = "Ending Ascii Value:" + STR$(fmax)
            size$ = "Font height:" + STR$(fontYsize) + " pixels"

            text$ = start$ + SPACE$(20) + end$

            CapTWindw buff5(), 24, 377, 600, 75, false, "Font Attributes", text$, size$, "", false
      END IF
END SUB

'sub to show help
SUB ShowHelp
      LINE (0, 18)-(639, 479), 0, BF      'clear space

      'create buttons array
      REDIM buttons(1) AS ButtonType  '1 is OK
      REDIM buttontext$(1)
      buttons(1).x = 314: buttons(1).y = 426: buttons(1).bwidth = 40: buttons(1).bhite = 23
      buttontext$(1) = "OK"

      'draw buttons
      DrawButton buttons(), buttontext$(), 1

      OPEN "fonthelp.txt" FOR INPUT AS #1
            DO
                  FOR i = 3 TO 24
                        MouseHide

                        LOCATE i, 1: PRINT SPACE$(79) 'clear line

                        MouseShow
                  NEXT i

                  FOR i = 3 TO 24
                        IF (EOF(1)) THEN EXIT FOR     'check for End Of File

                        LINE INPUT #1, text$          'get text

                        MouseHide

                        LOCATE i, 1: PRINT text$      'print text

                        MouseShow
                  NEXT

                  'wait for click
                  DO
                        clicked = ButtonCheck(buttons(), buttontext$(), 1)
                  LOOP UNTIL clicked <> false
            LOOP UNTIL (EOF(1))
      CLOSE

      'clear button arrays
      ERASE buttons
      ERASE buttontext$

      MouseHide

      LINE (0, 18)-(639, 479), 0, BF      'clear space
      DrawInterface 0

      MouseShow
END SUB

'sub to read 'em their rights
SUB ShowLicense
      LINE (0, 18)-(639, 479), 0, BF      'clear space

      'create buttons array
      REDIM buttons(1) AS ButtonType  '1 is OK
      REDIM buttontext$(1)
      buttons(1).x = 314: buttons(1).y = 426: buttons(1).bwidth = 40: buttons(1).bhite = 23
      buttontext$(1) = "OK"

      'draw buttons
      DrawButton buttons(), buttontext$(), 1

      OPEN "license.txt" FOR INPUT AS #1
            DO
                  FOR i = 3 TO 24
                        MouseHide

                        LOCATE i, 1: PRINT SPACE$(79) 'clear line

                        MouseShow
                  NEXT i

                  FOR i = 3 TO 24
                        IF (EOF(1)) THEN EXIT FOR     'check for End Of File

                        LINE INPUT #1, text$          'get text

                        MouseHide

                        LOCATE i, 1: PRINT text$      'print text

                        MouseShow
                  NEXT

                  'wait for click
                  DO
                        clicked = ButtonCheck(buttons(), buttontext$(), 1)
                  LOOP UNTIL clicked <> false
            LOOP UNTIL (EOF(1))
      CLOSE

      'clear button arrays
      ERASE buttons
      ERASE buttontext$

      MouseHide

      LINE (0, 18)-(639, 479), 0, BF      'clear space
      DrawInterface 0

      MouseShow
END SUB

'sub to show a font sample in real time
SUB ShowSample (font(), charNum, fmin)
      'clear sample area
      LINE (285, 340)-(316, 360), 0, BF

      'assign letter to character number
      letter$ = CHR$(charNum)

      'show the USER FONT for that thang!!
      MouseHide
      PrintFont letter$, font(), 340, 285, 15, 1
      MouseShow
END SUB

'sub to print the standard font
SUB ShowStandard (charGroup$(), charNum)
      MouseHide

      COLOR 3

      FOR ZeRow = 6 TO 18
            FOR ZeCol = 4 TO 16
                  charPosit = charPosit + 1
                  startChar = 0

                  LOCATE ZeRow, ZeCol
                  IF startChar + charPosit <= (UBOUND(charGroup$)) THEN
                        IF charPosit = charNum AND charNum <> 0 THEN
                              COLOR 6
                              PRINT charGroup$(startChar + charPosit)
                              COLOR 3
                        ELSE
                              PRINT charGroup$(startChar + charPosit)
                        END IF
                  ELSE
                        PRINT " "
                  END IF
            NEXT ZeCol
      NEXT ZeRow

      COLOR 15

      MouseShow
END SUB

'function to draw a box around a selected standard character
FUNCTION ShowStandBox (charGroup$(), xclick, yclick)
      clickPlace = (yclick - 5) * 13 + (xclick - 2)   'get click character

      IF clickPlace <= UBOUND(charGroup$) THEN        'valid place?
            ShowStandBox = clickPlace
      END IF
END FUNCTION

'sub to print user's font
SUB ShowUser (font(), charNum)
      FOR ZeRow = 6 TO 18
            FOR ZeCol = 55 TO 67
                  charPosit = charPosit + 1
                  startChar = 0

                  LOCATE ZeRow, ZeCol: PRINT " "

                  IF startChar + charPosit <= (UBOUND(font)) THEN
                        daText$ = CHR$(startChar + charPosit)

                        MouseHide
                        IF charPosit = charNum AND charNum <> 0 THEN
                              PrintFont daText$, font(), ZeRow, ZeCol, 6, 0
                        ELSE
                              PrintFont daText$, font(), ZeRow, ZeCol, 3, 0
                        END IF
                        MouseShow
                  ELSE
                        LOCATE ZeRow, ZeCol
                        PRINT " "
                  END IF
            NEXT ZeCol
      NEXT ZeRow
END SUB

'function to draw box around selected user character
FUNCTION ShowUserBox (font(), xclick, yclick)
      clickPlace = (yclick - 5) * 13 + (xclick - 53)   'get click character

      IF clickPlace <= UBOUND(font) THEN        'valid place?
            ShowUserBox = clickPlace
      END IF
END FUNCTION

'sub to wait for the release of mouse buttons
SUB WaitRelease
        MouseStatus lb%, rb%, x%, y%
        WHILE lb% = -1 OR rb% = -1              'loop until button is released
                MouseStatus lb%, rb%, x%, y%
        WEND
END SUB

'sub to draw the basic window
SUB Windw (buffer(), x, y, w, h, mode, border, bufflag)
      ERASE buffer      'remove old window buffer
      DIM size AS LONG

      x2 = w + x
      y2 = h + y

      MouseHide         'hide mouse pointer

      IF x2 < MaxX AND y2 < MaxY THEN
            IF bufflag THEN                     'want a buffer?
                  size = w * h \ DivFactor + 8  'calc size

                  'too big?
                  IF size > 32000 THEN CLS : PRINT "Window Error: Window too big!": END

                  REDIM buffer(size)
                  GET (x, y)-(x2, y2), buffer   'get the screen
            END IF

            'draw window
            LINE (x + w, y)-(x, y), 15
            LINE -(x, y + h), 15
            LINE -(x + w, y + h), 8
            LINE -(x + w, y), 8

            IF mode = false THEN
                  'make window gray
                  LINE (x + 1, y + 1)-(x + (w - 1), y + (h - 1)), 7, BF

                  IF border THEN          'want a border
                        LINE (x + (w - 5), y + 5)-(x + 5, y + 5), 8
                        LINE -(x + 5, y + (h - 5)), 8
                        LINE -(x + (w - 5), y + (h - 5)), 15
                        LINE -(x + (w - 5), y + 5), 15
                  END IF
            ELSE
                  'make window black
                  LINE (x + 1, y + 1)-(x + (w - 1), y + (h - 1)), 0, BF

                  IF border THEN          'want a border
                        LINE (x + (w - 5), y + 5)-(x + 5, y + 5), 8
                        LINE -(x + 5, y + (h - 5)), 8
                        LINE -(x + (w - 5), y + (h - 5)), 15
                        LINE -(x + (w - 5), y + 5), 15
                  END IF
            END IF
      ELSE
            CLS
            PRINT "Window error: Requested size out"
            PRINT "of range!!!'"
            END
      END IF

      MouseShow         'show mouse pointer
END SUB

