'TEMPLATE.BAS
'A program that will serve as your template for font-displaying
'Started 5/30/96 by Chris Sequeira

'all integers
DEFINT A-Z

'sub to show the font
DECLARE SUB PrintFont (text$, font(), rowNy, columnNx, col, mode)

'NEEDED global variables
COMMON SHARED fontYsize       'font height
COMMON SHARED startascii, endascii  'ASCII range

COMMON SHARED textY     'standard text height
'****************************************************************
textY = 16  'replace 16 with the character height for your screen mode.
		'16 is the height for SCREEN 12 and 8 is the height for
		'SCREEN 13.

'code to LOAD. Replace file$ with the name of your font (in quotes,
'plus the .FNT extension). Repeat this code for as many fonts as you
'need, or create a SUB and pass it the font array after creating it like
'this: REDIM font(0,0,0)
OPEN file$ FOR BINARY ACCESS READ AS #1
	GET #1, , id
	GET #1, , fontYsize
	GET #1, , startascii
	GET #1, , endascii

	REDIM font(startascii TO endascii, 8, fontYsize)
	FOR i = startascii TO endascii
		FOR y = 1 TO fontYsize
			GET #1, , fontval
			mask = &H80
			FOR x = 8 TO 1 STEP -1
				IF fontval AND mask THEN font(i, x, y) = 1
				mask = mask / 2
			NEXT x
		NEXT y
	NEXT i
CLOSE


'begin displaying. Change SCREEN 12 to any other screen mode except text
'mode.
SCREEN 12

'here's where you print the font! Replace text$ with some text.
'Replace rowNy with a text row or a pixel Y location.
'Replace columnNx with a text column or a pixel X location.
'Replace col with the desired color. Mode is the printing mode.
'0 to print by rows and columns, any other value to print by pixels.

PrintFont text$, font(), rowNy, columnNx, col, mode
END

SUB PrintFont (text$, font(), rowNy, columnNx, col, mode)
'this sub does the work!
	IF mode = 0 THEN
		x = (columnNx - 1) * 8 - 1: y = (rowNy - 1) * textY - 1
	ELSE
		x = columnNx: y = rowNy
	END IF

	FOR printem = 1 TO LEN(text$)
		daOne = ASC(MID$(text$, printem, 1))
		IF daOne >= startascii AND daOne <= endascii THEN
			FOR i = 1 TO 8
				FOR j = 1 TO fontYsize
					IF font(daOne, i, j) THEN
						PSET (x + i, y + j), col
					END IF
				NEXT j
			NEXT i
		END IF
		x = x + 8
	NEXT printem
END SUB

